<?php
function cctvsecuritycamera_blog_setting( $wp_customize ) {
$selective_refresh = isset( $wp_customize->selective_refresh ) ? 'postMessage' : 'refresh';
	$wp_customize->add_panel(
		'cctvsecuritycamera_frontpage_sections', array(
			'priority' => 32,
			'title' => esc_html__( 'Frontpage Sections', 'cctv-security-camera' ),
		)
	);
	
 
	/*=========================================
	banner Section
	=========================================*/
	$wp_customize->add_section(
		'banner_setting', array(
			'title' => esc_html__( 'Banner Section', 'cctv-security-camera' ),
			'priority' => 1,
			'panel' => 'cctvsecuritycamera_frontpage_sections',
		)
	);


	$wp_customize->add_setting('cctvsecuritycamera_banner_tabs', array(
	   'sanitize_callback' => 'wp_kses_post',
	));

	$wp_customize->add_control(new cctvsecuritycamera_Tab_Control($wp_customize, 'cctvsecuritycamera_banner_tabs', array(
	   'section' => 'banner_setting',
	   'priority' => 2,
	   'buttons' => array(
	      array(
         	'name' => esc_html__('General', 'cctv-security-camera'),
            'icon' => 'dashicons dashicons-welcome-write-blog',
            'fields' => array(
            	'banner_image',
				'banner_spanheading',
				'banner_heading',
				'banner_description',
				'banner_formsubheading',
				'banner_formheading',
				'banner_shortcode',
				'banner_btnlink',
				'banner_btn2link'
            ),
            'active' => true,
         ), 
	      array(
            'name' => esc_html__('Style', 'cctv-security-camera'),
        	'icon' => 'dashicons dashicons-art',
            'fields' => array(
                'banner_headingcolor',
				'banner_descriptioncolor',
				'banner_formbgcolor',
				'banner_formheadingcolor',
				'banner_formsubheadingcolor',
				'banner_formlabelcolor',
				'banner_formbtntextcolor',
				'banner_formbtnbgcolor',
				'banner_formbtnbgcolor2',
				'banner_formbtnbghrvcolor',
				'banner_button1textcolor',
				'banner_button1bgcolor',
				'banner_button2textcolor',
				'banner_button2bordercolor'

            ),
     	)
    	),
	))); 


	

	// General Tab

	// banner_image
	$wp_customize->add_setting(
    	'banner_image',
	    array(
	        'sanitize_callback' => 'esc_url_raw'
	    )
	);
	$wp_customize->add_control(
	    new WP_Customize_Image_Control(
	        $wp_customize,
	        'banner_image',
	        array(
			    'label'   		=> __('Image','cctv-security-camera'),
				'description'=> __('Image Size Should Be 483*724','cctv-security-camera'),
	            'section' => 'banner_setting',
	            'settings' => 'banner_image'
	        )
	    )
	);

	// banner_spanheading
	$wp_customize->add_setting(
    	'banner_spanheading',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'banner_spanheading',
		array(
		    'label'   		=> __('Span Heading','cctv-security-camera'),
		    'section'		=> 'banner_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	

	// banner_heading
	$wp_customize->add_setting(
    	'banner_heading',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'banner_heading',
		array(
		    'label'   		=> __('Heading','cctv-security-camera'),
		    'section'		=> 'banner_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	
	
	// banner_description
	$wp_customize->add_setting(
    	'banner_description',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'banner_description',
		array(
		    'label'   		=> __('Description','cctv-security-camera'),
		    'section'		=> 'banner_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	

	// banner_formsubheading
	$wp_customize->add_setting(
    	'banner_formsubheading',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'banner_formsubheading',
		array(
		    'label'   		=> __('Form SubHeading','cctv-security-camera'),
		    'section'		=> 'banner_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	

	// banner_formheading
	$wp_customize->add_setting(
    	'banner_formheading',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'banner_formheading',
		array(
		    'label'   		=> __('Form Heading','cctv-security-camera'),
		    'section'		=> 'banner_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	

	// banner_shortcode
	$wp_customize->add_setting(
    	'banner_shortcode',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'banner_shortcode',
		array(
		    'label'   		=> __('Form shortcode','cctv-security-camera'),
		    'section'		=> 'banner_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	

	// banner_btnlink
	$wp_customize->add_setting(
    	'banner_btnlink',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'banner_btnlink',
		array(
		    'label'   		=> __('Button Link','cctv-security-camera'),
		    'section'		=> 'banner_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	

	// banner_btn2link
	$wp_customize->add_setting(
    	'banner_btn2link',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'banner_btn2link',
		array(
		    'label'   		=> __('Button 2 Link','cctv-security-camera'),
		    'section'		=> 'banner_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	
	

	//style

	// banner heading Color
	$bannerheadingcolor = esc_html__('#fff', 'cctv-security-camera' );
	$wp_customize->add_setting(
    	'banner_headingcolor',
    	array(
			'default' => $bannerheadingcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'banner_headingcolor',
		array(
		    'label'   		=> __('Heading Color','cctv-security-camera'),
		    'section'		=> 'banner_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// banner description Color
	$bannerdescriptioncolor = esc_html__('#fff', 'cctv-security-camera' );
	$wp_customize->add_setting(
    	'banner_descriptioncolor',
    	array(
			'default' => $bannerdescriptioncolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'banner_descriptioncolor',
		array(
		    'label'   		=> __('Description Color','cctv-security-camera'),
		    'section'		=> 'banner_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);


	// banner formbg Color
	$bannerformbgcolor = esc_html__('#002335', 'cctv-security-camera' );
	$wp_customize->add_setting(
    	'banner_formbgcolor',
    	array(
			'default' => $bannerformbgcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'banner_formbgcolor',
		array(
		    'label'   		=> __('Form BG Color','cctv-security-camera'),
		    'section'		=> 'banner_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// banner formheading Color
	$bannerformheadingcolor = esc_html__('#fff', 'cctv-security-camera' );
	$wp_customize->add_setting(
    	'banner_formheadingcolor',
    	array(
			'default' => $bannerformheadingcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'banner_formheadingcolor',
		array(
		    'label'   		=> __('Form Heading Color','cctv-security-camera'),
		    'section'		=> 'banner_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// banner formsubheading Color
	$bannerformsubheadingcolor = esc_html__('#cefafe', 'cctv-security-camera' );
	$wp_customize->add_setting(
    	'banner_formsubheadingcolor',
    	array(
			'default' => $bannerformsubheadingcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'banner_formsubheadingcolor',
		array(
		    'label'   		=> __('Form SubHeading Color','cctv-security-camera'),
		    'section'		=> 'banner_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// banner formlabel Color
	$bannerformplaceholdercolor = esc_html__('#fff', 'cctv-security-camera' );
	$wp_customize->add_setting(
    	'banner_formlabelcolor',
    	array(
			'default' => $bannerformplaceholdercolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'banner_formlabelcolor',
		array(
		    'label'   		=> __('Form Label Color','cctv-security-camera'),
		    'section'		=> 'banner_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// banner formbtntext Color
	$bannerformbtntextcolor = esc_html__('#000', 'cctv-security-camera' );
	$wp_customize->add_setting(
    	'banner_formbtntextcolor',
    	array(
			'default' => $bannerformbtntextcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'banner_formbtntextcolor',
		array(
		    'label'   		=> __('Form Button Text Color','cctv-security-camera'),
		    'section'		=> 'banner_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// banner formbtnbg Color
	$bannerformbtnbgcolor = esc_html__('#00ff7f', 'cctv-security-camera' );
	$wp_customize->add_setting(
    	'banner_formbtnbgcolor',
    	array(
			'default' => $bannerformbtnbgcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'banner_formbtnbgcolor',
		array(
		    'label'   		=> __('Form Button BG Color 1','cctv-security-camera'),
		    'section'		=> 'banner_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// banner formbtnbg Color
	$bannerformbtnbgcolor2 = esc_html__('#51a2ff', 'cctv-security-camera' );
	$wp_customize->add_setting(
    	'banner_formbtnbgcolor2',
    	array(
			'default' => $bannerformbtnbgcolor2,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'banner_formbtnbgcolor2',
		array(
		    'label'   		=> __('Form Button BG Color 2','cctv-security-camera'),
		    'section'		=> 'banner_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// banner formbtnbghrv Color
	$bannerformbtnbghrvcolor = esc_html__('#2B85DD', 'cctv-security-camera' );
	$wp_customize->add_setting(
    	'banner_formbtnbghrvcolor',
    	array(
			'default' => $bannerformbtnbghrvcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'banner_formbtnbghrvcolor',
		array(
		    'label'   		=> __('Form Button BG Hover Color','cctv-security-camera'),
		    'section'		=> 'banner_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// banner button1text Color
	$bannerbutton1textcolor = esc_html__('#fff', 'cctv-security-camera' );
	$wp_customize->add_setting(
    	'banner_button1textcolor',
    	array(
			'default' => $bannerbutton1textcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'banner_button1textcolor',
		array(
		    'label'   		=> __('Button 1 Text Color','cctv-security-camera'),
		    'section'		=> 'banner_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// banner button1bg Color
	$bannerbutton1bgcolor = esc_html__('#3b82f6', 'cctv-security-camera' );
	$wp_customize->add_setting(
    	'banner_button1bgcolor',
    	array(
			'default' => $bannerbutton1bgcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'banner_button1bgcolor',
		array(
		    'label'   		=> __('Button 1 BG Color','cctv-security-camera'),
		    'section'		=> 'banner_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// banner button2text Color
	$bannerbutton2textcolor = esc_html__('#fff', 'cctv-security-camera' );
	$wp_customize->add_setting(
    	'banner_button2textcolor',
    	array(
			'default' => $bannerbutton2textcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'banner_button2textcolor',
		array(
		    'label'   		=> __('Button 2 Text Color','cctv-security-camera'),
		    'section'		=> 'banner_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);


	// banner button2border Color
	$bannerbutton2bordercolor = esc_html__('#00ff7f', 'cctv-security-camera' );
	$wp_customize->add_setting(
    	'banner_button2bordercolor',
    	array(
			'default' => $bannerbutton2bordercolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'banner_button2bordercolor',
		array(
		    'label'   		=> __('Button 2 Border Color','cctv-security-camera'),
		    'section'		=> 'banner_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);


	/*=========================================
	ourservice Section
	=========================================*/
	$wp_customize->add_section(
		'ourservice_setting', array(
			'title' => esc_html__( 'Our Service Section', 'cctv-security-camera' ),
			'priority' => 2,
			'panel' => 'cctvsecuritycamera_frontpage_sections',
		)
	);
	

	$wp_customize->add_setting('cctvsecuritycamera_ourservice_tabs', array(
	   'sanitize_callback' => 'wp_kses_post',
	));

	$wp_customize->add_control(new cctvsecuritycamera_Tab_Control($wp_customize, 'cctvsecuritycamera_ourservice_tabs', array(
	   'section' => 'ourservice_setting',
	   'priority' => 2,
	   'buttons' => array(
	      array(
         	'name' => esc_html__('General', 'cctv-security-camera'),
            'icon' => 'dashicons dashicons-welcome-write-blog',
            'fields' => array(
            	'ourservice_disable_section',
				'ourservice_heading',
				'ourservice_subheading',
				'ourservice_serviceslist1',
				'ourservice_serviceslist2',
				'ourservice_serviceslist3',
            	'ourservice1',
            	'ourservice2',
            	'ourservice3',
				'ourservice4',
            	'ourservice5',
            	'ourservice6'
            ),
            'active' => true,
         ),
	      array(
            'name' => esc_html__('Style', 'cctv-security-camera'),
        	'icon' => 'dashicons dashicons-art',
            'fields' => array(
            	'ourservice_headingcolor',
            	'ourservice_subheadingcolor',
				'ourservice_serviceslistcolor',
            	'ourservice_boxtitlecolor',
            	'ourservice_boxtitlehrvcolor',
				'ourservice_boxdescriptioncolor',
				'ourservice_btntextcolor',
				'ourservice_btntextbghrvcolor'
            ),
     	)
	    
    	),
	))); 



	// General

	// hide show ourservice section
	$wp_customize->add_setting(
        'ourservice_disable_section',
        array(
            'sanitize_callback' => 'wp_kses_post',
        )
    ); 
    $wp_customize->add_control(
        new cctvsecuritycamera_Toggle_Switch_Custom_Control(
            $wp_customize,
            'ourservice_disable_section',
            array(
                'settings'      => 'ourservice_disable_section',
                'section'       => 'ourservice_setting',
                'label'         => __( 'Disable Section', 'cctv-security-camera' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'cctv-security-camera' ),
                    'off' => __( 'No', 'cctv-security-camera' )
                ),
            )
        )
    );


    // ourservice_heading
	$wp_customize->add_setting(
    	'ourservice_heading',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'ourservice_heading',
		array(
		    'label'   		=> __('Heading','cctv-security-camera'),
		    'section'		=> 'ourservice_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	

	// ourservice_subheading
	$wp_customize->add_setting(
    	'ourservice_subheading',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'ourservice_subheading',
		array(
		    'label'   		=> __('SubHeading','cctv-security-camera'),
		    'section'		=> 'ourservice_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	

	// ourservice_serviceslist1
	$wp_customize->add_setting(
    	'ourservice_serviceslist1',
    	array(
			'default' => 'PROFESSIONAL INSTALL',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'ourservice_serviceslist1',
		array(
		    'label'   		=> __('Services List 1','cctv-security-camera'),
		    'section'		=> 'ourservice_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	

	// ourservice_serviceslist2
	$wp_customize->add_setting(
    	'ourservice_serviceslist2',
    	array(
			'default' => '24/7 MONITORING',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'ourservice_serviceslist2',
		array(
		    'label'   		=> __('Services List 2','cctv-security-camera'),
		    'section'		=> 'ourservice_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);
	
	// ourservice_serviceslist3
	$wp_customize->add_setting(
    	'ourservice_serviceslist3',
    	array(
			'default' => 'EXPERT SUPPORT',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'ourservice_serviceslist3',
		array(
		    'label'   		=> __('Services List 3','cctv-security-camera'),
		    'section'		=> 'ourservice_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	


	// ourservice 1
	$wp_customize->add_setting( 
    	'ourservice1',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'ourservice1',
		array(
		    'label'   		=> __('Our Service 1','cctv-security-camera'),
		    'section'		=> 'ourservice_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);		

	// ourservice 2
	$wp_customize->add_setting(
    	'ourservice2',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 2,
		)
	);	

	$wp_customize->add_control( 
		'ourservice2',
		array(
		    'label'   		=> __('Our Service 2','cctv-security-camera'),
		    'section'		=> 'ourservice_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);	


	// ourservice 3
	$wp_customize->add_setting(
    	'ourservice3',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'ourservice3',
		array(
		    'label'   		=> __('Our Service 3','cctv-security-camera'),
		    'section'		=> 'ourservice_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);	

	// ourservice 4
	$wp_customize->add_setting( 
    	'ourservice4',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'ourservice4',
		array(
		    'label'   		=> __('Our Service 4','cctv-security-camera'),
		    'section'		=> 'ourservice_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);		

	// ourservice 5
	$wp_customize->add_setting(
    	'ourservice5',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 5,
		)
	);	

	$wp_customize->add_control( 
		'ourservice5',
		array(
		    'label'   		=> __('Our Service 5','cctv-security-camera'),
		    'section'		=> 'ourservice_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);	


	// ourservice 6
	$wp_customize->add_setting(
    	'ourservice6',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 6,
		)
	);	

	$wp_customize->add_control( 
		'ourservice6',
		array(
		    'label'   		=> __('Our Service 6','cctv-security-camera'),
		    'section'		=> 'ourservice_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);	


	// style

	// ourservice heading color
	$ourserviceheadingcolor = esc_html__('#fff', 'cctv-security-camera' );
	$wp_customize->add_setting(
    	'ourservice_headingcolor',
    	array(
			'default' => $ourserviceheadingcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'ourservice_headingcolor',
		array(
		    'label'   		=> __('Heading Color','cctv-security-camera'),
		    'section'		=> 'ourservice_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// ourservice subheading color
	$ourservicesubheadingcolor = esc_html__('#fff', 'cctv-security-camera' );
	$wp_customize->add_setting(
    	'ourservice_subheadingcolor',
    	array(
			'default' => $ourservicesubheadingcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'ourservice_subheadingcolor',
		array(
		    'label'   		=> __('SubHeading Color','cctv-security-camera'),
		    'section'		=> 'ourservice_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// ourservice serviceslist color
	$ourserviceserviceslistcolor = esc_html__('#53eafd', 'cctv-security-camera' );
	$wp_customize->add_setting(
    	'ourservice_serviceslistcolor',
    	array(
			'default' => $ourserviceserviceslistcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'ourservice_serviceslistcolor',
		array(
		    'label'   		=> __('Services List Color','cctv-security-camera'),
		    'section'		=> 'ourservice_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);



	// ourservice boxtitle color
	$ourserviceboxtitlecolor = esc_html__('#fff', 'cctv-security-camera' );
	$wp_customize->add_setting(
    	'ourservice_boxtitlecolor',
    	array(
			'default' => $ourserviceboxtitlecolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'ourservice_boxtitlecolor',
		array(
		    'label'   		=> __('Box Title Color','cctv-security-camera'),
		    'section'		=> 'ourservice_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);
	

	// ourservice boxtitlehrv color
	$ourserviceboxtitlehrvcolor = esc_html__('#2B85DD', 'cctv-security-camera' );
	$wp_customize->add_setting(
    	'ourservice_boxtitlehrvcolor',
    	array(
			'default' => $ourserviceboxtitlehrvcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'ourservice_boxtitlehrvcolor',
		array(
		    'label'   		=> __('Box Title Hover Color','cctv-security-camera'),
		    'section'		=> 'ourservice_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// ourservice boxdescription color
	$ourserviceboxdescriptioncolor = esc_html__('#CFFAFE', 'cctv-security-camera' );
	$wp_customize->add_setting(
    	'ourservice_boxdescriptioncolor',
    	array(
			'default' => $ourserviceboxdescriptioncolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'ourservice_boxdescriptioncolor',
		array(
		    'label'   		=> __('Box Description Color','cctv-security-camera'),
		    'section'		=> 'ourservice_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// ourservice btntext color
	$ourservicebtntextcolor = esc_html__('#fff', 'cctv-security-camera' );
	$wp_customize->add_setting(
    	'ourservice_btntextcolor',
    	array(
			'default' => $ourservicebtntextcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'ourservice_btntextcolor',
		array(
		    'label'   		=> __('Button Text Color','cctv-security-camera'),
		    'section'		=> 'ourservice_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// ourservice btntextbghrv color
	$ourservicebtntextbghrvcolor = esc_html__('#8ECFF9', 'cctv-security-camera' );
	$wp_customize->add_setting(
    	'ourservice_btntextbghrvcolor',
    	array(
			'default' => $ourservicebtntextbghrvcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'ourservice_btntextbghrvcolor',
		array(
		    'label'   		=> __('Button BG Hover Color','cctv-security-camera'),
		    'section'		=> 'ourservice_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);


	
	/*=========================================
	aboutus Section
	=========================================*/
	$wp_customize->add_section(
		'aboutus_setting', array(
			'title' => esc_html__( 'AboutUs Section', 'cctv-security-camera' ),
			'priority' => 2,
			'panel' => 'cctvsecuritycamera_frontpage_sections',
		)
	);

	$wp_customize->add_setting('cctvsecuritycamera_aboutus_tabs', array(
	   'sanitize_callback' => 'wp_kses_post',
	));

	$wp_customize->add_control(new cctvsecuritycamera_Tab_Control($wp_customize, 'cctvsecuritycamera_aboutus_tabs', array(
	   'section' => 'aboutus_setting',
	   'priority' => 2,
	   'buttons' => array(
	      array(
         	'name' => esc_html__('General', 'cctv-security-camera'),
            'icon' => 'dashicons dashicons-welcome-write-blog',
            'fields' => array(
				'aboutus_disable_section',
				'aboutus_image',
				'aboutus_title',
				'aboutus_description',
				'aboutus_description2',
				'aboutus_box1heading',
				'aboutus_box1description',
				'aboutus_box2heading',
				'aboutus_box2description',
				'aboutus_box3heading',
				'aboutus_box3description',
				'aboutus_featuretext1',
				'aboutus_featuretext2',
				'aboutus_featuretext3'
            ),
            'active' => true,
		),
		array(
		'name' => esc_html__('Style', 'cctv-security-camera'),
		'icon' => 'dashicons dashicons-art',
		'fields' => array(
			'aboutus_titlecolor',
			'aboutus_descriptioncolor',
			'aboutus_boxiconcolor',
			'aboutus_boxheadingcolor',
			'aboutus_boxdescriptioncolor',
			'aboutus_boxbgcolor',
			'aboutus_featuretextcolor'
		),
     	)
    	),
	))); 


	// hide show aboutus section
	$wp_customize->add_setting(
        'aboutus_disable_section',
        array(
            'sanitize_callback' => 'wp_kses_post',
        )
    ); 
    $wp_customize->add_control(
        new cctvsecuritycamera_Toggle_Switch_Custom_Control(
            $wp_customize,
            'aboutus_disable_section',
            array(
                'settings'      => 'aboutus_disable_section',
                'section'       => 'aboutus_setting',
                'label'         => __( 'Disable Section', 'cctv-security-camera' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'cctv-security-camera' ),
                    'off' => __( 'No', 'cctv-security-camera' )
                ),
            )
        )
    );
	

	// aboutus_image
	$wp_customize->add_setting(
    	'aboutus_image',
	    array(
	        'sanitize_callback' => 'esc_url_raw'
	    )
	);
	$wp_customize->add_control(
	    new WP_Customize_Image_Control(
	        $wp_customize,
	        'aboutus_image',
	        array(
			    'label'   		=> __('Image','cctv-security-camera'),
				'description'=> __('Image Size Should Be 408*672','cctv-security-camera'),
	            'section' => 'aboutus_setting',
	            'settings' => 'aboutus_image'
	        )
	    )
	);

	// aboutus_title
	$wp_customize->add_setting(
    	'aboutus_title',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_title',
		array(
		    'label'   		=> __('Title','cctv-security-camera'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	

	// aboutus_description
	$wp_customize->add_setting(
    	'aboutus_description',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_description',
		array(
		    'label'   		=> __('Description','cctv-security-camera'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	// aboutus_description2
	$wp_customize->add_setting(
    	'aboutus_description2',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_description2',
		array(
		    'label'   		=> __('Description 2','cctv-security-camera'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	// aboutus_box1heading
	$wp_customize->add_setting(
    	'aboutus_box1heading',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_box1heading',
		array(
		    'label'   		=> __('Box 1 Heading','cctv-security-camera'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	// aboutus_box1description
	$wp_customize->add_setting(
    	'aboutus_box1description',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_box1description',
		array(
		    'label'   		=> __('Box 1 Description','cctv-security-camera'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	// aboutus_box2heading
	$wp_customize->add_setting(
    	'aboutus_box2heading',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_box2heading',
		array(
		    'label'   		=> __('Box 2 Heading','cctv-security-camera'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	// aboutus_box2description
	$wp_customize->add_setting(
    	'aboutus_box2description',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_box2description',
		array(
		    'label'   		=> __('Box 2 Description','cctv-security-camera'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	// aboutus_box3heading
	$wp_customize->add_setting(
    	'aboutus_box3heading',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_box3heading',
		array(
		    'label'   		=> __('Box 3 Heading','cctv-security-camera'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	// aboutus_box3description
	$wp_customize->add_setting(
    	'aboutus_box3description',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_box3description',
		array(
		    'label'   		=> __('Box 3 Description','cctv-security-camera'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	// aboutus_featuretext1
	$wp_customize->add_setting(
    	'aboutus_featuretext1',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_featuretext1',
		array(
		    'label'   		=> __('Feature Text 1','cctv-security-camera'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	// aboutus_featuretext2
	$wp_customize->add_setting(
    	'aboutus_featuretext2',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_featuretext2',
		array(
		    'label'   		=> __('Feature Text 2','cctv-security-camera'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	// aboutus_featuretext3
	$wp_customize->add_setting(
    	'aboutus_featuretext3',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_featuretext3',
		array(
		    'label'   		=> __('Feature Text 3','cctv-security-camera'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);



	
	//style

	// aboutus title Color
	$aboutustitlecolor = esc_html__('#002434', 'cctv-security-camera' );
	$wp_customize->add_setting(
    	'aboutus_titlecolor',
    	array(
			'default' => $aboutustitlecolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_titlecolor',
		array(
		    'label'   		=> __('Title Color','cctv-security-camera'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// aboutus description Color
	$aboutusdescriptioncolor = esc_html__('#828282', 'cctv-security-camera' );
	$wp_customize->add_setting(
    	'aboutus_descriptioncolor',
    	array(
			'default' => $aboutusdescriptioncolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_descriptioncolor',
		array(
		    'label'   		=> __('Description Color','cctv-security-camera'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// aboutus boxicon Color
	$aboutusboxiconcolor = esc_html__('#000', 'cctv-security-camera' );
	$wp_customize->add_setting(
    	'aboutus_boxiconcolor',
    	array(
			'default' => $aboutusboxiconcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_boxiconcolor',
		array(
		    'label'   		=> __('Box Icon Color','cctv-security-camera'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// aboutus boxheading Color
	$aboutusboxheadingcolor = esc_html__('#000', 'cctv-security-camera' );
	$wp_customize->add_setting(
    	'aboutus_boxheadingcolor',
    	array(
			'default' => $aboutusboxheadingcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_boxheadingcolor',
		array(
		    'label'   		=> __('Box Heading Color','cctv-security-camera'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// aboutus boxdescription Color
	$aboutusboxbordercolor = esc_html__('#b5b4b4', 'cctv-security-camera' );
	$wp_customize->add_setting(
    	'aboutus_boxdescriptioncolor',
    	array(
			'default' => $aboutusboxbordercolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_boxdescriptioncolor',
		array(
		    'label'   		=> __('Box Description Color','cctv-security-camera'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// aboutus boxbg Color
	$aboutusboxbgcolor = esc_html__('#d9ffec', 'cctv-security-camera' );
	$wp_customize->add_setting(
    	'aboutus_boxbgcolor',
    	array(
			'default' => $aboutusboxbgcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_boxbgcolor',
		array(
		    'label'   		=> __('Box BG Color','cctv-security-camera'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// aboutus featuretext Color
	$aboutusfeaturetextcolor = esc_html__('#6c757d', 'cctv-security-camera' );
	$wp_customize->add_setting(
    	'aboutus_featuretextcolor',
    	array(
			'default' => $aboutusfeaturetextcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_featuretextcolor',
		array(
		    'label'   		=> __('Features Text Color','cctv-security-camera'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);




	$wp_customize->register_control_type('cctvsecuritycamera_Tab_Control');

}

add_action( 'customize_register', 'cctvsecuritycamera_blog_setting' );

// feature selective refresh
function cctvsecuritycamera_blog_section_partials( $wp_customize ){	
	// blog_title
	$wp_customize->selective_refresh->add_partial( 'blog_title', array(
		'selector'            => '.home-blog .title h6',
		'settings'            => 'blog_title',
		'render_callback'  => 'cctvsecuritycamera_blog_title_render_callback',
	
	) );
	
	// blog_subtitle
	$wp_customize->selective_refresh->add_partial( 'blog_subtitle', array(
		'selector'            => '.home-blog .title h2',
		'settings'            => 'blog_subtitle',
		'render_callback'  => 'cctvsecuritycamera_blog_subtitle_render_callback',
	
	) );
	
	// blog_description
	$wp_customize->selective_refresh->add_partial( 'blog_description', array(
		'selector'            => '.home-blog .title p',
		'settings'            => 'blog_description',
		'render_callback'  => 'cctvsecuritycamera_blog_description_render_callback',
	
	) );	
	}

add_action( 'customize_register', 'cctvsecuritycamera_blog_section_partials' );

// blog_title
function cctvsecuritycamera_blog_title_render_callback() {
	return get_theme_mod( 'blog_title' );
}

// blog_subtitle
function cctvsecuritycamera_blog_subtitle_render_callback() {
	return get_theme_mod( 'blog_subtitle' );
}

// feature description
function cctvsecuritycamera_blog_description_render_callback() {
	return get_theme_mod( 'blog_description' );
}


