<?php
function cctvsecuritycamera_header_settings( $wp_customize ) {
$selective_refresh = isset( $wp_customize->selective_refresh ) ? 'postMessage' : 'refresh';
	/*=========================================
	Header Settings Panel
	=========================================*/
	$wp_customize->add_panel( 
		'header_section', 
		array(
			'priority'      => 2,
			'capability'    => 'edit_theme_options',
			'title'			=> __('Header', 'cctv-security-camera'),
		) 
	);

	
	/*=========================================
	Cctv Security Camera Site Identity
	=========================================*/
	$wp_customize->add_section(
        'title_tagline',
        array(
        	'priority'      => 1,
            'title' 		=> __('Site Identity','cctv-security-camera'),
			'panel'  		=> 'header_section',
		)
    );


	// topheader Logo Width
    $wp_customize->add_setting('topheader_logowidth',array(
        'default' => 100,
        'sanitize_callback' => 'cctvsecuritycamera_sanitize_float'
    ));
    $wp_customize->add_control(new cctvsecuritycamera_Custom_Control( $wp_customize, 'topheader_logowidth',array(
	    'label' => __('Logo Width','cctv-security-camera'),
	    'section' => 'title_tagline',
	    'input_attrs' => array(
	            'min' => 0,
	            'max' => 500,
	            'step' => 1,
	        ),
    )));

	
	// logo section padding 
	$wp_customize->add_setting('cctvsecuritycamera_logo_padding',array(
		'sanitize_callback'   => 'esc_html'
	));
	$wp_customize->add_control('cctvsecuritycamera_logo_padding',array(
		'label' => __('Logo Padding','cctv-security-camera'),
		'section' => 'title_tagline'
	));

	$wp_customize->add_setting('cctvsecuritycamera_logo_top_padding',array(
		'default' => '2',
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('cctvsecuritycamera_logo_top_padding',array(
		'type' => 'number',
		'label' => __('Top','cctv-security-camera'),
		'section' => 'title_tagline',
	));

	$wp_customize->add_setting('cctvsecuritycamera_logo_left_padding',array(
		'default' => '2',
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('cctvsecuritycamera_logo_left_padding',array(
		'type' => 'number',
		'label' => __('Left','cctv-security-camera'),
		'section' => 'title_tagline',
	));

	$wp_customize->add_setting('cctvsecuritycamera_logo_bottom_padding',array(
		'default' => '2',
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('cctvsecuritycamera_logo_bottom_padding',array(
		'type' => 'number',
		'label' => __('Bottom','cctv-security-camera'),
		'section' => 'title_tagline',
	));

	$wp_customize->add_setting('cctvsecuritycamera_logo_right_padding',array(
		'default' => '2',
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('cctvsecuritycamera_logo_right_padding',array(
		'type' => 'number',
		'label' => __('Right','cctv-security-camera'),
		'section' => 'title_tagline',
	));


    // top header Site Title Color
	$topheadersitetitlecol = esc_html__('#fff', 'cctv-security-camera' );
	$wp_customize->add_setting(
    	'topheader_sitetitlecol',
    	array(
			'default' => $topheadersitetitlecol,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'topheader_sitetitlecol',
		array(
		    'label'   		=> __('Site Title Color','cctv-security-camera'),
		    'section'		=> 'title_tagline',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);


	// top header Tagline Color
	$topheadertaglinecol = esc_html__('#fff', 'cctv-security-camera' );
	$wp_customize->add_setting(
    	'topheader_taglinecol',
    	array(
			'default' => $topheadertaglinecol,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'topheader_taglinecol',
		array(
		    'label'   		=> __('Tagline Color','cctv-security-camera'),
		    'section'		=> 'title_tagline',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);
	
 
	/*=========================================
	Cctv Security Camera header
	=========================================*/
	$wp_customize->add_section(
        'top_header',
        array(
        	'priority'      => 5,
            'title' 		=> __('Header','cctv-security-camera'),
			'panel'  		=> 'header_section',
		)
    );	

	
    $wp_customize->add_setting('cctvsecuritycamera_top_header_tabs', array(
	   'sanitize_callback' => 'wp_kses_post',
	));

	$wp_customize->add_control(new cctvsecuritycamera_Tab_Control($wp_customize, 'cctvsecuritycamera_top_header_tabs', array(
	   'section' => 'top_header',
	   'priority' => 1,
	   'buttons' => array(
	      array(
     		'name' => esc_html__('General', 'cctv-security-camera'),
 			'icon' => 'dashicons dashicons-welcome-write-blog',
            'fields' => array(
            	'hide_show_sticky',
				'tophead_btntext',
				'tophead_btnlink'

            ),
            'active' => true,
         ),
	      array(
            'name' => esc_html__('Style', 'cctv-security-camera'),
            'icon' => 'dashicons dashicons-art',
            'fields' => array(
				'header_menuscolor',
            	'header_menushovercolor',
            	'header_submenusbgcolor',
            	'header_submenusbordercolor',
            	'header_submenutextcolor',
				'header_submenutexticoncolor',
            	'header_submenusbghovercolor',
            	'header_submenustxthovercolor',
				'header_iconscolor',
				'header_btntextcolor',
				'header_btnbgcolor1',
				'header_btnbgcolor2',
				'header_btnbgcolorhrv'
            ),
         )
	    
    	),
	)));


	// general setting

	// sticky header
	$wp_customize->add_setting( 'hide_show_sticky',array(
        'default' => false,
        'sanitize_callback' => 'cctvsecuritycamera_switch_sanitization'
   	) );
   	$wp_customize->add_control( new cctvsecuritycamera_Toggle_Switch_Custom_Control( $wp_customize, 'hide_show_sticky',array(
        'label' => __( 'Show Sticky Header','cctv-security-camera' ),
        'section' => 'top_header'
   	)));

	// tophead btntext
	$topheadbtntext = esc_html__('INITIALIZE', 'cctv-security-camera' );
	$wp_customize->add_setting(
    	'tophead_btntext',
    	array(
			'default' => $topheadbtntext,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 7,
		)
	);	

	$wp_customize->add_control( 
		'tophead_btntext',
		array(
		    'label'   		=> __('Button Text','cctv-security-camera'),
		    'section'		=> 'top_header',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	// tophead btnlink
	$topheadbtnlink = esc_html__('#', 'cctv-security-camera' );
	$wp_customize->add_setting(
    	'tophead_btnlink',
    	array(
			'default' => $topheadbtnlink,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 7,
		)
	);	

	$wp_customize->add_control( 
		'tophead_btnlink',
		array(
		    'label'   		=> __('Button Text','cctv-security-camera'),
		    'section'		=> 'top_header',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	

	// Style setting

	// header menus Color
	$headermenuscolor = esc_html__('#fff', 'cctv-security-camera' );
	$wp_customize->add_setting(
    	'header_menuscolor',
    	array(
			'default' => $headermenuscolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'header_menuscolor',
		array(
		    'label'   		=> __('Menus Color','cctv-security-camera'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// header menushover Color
	$headermenushovercolor = esc_html__('#8ECFF9', 'cctv-security-camera' );
	$wp_customize->add_setting(
    	'header_menushovercolor',
    	array(
			'default' => $headermenushovercolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'header_menushovercolor',
		array(
		    'label'   		=> __('Menus Hover & Active Color','cctv-security-camera'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	$headersubmenusbgcolor = esc_html__('#fff', 'cctv-security-camera' );
	$wp_customize->add_setting(
    	'header_submenusbgcolor',
    	array(
			'default' => $headersubmenusbgcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'header_submenusbgcolor',
		array(
		    'label'   		=> __('SubMenus BG Color','cctv-security-camera'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	$headersubmenusbordercolor = esc_html__('#8ECFF9', 'cctv-security-camera' );
	$wp_customize->add_setting(
    	'header_submenusbordercolor',
    	array(
			'default' => $headersubmenusbordercolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'header_submenusbordercolor',
		array(
		    'label'   		=> __('SubMenus Border Color','cctv-security-camera'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);


	// header submenutext Color
	$headersubmenutextcolor = esc_html__('#8ECFF9', 'cctv-security-camera' );
	$wp_customize->add_setting(
    	'header_submenutextcolor',
    	array(
			'default' => $headersubmenutextcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'header_submenutextcolor',
		array(
		    'label'   		=> __('SubMenus Text Color','cctv-security-camera'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// header submenutexticon Color
	$headersubmenutexticoncolor = esc_html__('#fff', 'cctv-security-camera' );
	$wp_customize->add_setting(
    	'header_submenutexticoncolor',
    	array(
			'default' => $headersubmenutexticoncolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'header_submenutexticoncolor',
		array(
		    'label'   		=> __('SubMenus Text Icon Color','cctv-security-camera'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// header submenusbghover Color
	$headersubmenusbghovercolor = esc_html__('#8ECFF9', 'cctv-security-camera' );
	$wp_customize->add_setting(
    	'header_submenusbghovercolor',
    	array(
			'default' => $headersubmenusbghovercolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'header_submenusbghovercolor',
		array(
		    'label'   		=> __('SubMenus BG Hover Color','cctv-security-camera'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// header submenustxthover Color
	$headersubmenustxthovercolor = esc_html__('#fff', 'cctv-security-camera' );
	$wp_customize->add_setting(
    	'header_submenustxthovercolor',
    	array(
			'default' => $headersubmenustxthovercolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'header_submenustxthovercolor',
		array(
		    'label'   		=> __('SubMenus Text Hover Color','cctv-security-camera'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// header icons Color
	$headericonscolor = esc_html__('#8ECFF9', 'cctv-security-camera' );
	$wp_customize->add_setting(
    	'header_iconscolor',
    	array(
			'default' => $headericonscolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'header_iconscolor',
		array(
		    'label'   		=> __('Icons Color','cctv-security-camera'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// header btntext Color
	$headerbtntextcolor = esc_html__('#fff', 'cctv-security-camera' );
	$wp_customize->add_setting(
    	'header_btntextcolor',
    	array(
			'default' => $headerbtntextcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'header_btntextcolor',
		array(
		    'label'   		=> __('Button Text Color','cctv-security-camera'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// header btnbg Color1
	$headerbtnbgcolor1 = esc_html__('#06b6d4', 'cctv-security-camera' );
	$wp_customize->add_setting(
    	'header_btnbgcolor1',
    	array(
			'default' => $headerbtnbgcolor1,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'header_btnbgcolor1',
		array(
		    'label'   		=> __('Button BG Color 1','cctv-security-camera'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// header btnbg Color1
	$headerbtnbgcolor2 = esc_html__('#51a2ff', 'cctv-security-camera' );
	$wp_customize->add_setting(
    	'header_btnbgcolor2',
    	array(
			'default' => $headerbtnbgcolor2,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'header_btnbgcolor2',
		array(
		    'label'   		=> __('Button BG Color 2','cctv-security-camera'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// header btnbg Color1
	$headerbtnbgcolorhrv = esc_html__('#2B85DD', 'cctv-security-camera' );
	$wp_customize->add_setting(
    	'header_btnbgcolorhrv',
    	array(
			'default' => $headerbtnbgcolorhrv,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'header_btnbgcolorhrv',
		array(
		    'label'   		=> __('Button BG Hover Color','cctv-security-camera'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);



	$wp_customize->register_control_type('cctvsecuritycamera_Tab_Control');
	$wp_customize->register_panel_type( 'cctvsecuritycamera_WP_Customize_Panel' );
	$wp_customize->register_section_type( 'cctvsecuritycamera_WP_Customize_Section' );

}
add_action( 'customize_register', 'cctvsecuritycamera_header_settings' );



if ( class_exists( 'WP_Customize_Panel' ) ) {
  	class cctvsecuritycamera_WP_Customize_Panel extends WP_Customize_Panel {
	   public $panel;
	   public $type = 'cctvsecuritycamera_panel';
	   public function json() {

	      $array = wp_array_slice_assoc( (array) $this, array( 'id', 'description', 'priority', 'type', 'panel', ) );
	      $array['title'] = html_entity_decode( $this->title, ENT_QUOTES, get_bloginfo( 'charset' ) );
	      $array['content'] = $this->get_content();
	      $array['active'] = $this->active();
	      $array['instanceNumber'] = $this->instance_number;
	      return $array;
    	}
  	}
}

if ( class_exists( 'WP_Customize_Section' ) ) {
  	class cctvsecuritycamera_WP_Customize_Section extends WP_Customize_Section {
	   public $section;
	   public $type = 'cctvsecuritycamera_section';
	   public function json() {

	      $array = wp_array_slice_assoc( (array) $this, array( 'id', 'description', 'priority', 'panel', 'type', 'description_hidden', 'section', ) );
	      $array['title'] = html_entity_decode( $this->title, ENT_QUOTES, get_bloginfo( 'charset' ) );
	      $array['content'] = $this->get_content();
	      $array['active'] = $this->active();
	      $array['instanceNumber'] = $this->instance_number;

	      if ( $this->panel ) {
	        $array['customizeAction'] = sprintf( 'Customizing &#9656; %s', esc_html( $this->manager->get_panel( $this->panel )->title ) );
	      } else {
	        $array['customizeAction'] = 'Customizing';
	      }
	      return $array;
    	}
  	}
}






