<section id="ourservice-section" class="ourservice-area home-ourservice">

    <div class="overlay"></div>
    <div class="overlay2"></div>

    <?php 
        $toppawingicon = get_template_directory_uri().'/assets/images/toppawimage.png';
    ?>
    <div class="container-fluid">
        <div class="heading">
            <div class="scanner-wrapper">
                <div class="scanner-panel">
                    <div class="scanner-overlay"></div>
                    <div class="scanner-content">
                    <svg width="160" height="60" viewBox="0 0 160 60">
                        <defs>
                        <linearGradient id="neonGlow" x1="0%" y1="0%" x2="100%" y2="0%">
                            <stop offset="0%" stop-color="rgba(0, 255, 127, 0)"></stop>
                            <stop offset="50%" stop-color="rgba(0, 255, 127, 1)"></stop>
                            <stop offset="100%" stop-color="rgba(0, 191, 255, 0)"></stop>
                        </linearGradient>
                        </defs>
                        <line x1="0" y1="30" x2="160" y2="30" stroke="url(#neonGlow)" stroke-width="3" class="pulse"></line>
                        <circle cx="30" cy="30" r="4" fill="cyan" class="pulse-circle"></circle>
                        <circle cx="80" cy="30" r="5" fill="#00FF7F" class="pulse-circle delay-1"></circle>
                        <circle cx="130" cy="30" r="4" fill="cyan" class="pulse-circle delay-2"></circle>
                        <rect x="65" y="20" width="30" height="20" fill="none" stroke="cyan" stroke-width="1" opacity="0.5"></rect>
                        <text x="80" y="32" text-anchor="middle" fill="cyan" font-size="8" class="">SCAN</text>
                    </svg>
                    </div>
                    <!-- glowing dots around -->
                    <div class="dot ping" style="top:-12px; left:-12px;"></div>
                    <div class="dot pulse-circle" style="top:-8px; right:-20px; width:12px; height:12px; background:cyan;"></div>
                    <div class="dot ping delay-1" style="bottom:-12px; right:-12px;"></div>
                    <div class="dot pulse-circle delay-2" style="bottom:-8px; left:-20px; width:12px; height:12px; background:cyan;"></div>
                </div>
            </div>
            <h2> <span>CCTV </span> <?php echo esc_html(get_theme_mod('ourservice_heading')); ?></h2>
        <div class="textbx">
            <div class="highlight-bg"></div>
            <h3><?php echo esc_html(get_theme_mod('ourservice_subheading')); ?></h3>
        </div>
            <div class="service-list ">
                <h4 class="service-list-product1"><?php echo esc_html(get_theme_mod('ourservice_serviceslist1')); ?></h4>
                <h4 class="service-list-product2"><?php echo esc_html(get_theme_mod('ourservice_serviceslist2')); ?></h4>
                <h4 class="service-list-product3"><?php echo esc_html(get_theme_mod('ourservice_serviceslist3')); ?></h4>
            </div>
        </div>



        <div class="ourtbx"> 
            <div class="row">
                <?php for($p=1; $p<7; $p++) { ?>
                <?php if( get_theme_mod('ourservice'.$p,false)) { ?>
                <?php $querycolumns = new WP_query('page_id='.get_theme_mod('ourservice'.$p,true)); ?>
                <?php while( $querycolumns->have_posts() ) : $querycolumns->the_post(); 
                $image = wp_get_attachment_image_src(get_post_thumbnail_id() , true); ?>
                <?php 
                if(has_post_thumbnail()){
                    $img = esc_url($image[0]);
                }
                if(empty($image)){
                    $img = get_template_directory_uri().'/assets/images/default.png';
                }
                ?>

                <div class="col-md-6 col-lg-4 box-space pd-0">
                    <div class="threebox box<?php echo esc_attr( $p ) ?> <?php if($p % 3 == 0) { echo "last_column"; } ?>">    
                        <div class="single-ourservice">
                            <div class="part-2">
                                <a href="<?php echo esc_url( get_permalink() ); ?>">
                                    <h3 class="title"><?php the_title_attribute(); ?></h3>
                                </a>
                                <div class="description"><?php the_excerpt(); ?></div>
                                <div class="row m-0">
                                    <div class="list">
                                        <li><?php esc_html_e('HD/4K Camera Setup','cctv-security-camera'); ?></li>
                                        <li><?php esc_html_e('Professional Wiring','cctv-security-camera'); ?></li>
                                        <li><?php esc_html_e('Optimal Positioning','cctv-security-camera'); ?></li>
                                    </div>
                                    <div class="imgbx">
                                        <img src="<?php echo esc_url($img); ?>" alt="<?php the_title_attribute(); ?>">
                                    </div>
                                </div>
                                <div class="serv-btn">
                                    <a href="<?php echo esc_url( get_permalink() ); ?>">
                                        <?php esc_html_e('Learn More','cctv-security-camera'); ?> <i class="fa fa-arrow-right" ></i>
                                    </a>
                                </div>  
                            </div>
                            		
                            <div class="clearfix"></div>
                        </div>
                    </div>
                </div>
                <?php endwhile;
            wp_reset_postdata(); ?>
            <?php } } ?>
            <div class="clear"></div> 
            </div>
        </div> 
	</div>
</section>
