<?php 
/**
 * The template for displaying archive pages.
 *
 * Used for displaying archive-type pages. These views can be further customized by
 * creating a separate template for each one.
 *
 * - author.php (Author archive)
 * - category.php (Category archive)
 * - date.php (Date archive)
 * - tag.php (Tag archive)
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 */
?>
<?php get_header(); ?> 
<div class="<?php if(get_theme_mod('peccular_blog_page_width','Box Width') == 'Box Width'){ ?>container <?php } elseif(get_theme_mod('peccular_blog_page_width','Box Width') == 'Full Width'){ ?> container-fluid <?php }?>">  
	<?php
	if(get_theme_mod('page_title_on_off') != 'on' ){
		?>   
		<div class='button'> <?php the_archive_title( '<h1 class="ht-main-title">', '</h1>' ); ?></div>
	<?php } ?>   
</div>
<main id="innerpage-box">
	<div class="<?php if(get_theme_mod('peccular_blog_page_width','Box Width') == 'Box Width'){ ?>container <?php } elseif(get_theme_mod('peccular_blog_page_width','Box Width') == 'Full Width'){ ?> container-fluid <?php }?>">  

		<div class="inner_contentbox">
			<div class="row m-0">
				 <div id="blog-box" class="ht-blog-wrap innerpage-whitebox col-xl-9 col-lg-8 col-md-7 col-sm-6 col-xs-12">
					<div class="innerblogpost"> 
						<div class="md-0">
							<?php if ( have_posts() ) :
								$peccular_lite_full_posts = get_theme_mod('peccular_lite_full_posts');
								while ( have_posts() ) : the_post();
									peccular_lite_archive_post();
								endwhile;
								peccular_lite_post_navigation();
							endif; ?>
							<div class="clearfix"></div>
						</div>
						<div class="clearfix"></div>
					</div>
				</div> <!-- col 9-->
				<div class="col-xl-3 col-lg-4 col-md-5 col-sm-6 col-xs-12 p-0">
					<div id="secondary" class="widget-area">
						<?php dynamic_sidebar('peccular-blog-sidebar'); ?>
					</div>
				</div>
				<div class="clearfix"></div>
				<div class="pagingation">
					<?php lzGetPagination($query);?>
				</div>
			</div>
			<div class="clearfix"></div>
		</div>
		<div class="clearfix"></div>
	</div>
</main>

<script>
	jQuery.noConflict();
	$(function(){
		function innerblogpostHeight(){
			var ht = 0;
			$('.inner-blogpost').each(function(i){
				var tHt = $(this).height();
				if(ht<tHt){
					ht=tHt;
				}
			});
			$('.inner-blogpost').height(ht+'px');
		}
		innerblogpostHeight();
	});
	$( window ).resize(function(){
		innerblogpostHeight();
	});
</script>

<?php get_footer(); ?>