<?php     
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package peccular Premium
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<script src="https://use.fontawesome.com/18a9c36ed1.js"></script>
	
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/bootstrap.min.css">
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/animate.css" />
	<link rel="preconnect" href="https://fonts.gstatic.com"> 
	<link rel="preconnect" href="https://fonts.googleapis.com">
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>

	<link href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap" rel="stylesheet">

	<link href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap" rel="stylesheet">

	<link rel="preconnect" href="https://fonts.gstatic.com"> 
	<link href="https://fonts.googleapis.com/css2?family=Allerta&display=swap" rel="stylesheet">
	
	<!-- new ico -->
	<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css
	" rel="stylesheet">

	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/home1.css">
	<!-- video css-->
	<link rel="stylesheet" href="https://vjs.zencdn.net/7.1.0/video-js.css" rel="stylesheet">

	<link rel="preconnect" href="https://fonts.googleapis.com">
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
	<link href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&family=Tenor+Sans&display=swap" rel="stylesheet">

	<script src="<?php echo get_template_directory_uri(); ?>/js/jquery-3.1.1.slim.min.js" crossorigin="anonymous"></script>
	<script src="<?php echo get_template_directory_uri(); ?>/js/bootstrap.min.js" type="text/javascript"  ></script>
	<script src="<?php echo get_template_directory_uri(); ?>/js/wow.js" ></script>
	<script src="https://cdnjs.cloudflare.com/ajax/libs/video.js/7.2.2/video.min.js"></script>
	
	<script type="text/javascript">
		$(document).ready(function(){
			$("#formButton").click(function(){
				$("#form1").toggle();
			});
		});
	</script>

	<script type="text/javascript">
		$(document).ready(function(){
			$("button.box1-acc").click(function(){
				$(".box-1").toggle();
			});
		});
	</script>
	<script type="text/javascript">
		$(document).ready(function(){
			$("button.box2-acc").click(function(){
				$(".box-2").toggle();
				$('.box-1.prowoocoomercetab-description').hide(0);
			});
		});
	</script>
	<script type="text/javascript">
		$(document).ready(function(){
			$("button.box3-acc").click(function(){
				$(".box-3").toggle();
				$('.box-2.prowoocoomercetab-description').hide(0);

			});
		});
	</script>
	<script type="text/javascript">
		$(document).ready(function(){
			$("button.box4-acc").click(function(){
				$(".box-4").toggle();

			});
		});
	</script>
	<script type="text/javascript">
		$(document).ready(function(){
			$("button.box5-acc").click(function(){
				$("div#reviews").toggle();
				$('.box-3.prowoocoomercetab-description').hide(0);

			});
		});
	</script> 
	<!-- <script type="text/javascript"> -->
		<!-- $(document).ready(function(){ -->
		<!-- $("i.uil.fa.fa-bars.cart-button").click(function(){ -->
		<!-- $("#sidebar-cart").toggle(); -->
		<!-- }); -->
		<!-- }); -->
		<!-- </script> -->
		<script>

			$(document).ready(function($) {

	// Declare the body variable

				var $body = $("body");

	// Function that shows and hides the sidebar cart

				$(".cart-button, .close-button, #sidebar-cart-curtain").click(function(e) {

					e.preventDefault();

		// Add the show-sidebar-cart class to the body tag

					$body.toggleClass("show-sidebar-cart");

		// Check if the sidebar curtain is visible

					if ($("#sidebar-cart-curtain").is(":visible")) {

			// Hide the curtain

						$("#sidebar-cart-curtain").fadeOut(500);

					} else {

			// Show the curtain

						$("#sidebar-cart-curtain").fadeIn(500);

					}

				});

	// Function that adds or subtracts quantity when a 

	// plus or minus button is clicked

				$body.on('click', '.plus-button, .minus-button', function () {

		// Get quanitity input values

					var qty = $(this).closest('.qty').find('.qty-input');

					var val = parseFloat(qty.val());

					var max = parseFloat(qty.attr('max'));

					var min = parseFloat(qty.attr('min'));

					var step = parseFloat(qty.attr('step'));

		// Check which button is clicked

					if ($(this).is('.plus-button')) {

			// Increase the value

						qty.val(val + step);

					} else {

			// Check if minimum button is clicked and that value is 

			// >= to the minimum required

						if (min && min >= val) {

				// Do nothing because value is the minimum required

							qty.val(min);

						} else if (val > 0) {

				// Subtract the value

							qty.val(val - step);

						}

					}

				});

			});

		</script>

		
		<?php wp_head(); ?>

	</head>

	<body <?php body_class(); ?>>
		<div class="main-container">
			<div id="loading-area"><div class="la-anim-10"></div></div>
			<!-- header -->
			<!-- #masthead -->
			<?php if(get_theme_mod('peccular_header_style', 'Above Slider') == 'Above Slider' ){ ?>
				<header class="site-header header-transparent header mo-left header-seo" style="position:relative;">
					<div class="header-bg">
						<div class="mainbottom-header top-bar-head bottom-header <?php echo esc_attr(bakerystore_sticky_menu()); ?>">
							<?php
							$header_top_tagline = get_theme_mod('header_top_tagline', 'Get 15 % Off Your Dream Room Furniture And Elevate Your Space For Less!');
							?>	
							<?php if($header_top_tagline){ ?>			
								<div class="top-bar m-0"> 
									<div class="<?php if(get_theme_mod('peccular_header_width','Box Width') == 'Box Width'){ ?>container <?php } elseif(get_theme_mod('peccular_header_width','Box Width') == 'Full Width'){ ?> container-fluid <?php }?>">
										<div class="row m-0">
											<div class="col-xl-12 col-lg-12 col-md-10 col-sm-10 text-center p-0">
												<div class="taglinne"><?php echo ($header_top_tagline );  ?></div>
											</div>	
										</div>
									</div>
								</div>
							<?php }?>

							<div class="<?php if(get_theme_mod('peccular_header_width','Box Width') == 'Box Width'){ ?>container <?php } elseif(get_theme_mod('peccular_header_width','Box Width') == 'Full Width'){ ?> container-fluid<?php }?>">	

								<div class="header-nav-area bottom--header">
									<div class="row m-0">
										<?php
										$header__womencategories = get_theme_mod('header__womencategories', 'Women');
										$header__womencategorieslink = get_theme_mod('header__womencategorieslink', '');  

										$header__mencategories = get_theme_mod('header__mencategories', 'Men');
										$header__mencategorieslink = get_theme_mod('header__mencategorieslink', '');  
										?>
										<?php 
										if( get_theme_mod('pages_logoTopsetmaxwidth',true) ) {
											$pages_logoTopsetmaxwidth = 'max-width:'.esc_attr(get_theme_mod('pages_logoTopsetmaxwidth')).';';
										}
										if( get_theme_mod('pages_logoheight',true) ) {
											$pages_logoheight = 'height:'.esc_attr(get_theme_mod('pages_logoheight')).';';
										}
										if( get_theme_mod('pages_logoToppadding',true) ) {
											$pages_logoToppadding = 'padding-top:'.esc_attr(get_theme_mod('pages_logoToppadding')).';';
										}
										if( get_theme_mod('pages_logobottompadding',true) ) {
											$pages_logobottompadding = 'padding-bottom:'.esc_attr(get_theme_mod('pages_logobottompadding')).';';
										}
										if( get_theme_mod('pages_logoTopmargin',true) ) {
											$pages_logoTopmargin = 'margin-top:'.esc_attr(get_theme_mod('pages_logoTopmargin')).';';
										}
										if( get_theme_mod('pages_logobottommargin',true) ) {
											$pages_logobottommargin = 'margin-bottom:'.esc_attr(get_theme_mod('pages_logobottommargin')).';';
										}
										?>
										<div class="col-xl-4 col-lg-4 col-md-3 col-sm-3 p-0">
											<?php if( get_theme_mod('peccular_header_catbox_display','show' ) == 'show') :
												?> 
												<?php if(class_exists('woocommerce')){ ?>
													<div class="sec-center">
														<input class="dropdown" type="checkbox" id="dropdown" name="dropdown"/>
														<label class="for-dropdown heading-font" for="dropdown"><i class="uil fa fa-bars cart-button"></i></label>
														<aside id="sidebar-cart">
															<main>
																<a href="#" class="close-button"><span class="close-icon">X</span></a>
																<h2>Product Categories</h2>
																<ul class="products">
																	<li class="product">
																		<a href="#" class="product-link">

																			<span class="product-details">
																				<?php
																				$categories = get_theme_mod('peccular_headercat_categories');
																				$args = array(
																					'number'     => 0,
																					'orderby'    => 'title',
																					'order'      => 'ASC',
																					'hide_empty' => false,
																					'include' => $categories 
																				);
																				$product_categories = get_terms( 'product_cat', $args );
																				$count = count($product_categories);
																				if ( $count > 0 ){
																					foreach ( $product_categories as $product_category ) {
																						$cat_id   = $product_category->term_id;
																						$cat_link = get_category_link( $cat_id );
																						if ($product_category->category_parent == 0) { ?>
																							<li class="drp_dwn_menu"><a href="<?php echo esc_url(get_term_link( $product_category ) ); ?>">
																								<?php
																							}
																							echo esc_html( $product_category->name ); ?></a></li>
																							<?php
																						}
																					}
																					?> 
																				</span>
																			</a>
																		</li>
																	</ul>
																	
																</main>
																<div class="header-socials">
																	<div class="header-soc-ico">

																		<div class="row m-0">

																			<?php    

																			$facebook = get_theme_mod('ip_header_facebook', '//facebook.com/');

																			$twitter = get_theme_mod('ip_header_twitter', '//twitter.com/');

																			$instagram = get_theme_mod('ip_header_instagram', 'https://www.instagram.com/');

																			$phoneTaglineNumber = get_theme_mod('phoneTaglineNumber', 'Share :');	



																			?>

																			<div class="col-xl-3 col-lg-3 col-md-3 p-0 social-tagline">

																				<?php echo ($phoneTaglineNumber);  ?>

																			</div>

																			<div class="col-xl-6 col-lg-6 col-md-9 social-ico-bx">

																				<?php if(!empty($facebook)){ ?>

																					<li class="list-inline-item">

																						<a href="<?php echo $facebook ?>" title="Facebook" class="ip-btn-cl sharp" target="_blank"><i class="fa fa-facebook"></i></a>

																					</li>

																				<?php }?>

																				<?php if(!empty($twitter)){ ?>

																					<li class="list-inline-item">

																						<a href="<?php echo $twitter ?>" title="Twitter" class="ip-btn-cl sharp" target="_blank"><i class="fa-brands fa-x-twitter"></i>

																						</a>

																					</li>

																				<?php }?>

																				<?php if(!empty($instagram)){ ?>

																					<li class="list-inline-item"><a href="<?php echo $instagram ?>" title="instagram" class="ip-btn-cl sharp" target="_blank"><i class="fa fa-instagram"></i></a></li>

																				<?php }?>										

																			</div>

																		</div>
																	</div>
																</div>

															</aside>
														</div>

													<?php }else {
														echo '<h6 class="heading-font">'.esc_html('Please Install Woocommerce Plugin','furniture-mart-pro').'<h6>'; }?>
													<?php endif ?>
												</div>
												
												<div class="col-xl-4 col-lg-4 col-md-7 col-sm-6">
													<div class="header-logo">
														<?php 
														if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
															the_custom_logo();
													else : 
														if ( is_front_page() ) : ?>
															<?php if (get_theme_mod('peccular_show_site_title',true)) : ?>
																<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
															<?php endif; ?>
														<?php else : ?>
															<p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
														<?php endif; ?>
													<?php endif; ?> 
													<?php if (get_theme_mod('peccular_show_tagline',false)) {?>
														<p class="ht-site-description"><?php bloginfo( 'description' ); ?></p>
													<?php }?>		
												</div>
											</div>
											<div class="col-xl-4 col-lg-4 col-md-2 col-sm-3 p-0">
												<?php 

												$user_id = get_current_user_id();

												$wishlist = get_user_meta($user_id, 'wishlist', true);

												$wishlist_count = is_array($wishlist) ? count($wishlist) : 0;

					            $wishlist_page = get_page_by_path('wishlist'); // Make sure you have a page with slug 'wishlist'

					            $wishlist_url = $wishlist_page ? get_permalink($wishlist_page->ID) : '#'; 

					            ?>
					            <a href="<?php echo esc_url($wishlist_url); ?>" class="wishlist-link">

					            	<i class="fa fa-heart"></i>

					            	<?php if ($wishlist_count > 0): ?>

					            		<span class="wishlist-count"><?php echo esc_html($wishlist_count); ?></span>

					            	<?php endif; ?>

					            	<span class="tooltip-text">Wishlist</span>

					            </a>

					            <div class="row top-account-info m-0">
					            	<div class="col-xl-10 col-lg-9 col-md-5 col-sm-5 top-form width-auto">
					            		<?php if( get_theme_mod('peccular_header_sbutton_enable',true) == true){ ?>
					            			<button type="button" id="formButton" class="pull-right"></button>
					            			<form id="form1" role="search" method="get" class="woocommerce-product-search" action="<?php echo esc_url( home_url( '/'  ) ); ?>">
					            				<label class="screen-reader-text" for="s"><?php _e( 'Search for:', 'woocommerce' ); ?></label>
					            				<input type="search" class="effect-24" placeholder="Search Product" value="<?php echo get_search_query(); ?>" name="s" title="<?php echo esc_attr_x( 'Search for:', 'label', 'woocommerce' ); ?>" />
					            				<input type="submit" value="<?php echo esc_attr_x( 'Search', 'submit button', 'woocommerce' ); ?>" />
					            				<input type="hidden" name="post_type" value="product" />
					            			</form>
					            		<?php }?>	
					            	</div>
					            	<div class="col-xl-2 col-lg-3 col-md-7 col-sm-3 header-woo-cart p-0 width-auto">
					            		<div class="row">
					            			<div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 width-auto">
					            				<?php
					            				$peccular_headermyacccbtnlink = get_theme_mod('peccular_headermyacccbtnlink', '');  
					            				?>
					            				<a class="my-acc" href="<?php echo $peccular_headermyacccbtnlink ?>"> <i class="fa fa-user-o"></i></a>	</div>
					            				<div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 width-auto">
					            					<?php if(function_exists ('wc_get_cart_url')){?>	
					            						<div class="total-count">
					            							<?php if( get_theme_mod('peccular_checkout_button_display','show' ) == 'show') :
					            								?>  
					            								<div class="mini-cart-dropdown"> 
					            									<?php global $woocommerce; ?> <i class="fa fa-shopping-bag"></i> <?php echo WC()->cart->get_cart_contents_count(); ?> Items - <?php echo WC()->cart->get_cart_total(); ?> 
					            									<?php
					            									$peccular_checkoutbutton = get_theme_mod('peccular_checkoutbutton', 'Checkout'); 
					            									$peccular_checkoutbtnlink = get_theme_mod('peccular_checkoutbtnlink', '');  
					            									?>
					            									<div class="btncheckout">
					            										<a class="btn-checkout" target="_blank" href="<?php echo $peccular_checkoutbtnlink ?>"><span> <?php echo ($peccular_checkoutbutton );  ?></span></a>	
					            									</div>
					            								</div>	
					            							<?php endif ?>
					            							<a class="" href="<?php echo wc_get_cart_url();?>">
					            								<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="20" height="20" viewBox="0 0 20 20">
					            									<defs>
					            										<pattern id="pattern" preserveAspectRatio="xMidYMid slice" width="100%" height="100%" viewBox="0 0 512 512">
					            											<image width="512" height="512" xlink:href="data:image/png;base64,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"/>
					            										</pattern>
					            									</defs>
					            									<rect id="shopping-bag" width="20" height="20" fill="url(#pattern)"/>
					            								</svg>
					            							</a>
					            							<div class="count"><?php global $woocommerce; ?> <?php echo WC()->cart->get_cart_contents_count(); ?> 
					            						</div> 
					            					</div>
					            				<?php }?>
					            			</div>

					            		</div>

					            	</div>
					            </div>
					        </div>
					    </div>
					</div>			 
					<div class="row row-eq-height md-1">
						<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-xs-12 head-menu pd-0">
							<div class="inside-full-height">
								<?php
								if( get_theme_mod('menu_fontsize',true) ) {
									$menu_fontsize = 'font-size:'.esc_attr(get_theme_mod('menu_fontsize')).';';
								}
								if( get_theme_mod('dropdown_menu_fontsize',true) ) {
									$dropdown_menu_fontsize = 'font-size:'.esc_attr(get_theme_mod('dropdown_menu_fontsize')).';';
								}
								?>
								<div class="site-navigation">
									<div class="hamburger-menus">
										<span></span>
										<span></span>
										<span></span>
										<span></span>
										<span></span>
										<span></span>
										<span></span>
										<span></span>
										<span></span>
									</div>
									<nav class="navigation">
										<div class="overlaybg"></div><!--  /.overlaybg -->
										<!-- Main Menu -->
										<div class="menu-wrapper">
											<div class="menu-content">
												<?php
												if( get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true) !=='0') {
													wp_nav_menu ( array(
														'menu_class' => 'mainmenu ht-clearfix',
														'container'=> 'ul',
														'menu' => get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true),
														'theme_location' => 'primary',  
													)); 
												} else {
													wp_nav_menu ( array(
														'menu_class' => 'mainmenu ht-clearfix',
														'container'=> 'ul',
														'theme_location' => 'primary',  
													)); 
												}
												?>
											</div> <!-- /.hours-content-->

											<div class="clearfix"></div>

										</div><!-- /.menu-wrapper -->

									</nav>	
								</div><!--  /.site-navigation -->
							</div>
							<div class="clearfix"></div> 
						</div><!--9div close-->
					</div>
				</div>
			</div>		
			<!-- </div>				
			<div class="clearfix"></div>
		</div> -->
		<!--end main top header-->	 
	</div>
	<div class="clearfix"></div>
</header>

<?php } elseif(get_theme_mod('peccular_header_style', 'On Slider') == 'Above Slider' ){ ?>

	<header class="site-header header-transparent header mo-left header-seo" style="position:relative">
		<div class="mainbottom-header top-bar-head bottom-header " style="border-radius: 0px;">
			<div class="top-bar m-0">
				<div class="<?php if(get_theme_mod('peccular_header_width','Box Width') == 'Box Width'){ ?>container <?php } elseif(get_theme_mod('peccular_header_width','Box Width') == 'Full Width'){ ?> container-fluid pd-0<?php }?> <?php if( get_theme_mod( 'peccular_show_sticky_header', false) != '') { ?>sticky-header peccular-header <?php } ?>">	
					<div class="row">
						<?php
						$header_top_tagline = get_theme_mod('header_top_tagline', 'Exclusive Offers Just a Click Away – ');
						$header__top_link = get_theme_mod('header__top_link', 'Shop Now!');  
						$header__shoplink = get_theme_mod('header__shoplink', '');  
						$singnin_text = get_theme_mod('singnin_text', 'Sign In Or Join Now');
						$singnin_textlink = get_theme_mod('singnin_textlink', '');
						?>	
						<div class="col-xl-6 col-lg-6 col-md-6 col-sm-6">
							<div class="taglinne"><?php echo ($header_top_tagline );  ?> <a href="<?php echo $header__shoplink ?>"><?php echo ($header__top_link );  ?></a></div>
						</div>	
						<div class="col-xl-6 col-lg-6 col-md-4 col-sm-4">
							<div class="tagline text-right">
								<a href="<?php echo $singnin_textlink ?>"><?php echo ($singnin_text );  ?></a></div>
							</div>	
						</div>
					</div>
				</div>

				<div class="<?php if(get_theme_mod('peccular_header_width','Box Width') == 'Box Width'){ ?>container <?php } elseif(get_theme_mod('peccular_header_width','Box Width') == 'Full Width'){ ?> container-fluid pd-0<?php }?> <?php if( get_theme_mod( 'peccular_show_sticky_header', false) != '') { ?>sticky-header peccular-header <?php } ?>">	
					<div class="header-nav-area">
						<div class="row m-0">
							<?php
							$header__womencategories = get_theme_mod('header__womencategories', 'Women');
							$header__womencategorieslink = get_theme_mod('header__womencategorieslink', '');  

							$header__mencategories = get_theme_mod('header__mencategories', 'Men');
							$header__mencategorieslink = get_theme_mod('header__mencategorieslink', '');  
							?>
							<?php 
							if( get_theme_mod('pages_logoTopsetmaxwidth',true) ) {
								$pages_logoTopsetmaxwidth = 'max-width:'.esc_attr(get_theme_mod('pages_logoTopsetmaxwidth')).';';
							}
							if( get_theme_mod('pages_logoheight',true) ) {
								$pages_logoheight = 'height:'.esc_attr(get_theme_mod('pages_logoheight')).';';
							}
							if( get_theme_mod('pages_logoToppadding',true) ) {
								$pages_logoToppadding = 'padding-top:'.esc_attr(get_theme_mod('pages_logoToppadding')).';';
							}
							if( get_theme_mod('pages_logobottompadding',true) ) {
								$pages_logobottompadding = 'padding-bottom:'.esc_attr(get_theme_mod('pages_logobottompadding')).';';
							}
							if( get_theme_mod('pages_logoTopmargin',true) ) {
								$pages_logoTopmargin = 'margin-top:'.esc_attr(get_theme_mod('pages_logoTopmargin')).';';
							}
							if( get_theme_mod('pages_logobottommargin',true) ) {
								$pages_logobottommargin = 'margin-bottom:'.esc_attr(get_theme_mod('pages_logobottommargin')).';';
							}
							?>
							<div class="col-xl-4 col-lg-4 col-md-3 col-sm-3 p-0">
								<ul class="dropdown">
									<li><a href="<?php echo $header__womencategorieslink ?>"><?php echo ($header__womencategories );  ?></a> </li>
									<li><a href="<?php echo $header__mencategorieslink ?>"><?php echo ($header__mencategories );  ?></a> </li>		
								</ul> 	
							</div>
							<div class="col-xl-4 col-lg-5 col-md-7 col-sm-7">
								<?php 
								if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
									the_custom_logo();
							else : 
								if ( is_front_page() ) : ?>
									<?php if (get_theme_mod('peccular_show_site_title',true)) : ?>
										<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
									<?php endif; ?>
								<?php else : ?>
									<p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
								<?php endif; ?>
							<?php endif; ?> 
							<?php if (get_theme_mod('peccular_show_tagline',false)) {?>
								<p class="ht-site-description"><?php bloginfo( 'description' ); ?></p>
							<?php }?>		
						</div>
						<div class="col-xl-4 col-lg-3 col-md-2 col-sm-2 p-0">
							<div class="row top-account-info">
								<?php if( get_theme_mod('peccular_header_sbutton_enable',true) == true){ ?>
									<div class="col-xl-9 col-lg-9 col-md-9 col-sm-6 top-form width-auto">
										<button type="button" id="formButton" class="pull-right"></button>
										<form id="form1" role="search" method="get" class="woocommerce-product-search" action="<?php echo esc_url( home_url( '/'  ) ); ?>">
											<label class="screen-reader-text" for="s"><?php _e( 'Search for:', 'woocommerce' ); ?></label>
											<input type="search" class="effect-24" placeholder="Search Product" value="<?php echo get_search_query(); ?>" name="s" title="<?php echo esc_attr_x( 'Search for:', 'label', 'woocommerce' ); ?>" />
											<input type="submit" value="<?php echo esc_attr_x( 'Search', 'submit button', 'woocommerce' ); ?>" />
											<input type="hidden" name="post_type" value="product" />
										</form>
									</div>
								<?php }?>	

								<div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 header-woo-cart p-0 width-auto">
									<div class="row">
										<div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 width-auto">
											<?php if(function_exists ('wc_get_cart_url')){?>	
												<div class="total-count">
													<?php if( get_theme_mod('peccular_checkout_button_display','show' ) == 'show') :
														?>  
														<div class="mini-cart-dropdown"> 
															<?php global $woocommerce; ?> <i class="fa fa-shopping-bag"></i> <?php echo WC()->cart->get_cart_contents_count(); ?> Items - <?php echo WC()->cart->get_cart_total(); ?> 
															<?php
															$peccular_checkoutbutton = get_theme_mod('peccular_checkoutbutton', 'Checkout'); 
															$peccular_checkoutbtnlink = get_theme_mod('peccular_checkoutbtnlink', '');  
															?>
															<div class="btncheckout">
																<a class="btn-checkout" target="_blank" href="<?php echo $peccular_checkoutbtnlink ?>"><span> <?php echo ($peccular_checkoutbutton );  ?></span></a>	
															</div>
														</div>	
													<?php endif ?>
													<a href="<?php echo wc_get_cart_url();?>" class="">
														<svg xmlns="http://www.w3.org/2000/svg" width="22.715" height="23.5" viewBox="0 0 22.715 23.5">
															<g id="cart" transform="translate(-64.499 -47.479)">
																<path id="Path_734" data-name="Path 734" d="M-58.241-.364h1.674l1.409,0h.663l2.2,0h.716l2.3,0,2.365,0,1.328,0h1.708c.209,0,.417,0,.626,0l.184,0a1.055,1.055,0,0,1,.818.268.843.843,0,0,1,.135.2c.111.191.227.377.35.56a14.084,14.084,0,0,1,2.554,8.4v.121c0,.987-.024,1.973-.056,2.96q-.031.954-.043,1.909c0,.042,0,.085,0,.129q0,.256-.006.512c-.016,1.3-.038,2.595-.076,3.891q-.006.2-.011.4A4.131,4.131,0,0,1-40.578,22.2a3.557,3.557,0,0,1-2.538.913h-15.05a3.485,3.485,0,0,1-2.46-1.014,4.453,4.453,0,0,1-1.084-3.33l-.013-.411c-.039-1.266-.06-2.532-.077-3.8q0-.256-.007-.512l0-.128c-.009-.633-.027-1.265-.049-1.9-.034-.983-.056-1.965-.056-2.949,0-.06,0-.06,0-.121A14.9,14.9,0,0,1-59.26.4l.071-.112A1.159,1.159,0,0,1-58.241-.364Zm.688,1.907A7.914,7.914,0,0,0-59.1,4.689H-42c-.5-1.056-1.021-2.1-1.543-3.146Zm-2.137,5.1c0,2.172-.01,4.343-.015,6.581l-.007,2.078c0,.615,0,.615,0,1.23q0,.411,0,.821,0,.524,0,1.048,0,.192,0,.384c0,.173,0,.347,0,.52l0,.151a1.837,1.837,0,0,0,.549,1.339,2.093,2.093,0,0,0,1.333.361h.2c.217,0,.434,0,.65,0l.467,0h2.461q1.253,0,2.507,0,1.146,0,2.291,0,1.178,0,2.355,0h1.321q.621,0,1.242,0h.456c.208,0,.415,0,.623,0l.181,0a1.724,1.724,0,0,0,1.212-.453,1.792,1.792,0,0,0,.487-1.393c0-.081,0-.081,0-.165,0-.182,0-.363,0-.545q0-.2,0-.4,0-.532,0-1.063,0-.5,0-1,0-1.459-.006-2.919c-.006-3.261-.006-3.261-.011-6.588Z" transform="translate(126.415 47.866)"/>
																<path id="Path_735" data-name="Path 735" d="M-22.234-1.253a1.212,1.212,0,0,1,.56.751c.018.1.03.209.041.314a3.024,3.024,0,0,0,.99,2.014,3.007,3.007,0,0,0,2.2.594,2.964,2.964,0,0,0,1.9-1.187,3.712,3.712,0,0,0,.489-1.684,1.242,1.242,0,0,1,.579-.808,1.214,1.214,0,0,1,.842.007,1.465,1.465,0,0,1,.523.586A4.622,4.622,0,0,1-15.18,2.762l-.121.132-.119.136a4.554,4.554,0,0,1-3.123,1.42A4.985,4.985,0,0,1-22.29,3.061,4.64,4.64,0,0,1-23.633-.115l0-.147a1,1,0,0,1,.264-.762A1.035,1.035,0,0,1-22.234-1.253Z" transform="translate(94.728 58.92)"/>
															</g>
														</svg>
													</a>
													<div class="count"><?php global $woocommerce; ?> <?php echo WC()->cart->get_cart_contents_count(); ?> 
												</div> 
											</div>
										<?php }?>
									</div>
									<div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 width-auto">
										<?php
										$peccular_headermyacccbtnlink = get_theme_mod('peccular_headermyacccbtnlink', '');  
										?>
										<a class="my-acc" href="<?php echo $peccular_headermyacccbtnlink ?>"> <svg xmlns="http://www.w3.org/2000/svg" width="22.984" height="22.168" viewBox="0 0 22.984 22.168"> 
											<path id="profile" d="M-272.7-26.738a7.54,7.54,0,0,1,2.45,3.807l.057.2a7.311,7.311,0,0,1-.831,5.217,8.389,8.389,0,0,1-1.05,1.326l-.12.129a6.28,6.28,0,0,1-.985.81l.111.05.5.226.154.07A12.055,12.055,0,0,1-268.98-12.6l.094.09a10.675,10.675,0,0,1,1.287,1.457l.069.094a8.539,8.539,0,0,1,1.865,4.547l-.7.138-.2.04-.193.038-.177.035a2.807,2.807,0,0,1-.5.025l-.028-.1a10.291,10.291,0,0,0-2.288-4.469c-.105-.113-.205-.229-.3-.348a9.673,9.673,0,0,0-6.5-2.98,10.12,10.12,0,0,0-4.475.773l-.111.047a9.243,9.243,0,0,0-2.6,1.666l-.149.129a10.1,10.1,0,0,0-3,5.285,11.847,11.847,0,0,1-1.768-.276,5.138,5.138,0,0,1,.193-1.095l.044-.151a11.677,11.677,0,0,1,4.293-5.992l.092-.068a11.318,11.318,0,0,1,1.434-.861l.171-.09a10.574,10.574,0,0,1,1.23-.528v-.11c-.082-.062-.167-.12-.252-.176a6.712,6.712,0,0,1-1.737-1.868l-.108-.167a7.282,7.282,0,0,1-.826-5.257,7.241,7.241,0,0,1,3.2-4.456,8.308,8.308,0,0,1,1.988-.838l.2-.057A7.172,7.172,0,0,1-272.7-26.738Zm-7.991,1.652-.146.135a5,5,0,0,0-1.58,3.383,5.546,5.546,0,0,0,1.608,4.227,5.3,5.3,0,0,0,3.6,1.481,5.3,5.3,0,0,0,3.591-1.381l.146-.135a5,5,0,0,0,1.58-3.383,5.546,5.546,0,0,0-1.608-4.227A5.29,5.29,0,0,0-280.692-25.085Z" transform="translate(288.648 28.302)"/>
										</svg></a>	</div>
									</div>

								</div>
							</div>

						</div>
					</div>
				</div>			 
				<div class="row row-eq-height md-1">
					<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-xs-12 head-menu pd-0">
						<div class="inside-full-height">
							<?php
							if( get_theme_mod('menu_fontsize',true) ) {
								$menu_fontsize = 'font-size:'.esc_attr(get_theme_mod('menu_fontsize')).';';
							}
							if( get_theme_mod('dropdown_menu_fontsize',true) ) {
								$dropdown_menu_fontsize = 'font-size:'.esc_attr(get_theme_mod('dropdown_menu_fontsize')).';';
							}
							?>
							<div class="site-navigation">
								<div class="hamburger-menus">
									<span></span>
									<span></span>
									<span></span>
									<span></span>
									<span></span>
									<span></span>
									<span></span>
									<span></span>
									<span></span>
								</div>
								<nav class="navigation">
									<div class="overlaybg"></div><!--  /.overlaybg -->
									<!-- Main Menu -->
									<div class="menu-wrapper">
										<div class="menu-content">
											<?php
											if( get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true) !=='0') {
												wp_nav_menu ( array(
													'menu_class' => 'mainmenu ht-clearfix',
													'container'=> 'ul',
													'menu' => get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true),
													'theme_location' => 'primary',  
												)); 
											} else {
												wp_nav_menu ( array(
													'menu_class' => 'mainmenu ht-clearfix',
													'container'=> 'ul',
													'theme_location' => 'primary',  
												)); 
											}
											?>
										</div> <!-- /.hours-content-->

										<div class="clearfix"></div>

									</div><!-- /.menu-wrapper -->

								</nav>	
							</div><!--  /.site-navigation -->
						</div>
						<div class="clearfix"></div> 
					</div><!--9div close-->
				</div>
			</div>
		</div>
		<!--end main top header-->	
		<div class="clearfix"></div>
	</header>

<?php }?>

</div>