<?php 
$wp_customize->add_section( 'peccular_footer_setting' , array(
    'title'    => __( 'Footer Setting', 'peccular-premium' ),
    'priority' => null,
    'panel' => 'peccular_header_panel1'
) );
$wp_customize->add_setting('peccular_footer_nav', array(
   'sanitize_callback' => 'wp_kses_post',
));
$wp_customize->add_control(new peccular_Tab_Control($wp_customize, 'peccular_footer_nav', array(
   'section' => 'peccular_footer_setting',
   'priority' => 1,
   'buttons' => array(
      array(
         'name' => esc_html__('General', 'peccular-premium'),
         'icon' => 'dashicons dashicons-welcome-write-blog',
         'fields' => array(
            'peccular_footer_copyrighttext',
            'peccular_footerimg1_section_lbl',
            'peccular_footerimg_image7',
            'peccular_footerimg_image1',
            'peccular_footerimg_image3', 
            'peccular_footerimg_image4',
            'peccular_footerimg_image6'
        ),
         'active' => true,
     ),
      array(
        'name' => esc_html__('Style', 'peccular-premium'),
        'icon' => 'dashicons dashicons-art',
        'fields' => array(                      
         'peccular_footer_section_bg_color',
         'peccular_footer_section_bg_image',
         'peccular_footer_image_opacity',
         'peccular_footer_box_align', 
         'peccular_footer_copyright_align',   
         'peccular_footer_contnt_bg_color', 
         'peccular_footer_heading_color',
         'peccular_footer_text_color',
         'peccular_footer_icon_color',
         'peccular_footer_sicon_color',
         'peccular_footer_siconhover_color',
         'peccular_footer_menu_color',
         'peccular_footer_menuhover_color',
         'peccular_footer_cntct_ovrly_color',
         'peccular_footer_btmphnicn_color',
         'peccular_footer_btmphnbg_color',
         'peccular_footer_bttBG_color',
         'peccular_footer_bttmtext_color',
         'peccular_footer_bttmtext_color',
         'peccular_footer_btmphnicn_color',
         'peccular_footer_formtxt_color', 
         'peccular_footer_btmphnbg_color', 
         'peccular_footer_copytxt_color',
         'peccular_footer_borderc_color', 
         'peccular_footer_menuicon_color'
     ),
    ),
      array(
        'name' => esc_html__('Layout', 'peccular-premium'),
        'icon' => 'dashicons dashicons-layout',
        'fields' => array(
            'peccular_footer_padding',
            'peccular_footer_section_top_t_padding',
            'peccular_footer_section_top_b_padding',
            'peccular_footer_padding1',
            'peccular_footer_section_bottom_t_padding',
            'peccular_footer_section_bottom_b_padding',     
            'peccular_footer_section_width'
        ),
    )
  ),
)));
$wp_customize->add_setting(
    'peccular_footer_copyrighttext',
    array(
        'sanitize_callback' => 'peccular_sanitize_text',
        'default'           => __( 'Copyright © 2024 Furniture Mart - All Rights Reserved.', 'peccular' )
    )
);
$wp_customize->add_control(
    'peccular_footer_copyrighttext',
    array(
        'settings'      => 'peccular_footer_copyrighttext',
        'section'       => 'peccular_footer_setting', 
        'type'          => 'text',
        'label'         => __( 'Copyright', 'peccular' ),
         'input_attrs' => array(
            'readonly' => 'readonly',
        ),
    )
);
$wp_customize->add_setting( 'peccular_footer_section_bg_color', array(
   'default' => '',
   'sanitize_callback' => 'sanitize_hex_color'
));
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'peccular_footer_section_bg_color', array(
    'label' => __('Section BG Color','peccular'),
    'section' => 'peccular_footer_setting',
)));
$wp_customize->add_setting( 'peccular_footer_section_bg_image', array(
   'default' => '',
   'sanitize_callback' => 'esc_url_raw'
));
$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'peccular_footer_section_bg_image', array(
    'label' => __('Section BG Image','peccular'),
    'section' => 'peccular_footer_setting',
)));
$wp_customize->add_setting('peccular_footer_image_opacity',array(
    'default' => 1,
    'sanitize_callback' => 'peccular_sanitize_float'
));
$wp_customize->add_control(new peccular_Custom_Control( $wp_customize, 'peccular_footer_image_opacity',array(
    'label' => __('Section BG Opacity','peccular'),
    'section' => 'peccular_footer_setting',
    'input_attrs' => array(
        'min' => 0,
        'max' => 1,
        'step' => 0.1,
    ),
)));
$wp_customize->add_setting('peccular_footer_box_align',array(
    'default' => 'Left',
    'sanitize_callback' => 'peccular_sanitize_choices',
));
$wp_customize->add_control('peccular_footer_box_align',array(
    'type' => 'select',
    'label' => __('Footer Content Alignment','peccular'),
    'choices' => array (
        'Center' => __('Center','peccular'),
        'Left' => __('Left','peccular'),
        'Right' => __('Right','peccular')
    ),
    'section' => 'peccular_footer_setting',
));
$wp_customize->add_setting('peccular_footer_copyright_align',array(
    'default' => 'Left',
    'sanitize_callback' => 'peccular_sanitize_choices',
));
$wp_customize->add_control('peccular_footer_copyright_align',array(
    'type' => 'select',
    'label' => __('Copyright Alignment','peccular'),
    'choices' => array (
        'Center' => __('Center','peccular'),
        'Left' => __('Left','peccular'),
        'Right' => __('Right','peccular')
    ),
    'section' => 'peccular_footer_setting',
));
addColorPalatOption($wp_customize, 'peccular_footer_borderc_color', 'peccular_footer_setting', 'Footer Border Color', '');

addColorPalatOption($wp_customize, 'peccular_footer_heading_color', 'peccular_footer_setting', 'Heading Color', '');
addColorPalatOption($wp_customize, 'peccular_footer_text_color', 'peccular_footer_setting', 'Text Color ', '');
addColorPalatOption($wp_customize, 'peccular_footer_sicon_color', 'peccular_footer_setting', 'Social Icon Color', '');
addColorPalatOption($wp_customize, 'peccular_footer_siconhover_color', 'peccular_footer_setting', 'Social Icon Hover Color', '');
addColorPalatOption($wp_customize, 'peccular_footer_menu_color', 'peccular_footer_setting', 'Menu Color ', '');
addColorPalatOption($wp_customize, 'peccular_footer_menuhover_color', 'peccular_footer_setting', 'Menu Hover Color ', ''); 

addColorPalatOption($wp_customize, 'peccular_footer_formtxt_color', 'peccular_footer_setting', 'Form Text Color ', '');
//addColorPalatOption($wp_customize, 'peccular_footer_bttBG_color', 'peccular_footer_setting', 'Footer Bottom BG Color ', '');
addColorPalatOption($wp_customize, 'peccular_footer_bttmtext_color', 'peccular_footer_setting', 'Form Border Color ', '');
addColorPalatOption($wp_customize, 'peccular_footer_btmphnicn_color', 'peccular_footer_setting', 'Form Button Text Color ', '');
addColorPalatOption($wp_customize, 'peccular_footer_btmphnbg_color', 'peccular_footer_setting', 'Form Button BG Color ', '');

addColorPalatOption($wp_customize, 'peccular_footer_copytxt_color', 'peccular_footer_setting', 'Copyright Text Color ', '');


$wp_customize->add_setting('peccular_footer_padding',array(
  'sanitize_callback'   => 'esc_html'
));
$wp_customize->add_control('peccular_footer_padding',array(
  'label' => __('Top Footer Padding','peccular'),
  'section' => 'peccular_footer_setting'
));
$wp_customize->add_setting('peccular_footer_section_top_t_padding',array(
    'default' => '4',
    'sanitize_callback' => 'sanitize_text_field'
));
$wp_customize->add_control('peccular_footer_section_top_t_padding',array(
    'type' => 'number',
    'label' => __('Top','peccular'),
    'section' => 'peccular_footer_setting',
));
$wp_customize->add_setting('peccular_footer_section_top_b_padding',array(
    'default' => '1.3',
    'sanitize_callback' => 'sanitize_text_field'
));
$wp_customize->add_control('peccular_footer_section_top_b_padding',array(
    'type' => 'number',
    'label' => __('Bottom','peccular'),
    'section' => 'peccular_footer_setting',
));

// $wp_customize->add_setting('peccular_footer_padding1',array(
//   'sanitize_callback'   => 'esc_html'
// ));
// $wp_customize->add_control('peccular_footer_padding1',array(
//   'label' => __('Bottom Footer Padding','peccular'),
//   'section' => 'peccular_footer_setting'
// ));
// $wp_customize->add_setting('peccular_footer_section_bottom_t_padding',array(
//     'default' => '1',
//     'sanitize_callback' => 'sanitize_text_field'
// ));
// $wp_customize->add_control('peccular_footer_section_bottom_t_padding',array(
//     'type' => 'number',
//     'label' => __('Top','peccular'),
//     'section' => 'peccular_footer_setting',
// ));
// $wp_customize->add_setting('peccular_footer_section_bottom_b_padding',array(
//     'default' => '1',
//     'sanitize_callback' => 'sanitize_text_field'
// ));
// $wp_customize->add_control('peccular_footer_section_bottom_b_padding',array(
//     'type' => 'number',
//     'label' => __('Bottom','peccular'),
//     'section' => 'peccular_footer_setting',
// ));
$wp_customize->add_setting('peccular_footer_section_width',array(
    'default' => 'Box Width',
    'sanitize_callback' => 'peccular_sanitize_choices',
));
$wp_customize->add_control('peccular_footer_section_width',array(
    'type' => 'select',
    'label' => __('Section Width','peccular'),
    'choices' => array (
        'Box Width' => __('Box Width','peccular'),
        'Full Width' => __('Full Width','peccular')
    ),
    'section' => 'peccular_footer_setting',
));



$wp_customize->add_setting('peccular_footerimg1_section_lbl', array('sanitize_callback'=>'peccular_sanitize_text'));
$wp_customize->add_control(
    new peccular_Info_Text( 
        $wp_customize,
        'peccular_footerimg1_section_lbl',
        array(
            'settings'      => 'peccular_footerimg1_section_lbl',
            'section'       => 'peccular_footer_setting',
            'label'         => __( '', 'peccular Premium' ), 
            'description'   => __( '<strong>Note-</strong> <strong>Add Bottom Footer Card Images Of [51 * 24] Resolution To Show In Proper Way.</strong>', 'peccular Premium' ),
        )
    )
);

$wp_customize->add_setting( 'peccular_footerimg_image7', array(
   'default' => '',
   'sanitize_callback' => 'esc_url_raw'
));
$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'peccular_footerimg_image7', array(
    'label' => __('Bottom Footer Card Image 1','peccular'),
    'section' => 'peccular_footer_setting',
)));
$wp_customize->add_setting( 'peccular_footerimg_image1', array(
   'default' => '',
   'sanitize_callback' => 'esc_url_raw'
));
$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'peccular_footerimg_image1', array(
    'label' => __('Bottom Footer Card Image 2','peccular'),
    'section' => 'peccular_footer_setting',
)));
$wp_customize->add_setting( 'peccular_footerimg_image3', array(
   'default' => '',
   'sanitize_callback' => 'esc_url_raw'
));
$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'peccular_footerimg_image3', array(
    'label' => __('Bottom Footer Card Image 3','peccular'),
    'section' => 'peccular_footer_setting',
)));

$wp_customize->add_setting( 'peccular_footerimg_image4', array(
   'default' => '',
   'sanitize_callback' => 'esc_url_raw'
));
$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'peccular_footerimg_image4', array(
    'label' => __('Bottom Footer Card Image 4','peccular'),
    'section' => 'peccular_footer_setting',
)));
$wp_customize->add_setting( 'peccular_footerimg_image6', array(
   'default' => '',
   'sanitize_callback' => 'esc_url_raw'
));
$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'peccular_footerimg_image6', array(
    'label' => __('Bottom Footer Card Image 5','peccular'),
    'section' => 'peccular_footer_setting',
)));

?>