<?php  
// /HEADER SETTINGS IN CUSTOMIZER
$lvl1ParentPanel = new peccular_WP_Customize_Panel( $wp_customize, 'peccular_header_panel1', array(
    'title' => 'General Settings',
    'priority' => 1,
));

$wp_customize->add_panel( $lvl1ParentPanel );

$lvl2ParentPanel = new peccular_WP_Customize_Panel( $wp_customize, 'peccular_header_panel2', array(
    'title' => 'Header',
    'panel' => 'peccular_header_panel1',
    'priority' => 1,
));  

$wp_customize->add_panel( $lvl2ParentPanel );

  // Add example section and controls to the final (third) panel
$wp_customize->add_section( 'peccular_section', array(
    'title' => 'Section Test',
    'panel' => 'peccular_header_panel2',
));

//Bottom Header
$wp_customize->add_section( 'peccular_header_section' , array(
    'title'    => __( 'All Settings', 'peccular-premium' ),
    'priority' => null,
    'panel' => 'peccular_header_panel2'
) );
$wp_customize->add_setting('peccular_headersetting_nav', array(
   'sanitize_callback' => 'wp_kses_post',
));

$wp_customize->add_control(new peccular_Tab_Control($wp_customize, 'peccular_headersetting_nav', array(
   'section' => 'peccular_header_section',
   'priority' => 1,
   'buttons' => array(
      array(
         'name' => esc_html__('General', 'peccular-premium'),
         'icon' => 'dashicons dashicons-welcome-write-blog',
         'fields' => array(
             'peccular_header_style',
             'peccular_show_sticky_header',
             'header_top_tagline',
             'header__shoplink', 
             'header__top_link',
             'singnin_text',
             'header__womencategories',
             'header__womencategorieslink',
             'peccular_headercat_categories',
             'header__mencategories',
             'header__mencategorieslink',
             'peccular_header_sbutton_enable',
             'peccular_header_image_opacity',
             'peccular_checkoutbtnlink',
             'peccular_headermyacccbtnlink', 
             'singnin_textlink'              
         ),
         'active' => true,
     ),
      array(
        'name' => esc_html__('Style', 'peccular-premium'),
        'icon' => 'dashicons dashicons-art',
        'fields' => array(
         'header_SiteTitleColor',
         'header_SiteTaglineColor',
         'headerphone_label_color',
         'headerphone_color',
         'headereemailhove_color',
         'headerephoneicon_color',
         'headerphoneiconbrdr_color',
         'headersearbutton_color',
         'headersearbuttonbg_color',
         'header_allbgColor',
         'headerseartxt_color',
         'headercheckoutbx_color', 
         'headercheckoutcont_color',
         'headercheckoutbtn_color', 
         'headercheckoutbtnbg_color',
         'headercaticon_color',
         'headercaticonbg_color',
         'headercaticonlink_color',
         'headercaticonlinkbg_color',
         'headercaticonlinkhover_color', 
         'headercaticonlinkbrs_color', 
         'headersearbgx_color', 
         'header_offertagsignlColor',
         'headersearbgxactive_color',
         'headercheckoutbxbg2_color',
         'headercheckoutbxbgb3_color',
         'headercheckoutboxbg3c_color', 
         'headerboxptitle_color', 
         'headerboxptitleqty_color', 
         'headerboxpother_color',
         'headercartbtn_color',
         'headercartbtnhvr_color',
         'headercartbtnbrs_color', 
         'headercounticonbg_color',
         'headercountico_color',
         'headercartcheckhover_color',
         'headersocialico_color',
         'headersocialicohover_color',
         'headersociallabel_color',
         'headersociallabelbg_color',
         'headercaticonlinkborder_color',
         'header_bgColor'
     ),
    ),
      array(
        'name' => esc_html__('Layout', 'peccular-premium'),
        'icon' => 'dashicons dashicons-art',
        'fields' => array(
            'peccular_header_width'
        ),
    )
  ),
)));
$wp_customize->add_setting( 'peccular_show_sticky_header',array(
    'default' => false,
    'sanitize_callback' => 'peccular_switch_sanitization'
) );
$wp_customize->add_control( new peccular_Toggle_Switch_Custom_Control( $wp_customize, 'peccular_show_sticky_header',array(
    'label' => __( 'Show Sticky Header','peccular' ),
    'section' => 'peccular_header_section'
)));
$wp_customize->add_setting( 'peccular_header_sbutton_enable',array(
    'default' => true,
    'sanitize_callback' => 'peccular_switch_sanitization'
) );
$wp_customize->add_control( new peccular_Toggle_Switch_Custom_Control( $wp_customize, 'peccular_header_sbutton_enable',array(
    'label' => __( 'Show Search Box','peccular' ),
    'section' => 'peccular_header_section'
))); 

$wp_customize->add_setting('peccular_checkoutbtnlink',   array('default'=> 'add link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('peccular_checkoutbtnlink',
    array(
        'settings'      => 'peccular_checkoutbtnlink',
        'section'       => 'peccular_header_section',
        'type'          => 'url',
        'label'         => __( 'Checkout Link Here', 'peccular-premium' )
    )
);
$wp_customize->add_setting('peccular_headermyacccbtnlink',   array('default'=> 'add link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('peccular_headermyacccbtnlink',
    array(
        'settings'      => 'peccular_headermyacccbtnlink',
        'section'       => 'peccular_header_section',
        'type'          => 'url',
        'label'         => __( 'My Account Link Here', 'peccular-premium' )
    )
);
$wp_customize->add_setting('peccular_header_image_opacity',array(
    'default' => 1,
    'sanitize_callback' => 'peccular_sanitize_float'
));
$wp_customize->add_control(new peccular_Custom_Control( $wp_customize, 'peccular_header_image_opacity',array(
    'label' => __('Header Image Opacity','peccular'),
    'section' => 'peccular_header_section',
    'input_attrs' => array(
        'min' => 0,
        'max' => 1,
        'step' => 0.1,
    ),
)));
$wp_customize->add_setting('header_top_tagline',array(
    'sanitize_callback' => 'peccular_sanitize_text',
    'default' => __('Get 15 % Off Your Dream Room Furniture And Elevate Your Space For Less!','peccular-premium')
));
$wp_customize->add_control('header_top_tagline',array(
    'settings'      => 'header_top_tagline',
    'type' => 'textarea',
    'label' => __('Offer Tagline','peccular-premium'),
    'section' => 'peccular_header_section',
));

addColorPalatOption($wp_customize, 'header_offertagsignlColor', 'peccular_header_section', 'Offer Tagline Color', '');
addColorPalatOption($wp_customize, 'header_allbgColor', 'peccular_header_section', 'Header BG Color', '');
addColorPalatOption($wp_customize, 'header_bgColor', 'peccular_header_section', 'Top Bar BG Color', '');
addColorPalatOption($wp_customize, 'header_SiteTitleColor', 'peccular_header_section', 'Site Title Color', '');
addColorPalatOption($wp_customize, 'header_SiteTaglineColor', 'peccular_header_section', 'Tagline Color', '');
//addColorPalatOption($wp_customize, 'headerephoneicon_color', 'peccular_header_section', 'Category Icon Color', '');
addColorPalatOption($wp_customize, 'headerphone_label_color', 'peccular_header_section', 'My Account Icon Color', '');
// addColorPalatOption($wp_customize, 'headerphone_color', 'peccular_header_section', 'Checkout Box Count Number Color', '');
// addColorPalatOption($wp_customize, 'headerphoneiconbrdr_color', 'peccular_header_section', 'Checkout Box Count Number BG Color', '');
addColorPalatOption($wp_customize, 'headereemailhove_color', 'peccular_header_section', 'Search Box Border Color', '');
addColorPalatOption($wp_customize, 'headersearbutton_color', 'peccular_header_section', 'Search Button Text Color', '');
addColorPalatOption($wp_customize, 'headersearbuttonbg_color', 'peccular_header_section', 'Search Button BG Color', '');
addColorPalatOption($wp_customize, 'headerseartxt_color', 'peccular_header_section', 'Search Text Color', '');
addColorPalatOption($wp_customize, 'headersearbgx_color', 'peccular_header_section', 'Search Box BG Color', '');
addColorPalatOption($wp_customize, 'headersearbgxactive_color', 'peccular_header_section', 'Search Box Active BG Color', '');

addColorPalatOption($wp_customize, 'headercounticonbg_color', 'peccular_header_section', 'Count / Wishlist Number BG Color', '');
addColorPalatOption($wp_customize, 'headercountico_color', 'peccular_header_section', 'Count / Wishlist Number Color', '');

addColorPalatOption($wp_customize, 'headercheckoutbx_color', 'peccular_header_section', 'Checkout Box BG Color', '');
// addColorPalatOption($wp_customize, 'headercheckoutbxbgb3_color', 'peccular_header_section', 'Checkout Box Border Color', '');
// addColorPalatOption($wp_customize, 'headercheckoutboxbg3c_color', 'peccular_header_section', 'Checkout Box BG Color 3', '');

// addColorPalatOption($wp_customize, 'headerboxptitle_color', 'peccular_header_section', 'Checkout Box Products Title Color', '');
// addColorPalatOption($wp_customize, 'headerboxptitleqty_color', 'peccular_header_section', 'Checkout Box Products Price & Quantity Text Color', '');
addColorPalatOption($wp_customize, 'headerboxpother_color', 'peccular_header_section', 'Checkout Box Text & Icon Color', ''); 

//addColorPalatOption($wp_customize, 'headercheckoutcont_color', 'peccular_header_section', 'Checkout Content Color', '');
addColorPalatOption($wp_customize, 'headercheckoutbtn_color', 'peccular_header_section', 'Checkout Button Text Color', '');
addColorPalatOption($wp_customize, 'headercheckoutbtnbg_color', 'peccular_header_section', 'Checkout Button BG Color', '');
// addColorPalatOption($wp_customize, 'headercartbtn_color', 'peccular_header_section', 'Cart Button Text Color', '');
// addColorPalatOption($wp_customize, 'headercartbtnhvr_color', 'peccular_header_section', 'Cart Button Hover Text Color', '');

// addColorPalatOption($wp_customize, 'headercartbtnbrs_color', 'peccular_header_section', 'Cart Button Border Color', '');
// addColorPalatOption($wp_customize, 'headercartcheckhover_color', 'peccular_header_section', 'Cart & Checkout Button Hover BG Color', '');

addColorPalatOption($wp_customize, 'headercaticon_color', 'peccular_header_section', 'Category Icon Color', '');
addColorPalatOption($wp_customize, 'headercheckoutbxbg2_color', 'peccular_header_section', 'Category Box BG Color', '');
addColorPalatOption($wp_customize, 'headercaticonlinkbrs_color', 'peccular_header_section', 'Category Box Icon & Title Color', '');


//addColorPalatOption($wp_customize, 'headercaticonbg_color', 'peccular_header_section', 'Category Box BG Color', '');
addColorPalatOption($wp_customize, 'headercaticonlink_color', 'peccular_header_section', 'Category Link Color', '');
addColorPalatOption($wp_customize, 'headercaticonlinkhover_color', 'peccular_header_section', 'Category Link Hover Color', '');
addColorPalatOption($wp_customize, 'headercaticonlinkbg_color', 'peccular_header_section', 'Category Link Border Color', '');
addColorPalatOption($wp_customize, 'headercaticonlinkborder_color', 'peccular_header_section', 'Category Link Icon Color', '');

addColorPalatOption($wp_customize, 'headersocialico_color', 'peccular_header_section', 'Social Icon Color', '');
addColorPalatOption($wp_customize, 'headersocialicohover_color', 'peccular_header_section', 'Social Icon Hover Color', '');
addColorPalatOption($wp_customize, 'headersociallabel_color', 'peccular_header_section', 'Social Label Color', '');
addColorPalatOption($wp_customize, 'headersociallabelbg_color', 'peccular_header_section', 'Social BG Color', '');


$wp_customize->add_setting('peccular_header_width',array(
    'default' => 'Box Width',
    'sanitize_callback' => 'peccular_sanitize_choices',
));
$wp_customize->add_control('peccular_header_width',array(
    'type' => 'select',
    'label' => __('Section Width','peccular'),
    'choices' => array (
        'Box Width' => __('Box Width','peccular'),
        'Full Width' => __('Full Width','peccular')
    ),
    'section' => 'peccular_header_section',
));

$choices = getWooCategories($isObject = false, $id=0, $isParents = 0);

lzCheckBoxElement($wp_customize, 'peccular_headercat_categories', 'peccular_header_section', $choices, $default=0, $label=__('Please Select The Categories To Show', 'Peccular'));

?>