<?php 
// /HEADER SETTINGS IN CUSTOMIZER
 $wp_customize->add_section( 'header_menu_settings' , array(
        'title'    => __( 'Menu Settings', 'peccular-premium' ),
        'priority' => null,
        'panel' => 'peccular_header_panel2'
    ) );

    $wp_customize->add_setting('peccular_menusetting_nav', array(
       'sanitize_callback' => 'wp_kses_post',
    ));

    $wp_customize->add_control(new peccular_Tab_Control($wp_customize, 'peccular_menusetting_nav', array(
       'section' => 'header_menu_settings',
       'priority' => 1,
       'buttons' => array(
          array(
             'name' => esc_html__('General', 'peccular-premium'),
            'icon' => 'dashicons dashicons-welcome-write-blog',
            'fields' => array(
               'peccular_submenu_animation',
               'peccular_menu_case',
               'peccular_menu_font_size',
               'peccular_menu_font_weight'
            ),
            'active' => true,
         ),
          array(
            'name' => esc_html__('Style', 'peccular-premium'),
            'icon' => 'dashicons dashicons-art',
            'fields' => array(
                'header_topmenusColor',
                'header_topmenushoverColor',
                'header_topmenushoverBorderColor',
                'header_topmenusactiveColor',
                'header_topsubmenusColor',
                'header_submenusbgssc1Color',
                'header_topsubmenushvbgColor', 
                'header_topsubmenushvtxtColor',
                'header_topmenusarrowColor' ,
            ),
         ),
          array(
            'name' => esc_html__('Responsive', 'peccular-premium'),
            'icon' => 'dashicons dashicons-desktop',
            'fields' => array(
                'header_topsubmenuiconColor',
                'header_respnavtoggbarbgssColor',
                'header_respnavbsbgssColor',
                'header_navigationrespnavbrssColor',
                'peccular_respmenu_font_size',
                'header_respnavmenutxtColor',
                'header_respnavtxthvColor'
                
           ),
         )
        ),
    )));

//menu dropdown animation
$lzmenuanimation = getAnimations(true);

$wp_customize->add_setting(
   'peccular_submenu_animation',
   array(
      'sanitize_callback'=> 'absint',
      'default' => '2'
   )
);
$wp_customize->add_control(
   new peccular_Font_Chooser(
      $wp_customize,
      'peccular_submenu_animation',
      array(
         'settings'=> 'peccular_submenu_animation',
         'section' => 'header_menu_settings',
         'label'=>__('Menu Dropdown Animations', 'peccular Premium'),
         'choices'=>$lzmenuanimation
      )
   )
);

//menu font case
$lzmenufontcase = getfontcase(true);

$wp_customize->add_setting(
   'peccular_menu_case',
   array(
      'sanitize_callback'=> 'absint',
      'default' => '0'
   )
);
$wp_customize->add_control(
   new peccular_Font_Chooser(
      $wp_customize,
      'peccular_menu_case',
      array(
         'settings'=> 'peccular_menu_case',
         'section' => 'header_menu_settings',
         'label'=>__('Menu Font Case', 'peccular Premium'),
         'choices'=>$lzmenufontcase
      )
   )
);

   $wp_customize->add_setting('peccular_menu_font_size',array(
      'default' => '16',
      'sanitize_callback'  => 'peccular_sanitize_integer'
   ));
   $wp_customize->add_control('peccular_menu_font_size',array(
      'type' => 'number',
      'label' => __('Menu Font Size','peccular'),
      'section' => 'header_menu_settings',
   ));

   $wp_customize->add_setting('peccular_menu_font_weight',array(
     'default' => '500',
     'sanitize_callback' => 'peccular_sanitize_choices'
   ));
   $wp_customize->add_control('peccular_menu_font_weight',array(
      'type' => 'select',
      'label' => __('Font Weight','peccular'),
      'section' => 'header_menu_settings',
      'choices' => array(
         '300' => __('300','peccular'),
         '400' => __('400','peccular'),
         '500' => __('500','peccular'),
         '600' => __('600','peccular'),
         '700' => __('700','peccular'),
         '800' => __('800','peccular')
      ),
   ));

addColorPalatOption($wp_customize, 'header_topmenusColor', 'header_menu_settings', 'Menus Color', '');
addColorPalatOption($wp_customize, 'header_topmenushoverColor', 'header_menu_settings', 'Menus Hover Color', '');
//addColorPalatOption($wp_customize, 'header_topmenushoverBorderColor', 'header_menu_settings', 'Menus Icon Color', '');
//addColorPalatOption($wp_customize, 'header_topmenusarrowColor', 'header_menu_settings', 'Menus Drop Down Arrow Color', '');
addColorPalatOption($wp_customize, 'header_topmenusactiveColor', 'header_menu_settings', 'Active Menu & Menu Hover Color', '');
addColorPalatOption($wp_customize, 'header_topsubmenusColor', 'header_menu_settings', 'Dropdown Menus Color', '');
addColorPalatOption($wp_customize, 'header_submenusbgssc1Color', 'header_menu_settings', 'Dropdown Box BG Color', '');
addColorPalatOption($wp_customize, 'header_topsubmenushvtxtColor', 'header_menu_settings', 'Dropdown Menus Hover Color', '');

addColorPalatOption($wp_customize, 'header_topsubmenuiconColor', 'header_menu_settings', 'Menus Icon Color', '');

addColorPalatOption($wp_customize, 'header_respnavtoggbarbgssColor', 'header_menu_settings', 'Toggle Bar Color', '');
addColorPalatOption($wp_customize, 'header_respnavmenutxtColor', 'header_menu_settings', 'Menus Text Color', '');
addColorPalatOption($wp_customize, 'header_respnavtxthvColor', 'header_menu_settings', 'Menus Text Hover Color', '');

addColorPalatOption($wp_customize, 'header_respnavbsbgssColor', 'header_menu_settings', 'BG Color', '');

addColorPalatOption($wp_customize, 'header_navigationrespnavbrssColor', 'header_menu_settings', 'Border Color', '');

 $wp_customize->add_setting('peccular_respmenu_font_size',array(
      'default' => '16px',
      'sanitize_callback'  => 'peccular_sanitize_integer'
   ));
   $wp_customize->add_control('peccular_respmenu_font_size',array(
      'type' => 'number',
      'label' => __('Menu Font Size','peccular'),
      'section' => 'header_menu_settings',
   ));
?>