<?php   
$wp_customize->add_section(
	'peccular_bestseller_products_section',
	array(
		'title' => __( 'New Arrivals', 'peccular-premium' ),
		'panel' => 'peccular_premium_home_panel1',
		'priority' =>19
	) 
); 
$wp_customize->add_setting('peccular_bestseller_products_nav', array(
	'sanitize_callback' => 'wp_kses_post',
)); 
$wp_customize->add_control(new peccular_Tab_Control($wp_customize, 'peccular_bestseller_products_nav', array(
	'section' => 'peccular_bestseller_products_section',
	'priority' => 1,
	'buttons' => array(
		array(
			'name' => esc_html__('General', 'peccular-premium'),
			'icon' => 'dashicons dashicons-welcome-write-blog',
			'fields' => array(
				'peccular_bestseller_products_enable',
				'peccular_bs_lbl',
				'ct__bestsellerproduct__page_title',
				'ct__bestseller__page_title'
			),
			'active' => true,
		),
		array(
			'name' => esc_html__('Style', 'peccular-premium'),
			'icon' => 'dashicons dashicons-art',
			'fields' => array(
				'peccular_bs_bg_color',
				'peccular_bs_bg_image',
				'peccular_bs_image_opacity',
				'peccular_bs_head_align',
				'peccular_bs_head_case',
				'peccular_bs_mainheading_color',
				'peccular_bs_proheading_color',
				'peccular_bs_proheadinghover_color',
				'peccular_bs_saleprice_color', 
				'peccular_bs_regprice_color', 
				'peccular_bs_ind_color',
				'peccular_bs_acind_color',
				'peccular_bs_wishico_color',
				'peccular_bs_mwishicobg_color',
				'peccular_bs_tooltip_color',
				'peccular_bs_tooltipbg_color',
				'peccular_newarrproductindicator_color',
				'peccular_activnewarrproductindicator_color',
				'curtains_bs_title_case'
			),
		),
		array(
			'name' => esc_html__('Layout', 'peccular-premium'),
			'icon' => 'dashicons dashicons-layout',
			'fields' => array(
				'peccular_bs_padding',
				'peccular_bs_t_padding',
				'peccular_bs_b_padding',
				'peccular_bs_section_width'
			),
		)
	),
)));
$wp_customize->add_setting( 'peccular_bestseller_products_enable',array(
	'default' => true,
	'sanitize_callback' => 'peccular_switch_sanitization'
) );
$wp_customize->add_control( new peccular_Toggle_Switch_Custom_Control( $wp_customize, 'peccular_bestseller_products_enable',array(
	'label' => __( 'Disable Section','peccular' ),
	'section' => 'peccular_bestseller_products_section'
)));
$wp_customize->add_setting('peccular_bs_lbl', array('sanitize_callback'=>'peccular_sanitize_text'));
$wp_customize->add_control(
	new peccular_Info_Text( 
		$wp_customize,
		'peccular_bs_lbl',
		array(
			'settings'      => 'peccular_bs_lbl',
			'section'       => 'peccular_bestseller_products_section',
			'label'         => __( '', 'peccular Premium' ), 
			'description'   => __( '<strong>Note-</strong> <strong>Add Product Images Of Equal Height To Show In A Proper Way.</strong>', 'peccular Premium' ),
		)
	)
); 
$wp_customize->add_setting(
	'ct__bestsellerproduct__page_title',
	array(
		'sanitize_callback' => 'peccular_sanitize_text',
		'default'           => __( 'New Arrivals', 'peccular-premium' )
	)
);
$wp_customize->add_control(
	'ct__bestsellerproduct__page_title',
	array(
		'settings'      => 'ct__bestsellerproduct__page_title',
		'section'       => 'peccular_bestseller_products_section', 
		'type'          => 'text',
		'label'         => __( 'Section Heading', 'peccular-premium' )
	)
); 
$wp_customize->add_setting( 'peccular_bs_bg_color', array(
	'default' => '',
	'sanitize_callback' => 'sanitize_hex_color'
));
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'peccular_bs_bg_color', array(
	'label' => __('Section BG Color','peccular'),
	'section' => 'peccular_bestseller_products_section',
)));
$wp_customize->add_setting( 'peccular_bs_bg_image', array(
	'default' => '',
	'sanitize_callback' => 'esc_url_raw'
));
$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'peccular_bs_bg_image', array(
	'label' => __('Section BG Image','peccular'),
	'section' => 'peccular_bestseller_products_section',
)));
$wp_customize->add_setting('peccular_bs_image_opacity',array(
	'default' => 1,
	'sanitize_callback' => 'peccular_sanitize_float'
));
$wp_customize->add_control(new peccular_Custom_Control( $wp_customize, 'peccular_bs_image_opacity',array(
	'label' => __('Section BG Opacity','peccular'),
	'section' => 'peccular_bestseller_products_section',
	'input_attrs' => array(
		'min' => 0,
		'max' => 1,
		'step' => 0.1,
	),
)));
$wp_customize->add_setting('peccular_bs_head_align',array(
	'default' => 'Center',
	'sanitize_callback' => 'peccular_sanitize_choices',
));
$wp_customize->add_control('peccular_bs_head_align',array(
	'type' => 'select',
	'label' => __('Section Heading Alignment','peccular'),
	'choices' => array (
		'Center' => __('Center','peccular'),
		'Left' => __('Left','peccular'),
		'Right' => __('Right','peccular')
	),
	'section' => 'peccular_bestseller_products_section',
));
$wp_customize->add_setting('peccular_bs_head_case',array(
	'default' => 'Capitalize',
	'sanitize_callback' => 'peccular_sanitize_choices',
));
$wp_customize->add_control('peccular_bs_head_case',array(
	'type' => 'select',
	'label' => __('Section Heading Case','peccular'),
	'choices' => array (
		'Uppercase' => __('Uppercase','peccular'),
		'Lowercase' => __('Lowercase','peccular'),
		'Capitalize' => __('Capitalize','peccular')
	),
	'section' => 'peccular_bestseller_products_section',
));
$wp_customize->add_setting('curtains_bs_title_case',array(
	'default' => 'Capitalize',
	'sanitize_callback' => 'peccular_sanitize_choices',
));
$wp_customize->add_control('curtains_bs_title_case',array(
	'type' => 'select',
	'label' => __('Product Title Case','peccular'),
	'choices' => array (
		'Uppercase' => __('Uppercase','peccular'),
		'Lowercase' => __('Lowercase','peccular'),
		'Capitalize' => __('Capitalize','peccular')
	),
	'section' => 'peccular_bestseller_products_section',
));
$wp_customize->add_setting('peccular_bs_padding',array(
	'sanitize_callback'   => 'esc_html'
));
$wp_customize->add_control('peccular_bs_padding',array(
	'label' => __('Section Padding','peccular'),
	'section' => 'peccular_bestseller_products_section'
));

$wp_customize->add_setting('peccular_bs_t_padding',array(
	'default' => '3.5',
	'sanitize_callback' => 'sanitize_text_field'
));
$wp_customize->add_control('peccular_bs_t_padding',array(
	'type' => 'number',
	'label' => __('Top','peccular'),
	'section' => 'peccular_bestseller_products_section',
));
$wp_customize->add_setting('peccular_bs_b_padding',array(
	'default' => '2.5',
	'sanitize_callback' => 'sanitize_text_field'
));
$wp_customize->add_control('peccular_bs_b_padding',array(
	'type' => 'number',
	'label' => __('Bottom','peccular'),
	'section' => 'peccular_bestseller_products_section',
));

$wp_customize->add_setting('peccular_bs_section_width',array(
	'default' => 'Box Width',
	'sanitize_callback' => 'peccular_sanitize_choices',
));
$wp_customize->add_control('peccular_bs_section_width',array(
	'type' => 'select',
	'label' => __('Section Width','peccular'),
	'choices' => array (
		'Box Width' => __('Box Width','peccular'),
		'Full Width' => __('Full Width','peccular')
	),
	'section' => 'peccular_bestseller_products_section',
));
addColorPalatOption($wp_customize, 'peccular_bs_mainheading_color', 'peccular_bestseller_products_section', 'Section Heading Color', '');
addColorPalatOption($wp_customize, 'peccular_bs_proheading_color', 'peccular_bestseller_products_section', 'Product Title Color', '');
addColorPalatOption($wp_customize, 'peccular_bs_proheadinghover_color', 'peccular_bestseller_products_section', 'Product Title Hover Color', '');
addColorPalatOption($wp_customize, 'peccular_bs_saleprice_color', 'peccular_bestseller_products_section', 'Sale Price Text Color', '');
addColorPalatOption($wp_customize, 'peccular_bs_regprice_color', 'peccular_bestseller_products_section', 'Regular Price Text Color', '');
addColorPalatOption($wp_customize, 'peccular_bs_ind_color', 'peccular_bestseller_products_section', 'Previous Arrow Color', '');
addColorPalatOption($wp_customize, 'peccular_bs_acind_color', 'peccular_bestseller_products_section', 'Next Arrow Color', '');

addColorPalatOption($wp_customize, 'peccular_bestproductindicator_color', 'peccular_catproduct_section', 'Indicator Color', '');
addColorPalatOption($wp_customize, 'peccular_activbestproductindicator_color', 'peccular_catproduct_section', 'Active Indicator Color', '');


addColorPalatOption($wp_customize, 'peccular_bs_wishico_color', 'peccular_bestseller_products_section', 'Wishlist Icon Color', '');
addColorPalatOption($wp_customize, 'peccular_bs_mwishicobg_color', 'peccular_bestseller_products_section', 'Wishlist Icon BG Color', '');
addColorPalatOption($wp_customize, 'peccular_bs_tooltip_color', 'peccular_bestseller_products_section', 'Tooltip Text Color', '');
addColorPalatOption($wp_customize, 'peccular_bs_tooltipbg_color', 'peccular_bestseller_products_section', 'Tooltip Text BG Color', '');

addColorPalatOption($wp_customize, 'peccular_newarrproductindicator_color', 'peccular_bestseller_products_section', 'Indicator Color', '');
addColorPalatOption($wp_customize, 'peccular_activnewarrproductindicator_color', 'peccular_bestseller_products_section', 'Active Indicator Color', '');
?>