<?php 
$wp_customize->add_section(
    'peccular_courses_section',
    array(
        'title'   => __( 'Projects Section', 'peccular' ),
        'panel'   => 'peccular_premium_home_panel1',
        'priority' =>20
    ) 
);

$wp_customize->add_setting('peccular_courses_nav', array(
   'sanitize_callback' => 'wp_kses_post',
)); 

$wp_customize->add_control(new peccular_Tab_Control($wp_customize, 'peccular_courses_nav', array(
   'section' => 'peccular_courses_section',
   'priority' => 1,
   'buttons' => array( 
      array(
         'name' => esc_html__('General', 'peccular-premium'),
         'icon' => 'dashicons dashicons-welcome-write-blog',
         'fields' => array(
            'peccular_courses_enable', 
            'peccular_courses_maintitle',
            'peccular_featuredproduct_products_section_lbl',
            'peccular_courses_subtitle',
            'peccular_courses_headImg_display',
            'peccular_courses_head_icon_enable',
            'peccular_courses_head_icon',  
            'peccular_courses_area_lbl',
            'peccular_courses_section_lbl', 
            'peccular_courses_section_lbl2',
            'peccular_courses_number', 
            'peccular_courses_heading1',
            'peccular_courses_heading2',
            'peccular_courses_heading3',
            'peccular_courses_heading4',
            'peccular_courses_heading5',
            'peccular_courses_heading6',
            'peccular_courses_heading7',
            'peccular_courses_heading8',
            'peccular_courses_heading9',
            'peccular_courses_heading10',
            'peccular_courses_heading11',
            'peccular_courses_area_lblpro',
            'peccular_courses_heading12',
            'peccular_courses_page1',
            'peccular_courses_page2',
            'peccular_courses_page3',
            'peccular_courses_page4',
            'peccular_courses_page5',
            'peccular_courses_page6',
            'peccular_courses_page7',
            'peccular_courses_page8',
            'peccular_courses_page9',
            'peccular_courses_page10',
            'peccular_courses_page11',
            'peccular_courses_page12',
            'peccular_courses_page_icon_1',
            'peccular_courses_page_icon_2',
            'peccular_courses_page_icon_3',
            'peccular_courses_page_icon_4',
            'peccular_courses_page_icon_5',
            'peccular_courses_page_icon_6',
            'peccular_courses_page_icon_7',
            'peccular_courses_page_icon_8',
            'peccular_courses_page_icon_9',
            'peccular_courses_page_icon_10',
            'peccular_courses_page_icon_11',
            'peccular_courses_page_icon_12',
            'peccular_courses_maintext',
            'peccular_projects_display',
            'peccular_projectsbutton',
            'peccular_projectsbuttonlink',
            'peccular_courses_icon_enable'
        ),
         'active' => true,
     ),
      array(
        'name' => esc_html__('Style', 'peccular-premium'),
        'icon' => 'dashicons dashicons-art',
        'fields' => array(
            'peccular_courses_section_bg_color',
            'peccular_courses_section_bg_image',
            'peccular_courses_head_align',
            'curtains_feaproduct_title_case',
            'peccular_feaproductslabel_head_case',
            'peccular_fmainheading_color', 
            'peccular_fetpro_wishico_color',
            'peccular_fetpro_mwishicobg_color',
            'peccular_fetpro_tooltip_color',
            'peccular_projectallttl_color',
            'peccular_cproject_case',
            'peccular_fetpro_tooltipbg_color',
            'peccular_projectallttlhvr_color',
            'peccular_fproheading_color',
            'peccular_fmaincontent_color', 
            'peccular_fproheadinghover_color',
            'peccular_fsaleprice_color',
            'peccular_projects_heading_case',
            'slidertxtbutton_color_one',
            'slidertxtbtnbg_color_one',
            'slidertxtbutton_hover_one',
            'peccular_fetpro_boxbg_color',
            'peccular_featproductindicator_color',
            'peccular_activefeatproductindicator_color',
            'peccular_fregprice_color',
            'peccular_courses_image_opacity'
        ),
    ),
      array(
        'name' => esc_html__('Layout', 'peccular-premium'),
        'icon' => 'dashicons dashicons-layout',
        'fields' => array(
            'peccular_courses_padding',                
            'peccular_courses_top_padding',
            'peccular_courses_bottom_padding',                 
            'peccular_courses_section_width'        
        ),
    )
  ),
)));

$wp_customize->add_setting( 'peccular_courses_enable',array(
    'default' => true,
    'sanitize_callback' => 'peccular_switch_sanitization'
) );
$wp_customize->add_control( new peccular_Toggle_Switch_Custom_Control( $wp_customize, 'peccular_courses_enable',array(
    'label' => __( 'Disable Section','peccular' ),
    'section' => 'peccular_courses_section'
)));

$wp_customize->add_setting('peccular_featuredproduct_products_section_lbl', array('sanitize_callback'=>'peccular_sanitize_text'));
$wp_customize->add_control(
    new peccular_Info_Text( 
        $wp_customize,
        'peccular_featuredproduct_products_section_lbl',
        array(
            'settings'      => 'peccular_featuredproduct_products_section_lbl',
            'section'       => 'peccular_courses_section',
            'label'         => __( '', 'peccular Premium' ), 
            'description'   => __( '<strong>Note- 1</strong> <strong>Add Product Images Of Equal Height To Show In A Proper Way.</strong>', 'peccular Premium' ),
        )
    )
);

$wp_customize->add_setting(
    'peccular_courses_maintitle',
    array(
        'sanitize_callback' => 'peccular_sanitize_text',
        'default'           => __( 'Our Projects', 'peccular' )
    )
); 
$wp_customize->add_control(
    'peccular_courses_maintitle',
    array(
        'settings'      => 'peccular_courses_maintitle',
        'section'       => 'peccular_courses_section', 
        'type'          => 'text',
        'label'         => __( 'Section Heading', 'peccular' )
    )
);
$wp_customize->add_setting(
    'peccular_courses_maintext',
    array(
        'sanitize_callback' => 'peccular_sanitize_text',
        'default'           => __( 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys', 'peccular' )
    )
); 
$wp_customize->add_control(
    'peccular_courses_maintext',
    array(
        'settings'      => 'peccular_courses_maintext',
        'section'       => 'peccular_courses_section', 
        'type'          => 'textarea',
        'label'         => __( 'Section Content', 'peccular' )
    )
);

$CoursesSingleChoice[] = 'select';

$wp_customize->add_setting('peccular_courses_area_lblpro', array('sanitize_callback'=>'peccular_sanitize_text'));
$wp_customize->add_control(
    new peccular_Info_Text( 
        $wp_customize,
        'peccular_courses_area_lblpro',
        array(
            'settings'      => 'peccular_courses_area_lblpro',
            'section'       => 'peccular_courses_section',
            'label'         => __( '', 'peccular Premium' ), 
            'description'   => __( '<strong>Note-2:</strong> <strong>Changes Will Not Reflect Unless You Select The Projects. Please Add The Project From "Projects Menu" And Then Select Project To Show Information.</strong>', 'peccular Premium' ),
        )
    )
);

$wp_customize->add_setting('peccular_courses_section_lbl2', array('sanitize_callback'=>'peccular_sanitize_text'));
$wp_customize->add_control(
    new peccular_Info_Text( 
        $wp_customize,
        'peccular_courses_section_lbl2',
        array(
            'settings'      => 'peccular_courses_section_lbl2',
            'section'       => 'peccular_courses_section',
            'label'         => __( '', 'peccular Premium' ), 
            'description'   => __( '<strong>Note-3:</strong> <strong>Just Place The Shortcode "[PROJECTS]" In Your Page To List The Projects In A Page</strong> ', 'peccular Premium' ),
        )
    )
);
$wp_customize->add_setting('peccular_courses_number',array('sanitize_callback' => 'peccular_sanitize_text','default' => 0));
$wp_customize->add_control(
    'peccular_courses_number',
    array(
        'settings'      => 'peccular_courses_number',
        'section'       => 'peccular_courses_section',
        'type'          => 'select',
        'label'         => __( 'Number Of Projects To Show', 'peccular-premium' ),
        'choices'=>array(1,2,3,4,5,6,7,8,9,10,11,12)
    )
);

//courses PAGES
for( $i = 1; $i<= 12; $i++ ){
    $wp_customize->add_setting(
        'peccular_courses_heading'.$i,
        array(
            'sanitize_callback' => 'peccular_sanitize_text'
        )
    ); 
    $wp_customize->add_control(
        new peccular_Customize_Heading(
            $wp_customize,
            'peccular_courses_heading'.$i,
            array(
                'settings'      => 'peccular_courses_heading'.$i,
                'section'       => 'peccular_courses_section',
                'label'         => __( 'Project -', 'peccular Premium' ).$i,
            )
        )
    );
    $wp_customize->add_setting(
        'peccular_courses_page'.$i,
        array(
            'sanitize_callback' => 'absint'
        )
    );
    $wp_customize->add_control(
        'peccular_courses_page'.$i,
        array(
            'settings'      => 'peccular_courses_page'.$i,
            'section'       => 'peccular_courses_section',
            'type'=> 'select',
            'label'         => __( 'Select A Project', 'peccular Premium' ),
            'choices' => $CoursesSingleChoice,
        )
    );
}
$wp_customize->add_setting( 'peccular_courses_section_bg_color', array(
   'default' => '',
   'sanitize_callback' => 'sanitize_hex_color'
));
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'peccular_courses_section_bg_color', array(
    'label' => __('Section BG Color','peccular'),
    'section' => 'peccular_courses_section',
)));

$wp_customize->add_setting( 'peccular_courses_section_bg_image', array(
   'default' => '',
   'sanitize_callback' => 'esc_url_raw'
));
$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'peccular_courses_section_bg_image', array(
    'label' => __('Section BG Image','peccular'),
    'section' => 'peccular_courses_section',
)));
$wp_customize->add_setting('peccular_courses_image_opacity',array(
    'default' => 1,
    'sanitize_callback' => 'peccular_sanitize_float'
));
$wp_customize->add_control(new peccular_Custom_Control( $wp_customize, 'peccular_courses_image_opacity',array(
    'label' => __('Section BG Opacity','peccular'),
    'section' => 'peccular_courses_section',
    'input_attrs' => array(
        'min' => 0,
        'max' => 1,
        'step' => 0.1,
    ),
)));
$wp_customize->add_setting('peccular_projects_heading_case',array(
    'default' => 'None',
    'sanitize_callback' => 'peccular_sanitize_choices',
));
$wp_customize->add_control('peccular_projects_heading_case',array(
    'type' => 'select',
    'label' => __('Section Heading Case','peccular'),
    'choices' => array (
        'Uppercase' => __('Uppercase','peccular'),
        'Lowercase' => __('Lowercase','peccular'),
        'Capitalize' => __('Capitalize','peccular'),
        'None' => __('None','peccular')
    ),
    'section' => 'peccular_courses_section',
));
$wp_customize->add_setting('peccular_courses_head_align',array(
    'default' => 'Center',
    'sanitize_callback' => 'peccular_sanitize_choices',
));
$wp_customize->add_control('peccular_courses_head_align',array(
    'type' => 'select',
    'label' => __('Section Heading Alignment','peccular'),
    'choices' => array (
        'Center' => __('Center','peccular'),
        'Left' => __('Left','peccular'),
        'Right' => __('Right','peccular')
    ),
    'section' => 'peccular_courses_section',
));
$wp_customize->add_setting('peccular_courses_padding',array(
  'sanitize_callback'   => 'esc_html'
));
$wp_customize->add_control('peccular_courses_padding',array(
  'label' => __('Section Padding','peccular'),
  'section' => 'peccular_courses_section'
));
$wp_customize->add_setting('peccular_courses_top_padding',array(
    'default' => '2.5',
    'sanitize_callback' => 'sanitize_text_field'
));
$wp_customize->add_control('peccular_courses_top_padding',array(
    'type' => 'number',
    'label' => __('Top','peccular'),
    'section' => 'peccular_courses_section',
));
$wp_customize->add_setting('peccular_courses_bottom_padding',array(
    'default' => '3.5',
    'sanitize_callback' => 'sanitize_text_field'
));
$wp_customize->add_control('peccular_courses_bottom_padding',array(
    'type' => 'number',
    'label' => __('Bottom','peccular'),
    'section' => 'peccular_courses_section',
));

$wp_customize->add_setting('peccular_courses_section_width',array(
    'default' => 'Box Width',
    'sanitize_callback' => 'peccular_sanitize_choices',
));
$wp_customize->add_control('peccular_courses_section_width',array(
    'type' => 'select',
    'label' => __('Section Width','peccular'),
    'choices' => array (
        'Box Width' => __('Box Width','peccular'),
        'Full Width' => __('Full Width','peccular')
    ),
    'section' => 'peccular_courses_section',
));


$wp_customize->add_setting('peccular_cproject_case',array(
    'default' => 'Capitalize',
    'sanitize_callback' => 'peccular_sanitize_choices',
));
$wp_customize->add_control('peccular_cproject_case',array(
    'type' => 'select',
    'label' => __('Project Title Case','peccular'),
    'choices' => array (
        'Uppercase' => __('Uppercase','peccular'),
        'Lowercase' => __('Lowercase','peccular'),
        'Capitalize' => __('Capitalize','peccular')
    ),
    'section' => 'peccular_courses_section',
));
$wp_customize->add_setting('curtains_feaproduct_title_case',array(
    'default' => 'None',
    'sanitize_callback' => 'peccular_sanitize_choices',
));
$wp_customize->add_control('curtains_feaproduct_title_case',array(
    'type' => 'select',
    'label' => __('Product Title Case','peccular'),
    'choices' => array (
        'None' => __('None','peccular'),
        'Uppercase' => __('Uppercase','peccular'),
        'Lowercase' => __('Lowercase','peccular'),
        'Capitalize' => __('Capitalize','peccular')
    ),
    'section' => 'peccular_courses_section',
));
addColorPalatOption($wp_customize, 'peccular_fmainheading_color', 'peccular_courses_section', 'Section Heading Color', '');
addColorPalatOption($wp_customize, 'peccular_fmaincontent_color', 'peccular_courses_section', 'Section Content Color', '');

addColorPalatOption($wp_customize, 'peccular_projectallttl_color', 'peccular_courses_section', 'Project Title Color', '');
addColorPalatOption($wp_customize, 'peccular_projectallttlhvr_color', 'peccular_courses_section', 'Project Title BG Color', '');


addColorPalatOption($wp_customize, 'slidertxtbutton_color_one', 'peccular_courses_section', 'Button Text Color', '');
addColorPalatOption($wp_customize, 'slidertxtbtnbg_color_one', 'peccular_courses_section', 'Button BG Color', '');
addColorPalatOption($wp_customize, 'slidertxtbutton_hover_one', 'peccular_courses_section', 'Button Text Hover Color', '');

addColorPalatOption($wp_customize, 'peccular_fproheading_color', 'peccular_courses_section', 'Product Title Color', '');
addColorPalatOption($wp_customize, 'peccular_fproheadinghover_color', 'peccular_courses_section', 'Product Title Hover Color', '');
addColorPalatOption($wp_customize, 'peccular_fsaleprice_color', 'peccular_courses_section', 'Sale Price Text Color', '');
addColorPalatOption($wp_customize, 'peccular_fregprice_color', 'peccular_courses_section', 'Regular Price Text Color', '');

addColorPalatOption($wp_customize, 'peccular_fetpro_wishico_color', 'peccular_courses_section', 'Wishlist Icon Color', '');
addColorPalatOption($wp_customize, 'peccular_fetpro_mwishicobg_color', 'peccular_courses_section', 'Wishlist Icon BG Color', '');
addColorPalatOption($wp_customize, 'peccular_fetpro_tooltip_color', 'peccular_courses_section', 'Tooltip Text Color', '');
addColorPalatOption($wp_customize, 'peccular_fetpro_tooltipbg_color', 'peccular_courses_section', 'Tooltip Text BG Color', '');

addColorPalatOption($wp_customize, 'peccular_fetpro_boxbg_color', 'peccular_courses_section', 'Product Image Box BG Color', '');

// to show & hide another button
$wp_customize->add_setting( 'peccular_projects_display', array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'peccular_projects_display', array( 'label' => 'Button Display', 'section' => 'peccular_courses_section', 'settings' => 'peccular_projects_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Button', 'hide' => 'Hide Button', ), ) ); 
// end to show & hide button
// end to show & hide button
$wp_customize->add_setting(
    'peccular_projectsbutton',
    array(
        'sanitize_callback' => 'peccular_sanitize_text',
        'default'           => __( 'FOR ALL PROJECTS' )
    )
);
$wp_customize->add_control(
    'peccular_projectsbutton',
    array(
        'settings'      => 'peccular_projectsbutton',
        'section'       => 'peccular_courses_section',
        'type'          => 'text',
        'label'         => __( 'Button Text', 'peccular-premium' )
    )
);
$wp_customize->add_setting('peccular_projectsbuttonlink',   array('default'=> 'Add Link Here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('peccular_projectsbuttonlink',
    array(
        'settings'      => 'peccular_projectsbuttonlink',
        'section'       => 'peccular_courses_section',
        'type'          => 'url',
        'label'         => __( 'Button Link', 'peccular-premium' )
    )
);

addColorPalatOption($wp_customize, 'peccular_featproductindicator_color', 'peccular_courses_section', 'Indicator Color', '');
addColorPalatOption($wp_customize, 'peccular_activefeatproductindicator_color', 'peccular_courses_section', 'Active Indicator Color', '');
?>