/*
 * Theme Name: Online Fashion Store Pro
 */

/*----------------------------------------------------
/* Responsive Navigation
/*--------------------------------------------------*/
jQuery(document).ready(function($){
    $('.primary-navigation').append('<div id="mobile-menu-overlay" />');

    $('.toggle-mobile-menu').click(function(e) {
        e.preventDefault();
        e.stopPropagation();
        $('body').toggleClass('mobile-menu-active');

        if ( $('body').hasClass('mobile-menu-active') ) {
            if ( $(document).height() > $(window).height() ) {
                var scrollTop = ( $('html').scrollTop() ) ? $('html').scrollTop() : $('body').scrollTop();
                $('html').addClass('noscroll').css( 'top', -scrollTop );
            }
            $('#mobile-menu-overlay').fadeIn();
        } else {
            var scrollTop = parseInt( $('html').css('top') );
            $('html').removeClass('noscroll');
            $('html,body').scrollTop( -scrollTop );
            $('#mobile-menu-overlay').fadeOut();
        }
    });
}).on('click', function(event) {

    var $target = jQuery(event.target);
    if ( ( $target.hasClass("publishable-icon") && $target.parent().hasClass("toggle-caret") ) ||  $target.hasClass("toggle-caret") ) {// allow clicking on menu toggles
        return;
    }
    jQuery('body').removeClass('mobile-menu-active');
    jQuery('html').removeClass('noscroll');
    jQuery('#mobile-menu-overlay').fadeOut();
});

/*----------------------------------------------------
/*  Dropdown menu
/* ------------------------------------------------- */
jQuery(document).ready(function($) {
    
    function mtsDropdownMenu() {
        var wWidth = $(window).width();
        if(wWidth > 865) {
            $('#navigation ul.sub-menu, #navigation ul.children').hide();
            var timer;
            var delay = 100;
            $('#navigation li').hover( 
              function() {
                var $this = $(this);
                timer = setTimeout(function() {
                    $this.children('ul.sub-menu, ul.children').slideDown('fast');
                }, delay);
                
            },
            function() {
                $(this).children('ul.sub-menu, ul.children').hide();
                clearTimeout(timer);
            }
            );
        } else {
            $('#navigation li').unbind('hover');
            $('#navigation li.active > ul.sub-menu, #navigation li.active > ul.children').show();
        }
    }

    mtsDropdownMenu();

    $(window).resize(function() {
        mtsDropdownMenu();
    });
});

/*---------------------------------------------------
/*  Vertical menus toggles
/* -------------------------------------------------*/
jQuery(document).ready(function($) {

    $('.widget_nav_menu, #navigation .menu').addClass('toggle-menu');
    $('.toggle-menu ul.sub-menu, .toggle-menu ul.children').addClass('toggle-submenu');
    $('.toggle-menu ul.sub-menu').parent().addClass('toggle-menu-item-parent');

    $('.toggle-menu .toggle-menu-item-parent').append('<span class="toggle-caret"><i class="publishable-icon icon-plus"></i></span>');

    $('.toggle-caret').click(function(e) {
        e.preventDefault();
        $(this).parent().toggleClass('active').children('.toggle-submenu').slideToggle('fast');
    });
});

/*----------------------------------------------------
/* Back to top smooth scrolling
/*--------------------------------------------------*/
jQuery(document).ready(function($) {
    jQuery('a[href=#top]').click(function(){
        jQuery('html, body').animate({scrollTop:0}, 'slow');
        return false;
    });
});


/*----------------------------------------------------
/* Video pop up
/*--------------------------------------------------*/

var links = $('.boxes a');
links.colorbox({
  inline: true,
  rel: 'gallery'
});

/* Colorbox resize function */
var resizeTimer;
function resizeColorBox()
{
    if (resizeTimer) clearTimeout(resizeTimer);
    resizeTimer = setTimeout(function() {
        if ($('#cboxOverlay').is(':visible')) {
            $.colorbox.load(true);
        }
    }, 300)
}

// Resize Colorbox when resizing window or changing mobile device orientation
$(window).resize(resizeColorBox);
window.addEventListener("orientationchange", resizeColorBox, false);


$('.boxes a').colorbox({maxWidth:'95%', maxHeight:'95%'});




/*----------------------------------------------------
/* Slider  
/*--------------------------------------------------*/
    $('.slider').slick({
  autoplay: true,
  speed: 800,
  lazyLoad: 'progressive',
  arrows: true,
  dots: true,
  prevArrow: '<div class="slick-nav prev-arrow"><i></i><svg><use xlink:href="#circle"></svg></div>',
  nextArrow: '<div class="slick-nav next-arrow"><i></i><svg><use xlink:href="#circle"></svg></div>',
}).slickAnimation();



$('.slick-nav').on('click touch', function(e) {

    e.preventDefault();

    let arrow = $(this);

    if(!arrow.hasClass('animate')) {
        arrow.addClass('animate');
        setTimeout(() => {
            arrow.removeClass('animate');
        }, 1600);
    }

});


$('#productcat_section .owl-carousel').owlCarousel({
    loop:true,
    margin:20,
    dots:false,
    nav:false,
    mouseDrag:true,
    autoplay:false,
    responsive:{
        0:{
            items:2,
            dots:true
        },
        600:{
            items:3,
            dots:true
        },
        1300:{
            items:5
        },
        1000:{
            items:4
        }
    }
}); 


$('div#projects .mob-box .owl-carousel').owlCarousel({
    loop:true,
    margin:20,
    dots:false,
    nav:false,
    mouseDrag:true,
    autoplay:false,
    responsive:{
        0:{
            items:2,
            dots:true
        },
        600:{
            items:3,
            dots:true
        },
        1300:{
            items:5
        },
        1000:{
            items:4
        }
    }
}); 



$('#featuredproduct-section .owl-carousel').owlCarousel({
    loop:true,
    margin:45,
    dots:false,
    nav:false,
    mouseDrag:true,
    autoplay:false,
    responsive:{
        0:{
            items:1
        },
        576:{
            items:2,
            margin: 30
        },
        600:{
            items:2,
            margin:30
        },
        1000:{
            items:3,
            margin:30
        },
        1300:{
            items:3
        }
    }
}); 

$('#best-seller-products .owl-carousel').owlCarousel({
    loop:true,
    margin:30,
    dots:false,
    nav:true,
    mouseDrag:true,
    autoplay:false,
    responsive:{
        0:{
            items:2,
            dots:true,
            nav: false
        },
        576:{
            items:2,
            margin: 30,
            dots: true,
            nav: false

        },
        600:{
            items:3,
            margin:30,
            dots: true,
            nav: false

        },
        1000:{
            items:3,
            margin:30
        },
        1300:{
            items:4
        }
    }
}); 

$('#projects .owl-carousel').owlCarousel({
    loop:true,
    margin:20,
    dots:false,
    nav:false,
    mouseDrag:true,
    autoplay:true,
    responsive:{
        0:{
            items:1
        },
        600:{
            items:1
        },
        1300:{
            items:1
        },
        1000:{
            items:1
        }
    }
}); 

