jQuery(document).ready(function($) {
    $('.add-to-wishlist-button').on('click', function(event) {
        event.preventDefault(); // Prevent default action

        var product_id = $(this).data('product-id');
        var security = wishlist_ajax_object.nonce;

        $.ajax({
            type: 'POST',
            url: wishlist_ajax_object.ajax_url,
            data: {
                action: 'add_to_wishlist',
                security: security,
                product_id: product_id
            },
            success: function(response) {
                // Optional: You can update UI here if needed
                console.log('Product added to wishlist successfully.');
            },
            error: function(error) {
                console.error('Error adding product to wishlist.');
            }
        });
    });
});
