// Code to remove from wishlist for wishlist.php
	jQuery(function($) {
    var $confirmPopup = $('#confirm-remove-popup');
    var $confirmYes = $('#confirm-remove-yes');
    var $confirmNo = $('#confirm-remove-no');
    var $popupClose = $('#popup-close');
    var removeUrl = '';

    // Show confirmation popup
    $(document).on('click', '.remove-from-wishlist-button', function(e) {
        e.preventDefault();
        removeUrl = $(this).data('remove-url');
        $confirmPopup.show();
    });

    // Handle Yes button click
    $confirmYes.on('click', function() {
        // Ajax request
        $.ajax({
            url: removeUrl,
            method: 'GET',
            success: function(response) {
                // Reload the page after the product is removed
                location.reload();
            },
            error: function(error) {
                // Handle error responses if needed
                console.error('Error removing from Wishlist');
            }
        });

        $confirmPopup.hide();
    });

    // Handle No button click
    $confirmNo.on('click', function() {
        $confirmPopup.hide();
    });

    // Handle close button click
    $popupClose.on('click', function() {
        $confirmPopup.hide();
    });
});



	jQuery(function($) {
    // Add to Wishlist click event
  $('.add-to-wishlist-button').on('click', function(e) {
    e.preventDefault();
    var $button = $(this);
    var wishlist_url = $button.attr('href');
    var $spinner = $button.find('.spinner');
    var $tooltip = $button.find('.tooltip-text');
    var $icon = $button.find('i.fa');

    // Show spinner
    $spinner.addClass('loading');
    $tooltip.text('Processing...');

    // Ajax request
    $.ajax({
        url: wishlist_url,
        method: 'GET',
        success: function(response) {
            // Simulate delay for demonstration purposes (remove in production)
            setTimeout(function() {
                // Hide spinner and toggle "Added" or "Add" text
                $spinner.removeClass('loading');
                if ($button.hasClass('added')) {
                    $tooltip.text('Add To Wishlist');
                    $button.removeClass('added');
                    $icon.removeClass('fa-heart').addClass('fa-heart-o');
                } else {
                    $tooltip.text('Added To Wishlist');
                    $button.addClass('added');
                    $icon.removeClass('fa-heart-o').addClass('fa-heart');
                }
            }, 1000); // Simulate delay for 1 second (remove in production)
        },
        error: function(error) {
            // Handle error responses if needed
            console.error('Error updating Wishlist');
            $tooltip.text('Error');
            $spinner.removeClass('loading');
        }
    });
});

// Remove from wishlist button on wishlist page
$('.remove-from-wishlist-button').on('click', function(e) {
    e.preventDefault();
    var $button = $(this);
    var remove_url = $button.attr('href');

    // Show spinner or some visual indication if needed

    // Ajax request
    $.ajax({
        url: remove_url,
        method: 'GET',
        success: function(response) {
            // Simulate delay for demonstration purposes (remove in production)
            setTimeout(function() {
                // Remove the product item from the wishlist page
                $button.closest('.wishlist-item').fadeOut('slow', function() {
                    $(this).remove();
                });
            }, 1000); // Simulate delay for 1 second (remove in production)
        },
        error: function(error) {
            // Handle error responses if needed
            console.error('Error removing from Wishlist');
        }
    });
});

// Add to Cart click event
$('.add_to_cart_button').on('click', function(e) {
    e.preventDefault();
    var $button = $(this);
    var add_to_cart_url = $button.attr('href');
    var product_id = $button.data('product_id');
    var $spinner = $button.find('.spinner');
    var $tooltip = $button.find('.tooltip-text');

    // Show spinner
    $spinner.addClass('loading');
    $tooltip.text('Processing...');

    // Ajax request
    $.ajax({
        url: add_to_cart_url,
        method: 'POST',
        data: {
            product_id: product_id,
            quantity: 1,
            action: 'add_to_cart'
        },
        success: function(response) {
            // Simulate delay for demonstration purposes (remove in production)
            setTimeout(function() {
                // Hide spinner and show "Added" text
                $spinner.removeClass('loading');
                $tooltip.text('Added To Cart');
                $button.addClass('added');
                setTimeout(function() {
                    $button.removeClass('added');
                }, 1500); // Reset after 1.5 seconds
            }, 1000); // Simulate delay for 1 second (remove in production)
        },
        error: function(error) {
            // Handle error responses if needed
            console.error('Error adding to Cart');
            $tooltip.text('Error');
            $spinner.removeClass('loading');
        }
    });
});

    // Quick View click event
    $('.quick-view').on('click', function(e) {
        e.preventDefault();
        var product_id = $(this).data('product_id');

        // Here you can implement your Ajax call to fetch and display quick view content
        // Example:
        $.ajax({
            url: ajax_object.ajax_url, // Use wp_localize_script to pass ajax_url to your script
            method: 'POST',
            data: {
                action: 'product_quick_view',
                product_id: product_id
            },
            success: function(response) {
                // Assuming you have a function to handle displaying quick view content
                displayQuickView(response);
            },
            error: function(error) {
                // Handle error responses if needed
                console.error('Error fetching quick view');
            }
        });
    });

    // Function to display quick view content
    function displayQuickView(content) {
        // Example: Show content in a modal or popup
        alert('Quick View Content: ' + content);
    }
});



document.addEventListener('DOMContentLoaded', function () {
    const quickViewButtons = document.querySelectorAll('.quick-view');

    quickViewButtons.forEach(button => {
        button.addEventListener('click', function (e) {
            e.preventDefault();
            const productId = this.getAttribute('data-product-id');
            const popup = document.querySelector(`#quick-view-${productId}`);
            
            // Close any open popups
            document.querySelectorAll('.quick-view-popup').forEach(popup => {
                popup.style.display = 'none';
            });

            // Open the selected popup
            if (popup) {
                popup.style.display = 'block';
            }
        });
    });

    // Close the quick view popup
    document.addEventListener('click', function (e) {
        if (e.target.closest('.close-quick-view')) {
            e.target.closest('.quick-view-popup').style.display = 'none';
        }
    });
});