<?php 
/**
 * Template Name: Contact Page
 *
 * @package peccular Premium
 */
get_header(); 
?>
<?php $image = wp_get_attachment_url( get_post_thumbnail_id($post->ID));?>
<div class="<?php if(get_theme_mod('peccular_inner_page_width','Box Width') == 'Box Width'){ ?>container <?php } elseif(get_theme_mod('peccular_inner_page_width','Box Width') == 'Full Width'){ ?> container-fluid <?php }?>">
	<?php
	if(get_theme_mod('page_title_on_off') != 'on' ){
		?>   
		<div class='button'><?php peccular_lite_the_breadcrumb(); ?></div>
	<?php } ?>   
</div>
<main id="innerpage-box">
	<div class="inner_contentbox">
		<?php 
		$peccular_contact_page_address_label = get_theme_mod('peccular_contactpage_address_label', 'Address');
		$peccular_contact_block2_addtext = get_theme_mod('peccular_contact_block2_addtext', 'PO Box 14122 Lorem ipsum dolor sit');

		$peccular_contact_page_phone11 = get_theme_mod('peccular_contact_page_phone11', '(00) 0123-456-789');

		$peccular_contact_block2_title = get_theme_mod('peccular_contact_block2_title', 'Phone');
		$peccular_contact_block2_addlb = get_theme_mod('peccular_contact_block2_addlb', 'Address');
		$peccular_contact_block2_emaillbl = get_theme_mod('peccular_contact_block2_emaillbl', 'Email');
		$peccular_contact_block2_emailtext = get_theme_mod('peccular_contact_block2_emailtext', 'user@gmail.com');

		$peccular_contact_page_formtitle1 = get_theme_mod('peccular_contact_page_formtitle1', 'Get In Touch');

		$peccular_contact_page_form_shortcode = get_theme_mod('peccular_contactpage_form_shortcode', 'Add Form [SHORTCODE] Here');

		$peccular_contact_page_iframe_shortcode = get_theme_mod('peccular_contactpage_iframe_shortcode', 'Add Map Embed Code Here');

		$peccular_contact_page_formleft = get_theme_mod('peccular_contact_page_formleft', 'Find us here');
		$peccular_contact_page_formleftp = get_theme_mod('peccular_contact_page_formleftp', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit');
		?>
		<div id="peccular-contactus-wrap">
			<div class="<?php if(get_theme_mod('peccular_inner_page_width','Box Width') == 'Box Width'){ ?> container <?php } elseif(get_theme_mod('peccular_inner_page_width','Box Width') == 'Full Width'){ ?> container-fluid <?php }?>">
				<div class="row m-0"> 
					<?php if( get_theme_mod('peccular_contactbox_display','show' ) == 'show') :
						?>  
						<div class="col-xl-5 col-lg-5 col-md-12 col-sm-12 col-xs-12 p-0-10">
							<div class="contact-block-bg">
								<h2><?php echo ($peccular_contact_page_formleft);  ?></h2>
								<p><?php echo ($peccular_contact_page_formleftp);  ?></p>

								<div class="col-xl-12 boxes-gap">
									<div class="row m-0">
										<?php if($peccular_contact_page_address_label || $peccular_contact_block2_addtext){ ?>
											<div class="col-xl-1 col-lg-1 col-md-1 col-sm-1 contact-icon">
												<i class="fa fa-map-marker" aria-hidden="true"></i>	
											</div>
											<div class="col-xl-10 col-lg-10 col-md-10 col-sm-10 peccular-contact-area" style="text-align: <?php if(get_theme_mod('peccular_contactpage_content_align','Left') == 'Left'){ ?> left <?php } elseif(get_theme_mod('peccular_contactpage_content_align','Center') == 'Center'){ ?> center <?php } elseif(get_theme_mod('peccular_contactpage_content_align','Right') == 'Right'){ ?> right <?php } ?> ">
												<div class="contact_l_area">
													<?php echo ($peccular_contact_page_address_label);  ?>
												</div>
												<div class="contact_info_area">
													<?php echo ($peccular_contact_block2_addtext);  ?>
												</div>	
											</div>
										<?php }?>
									</div>
								</div>

								<div class="col-xl-12 boxes-gap">
									<div class="row m-0">
										<?php if($peccular_contact_block2_emaillbl || $peccular_contact_block2_emailtext){ ?>
											<div class="col-xl-1 col-lg-1 col-md-1 col-sm-1 contact-icon">
												<i class="fa fa-envelope" aria-hidden="true"></i>		
											</div>
											<div class="col-xl-10 col-lg-10 col-md-10 col-sm-10 peccular-contact-area" style="text-align: <?php if(get_theme_mod('peccular_contactpage_content_align','Left') == 'Left'){ ?> left <?php } elseif(get_theme_mod('peccular_contactpage_content_align','Center') == 'Center'){ ?> center <?php } elseif(get_theme_mod('peccular_contactpage_content_align','Right') == 'Right'){ ?> right <?php } ?> ">
												<div class="contact_l_area">
													<?php echo ($peccular_contact_block2_emaillbl);  ?>
												</div>
												<div class="contact_info_area">
													<a href="mailto:<?php echo $peccular_contact_block2_emailtext;?>"><?php echo ($peccular_contact_block2_emailtext);  ?></a>		
												</div>	
											</div>
										<?php }?>
									</div>
								</div>	
								<div class="col-xl-12 boxes-gap">
									<div class="row m-0">
										<?php if($peccular_contact_block2_title || $peccular_contact_page_phone11){ ?>
											<div class="col-xl-1 col-lg-1 col-md-1 col-sm-1 contact-icon">
												<i class="fa fa-phone" aria-hidden="true"></i>			
											</div>
											<div class="col-xl-10 col-lg-10 col-md-10 col-sm-10 peccular-contact-area" style="text-align: <?php if(get_theme_mod('peccular_contactpage_content_align','Left') == 'Left'){ ?> left <?php } elseif(get_theme_mod('peccular_contactpage_content_align','Center') == 'Center'){ ?> center <?php } elseif(get_theme_mod('peccular_contactpage_content_align','Right') == 'Right'){ ?> right <?php } ?> ">
												<div class="contact_l_area">
													<?php echo ($peccular_contact_block2_title);  ?>
												</div>
												<div class="contact_info_area">
													<a href="tel:<?php echo ($peccular_contact_page_phone11);  ?>"><?php echo ($peccular_contact_page_phone11);  ?></a>	
												</div>	
											</div>
										<?php }?>
									</div>
								</div>
							</div>

						</div>
					<?php endif ?>
					<div class="col-xl-7 col-lg-7 col-md-12 col-sm-12 col-xs-12 contact-gap">
						<div class="peccular-contact-form-block">
							<div class="<?php if(get_theme_mod('peccular_inner_page_width','Box Width') == 'Box Width'){ ?>container <?php } elseif(get_theme_mod('peccular_inner_page_width','Box Width') == 'Full Width'){ ?> container-fluid <?php }?>">
								<div class="row">
									<?php if(!empty($peccular_contact_page_form_shortcode)){ ?>

										<div class="peccular-contact-page-form">		
											<h2><?php echo ($peccular_contact_page_formtitle1);?></h2>
											<?php echo do_shortcode($peccular_contact_page_form_shortcode);?>
										</div>

									<?php }?>

									<div class="clearfix"></div>
								</div>
								<div class="clearfix"></div>
							</div>
						</div>	
					</div>
				</div>
			</div>
		</div>

		<div class="<?php if(get_theme_mod('peccular_inner_page_width','Full Width') == 'Full Width'){ ?>container-fluid p-0<?php } elseif(get_theme_mod('peccular_inner_page_width','Full Width') == 'Full Width'){ ?> container-fluid p-0 <?php }?>">
			<?php if(!empty($peccular_contact_page_iframe_shortcode)){ ?>
				<div class="peccular-contact-mapbox">
					<?php echo ($peccular_contact_page_iframe_shortcode);  ?>
				</div>
			<?php }?>
		</div>			
		<div class="clearfix"></div>
	</div>
</main>
<?php get_footer(); ?>