<?php
/**
 * Template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you (the theme developer).
 * will need to copy the new files to your theme to maintain compatibility. We try to do this.
 * as little as possible, but it does happen. When this occurs the version of the template file will.
 * be bumped and the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

global $product;

/**
 * Hook: woocommerce_before_single_product.
 *
 * @hooked woocommerce_output_all_notices - 10
 */
do_action( 'woocommerce_before_single_product' );

if ( post_password_required() ) {
	echo get_the_password_form(); // WPCS: XSS ok.
	return;
}
?>

<div id="product-<?php the_ID(); ?>" <?php wc_product_class( '', $product ); ?>>
	<?php
		/**
		 * Hook: woocommerce_before_single_product_summary.
		 *
		 * @hooked woocommerce_show_product_sale_flash - 10
		 * @hooked woocommerce_show_product_images - 20
		 */
		do_action( 'woocommerce_before_single_product_summary' );
	?>

	<div class="summary entry-summary">
		<?php 
			$user_id = get_current_user_id();
			$product_id = $product->get_id();
			$wishlist = get_user_meta($user_id, 'wishlist', true);
			$button_class = in_array($product_id, (array)$wishlist) ? 'added' : '';
			$nonce = wp_create_nonce('update_wishlist_' . $product_id);

			$wishlist_url = esc_url(add_query_arg(
			    array(
			        'update_wishlist' => $product_id,
			        '_wpnonce' => $nonce
			    )
			));
		?>
		<?php

			
			// remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 10 );
			// remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30 );
			// remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40 );
			// remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_sharing', 50 );
			// // Remove related products from single product pages
			// remove_action('woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20);

			// Add the title and short description
			do_action( 'woocommerce_single_product_summary' );

			// Display quantity input and add to cart button
			echo '<div class="product-btnarea">';
			echo '<div class="product-quantity">';
			//woocommerce_template_single_add_to_cart(); // This includes quantity input and add-to-cart button
				//$buy_now_url = wc_get_cart_url() . '?add-to-cart=' . $product->get_id();
				//echo '<a href="' . esc_url($buy_now_url) . '" class="button buy-now-button">Buy Now</a>';

			echo '</div>';

			echo '<a href="' . $wishlist_url . '" class="add-to-wishlist-button ' . $button_class . '">
			    <span class="spinner"></span>
			    <i class="fa fa-heart' . ($button_class ? '' : '-o') . '" aria-hidden="true"></i>
			     <span class="tooltip-text">' . ($button_class ? 'Added To Wishlist' : 'Add To Wishlist') . '</span>
			</a>'; 
			echo '</div>';
		?>

	</div>

	<?php
		/**
		 * Hook: woocommerce_after_single_product_summary.
		 *
		 * @hooked woocommerce_output_product_data_tabs - 10
		 * @hooked woocommerce_upsell_display - 15
		 * @hooked woocommerce_output_related_products - 20
		 */
		do_action( 'woocommerce_after_single_product_summary' );
	?>
</div>

<?php do_action( 'woocommerce_after_single_product' ); ?>
