<?php
/**
 *  functions and definitions.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * * @package peccular Premium
 */
$query='';
if ( ! function_exists( 'peccular_lite_setup' ) ) :
    /**
     * Sets up theme defaults and registers support for various WordPress features.
     *
     * Note that this function is hooked into the after_setup_theme hook, which
     * runs before the init hook. The init hook is too late for some features, such
     * as indicating support for post thumbnails.
     */
    function peccular_lite_setup() {
        define( 'MTS_THEME_VERSION', '2.0.6' );
        /*
         * Make theme available for translation.
         * Translations can be filed in the /languages/ directory.
         * If you're building a theme based on publishable, use a find and replace
         * to change 'peccular Premium' to the name of your theme in all the template files.
         */
        load_theme_textdomain( 'peccular Premium', get_template_directory() . '/languages' );

        // Add default posts and comments RSS feed links to head.
        add_theme_support( 'automatic-feed-links' );

        /*
         * Let WordPress manage the document title.
         * By adding theme support, we declare that this theme does not use a
         * hard-coded <title> tag in the document head, and expect WordPress to
         * provide it for us.
         */
        add_theme_support( 'title-tag' );

        /*
         * Enable support for Post Thumbnails on posts and pages.
         *
         * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
         */
        add_theme_support( 'post-thumbnails' );
        set_post_thumbnail_size( 150, 150, true );
        add_image_size( 'peccular Premium-related', 200, 125, true ); //related

        // This theme uses wp_nav_menu() in one location.
        register_nav_menus( array(
            'primary' => esc_html__( 'Primary Menu', 'peccular Premium' ),
        ) );


        // This theme uses wp_nav_menu() in one location.
        register_nav_menus( array(
            'topmenu' => esc_html__( 'Top Menu', 'peccular Premium' ),
        ) );

        /*
         * Switch default core markup for search form, comment form, and comments
         * to output valid HTML5.
         */
        add_theme_support( 'html5', array(
            'comment-form',
            'comment-list',
            'gallery',
            'caption',
        ) );

        if ( peccular_lite_is_wc_active() ) {
            add_theme_support( 'woocommerce' );
        }
        
        // Set up the WordPress core custom background feature.
        add_theme_support( 'custom-background', apply_filters( 'peccular_lite_custom_background_args', array(
          'default-color' => '#000',
          'default-image' => '',
      ) ) );
    }
endif;
add_action( 'after_setup_theme', 'peccular_lite_setup' );

function peccular_lite_content_width() {
    $GLOBALS['content_width'] = apply_filters( 'peccular_lite_content_width', 678 );
}
add_action( 'after_setup_theme', 'peccular_lite_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function peccular_lite_widgets_init() {
    register_sidebar( array(
        'name'          => esc_html__( 'Sidebar', 'peccular Premium' ),
        'id'            => 'sidebar',
        'description'   => '',
        'before_widget' => '<div id="%1$s" class="widget %2$s  wow bounceInUp">',
        'after_widget'  => '</div>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );

    /*// Header Ad sidebar
    register_sidebar(array(
        'name' => __('Header Ad', 'peccular Premium'),
        'description'   => __( '728x90 Ad Area', 'peccular Premium' ),
        'id' => 'widget-header',
        'before_widget' => '<div id="%1$s" class="widget-header">',
        'after_widget' => '</div>',
        'before_title' => '<h3 class="widget-title">',
        'after_title' => '</h3>',
    ));*/
    
    // Shop side bar
    register_sidebar( array(
        'name'          => esc_html__( 'Shop Sidebar', 'peccular Premium' ),
        'id'            => 'peccular-shop-sidebar',
        'description'   => __( 'Add widgets here to appear in your sidebar of shop page.', 'peccular Premium' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s wow bounceInUp">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );
    // Blog side bar
    register_sidebar( array(
        'name'          => esc_html__( 'Blog Sidebar', 'peccular Premium' ),
        'id'            => 'peccular-blog-sidebar',
        'description'   => __( 'Add widgets here to appear in your sidebar of blog page.', 'peccular Premium' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s  wow bounceInUp">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );


   // Gtranslate widge top bar
    register_sidebar( array(
        'name'          => esc_html__( 'Language Translate Widge', 'peccular Premium' ),
        'id'            => 'peccular-gtranslate-sidebar',
        'description'   => __( 'Add Language Translate.', 'peccular Premium' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s  wow bounceInUp">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );


 
    // Services side bar
    register_sidebar( array(
        'name'          => esc_html__( 'Service Sidebar', 'peccular Premium' ),
        'id'            => 'peccular-service-sidebar',
        'description'   => __( 'Add widgets here to appear in your sidebar of services page.', 'peccular Premium' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s  wow bounceInUp">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );

       // project side bar
    // register_sidebar( array(
    //     'name'          => esc_html__( 'Project Sidebar', 'peccular Premium' ),
    //     'id'            => 'peccular-project-sidebar',
    //     'description'   => __( 'Add widgets here to appear in your sidebar of project page.', 'peccular Premium' ),
    //     'before_widget' => '<aside id="%1$s" class="widget %2$s  wow bounceInUp">',
    //     'after_widget'  => '</aside>',
    //     'before_title'  => '<h4 class="widget-title">',
    //     'after_title'   => '</h4>',
    // ) );

    // FOOTER ONE WIDGET SIDEBAR
    register_sidebar( array(
        'name'          => esc_html__( 'Footer One', 'peccular Premium' ),
        'id'            => 'peccular-footer1',
        'description'   => __( 'Add widgets here to appear in your Footer.', 'peccular Premium' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );
    // FOOTER TWO WIDGET SIDEBAR
    register_sidebar( array(
        'name'          => esc_html__( 'Footer Two', 'peccular Premium' ),
        'id'            => 'peccular-footer2',
        'description'   => __( 'Add widgets here to appear in your Footer.', 'peccular Premium' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );
    // FOOTER THREE WIDGET SIDEBAR
    register_sidebar( array(
        'name'          => esc_html__( 'Footer Three', 'peccular Premium' ),
        'id'            => 'peccular-footer3',
        'description'   => __( 'Add widgets here to appear in your Footer.', 'peccular Premium' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );
    // FOOTER FOUR WIDGET SIDEBAR
    register_sidebar( array(
        'name'          => esc_html__( 'Footer Four', 'peccular Premium' ),
        'id'            => 'peccular-footer4',
        'description'   => __( 'Add widgets here to appear in your Footer.', 'peccular Premium' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );
     // FOOTER FIVE WIDGET SIDEBAR
    // register_sidebar( array(
    //     'name'          => esc_html__( 'Footer Five', 'peccular Premium' ),
    //     'id'            => 'peccular-footer5',
    //     'description'   => __( 'Add widgets here to appear in your Footer.', 'peccular Premium' ),
    //     'before_widget' => '<aside id="%1$s" class="widget %2$s">',
    //     'after_widget'  => '</aside>',
    //     'before_title'  => '<h4 class="widget-title">',
    //     'after_title'   => '</h4>',
    // ) ); 

    //  register_sidebar( array(
    //     'name'          => esc_html__( 'Footer Six', 'peccular Premium' ),
    //     'id'            => 'peccular-footer6',
    //     'description'   => __( 'Add widgets here to appear in your Footer.', 'peccular Premium' ),
    //     'before_widget' => '<aside id="%1$s" class="widget %2$s">',
    //     'after_widget'  => '</aside>',
    //     'before_title'  => '<h4 class="widget-title">',
    //     'after_title'   => '</h4>',
    // ) ); 

    if ( peccular_lite_is_wc_active() ) {
        // Register WooCommerce Shop and Single Product Sidebar
        register_sidebar( array(
            'name' => __('Shop Page Sidebar', 'peccular Premium' ),
            'description'   => __( 'Appears on Shop main page and product archive pages.', 'peccular Premium' ),
            'id' => 'shop-sidebar',
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget' => '</div>',
            'before_title' => '<h4 class="widget-title">',
            'after_title' => '</h4>',
        ) );
        register_sidebar( array(
            'name' => __('Single Product Sidebar', 'peccular Premium' ),
            'description'   => __( 'Appears on single product pages.', 'peccular Premium' ),
            'id' => 'product-sidebar',
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget' => '</div>',
            'before_title' => '<h4 class="widget-title">',
            'after_title' => '</h4>',
        ) );
    }
}
add_action( 'widgets_init', 'peccular_lite_widgets_init' );

require_once get_template_directory() . '/functions/cr.php';
function enqueue_custom_scripts() {
    // Register and enqueue your custom JavaScript file
    wp_enqueue_script('custom-script', get_template_directory_uri() . '/path/to/your/custom-script.js', array(), null, true);
}
add_action('wp_enqueue_scripts', 'enqueue_custom_scripts');
wp_enqueue_script('custom-script', get_template_directory_uri() . '/js/custom-script.js', array(), null, true);

function peccular_lite_custom_sidebar() {
    // Default sidebar.
    $sidebar = 'sidebar';

    // Woocommerce.
    if ( peccular_lite_is_wc_active() ) {
        if ( is_shop() || is_product_category() ) {
            $sidebar = 'shop-sidebar';
        }
        if ( is_product() ) {
            $sidebar = 'product-sidebar';
        }
    }

    return $sidebar;
}

/**
 * Enqueue scripts and styles.
 */
function peccular_lite_scripts() {
    wp_enqueue_style( 'peccular Premium-style', get_stylesheet_uri() );

    $handle = 'peccular Premium-style';

    // WooCommerce
    if ( peccular_lite_is_wc_active() ) {
        if ( is_woocommerce() || is_cart() || is_checkout() ) {
            wp_enqueue_style( 'woocommerce', get_template_directory_uri() . '/css/woocommerce2.css' );
            $handle = 'woocommerce';
        }
    }

  // if any file or sections doesnt work then change jquery file position 
  //wp_enqueue_script('jquery-3-3-1-min', get_template_directory_uri().'/js/jquery-3.3.1.min.js', array(), '1.1', true);

    wp_enqueue_script( 'smoothscroll', get_template_directory_uri() . '/js/SmoothScroll.js', array(), '20160809', false );
    wp_enqueue_script( 'jquery-nav', get_template_directory_uri() . '/js/jquery.nav.js', array('jquery'), '20160903', true );
    wp_enqueue_script( 'jquery-bxslider', get_template_directory_uri() . '/js/jquery.bxslider.js', array('jquery'), '4.1.2', true );
     wp_enqueue_script( 'isotope-pkgd', get_template_directory_uri() . '/js/isotope.pkgd.js', array('jquery', 'imagesloaded' ), '20150903', true );
    wp_enqueue_script( 'nivo-lightbox', get_template_directory_uri() . '/js/nivo-lightbox.js', array('jquery'), '20150903', true );
    wp_enqueue_script( 'superfish', get_template_directory_uri() . '/js/superfish.js', array('jquery'), '20150903', true );
    wp_enqueue_script( 'jquery-stellar', get_template_directory_uri() . '/js/jquery.stellar.js', array('imagesloaded'), '20150903', false ); 

    wp_enqueue_script( 'owl-carousel', get_template_directory_uri() . '/js/owl.carousel.js', array('jquery'), '1.3.3', true );

    wp_enqueue_script( 'wow', get_template_directory_uri() . '/js/wow.js', array('jquery'), '20150903', true );
    wp_enqueue_script( 'odometer', get_template_directory_uri() . '/js/odometer.js', array('jquery'), '20150903', true );
    wp_enqueue_script( 'waypoint', get_template_directory_uri() . '/js/waypoint.js', array('jquery'), '20150903', true );
    wp_enqueue_script( 'total-custom', get_template_directory_uri() . '/js/total-custom.js', array('jquery'), '20150903', true );
    wp_enqueue_script('slider', get_template_directory_uri().'/js/slider.js', array(), '1.1', true);
    wp_localize_script( 'total-custom', 'total_localize', array('template_path' => get_template_directory_uri() ));

    //  wp_enqueue_script( 'jquery-3-1-1-slim-min', get_template_directory_uri() . '/js/jquery-3.1.1.slim.min.js', array('jquery'), '20150903', true );
      wp_enqueue_script( 'jquery-colorbox', get_template_directory_uri() . '/js/jquery.colorbox.js', array(), '20160809', false );

    wp_enqueue_style( 'bxslider', get_template_directory_uri() . '/css/jquery.bxslider.css', array(), '4.1.2' );
    wp_enqueue_style( 'colorbox-popup', get_template_directory_uri() . '/css/colorbox.css', array(), '4.1.2' );
    wp_enqueue_style( 'animate', get_template_directory_uri() . '/css/animate.css', array(), '1.0' );
    wp_enqueue_style( 'font-awesome', get_template_directory_uri() . '/css/font-awesome.css', array(), '4.4.0' );
  

    wp_enqueue_style( 'owl-carousel', get_template_directory_uri() . '/css/owl.carousel.css', array(), '1.3.3' );
    wp_enqueue_style( 'owl-theme', get_template_directory_uri() . '/css/owl.theme.css', array(), '1.3.3' );
        wp_enqueue_style( 'nivo-lightbox', get_template_directory_uri() . '/css/nivo-lightbox.css', array(), '1.3.3' );
    wp_enqueue_style( 'superfish', get_template_directory_uri() . '/css/superfish.css', array(), '1.3.3' );

     wp_enqueue_style( 'docs-theme-min', get_template_directory_uri() . '/css/docss.theme.min.css', array(), '1.3.3' );
        wp_enqueue_style( 'owl-carousel-min', get_template_directory_uri() . '/css/owl.carousel.min.css', array(), '1.3.3' );
        wp_enqueue_style( 'owl-theme-default-min', get_template_directory_uri() . '/css/owl.theme.default.min.css', array(), '1.3.3' );
   

    //wp_enqueue_script('owl-carousel-min', get_template_directory_uri().'/js/owl.carousel.min.js', array(), '1.1', true);

  // wp_enqueue_style( 'total-style', get_stylesheet_uri(), array( 'bxslider', 'animate', 'font-awesome', 'owl-carousel', 'owl-theme', 'nivo-lightbox', 'superfish'), '1.0' );
  // wp_enqueue_style( 'total-fonts', total_fonts_url(), array(), null );
   // wp_enqueue_script('script', get_template_directory_uri().'/js/script.js', array(), '1.1', true);
// extra for header
  
   wp_enqueue_style( 'templete', get_template_directory_uri() . '/css-new/templete.css', array(), '1.3.3' );

// extra for header

wp_enqueue_script( 'main', get_template_directory_uri() . '/js/main.js', array('jquery'), '20150903', true );
 wp_enqueue_style( 'style-min', get_template_directory_uri() . '/css/style.min.css', array(), '1.3.3' );

 wp_enqueue_style( 'swiper-min', get_template_directory_uri() . '/css/swiper.min.css', array(), '1.3.3' );
 
 wp_enqueue_script( 'swiper', get_template_directory_uri() . '/js/swiper.min.js', array('jquery'), '20150903', true );
 wp_enqueue_script( 'sliderscript', get_template_directory_uri() . '/js/sliderscript.js', array('jquery'), '20150903', true );
 // single product page feature 
  wp_enqueue_script( 'singlepfscript', get_template_directory_uri() . '/js/singlepfscript.js', array('jquery'), '20150903', true );

// team popup js
wp_enqueue_script( 'teampopup', get_template_directory_uri() . '/js/teampopup.js', array('jquery'), '20150903', true );

// Function to work all sliders with card error in checkout cart page
if ( peccular_lite_is_wc_active() ) {
        if(is_woocommerce()) {
            wp_enqueue_script('jquery-3-3-1-min', get_template_directory_uri().'/js/jquery-3.3.1.min.js', array(), '1.1', true);
            $handle = 'woocommerce';
        }
    }
// gallery pop up

 wp_enqueue_style( 'main', get_template_directory_uri() . '/css/gallery/main.css', array(), '1.3.3' );
  wp_enqueue_style( 'lightgallery', get_template_directory_uri() . '/css/gallery/lightgallery.css', array(), '1.3.3' );

// End gallery pop up

  

    //google fonts
    wp_enqueue_style( 'google-fonts', 'https://fonts.googleapis.com/css?family=Archivo+Narrow|Arimo|Berkshire+Swash|Bitter|Comfortaa|Dancing+Script|Dosis|Droid+Serif|Francois+One|Germania+One|Hammersmith+One|Indie+Flower|Lobster|Muli|Nosifer|PT+Sans|PT+Sans+Caption|PT+Sans+Narrow|Pacifico|Questrial|Roboto+Mono|Roboto+Slab|Source+Serif+Pro|Titillium+Web|Work+Sans|Rubik:700i' );
    // wp_add_inline_style( 'total-style', total_dymanic_styles() );

    wp_enqueue_script( 'peccular Premium-customscripts', get_template_directory_uri() . '/js/customscripts.js',array('jquery'),'',true);

    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
      wp_enqueue_script( 'comment-reply' );
  }

  $peccular_lite_color_scheme = get_theme_mod('peccular_template_color', '#fe5722');
  $peccular_lite_color_scheme2 = get_theme_mod('peccular_template_color2', '#44afdd');
  $header = get_theme_mod('header_textcolor', '#000');
  $peccular_lite_layout = get_theme_mod('peccular_lite_layout', 'cslayout');

  $custom_css = total_dymanic_styles();
  wp_add_inline_style( $handle, $custom_css );
}
add_action( 'wp_enqueue_scripts', 'peccular_lite_scripts' );
/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Implement the Custom style css.
 */
require get_template_directory() . '/inc/style.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require get_template_directory() . '/inc/extras.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/lz-customizer.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require get_template_directory() . '/inc/lz-customizer-functions.php';
/**
 * Load Jetpack compatibility file.
 */
require get_template_directory() . '/inc/jetpack.php';
/**
 * Load Font Awesome list file.
 */
require get_template_directory() . '/inc/font-awesome-list.php';
/**
 * Load function file.
 */
require get_template_directory() . '/inc/functions.php';
/**
 * Add the Social buttons Widget.
 */
include_once( "functions/widget-social.php" );
require_once('functions/meta-data.php'); // ADD THE META DETA FOR THE PHP
/**
 * Copyrights
 */
if ( ! function_exists( 'peccular_lite_copyrights_credit' ) ) {
    function peccular_lite_copyrights_credit() { 
        global $mts_options
        ?>
        <!--start copyrights-->
        <div class="copyrights">
            <div class="container">
                <div id="copyright-note">
                    <span>Copyright <?php echo '&copy; '.date_i18n(__('Y','peccular')); ?> <?php bloginfo( 'name' ); ?>. All Rights Reserved

            <!--<div class="top">
            
                <a href="#top" class="toplink"><?php //_e('Back to Top','peccular Premium'); ?> &uarr;</a>
            </div>-->
        </div>
    </div>
</div>
<!--end copyrights-->
<?php }
}

/**
 * Custom Comments template
 */
if ( ! function_exists( 'peccular_lite_comments' ) ) {
    function peccular_lite_comment($comment, $args, $depth) { ?>
        <li <?php comment_class(); ?> id="li-comment-<?php comment_ID() ?>">
            <div id="comment-<?php comment_ID(); ?>" style="position:relative;" itemscope itemtype="http://schema.org/UserComments">
                <div class="comment-author vcard">
                    <?php echo get_avatar( $comment->comment_author_email, 70 ); ?>
                    <div class="comment-metadata">
                        <?php printf('<span class="fn" itemprop="creator" itemscope itemtype="http://schema.org/Person">%s</span>', get_comment_author_link()) ?>
                        <span class="comment-meta">
                          <?php edit_comment_link(__('(Edit)', 'peccular Premium'),'  ','') ?>
                      </span>
                  </div>
              </div>
              <?php if ($comment->comment_approved == '0') : ?>
               <em><?php _e('Your comment is awaiting moderation.', 'peccular Premium') ?></em>
               <br />
           <?php endif; ?>
           <div class="commentmetadata" itemprop="commentText">
               <?php comment_text() ?>
               <time><?php comment_date(get_option( 'date_format' )); ?></time>
               <span class="reply">
                <?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
            </span>
        </div>
    </div>
</li>
<?php }
}

/*
 * Excerpt
 */
function peccular_lite_excerpt($limit) {
  $excerpt = explode(' ', get_the_excerpt(), $limit);
  if (count($excerpt)>=$limit) {
    array_pop($excerpt);
    $excerpt = implode(" ",$excerpt);
} else {
    $excerpt = implode(" ",$excerpt);
}
$excerpt = preg_replace('`[[^]]*]`','',$excerpt);
return $excerpt;
}

/**
 * Shorthand function to check for more tag in post.
 *
 * @return bool|int
 */
function peccular_lite_post_has_moretag() {
    return strpos( get_the_content(), '<!--more-->' );
}

if ( ! function_exists( 'peccular_lite_readmore' ) ) {
    /**
     * Display a "read more" link.
     */
    function peccular_lite_readmore() {
        ?>
      <!--   <div class="readMore">
            <a href="<?php //echo esc_url( get_the_permalink() ); ?>" title="<?php //the_title_attribute(); ?>" target="_blank">
                <?php //_e( 'Continue Reading', 'peccular Premium' ); ?>
            </a>
        </div> -->

     
            <?php if( get_theme_mod('blogpage_button_display','show' ) == 'show') :
                      ?>
                      <?php
                        $bloginner_page_id = get_theme_mod('bloginner_page'); 
                        $bloginnerbutn_text = get_theme_mod('blogbutninner_text', 'Continue Reading');
                        ?>

                  
                         <a href="<?php echo esc_url( get_the_permalink() ); ?>" title="<?php the_title_attribute(); ?>" target="_blank">
                            <?php echo $bloginnerbutn_text; ?>
                                
                            </a>
                   
                      <?php endif ?>



        <?php 
    }
}


/**
 * Breadcrumbs
 */
if (!function_exists('peccular_lite_the_breadcrumb')) {
    function peccular_lite_the_breadcrumb() {
        if ( is_front_page() ) {
            return;
        }
        echo '<span typeof="v:Breadcrumb" class="root"><a rel="v:url" property="v:title" href="';
        echo esc_url( home_url() );
        /* =====breadcrumb text====== */
        $breadcrumbhometxtbutton = get_theme_mod('peccular_breadcrumbhometxt', 'Home'); 
        /* =====breadcrumb text====== */
        echo '">'.(sprintf( __( "$breadcrumbhometxtbutton", 'peccular Premium' )));
        echo '</a>  </span> <span class="b-icon"> <i class="fa fa-minus" aria-hidden="true"></i> </span>';
        if (is_single()) {
            $categories = get_the_category();
            if ( $categories ) {
                $level = 0;
                $hierarchy_arr = array();
                foreach ( $categories as $cat ) {
                    $anc = get_ancestors( $cat->term_id, 'category' );
                    $count_anc = count( $anc );
                    if (  0 < $count_anc && $level < $count_anc ) {
                        $level = $count_anc;
                        $hierarchy_arr = array_reverse( $anc );
                        array_push( $hierarchy_arr, $cat->term_id );
                    }
                }
                if ( empty( $hierarchy_arr ) ) {
                    $category = $categories[0];
                    echo '<span typeof="v:Breadcrumb" class="root-mid"><a href="'. esc_url( get_category_link( $category->term_id ) ).'" rel="v:url" property="v:title">'.esc_html( $category->name ).'</a><span class="b-icon"> <i class="fa fa-minus" aria-hidden="true"></i> </span> </span>';
                } else {
                    foreach ( $hierarchy_arr as $cat_id ) {
                        $category = get_term_by( 'id', $cat_id, 'category' );
                        echo '<span typeof="v:Breadcrumb"><a href="'. esc_url( get_category_link( $category->term_id ) ).'" rel="v:url" property="v:title">'.esc_html( $category->name ).'</a></span>';
                    }
                }
            }
            echo "<span><span class='treeEnd'>";
            the_title();
            echo "</span></span>";
        } elseif (is_page()) {
            $parent_id  = wp_get_post_parent_id( get_the_ID() );
            if ( $parent_id ) {
                $breadcrumbs = array();
                while ( $parent_id ) {
                    $page = get_page( $parent_id );
                    $breadcrumbs[] = '<span typeof="v:Breadcrumb"><a href="'.esc_url( get_permalink( $page->ID ) ).'" rel="v:url" property="v:title">'.esc_html( get_the_title($page->ID) ). '</a></span><span class="b-icon"><i class="fa fa-minus" aria-hidden="true"></i></span>';
                    $parent_id  = $page->post_parent;
                }
                $breadcrumbs = array_reverse( $breadcrumbs );
                foreach ( $breadcrumbs as $crumb ) { echo $crumb; }
            }
            echo "<span><span class='treeEnd'>";
            the_title();
            echo "</span></span>";
        } elseif (is_category()) {
            global $wp_query;
            $cat_obj = $wp_query->get_queried_object();
            $this_cat_id = $cat_obj->term_id;
            $hierarchy_arr = get_ancestors( $this_cat_id, 'category' );
            if ( $hierarchy_arr ) {
                $hierarchy_arr = array_reverse( $hierarchy_arr );
                foreach ( $hierarchy_arr as $cat_id ) {
                    $category = get_term_by( 'id', $cat_id, 'category' );
                    echo '<span typeof="v:Breadcrumb"><a href="'.esc_url( get_category_link( $category->term_id ) ).'" rel="v:url" property="v:title">'.esc_html( $category->name ).'</a></span><span class="b-icon"><i class="fa fa-minus" aria-hidden="true"></i></span>';
                }
            }
            echo "<span><span class='treeEnd'>";
            single_cat_title();
            echo "</span></span>";
        } elseif (is_author()) {
            echo "<span><span class='treeEnd'>";
            if(get_query_var('author_name')) :
                $curauth = get_user_by('slug', get_query_var('author_name'));
            else :
                $curauth = get_userdata(get_query_var('author'));
            endif;
            echo esc_html( $curauth->nickname );
            echo "</span></span>";
        } elseif (is_search()) {
            echo "<span><span class='treeEnd'>";
            the_search_query();
            echo "</span></span>";
        } elseif (is_tag()) {
            echo "<span><span class='treeEnd'>";
            single_tag_title();
            echo "</span></span>";
        }
    }
}



/*
 * Google Fonts
 */
function peccular_lite_fonts_url() {
    $fonts_url = '';

    /* Translators: If there are characters in your language that are not
    * supported by Monda, translate this to 'off'. Do not translate
    * into your own language.
    */
    $monda = _x( 'on', 'Monda font: on or off', 'peccular Premium' );

    if ( 'off' !== $monda ) {
        $font_families = array();

        if ( 'off' !== $monda ) {
            $font_families[] = urldecode('Roboto:400,500,700,900');
        }

        $query_args = array(
            'family' => urlencode( implode( '|', $font_families ) ),
            //'subset' => urlencode( 'latin,latin-ext' ),
        );

        $fonts_url = add_query_arg( $query_args, '//fonts.googleapis.com/css' );
    }

    return $fonts_url;
}

function peccular_lite_scripts_styles() {
    wp_enqueue_style( 'theme-slug-fonts', peccular_lite_fonts_url(), array(), null );

}
add_action( 'wp_enqueue_scripts', 'peccular_lite_scripts_styles' );

/**
 * WP Mega Menu Plugin Support
 */
function peccular_lite_megamenu_parent_element( $selector ) {
    return '.primary-navigation .container';
}
add_filter( 'wpmm_container_selector', 'peccular_lite_megamenu_parent_element' );

/**
 * Determines whether the WooCommerce plugin is active or not.
 * @return bool
 */
function peccular_lite_is_wc_active() {
    if ( is_multisite() ) {
        include_once( ABSPATH . 'wp-admin/includes/plugin.php' );

        return is_plugin_active( 'woocommerce/woocommerce.php' );
    } else {
        return in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) );
    }
}

/**
 * WooCommerce
 */
if ( peccular_lite_is_wc_active() ) {
    if ( !function_exists( 'mts_loop_columns' )) {
        /**
         * Change number or products per row to 3
         *
         * @return int
         */
        function mts_loop_columns() {
            return 3; // 3 products per row
        }
    }
    add_filter( 'loop_shop_columns', 'mts_loop_columns' );

    /**
     * Redefine woocommerce_output_related_products()
     */
    function woocommerce_output_related_products() {
        $args = array(
            'posts_per_page' => 3,
            'columns' => 3,
        );
        woocommerce_related_products($args); // Display 3 products in rows of 1
    }
    
    global $pagenow;
    if ( is_admin() && isset( $_GET['activated'] ) && $pagenow == 'themes.php' ) {
        /**
         * Define WooCommerce image sizes.
         */
        function peccular_lite_woocommerce_image_dimensions() {
            $catalog = array(
                'width'     => '210',   // px
                'height'    => '155',   // px
                'crop'      => 1        // true
            );
            $single = array(
                'width'     => '326',   // px
                'height'    => '444',   // px
                'crop'      => 1        // true
            );
            $thumbnail = array(
                'width'     => '74',    // px
                'height'    => '74',   // px
                'crop'      => 0        // false
            );
            // Image sizes
            update_option( 'shop_catalog_image_size', $catalog );       // Product category thumbs
            update_option( 'shop_single_image_size', $single );         // Single product image
            update_option( 'shop_thumbnail_image_size', $thumbnail );   // Image gallery thumbs
        }
        add_action( 'init', 'peccular_lite_woocommerce_image_dimensions', 1 );
    }


    /**
     * Change the number of product thumbnails to show per row to 4.
     *
     * @return int
     */
    function peccular_lite_woocommerce_thumb_cols() {
     return 4; // .last class applied to every 4th thumbnail
 }
 add_filter( 'woocommerce_product_thumbnails_columns', 'peccular_lite_woocommerce_thumb_cols' );


    /**
     * Ensure cart contents update when products are added to the cart via AJAX.
     *
     * @param $fragments
     *
     * @return mixed
     */
    function peccular_lite_header_add_to_cart_fragment( $fragments ) {
        global $woocommerce;
        ob_start(); ?>
        
        <a class="cart-contents" href="<?php echo esc_url( $woocommerce->cart->get_cart_url() ); ?>" title="<?php _e( 'View your shopping cart', 'peccular Premium' ); ?>"><?php echo sprintf( _n( '%d item', '%d items', $woocommerce->cart->cart_contents_count, 'peccular Premium' ), $woocommerce->cart->cart_contents_count );?> - <?php echo $woocommerce->cart->get_cart_total(); ?></a>
        
        <?php $fragments['a.cart-contents'] = ob_get_clean();
        return $fragments;
    }
    add_filter( 'add_to_cart_fragments', 'peccular_lite_header_add_to_cart_fragment' );

    /**
     * Optimize WooCommerce Scripts
     * Updated for WooCommerce 2.0+
     * Remove WooCommerce Generator tag, styles, and scripts from non WooCommerce pages.
     */
    function peccular_lite_manage_woocommerce_styles() {
        //remove generator meta tag
        remove_action( 'wp_head', array( $GLOBALS['woocommerce'], 'generator' ) );

        //first check that woo exists to prevent fatal errors
        if ( function_exists( 'is_woocommerce' ) ) {
            //dequeue scripts and styles
            if ( ! is_woocommerce() && ! is_cart() && ! is_checkout() ) {
                wp_dequeue_style( 'woocommerce-layout' );
                wp_dequeue_style( 'woocommerce-smallscreen' );
                wp_dequeue_style( 'woocommerce-general' );
                wp_dequeue_style( 'wc-bto-styles' ); //Composites Styles
                wp_dequeue_script( 'wc-add-to-cart' );
                wp_dequeue_script( 'wc-cart-fragments' );
                wp_dequeue_script( 'woocommerce' );
                wp_dequeue_script( 'jquery-blockui' );
                wp_dequeue_script( 'jquery-placeholder' );



            }
        }
    }
    add_action( 'wp_enqueue_scripts', 'peccular_lite_manage_woocommerce_styles', 99 );

    // Remove WooCommerce generator tag.
    remove_action('wp_head', 'wc_generator_tag');
}

/**
 * Post Layout for Archives
 */
if ( ! function_exists( 'peccular_lite_archive_post' ) ) {
    /**
     * Display a post of specific layout.
     * 
     * @param string $layout
     */
    function peccular_lite_archive_post( $layout = '' ) { 
        $peccular_lite_full_posts = get_theme_mod('peccular_lite_full_posts', '0'); ?>
        <article class="post excerpt col-xl-12 col-lg-12 col-md-12 col-sm-12 col-xs-12 wow zoomIn inner-blog-post">
                <?php
            if ( is_sticky() && is_home() && ! is_paged() ) {
                printf( '<span class="sticky-post">%s</span>', __( 'Featured', 'peccular Premium' ) );
            } ?>
            <?php if ( is_single() ) : ?>
                <div class="post-date-publishable"><?php the_time( get_option( 'date_format' ) ); ?></div>
            <?php endif; ?>



<!-- category page -->

    <div class="inner-blogpost row row-eq-height">
        <?php if ( empty($peccular_lite_full_posts) ) : ?>
                <?php if ( has_post_thumbnail() ) { ?>
        <div class="col-md-6 pd-0 peccular-blog-img-element ht-blog-thumbnail">
             <div class="inside-full-height">

          
                <?php the_post_thumbnail('peccular Premium-featured',array('title' => '' )); ?>
                <?php if (function_exists('wp_review_show_total')) wp_review_show_total(true, 'latestPost-review-wrapper'); ?>
               
                 <a class="blog-link" href="<?php the_permalink(); ?>"> <div class="overlay"></div></a>
          </div>
        </div>

   <?php } else { ?>
    <?php } ?>
<div class="col-md-6 pd-0 peccular-blog-element ">
        <div class="inside-full-height">
          <div class="peccular-blog-overlay"></div>
    <div class="peccular-blog-single">      
            <?php if (get_theme_mod('peccular_show_date',true) != false){ ?>
              <div class="peccular-blog-comment col-lg-12 col-md-12 col-sm-12 col-xs-12">
            <ul>
             <li class="blog_date_box">
                <div class="peccular-blog-date">
                 <span><?php echo get_the_date( 'j-M-Y' ); ?></span>
               </div>
           </li> 
         </ul>                            
       </div>
        <?php } ?> 

        <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
 
          <div class="inner-blog-excerpt">
               <?php echo peccular_lite_excerpt(16); ?>
          </div>
                <?php 
              $blogbutton = get_theme_mod('blog_page_btn_txt', 'Read More'); 
              ?>
              <?php
              if(get_theme_mod('blog_page_button_display') != 'on' ){
                ?>  
            <div class="peccular-blogpage-btn">
           <a href="<?php the_permalink(); ?>"><?php echo $blogbutton ?></a>
              </div>  

             <?php } ?>   
       

      <?php else : ?>
        <?php if (peccular_lite_post_has_moretag()) : ?>
    
       <div class="clearfix"></div>
    
        
       <div class="clearfix"></div> 
                   
</div>
</div>
</div>
            <div class="clearfix"></div> 
</div> 

<!-- END category page -->

 
                    <?php endif; ?>
                <?php endif; ?>
            <div class="clearfix"></div>
            </article>
       
        <?php }
    }


/**
 * Extras
 */
add_action( 'customize_controls_print_styles', 'peccular_customizer_stylesheet' );

function peccular_load_custom_wp_admin_style( $hook ) {
    if ( 'appearance_page_about-peccular_mag' !== $hook ) {
        return;
    }
    wp_enqueue_style( 'peccular_mag-custom-admin-css', get_template_directory_uri() . '/css/themeinfo.css', false, '1.0.0' );
}
add_action( 'admin_enqueue_scripts', 'peccular_load_custom_wp_admin_style' );


// Adding Custome Post Type
function createCustomeTypes() {
register_post_type( 'our-services',
        array( 
            'labels' => array(
                'name' => __( 'Services' , 'peccular Premium'),
                'singular_name' => __( 'Service', 'peccular Premium' )
            ),
            'public' => true,
            'featured_image'=>true,
            'has_archive' => true,
            'menu_icon' => 'dashicons-media-document', //  The url to the icon to be used for this menu or the name of the icon from the iconfont
            'supports' => array('title','editor', 'thumbnail', 'page-attributes'),
        )
    ); 

        // SLIDER Custome type
    register_post_type( 'slider',
        array(
            'labels' => array(
                'name' => __( 'Sliders' , 'paccular'),
                'singular_name' => __( 'Slider', 'paccular' )
            ),
            'public' => true,
            'featured_image'=>true,
            'has_archive' => true,
            'menu_icon' => 'dashicons-images-alt', //  The url to the icon to be used for this menu or the name of the icon from the iconfont
            'supports' => array('title', 'editor', 'thumbnail', 'page-attributes'),
        )
    );
}
add_action( 'init', 'createCustomeTypes' );


// for slider button url
function slider2BtnUrlCutomFieldHtml2(){
    global $post;
    // get the saved value 

    $sliderbtn1url = get_post_meta($post->ID, 'sliderbtn1url', false);
    $sliderbtn1url = !empty($sliderbtn1url[0])?$sliderbtn1url[0]:'';

    // Use nonce for verification
    wp_nonce_field(plugin_basename(__FILE__), 'slider2Btn_links');
    echo '<table id="slider2Btn" width="100%">';

    echo '<table id="slider2Btn" width="100%">';
    echo '<tr> 
    <th width="10%"><span class="dashicons dashicons-info"></span></th>
    <td width="90%"><input type="text" name="sliderbtn1url" width="100%" placeholder="Slider Button Url Here" value="'.$sliderbtn1url.'" /></td>
    </tr>';
    echo '</table>';
}

function addSlider2btnHook(){
     // add_meta_box('slider1_btn_url', __('Add Slider Button Url Here', 'peccular-premium'), 'slider2BtnUrlCutomFieldHtml2', 'slider', 'normal', 'high');
    add_meta_box('slider2_btn_url', __('Add Slider Button Url Here', 'peccular-premium'), 'slider2BtnUrlCutomFieldHtml2', 'slider', 'normal', 'high');
}
function saveslider2btnUrlCutomData($post_id){
    // If it is our form has not been submitted, so we dont want to do anything
    if(defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
        return;

    $sliderbtn1url = !empty($_POST['sliderbtn1url'])?$_POST['sliderbtn1url']:'';
    update_post_meta($post_id, 'sliderbtn1url', $sliderbtn1url);
}
add_action('add_meta_boxes', 'addSlider2btnHook');
add_action('save_post', 'saveslider2btnUrlCutomData');


// for slider button text

function slider1btntextCutomFieldHtml2(){
    global $post;
    // get the saved value 
    $slider1btntext = get_post_meta($post->ID, 'slider1btntext', false);
    $slider1btntext = !empty($slider1btntext[0])?$slider1btntext[0]:'';
    
    // Use nonce for verification
    wp_nonce_field(plugin_basename(__FILE__), 'sliderbtn_text');
    echo '<table id="sliderbtntext" width="100%">';

      echo '<table id="sliderbtntext" width="100%">';
    echo '<tr> 
    <th width="10%"><span class="dashicons dashicons-edit-large"></span></th>
    <td width="90%"><input type="text" name="slider1btntext" width="100%" placeholder="Slider Button Text" value="'.$slider1btntext.'" /></td>
    </tr>';
    echo '</table>';
}

function addslider1btntextHook(){

    add_meta_box('test_slider1btntext', __('Add Slider Button Text', 'peccular-premium'), 'slider1btntextCutomFieldHtml2', 'slider', 'normal', 'high');
}

function saveslider1btntextCutomData($post_id){
    // If it is our form has not been submitted, so we dont want to do anything
    if(defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
        return;

     if (isset($_POST['slider1btntext'])) {

    $slider1btntext = $_POST['slider1btntext'];
    update_post_meta($post_id, 'slider1btntext', $slider1btntext);
    
    }
}
add_action('add_meta_boxes', 'addslider1btntextHook');
add_action('save_post', 'saveslider1btntextCutomData');



function testimonialsDesignationCutomFieldHtml(){
    global $post;
    // get the saved value 
    $designation = get_post_meta($post->ID, 'designation', false);
    $designation = !empty($designation[0])?$designation[0]:'';

    // Use nonce for verification
    wp_nonce_field(plugin_basename(__FILE__), 'testimonials_social_media_links');
    echo '<table id="socialUrls" width="100%">';
    echo '<tr> 
    <th width="10%"><span class="dashicons dashicons-welcome-learn-more
"></span></th>
    <td width="90%"><input type="text" name="designation" width="100%" placeholder="Designation / Number" value="'.$designation.'" /></td>
    </tr>';
    echo '</table>';
}
function PackagesunitCutomFieldHtml(){
    global $post;
    // get the saved value 
    $priceunit = get_post_meta($post->ID, 'priceunit', false);
    $priceunit = !empty($priceunit[0])?$priceunit[0]:'';
    // Use nonce for verification
    wp_nonce_field(plugin_basename(__FILE__), 'packages_social_media_links');
    echo '<table id="socialUrls" width="100%">';
    echo '<tr> 
    <th width="10%"><span class="dashicons dashicons-external"></span></th>
    <td width="90%"><input type="text" name="priceunit" width="100%" placeholder="Add Text Here" value="'.$priceunit.'" /></td>
    </tr>';
    echo '</table>';
}

function addtestimonialsHook(){
    add_meta_box('peccular-testimonials-designation', __('Add Designation / Number', 'peccular'), 'testimonialsDesignationCutomFieldHtml', 'our-testimonial', 'normal', 'high');

    add_meta_box('package_one_priceUnit', __('Add Review Text Here', 'Premium Theme'), 'PackagesunitCutomFieldHtml', 'our-testimonial', 'normal', 'high');
}
/**
 * Method to save the custom field for the testimonial posts 
 * When the post is saved, saves our custom data 
 * @param integer $post_id - An id of the post 
 * @author peccular <support@peccular.com>
 * @since V 1.1  09th jan 2022
 **/
function savetestimonialsSocialCutomData($post_id){
    // If it is our form has not been submitted, so we dont want to do anything
    if(defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
        return;
    if(empty($_POST['designation']) ){
        // echo 'empty --> '; exit;       
        return;
    }

    $designation = $_POST['designation'];
    update_post_meta($post_id, 'designation', $designation);

     $priceunit = !empty($_POST['priceunit'])?$_POST['priceunit']:'';
    update_post_meta($post_id, 'priceunit', $priceunit);
}
add_action('add_meta_boxes', 'addtestimonialsHook');
add_action('save_post', 'savetestimonialsSocialCutomData');
/***** End Add custome fields for testimonials section *****/



/***** Start Add custome fields for team section *****/
/**
 * Method to save the custom field for the team posts 
 * When the post is saved, saves our custom data 
 * @author peccular <support@peccular.com>
 * @since V 1.1  09th jan 2022
 **/
function teamSocialURLsCutomFieldHtml(){
    global $post;

    $teamTwitter = get_post_meta($post->ID, 'teamTwitter', false);
    $teamTwitterValue = !empty($teamTwitter[0])?$teamTwitter[0]:''; 
    $teamFacebook = get_post_meta($post->ID, 'teamFacebook', false);
    $teamFacebookValue = !empty($teamFacebook[0])?$teamFacebook[0]:'';    
    $teamInstagram = get_post_meta($post->ID, 'teamInstagram', false);
    $teamInstagramValue = !empty($teamInstagram[0])?$teamInstagram[0]:'';
    $teamPinterest = get_post_meta($post->ID, 'teamPinterest', false);
    $teamPinterestValue = !empty($teamPinterest[0])?$teamPinterest[0]:'';
    

    // Use nonce for verification

    wp_nonce_field(plugin_basename(__FILE__), 'Team_social_media_links');
    echo '<table id="socialUrls" width="100%">';

     echo '<tr> 
    <th><span class="dashicons dashicons-twitter"></span></th>
    <td><input type="text" name="teamTwitter" placeholder="Twitter URL" width="100%" value="'.$teamTwitterValue.'" /></td>
    </tr>';

    echo '<tr> 
    <th width="10%"><span class="dashicons dashicons-facebook"></span></th>
    <td width="90%"><input type="text" name="teamFacebook" width="100%" placeholder="Facebook URL" value="'.$teamFacebookValue.'" /></td>
    </tr>';   
   
    echo '<tr> 
    <th><span class="dashicons dashicons-smartphone"></span></th>
    <td><input type="text" name="teamInstagram" placeholder="Instagram URL" width="100%" value="'.$teamInstagramValue.'" /></td>
    </tr>';
    
    echo '<tr> 
    <th><span class="dashicons dashicons-pinterest"></span></th>
    <td><input type="text" name="teamPinterest" placeholder="Pinterest URL" width="100%" value="'.$teamPinterestValue.'" /></td>
    </tr>';

    echo '</table>';

   
}

/**
 * Method to save the custom field for the slider posts 
 * When the post is saved, saves our custom data 
 * @author peccular <support@peccular.com>
 * @since V 1.1  09th jan 2022
 **/
function teamDesignationCutomFieldHtml(){
    global $post;
    // get the saved value 
    $designation = get_post_meta($post->ID, 'designation', false);
    $designation = !empty($designation[0])?$designation[0]:'';

    // Use nonce for verification
    wp_nonce_field(plugin_basename(__FILE__), 'Team_social_media_links');
    echo '<table id="socialUrls" width="100%">';
    echo '<tr> 
    <th width="10%"><span class="dashicons dashicons-welcome-learn-more"></span></th>
    <td width="90%"><input type="text" name="designation" width="100%" placeholder="Designation" value="'.$designation.'" /></td>
    </tr>';
    echo '</table>';
}


function addTeamHook(){
     add_meta_box('peccular-team-social-icon', __('Add Social media links', 'peccular'), 'teamSocialURLsCutomFieldHtml', 'our-team', 'normal', 'high');
    add_meta_box('peccular-team-designation', __('Add Designation', 'peccular'), 'teamDesignationCutomFieldHtml', 'our-team', 'normal', 'high');
}

/**
 * Method to save the custom field for the testimonial posts 
 * When the post is saved, saves our custom data 
 * @param integer $post_id - An id of the post 
 * @author peccular <support@peccular.com>
 * @since V 1.1  09th jan 2022
 **/
function saveTeamSocialCutomData($post_id){
    // If it is our form has not been submitted, so we dont want to do anything
    if(defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
        return;
    if(empty($_POST['teamFacebook']) && empty($_POST['teamTwitter']) && empty($_POST['teamInstagram']) && empty($_POST['teamTelegram']) && empty($_POST['designation']) ){
        // echo 'empty --> '; exit;       
        return;

       
    }
   
    $teamFacebook = $_POST['teamFacebook'];
    update_post_meta($post_id, 'teamFacebook', $teamFacebook);
    $teamTwitter = $_POST['teamTwitter'];
    update_post_meta($post_id, 'teamTwitter', $teamTwitter);   
    $teamInstagram = $_POST['teamInstagram'];
    update_post_meta($post_id, 'teamInstagram', $teamInstagram);
    $teamPinterest = $_POST['teamPinterest'];
    update_post_meta($post_id, 'teamPinterest', $teamPinterest);

    $designation = $_POST['designation'];
    update_post_meta($post_id, 'designation', $designation);
}
add_action('add_meta_boxes', 'addTeamHook');
add_action('save_post', 'saveTeamSocialCutomData');



/***** End Add custome fields for team section *****/

/*****  Add custome fields for Project video section *****/

function PeccularProjectVideoboxIframeURLsCutomFieldHtml(){
    global $post;
    $peccularprojectvideoboxiframe = get_post_meta($post->ID, 'peccularprojectvideoboxiframe', false);
    $peccularprojectvideoboxiframeValue = !empty($peccularprojectvideoboxiframe[0])?$peccularprojectvideoboxiframe[0]:'';
   
    wp_nonce_field(plugin_basename(__FILE__), 'featured_social_media_links');
    echo '<table id="socialUrls" width="100%">';
    echo '<tr> 
        <th width="10%"><span class="dashicons dashicons-playlist-video"></span></th>
        <td width="90%"><input type="text" name="peccularprojectvideoboxiframe" width="100%" placeholder="Video Src URL" value="'.$peccularprojectvideoboxiframeValue.'" /></td>
    </tr>';
    
    echo '</table>';
}
function addpeccularprojectvideoboxiframeHook(){
    add_meta_box('project-video', __('Add youtube video href like (https://www.youtube.com/watch?v=youtube_id ) ', 'Luzuk'), 'PeccularProjectVideoboxIframeURLsCutomFieldHtml', 'our-project', 'normal', 'high');
}
function savePeccularProjectVideoboxIframeCutomData($post_id){
    if(defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
        return;
    if(empty($_POST['peccularprojectvideoboxiframe']) && empty($_POST['peccularprojectvideoboxiframe']) && empty($_POST['peccularprojectvideoboxiframe']) ){
        return;
    }
    $peccularprojectvideoboxiframe = $_POST['peccularprojectvideoboxiframe'];
    update_post_meta($post_id, 'peccularprojectvideoboxiframe', $peccularprojectvideoboxiframe);
    
}
add_action('add_meta_boxes', 'addpeccularprojectvideoboxiframeHook');
add_action('save_post', 'savePeccularProjectVideoboxIframeCutomData');

/***** End Add custome fields for Project video section *****/


/*****  Add custome fields for video section *****/

function PeccularmainVideoboxIframeURLsCutomFieldHtml(){
    global $post;
    $peccularmainvideoboxiframe = get_post_meta($post->ID, 'peccularmainvideoboxiframe', false);
    $peccularmainvideoboxiframeValue = !empty($peccularmainvideoboxiframe[0])?$peccularmainvideoboxiframe[0]:'';
   
    wp_nonce_field(plugin_basename(__FILE__), 'featured_social_media_links');
    echo '<table id="socialUrls" width="100%">';
    echo '<tr> 
        <th width="10%"><span class="dashicons dashicons-playlist-video"></span></th>
        <td width="90%"><input type="text" name="peccularmainvideoboxiframe" width="100%" placeholder="Video Src URL" value="'.$peccularmainvideoboxiframeValue.'" /></td>
    </tr>';
    
    echo '</table>';
}
function addpeccularmainvideoboxiframeHook(){
    add_meta_box('main-video', __('Add youtube video href like (https://www.youtube.com/watch?v=youtube_id ) ', 'Luzuk'), 'PeccularmainVideoboxIframeURLsCutomFieldHtml', 'our-video', 'normal', 'high');
}
function savePeccularmainVideoboxIframeCutomData($post_id){
    if(defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
        return;
    if(empty($_POST['peccularmainvideoboxiframe']) && empty($_POST['peccularmainvideoboxiframe']) && empty($_POST['peccularmainvideoboxiframe']) ){
        return;
    }
    $peccularmainvideoboxiframe = $_POST['peccularmainvideoboxiframe'];
    update_post_meta($post_id, 'peccularmainvideoboxiframe', $peccularmainvideoboxiframe);
    
}
add_action('add_meta_boxes', 'addpeccularmainvideoboxiframeHook');
add_action('save_post', 'savePeccularmainVideoboxIframeCutomData');

/***** End Add custome fields for  video section *****/



// for servies
function ServiceblockNumberCutomFieldHtml(){
    global $post;
    // get the saved value 
    $designation = get_post_meta($post->ID, 'designation', false);
    $designation = !empty($designation[0])?$designation[0]:'';

    // Use nonce for verification
    wp_nonce_field(plugin_basename(__FILE__), 'Serviceblock_social_media_links');
    echo '<table id="socialUrls" width="100%">';
    echo '<tr> 
    <th width="10%"><span class="dashicons dashicons-admin-settings"></span></th>
    <td width="90%"><input type="text" name="designation" width="100%" placeholder="Url Here" value="'.$designation.'" /></td>
    </tr>';
    echo '</table>';
}

function addServiceblockHook(){
    add_meta_box('tm_services_designation', __('Add Custom Url Here', 'lz-fitness-premium'), 'ServiceblockNumberCutomFieldHtml', 'our-logo', 'normal', 'high');
}
function savegServiceblockSocialCutomData($post_id){
    // If it is our form has not been submitted, so we dont want to do anything
    if(defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
        return;
    $designation = !empty($_POST['designation'])?$_POST['designation']:'';
    update_post_meta($post_id, 'designation', $designation);
}
add_action('add_meta_boxes', 'addServiceblockHook');
add_action('save_post', 'savegServiceblockSocialCutomData');

/**
 * Method to save the custom field for the testimonial posts 
 * When the post is saved, saves our custom data 
 * @param integer $post_id - An id of the post 
 * @author peccular <support@peccular.com>
 * @since V 1.1  09th jan 2022
 **/
function getFonts($list = false, $index = -1){
    $fonts = array(
        "'Archivo Narrow', sans-serif",
        "'Archivo Black', sans-serif",
        "'Arial', sans-serif",
        "'Arimo', sans-serif",
        "'Allerta', sans-serif",
        "'Alex Brush', cursive",
        "'Berkshire Swash', cursive",
        "'Bitter', serif",
        "'Carter One', cursive",
        "'Comfortaa', cursive",
        "'Dancing Script', cursive",
        "'Dosis', sans-serif",
        "'Droid Serif', serif",
        "'Francois One', sans-serif",
        "'Germania One', cursive",
        "'Hammersmith One', sans-serif",
        "'Indie Flower', cursive",
        "'Lobster', cursive",
        "'Lato', sans-serif",
        "'Merriweather', serif",
        "'Muli', sans-serif",
        "'Nosifer', cursive",
        "'Oswald', sans-serif",
        "'PT Sans Caption', sans-serif",
        "'PT Sans Narrow', sans-serif",
        "'PT Sans', sans-serif",
        "'Pacifico', cursive",
        "'Poppins', sans-serif",
        "'Open Sans', sans-serif",
        "'Montserrat', sans-serif",
        "'Prata', serif",
        "'Questrial', sans-serif",
        "'Raleway', sans-serif",
        "'Roboto Mono', monospace",
        "'Roboto Slab', serif",
        "'Roboto', sans-serif",
        "'Rubik', sans-serif",
        "'Source Serif Pro', serif",
        "'Titillium Web', sans-serif",
        "'Biryani', sans-serif", 
        "'Montserrat Alternates', sans-serif",
        "'Work Sans', sans-serif",
        "'Arvo', serif",
        "'Passion One', cursive",
        "'Schoolbell', cursive",
        "'DM Serif Display', serif"
        
    );
    if($list == true){
        foreach ($fonts as $key => $value) {
            $fonts[$key] = str_replace("'", "", $value);
        }
        asort($fonts);
        return $fonts;
    }
    $len = count($fonts);
    if(is_integer($index) && $index >= 0 && $index < $len){
        return $fonts[$index];
    }else{
        return $fonts;
    }
}

// dropdown animation
function getAnimations($list = false, $index = -1){
    $animations = array(
        "zoomIn .1s ease-in-out",
        "bounceInUp .5s ease-in-out",
        "fadeInUp .3s ease-in-out",
    );
    if($list == true){
        foreach ($animations as $key => $value) {
            $animations[$key] = str_replace("'", "", $value);
        }
        asort($animations);
        return $animations;
    }
    $len = count($animations);
    if(is_integer($index) && $index >= 0 && $index < $len){
        return $animations[$index];
    }else{
        return $animations;
    }
}

// menu font case
function getfontcase($list = false, $index = -1){
    $fontcase = array(
        "none",
        "uppercase",
        "lowercase",
        "capitalize",
    );
    if($list == true){
        foreach ($fontcase as $key => $value) {
            $fontcase[$key] = str_replace("'", "", $value);
        }
        asort($fontcase);
        return $fontcase;
    }
    $len = count($fontcase);
    if(is_integer($index) && $index >= 0 && $index < $len){
        return $fontcase[$index];
    }else{
        return $fontcase;
    }
}

//Blog layout
function getBlogLayout($list = false, $index = -1){
    $bloglayout = array(
        'No Sidebar',
        'Left Sidebar',
        'Right Sidebar'
    );
    if($list == true){
        foreach ($bloglayout as $key => $value) {
            $bloglayout[$key] = str_replace("'", "", $value);
        }
        asort($bloglayout);
        return $bloglayout;
    }
    $len = count($bloglayout);
    if(is_integer($index) && $index >= 0 && $index < $len){
        return $bloglayout[$index];
    }else{
        return $bloglayout;
    }
}


//banner layout
function getBannerLayout($list = false, $index = -1){
    $bannerlayout = array(
        'Show 2 Banners',
        'Show 3 Banners',
        'Show 4 Banners'
    );
    if($list == true){
        foreach ($bannerlayout as $key => $value) {
            $bannerlayout[$key] = str_replace("'", "", $value);
        }
        asort($bannerlayout);
        return $bannerlayout;
    }
    $len = count($bannerlayout);
    if(is_integer($index) && $index >= 0 && $index < $len){
        return $bannerlayout[$index];
    }else{
        return $bannerlayout;
    }
}

//category layout
function getCategoryLayout($list = false, $index = -1){
    $categorylayout = array(
        'Show 3 Category',
        'Show 4 Category',
        'Show 2 Category'
    );
    if($list == true){
        foreach ($categorylayout as $key => $value) {
            $categorylayout[$key] = str_replace("'", "", $value);
        }
        asort($categorylayout);
        return $categorylayout;
    }
    $len = count($categorylayout);
    if(is_integer($index) && $index >= 0 && $index < $len){
        return $categorylayout[$index];
    }else{
        return $categorylayout;
    }
}

//
//banner layout
function getBanner2Layout($list = false, $index = -1){
    $banner2layout = array(
        'Show 3 Banners',
        'Show 4 Banners',
        'Show 2 Banners'
    );
    if($list == true){
        foreach ($banner2layout as $key => $value) {
            $banner2layout[$key] = str_replace("'", "", $value);
        }
        asort($banner2layout);
        return $banner2layout;
    }
    $len = count($banner2layout);
    if(is_integer($index) && $index >= 0 && $index < $len){
        return $banner2layout[$index];
    }else{
        return $banner2layout;
    }
}


//Single post Blog layout
function getBlogSPostLayout($list = false, $index = -1){
    $blogspostlayout = array(
        'Right Sidebar',
        'No Sidebar',
        'Left Sidebar'
    );
    if($list == true){
        foreach ($blogspostlayout as $key => $value) {
            $blogspostlayout[$key] = str_replace("'", "", $value);
        }
        asort($blogspostlayout);
        return $blogspostlayout;
    }
    $len = count($blogspostlayout);
    if(is_integer($index) && $index >= 0 && $index < $len){
        return $blogspostlayout[$index];
    }else{
        return $blogspostlayout;
    }
}

// //Testimonial Inner page layout
// function getTestimonialInnerLayout($list = false, $index = -1){
//     $testimoniallayout = array(
//         'No Sidebar',
//         'Left Sidebar',
//         'Right Sidebar'
//     );
//     if($list == true){
//         foreach ($testimoniallayout as $key => $value) {
//             $testimoniallayout[$key] = str_replace("'", "", $value);
//         }
//         asort($testimoniallayout);
//         return $testimoniallayout;
//     }
//     $len = count($testimoniallayout);
//     if(is_integer($index) && $index >= 0 && $index < $len){
//         return $testimoniallayout[$index];
//     }else{
//         return $testimoniallayout;
//     }
// }

//Page layout
function getPageLayout($list = false, $index = -1){
    $pagelayout = array(
        'No Sidebar',
        'Left Sidebar',
        'Right Sidebar'
    );
    if($list == true){
        foreach ($pagelayout as $key => $value) {
            $pagelayout[$key] = str_replace("'", "", $value);
        }
        asort($pagelayout);
        return $pagelayout;
    }
    $len = count($pagelayout);
    if(is_integer($index) && $index >= 0 && $index < $len){
        return $pagelayout[$index];
    }else{
        return $pagelayout;
    }
}


//Shop page layout
function getShopPageLayout($list = false, $index = -1){
    $shoppagelayout = array(
        'Left Sidebar',
        'No Sidebar',       
        'Right Sidebar'
        
    );
    if($list == true){
        foreach ($shoppagelayout as $key => $value) {
            $shoppagelayout[$key] = str_replace("'", "", $value);
        }
        asort($shoppagelayout);
        return $shoppagelayout;
    }
    $len = count($shoppagelayout);
    if(is_integer($index) && $index >= 0 && $index < $len){
        return $shoppagelayout[$index];
    }else{
        return $shoppagelayout;
    }
}

/**
 * show the pagination for the custome or normal post types
 * @param object $customeQuery - An onject of a query post
 * @author peccular <support@peccular.com>
 * @since V 1.1  09th jan 2022
 **/
function lzGetPagination($customQuery){
    if(!is_object($customQuery)){return false;}
    $total_pages = $customQuery->max_num_pages;
    $big = 999999999;
    $current_page = max(1, get_query_var('paged'));
    echo paginate_links(array(
        'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
        'format' => '?paged=%#%',
        'current' => $current_page,
        'total' => $total_pages,    
    ));
}


if ( class_exists( 'WP_Customize_Panel' ) ) {

  class peccular_WP_Customize_Panel extends WP_Customize_Panel {

    public $panel;

    public $type = 'peccular_panel';

    public function json() {

      $array = wp_array_slice_assoc( (array) $this, array( 'id', 'description', 'priority', 'type', 'panel', ) );
      $array['title'] = html_entity_decode( $this->title, ENT_QUOTES, get_bloginfo( 'charset' ) );
      $array['content'] = $this->get_content();
      $array['active'] = $this->active();
      $array['instanceNumber'] = $this->instance_number;

      return $array;

    }

  }

}

if ( class_exists( 'WP_Customize_Section' ) ) {

  class peccular_WP_Customize_Section extends WP_Customize_Section {

    public $section;

    public $type = 'peccular_section';

    public function json() {

      $array = wp_array_slice_assoc( (array) $this, array( 'id', 'description', 'priority', 'panel', 'type', 'description_hidden', 'section', ) );
      $array['title'] = html_entity_decode( $this->title, ENT_QUOTES, get_bloginfo( 'charset' ) );
      $array['content'] = $this->get_content();
      $array['active'] = $this->active();
      $array['instanceNumber'] = $this->instance_number;

      if ( $this->panel ) {

        $array['customizeAction'] = sprintf( 'Customizing &#9656; %s', esc_html( $this->manager->get_panel( $this->panel )->title ) );

      } else {

        $array['customizeAction'] = 'Customizing';

      }

      return $array;

    }

  }

}
// for overlay opacity
function peccular_customize_opacity_range() {
return apply_filters(
'peccular_customize_opacity_range',
array(
'min' => 0,
'max' => 100,
'step' => 5,
)
);
}

function peccular_customize_preview_init() {
    $theme_version = wp_get_theme()->get( 'Version' );

    wp_add_inline_script(
        'peccular-customize-preview',
        sprintf(
            'wp.customize.selectiveRefresh.partialConstructor[ %1$s ].prototype.attrs = %2$s;',
            wp_json_encode( 'cover_opacity' ),
            wp_json_encode( peccular_customize_opacity_range() )
        )
    );
}
add_action( 'customize_preview_init', 'peccular_customize_preview_init' );

// Redirects to checkout 
add_filter ('woocommerce_add_to_cart_redirect', 'redirect_user_to_checkout');

function redirect_user_to_checkout() {
  // global $woocommerce;
  // $checkout_url = wc_get_cart_url();
  // return $checkout_url;
}

// code for shop & single products page ratings also copy rating css from style.css

add_action('woocommerce_after_shop_loop_item_title', 'woocommerce_template_single_content', 5);
function woocommerce_template_single_content() {

    // The "echo '</a>';" line below MAY BE needed to close the anchor tag (link/href) added for product images
    // That way, we can use a different (custom) link for our star ratings and star rating text
    // Comment this out if it is not applicable in your case.
  echo '</a>';

  global $product;
  $rating = $product->get_average_rating();
  if ( $rating > 0 ) {
    $title = sprintf(__( 'Rated %s out of 5:', 'woocommerce' ), $rating);
  } else {
    $title = 'Rate this product:';
    $rating = 0;
  }
  $rating_html  = '</a><a href="' . get_the_permalink() . '#respond"><div class="star-rating ehi-star-rating"><span style="width:' . (( $rating / 5 ) * 100) . '%"></span></div><span style="font-size: 0.857em;"><em><strong>' . $title . '</strong></em></span></a>';
  echo $rating_html;

    // Now we display the product short description. This is optional.
    //wc_get_template('single-product/short-description.php'); 
}


// for excerpt height
function peccular_customize_excerpt_length_range() {
return apply_filters(
'peccular_customize_excerpt_length_range',
array(
'min' => 0,
'max' => 100,
'step' => 5,
)
);
}

function peccular_customize_excerpt_length_init() {
    $theme_version = wp_get_theme()->get( 'Version' );

  
    wp_add_inline_script(
        'peccular-customize-preview',
        sprintf(
            'wp.customize.selectiveRefresh.partialConstructor[ %1$s ].prototype.attrs = %2$s;',
            wp_json_encode( 'excerpt_length' ),
            wp_json_encode( peccular_customize_excerpt_length_range() )
        )
    );
}

add_action( 'customize_excerpt_length_init', 'peccular_customize_excerpt_length_init' );

// for featured image height
function peccular_customize_featured_height_range() {
return apply_filters(
'peccular_customize_featured_height_range',
array(
'min' => 100,
'max' => 500,
'step' => 5,
)
);
}

function peccular_customize_featured_height_init() {
    $theme_version = wp_get_theme()->get( 'Version' );

  
    wp_add_inline_script(
        'peccular-customize-preview',
        sprintf(
            'wp.customize.selectiveRefresh.partialConstructor[ %1$s ].prototype.attrs = %2$s;',
            wp_json_encode( 'featured_img_height' ),
            wp_json_encode( peccular_customize_featured_height_range() )
        )
    );
}

add_action( 'customize_preview_featured_height_init', 'peccular_customize_featured_height_init' );

require get_parent_theme_file_path( '/inc/tab-control.php' );

// sanitize
function peccular_sanitize_choices( $input, $setting ) {
    global $wp_customize; 
    $control = $wp_customize->get_control( $setting->id ); 
    if ( array_key_exists( $input, $control->choices ) ) {
        return $input;
    } else {
        return $setting->default;
    }
}

function peccular_sanitize_checkbox( $input ) {
    return ( ( isset( $input ) && true == $input ) ? true : false );
}

function peccular_sanitize_phone_number( $phone ) {
    return preg_replace( '/[^\d+]/', '', $phone );
}

function peccular_sanitize_float( $input ) {
    return filter_var($input, FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);
}


function peccular_switch_sanitization( $input ) {
    if ( true === $input ) {
        return 1;
    } else {
        return 0;
    }
}


// Integer sanitization
if ( ! function_exists( 'peccular_sanitize_integer' ) ) {
    function peccular_sanitize_integer( $input ) {
        return (int) $input;
    }
}

/* Excerpt Limit Begin */
function peccular_string_limit_words($string, $word_limit) {
    $words = explode(' ', $string, ($word_limit + 1));
    if(count($words) > $word_limit)
    array_pop($words);
    return implode(' ', $words);
}

// Change number or products per row to 3
add_filter('loop_shop_columns', 'peccular_loop_columns');
    if (!function_exists('peccular_loop_columns')) {
        function peccular_loop_columns() {
    return 3; // 3 products per row
    }
}


function peccular_sanitize_dropdown_pages( $page_id, $setting ) {
    // Ensure $input is an absolute integer.
    $page_id = absint( $page_id );
    // If $page_id is an ID of a published page, return it; otherwise, return the default.
    return ( 'publish' == get_post_status( $page_id ) ? $page_id : $setting->default );
}

// Hide show customizer options 
function peccular_shortcode_slider_enabled(){
    if(get_theme_mod('peccular_slider_section_option', 'peccular Slider Plugin') == 'Other Shortcode' ) {
        return true;
    }
    return false;
}

function peccular_shortcode_team_enabled(){
    if(get_theme_mod('peccular_team_section_option', 'peccular Team Plugin') == 'Other Shortcode' ) {
        return true;
    }
    return false;
}
function peccular_shortcode_testimonials_enabled(){
    if(get_theme_mod('peccular_testimonials_section_option', 'peccular Testimonials Plugin') == 'Other Shortcode' ) {
        return true;
    }
    return false;
}
function peccular_service_type_posts(){
    if(get_theme_mod('peccular_service_type', 'With Posts') == 'With Posts' ) {
        return true;
    }
    return false;
}

function peccular_service_type_pages(){
    if(get_theme_mod('peccular_service_type', 'With Posts') == 'With Pages' ) {
        return true;
    }
    return false;
}

function peccular_service_bg_image_opacity(){
    if(get_theme_mod('peccular_services_bg_image') != 'color' ) {
        return true;
    }
    return false;
}

function peccular_service_type_icon(){
    if(get_theme_mod('peccular_service_head_icon_enable', 'Yes') == 'Yes' ) {
        return true;
    }
    return false;
}

function peccular_about_type_icon(){
    if(get_theme_mod('peccular_about_head_icon_enable', 'Yes') == 'Yes' ) {
        return true;
    }
    return false;
}


function peccular_features_type_icon(){
    if(get_theme_mod('peccular_features_head_icon_enable', 'Yes') == 'Yes' ) {
        return true;
    }
    return false;
}

function peccular_facility_type_icon(){
    if(get_theme_mod('peccular_facility_head_icon_enable', 'Yes') == 'Yes' ) {
        return true;
    }
    return false;
}

function peccular_steps_type_icon(){
    if(get_theme_mod('peccular_steps_head_icon_enable', 'Yes') == 'Yes' ) {
        return true;
    }
    return false;
}

function peccular_blog_type_icon(){
    if(get_theme_mod('peccular_blog_head_icon_enable', 'Yes') == 'Yes' ) {
        return true;
    }
    return false;
}

function peccular_pricing_type_icon(){
    if(get_theme_mod('peccular_pricing_head_icon_enable', 'Yes') == 'Yes' ) {
        return true;
    }
    return false;
}

function peccular_newsletter_type_icon(){
    if(get_theme_mod('peccular_newsletter_head_icon_enable', 'Yes') == 'Yes' ) {
        return true;
    }
    return false;
}

function peccular_contact_type_icon(){
    if(get_theme_mod('peccular_contact_head_icon_enable', 'Yes') == 'Yes' ) {
        return true;
    }
    return false;
}

function peccular_contactinfo_type_icon(){
    if(get_theme_mod('peccular_contactinfo_head_icon_enable', 'Yes') == 'Yes' ) {
        return true;
    }
    return false;
}
function peccular_team_type_icon(){
    if(get_theme_mod('peccular_team_head_icon_enable', 'Yes') == 'Yes' ) {
        return true;
    }
    return false;
}

function peccular_testimonials_type_icon(){
    if(get_theme_mod('peccular_testimonials_head_icon_enable', 'Yes') == 'Yes' ) {
        return true;
    }
    return false;
} 

function peccular_counter_type_icon(){
    if(get_theme_mod('peccular_counter_head_icon_enable', 'Yes') == 'Yes' ) {
        return true;
    }
    return false;
}


/**
 * Function that returns if the menu is sticky
 */
if (!function_exists('bakerystore_sticky_menu')):
    function bakerystore_sticky_menu()
    {
        $is_sticky = get_theme_mod('peccular_show_sticky_header', false);

        if ($is_sticky == false):
            return 'not-sticky';
        else:
            return 'is-sticky-on';
        endif;
    }
endif;

add_action( 'after_setup_theme', 'yourtheme_setup' );

function yourtheme_setup() {
    add_theme_support( 'wc-product-gallery-zoom' );
    add_theme_support( 'wc-product-gallery-lightbox' );
    add_theme_support( 'wc-product-gallery-slider' );
    add_theme_support( 'woocommerce' );
}


add_filter( 'woocommerce_single_product_carousel_options', 'cuswoo_update_woo_flexslider_options' );
/** 
 * Filer WooCommerce Flexslider options - Add Navigation Arrows
 */
function cuswoo_update_woo_flexslider_options( $options ) {

    $options['directionNav'] = true;

    return $options;
}

/* buy now button woocommerce code by WPcookie
 * update: https://redpishi.com/wordpress-tutorials/buy-now-button-woocommerce/
 */
add_action( 'wp_footer', function(){ if(!is_admin()) { 

// Change button color from here
$color = ""; 
    
?>
<style>
a.custom-checkout-btn {
    margin: 0px 5px!important;
}
</style>
<?php
if ( $color != "" ){
?>
<style>
a.custom-checkout-btn {
    background: <?php echo $color; ?>!important;
    transition: 0.4s filter ease; 
}
a.custom-checkout-btn:hover {
    filter: saturate(2);
}
</style>
<?php }}});

add_action( 'woocommerce_after_add_to_cart_button', 'add_custom_addtocart_and_checkout' );
function add_custom_addtocart_and_checkout() {  
    global $product;
    
    // conditional tags
    $condition = $product->is_type( 'simple' ) || $product->is_type( 'variable' );
    
    $addtocart_url = wc_get_checkout_url().'?add-to-cart='.$product->get_id();
    $button_class  = 'single_add_to_cart_button button alt custom-checkout-btn';
    
      // Change the text of the buy now button from here
    $button_text   = __("Buy now", "woocommerce");
    
    if( $product->is_type( 'simple' ) ) :       
    ?>
    <script>
    jQuery(function($) {
        var url    = '<?php echo $addtocart_url; ?>',
            qty    = 'input.qty',
            button = 'a.custom-checkout-btn';

        // On input/change quantity event
        $(qty).on('input change', function() {
            $(button).attr('href', url + '&quantity=' + $(this).val() );
        });
    });
    </script>
    <?php
    elseif( $product->is_type( 'variable' ) ) : 
    $addtocart_url = wc_get_checkout_url().'?add-to-cart=';
    ?>
    <script>
    jQuery(function($) {
        var url    = '<?php echo $addtocart_url; ?>',
            vid    = 'input[name="variation_id"]',
            pid    = 'input[name="product_id"]',
            qty    = 'input.qty',
            button = 'a.custom-checkout-btn';
        setTimeout( function(){
            if( $(vid).val() != '' ){
                $(button).attr('href', url + $(vid).val() + '&quantity=' + $(qty).val() );
            }
        }, 300 );
        $(qty).on('input change', function() {
            if( $(vid).val() != '' ){
                $(button).attr('href', url + $(vid).val() + '&quantity=' + $(this).val() );
            }
        });
        $('.variations_form').on('change blur', 'table.variations select', function() {
            if( $(vid).val() != '' ){
                $(button).attr('href', url + $(vid).val() + '&quantity=' + $(qty).val() );
            }
        });
    });
    </script>
    <?php           
    endif;
    if ($condition) {
        echo '<a href="'.$addtocart_url.'" class="'.$button_class.'">'.$button_text.'</a>';
    }   
}

// add_shortcode( 'featured_products', 'bbloomer_featured_products_shortcode' );
 
// function bbloomer_featured_products_shortcode() {
 
//    $viewed_products = ! empty( $_COOKIE['woocommerce_featured_products'] ) ? (array) explode( '|', wp_unslash( $_COOKIE['woocommerce_featured_products'] ) ) : array();
//    $viewed_products = array_slice($viewed_products, 0, 8);

 
//    if ( empty( $viewed_products ) ) return;
    
//    $title = '<h3 class="text-center product-section-title container-width product-section-title-related pt-half pb-half">Featured Products </h3>';
//    $product_ids = implode( ",", $viewed_products );
 
//    return $title . do_shortcode("[products ids='$product_ids']");
   
// }

// // adds notice at single product page above add to cart
// add_action( 'woocommerce_after_single_product', 'recviproducts', 31 );
// function recviproducts() {
//     echo do_shortcode ('[featured_products]');
// }

// // https://github.com/woocommerce/woocommerce/issues/9724#issuecomment-160618200
// function custom_track_product_view() {
//     if ( ! is_singular( 'product' ) ) {
//         return;
//     }

//     global $post;

//     if ( empty( $_COOKIE['woocommerce_featured_products'] ) )
//         $featured_products = array();
//     else
//         $featured_products = (array) explode( '|', $_COOKIE['woocommerce_featured_products'] );

//     if ( ! in_array( $post->ID, $featured_products ) ) {
//         $featured_products[] = $post->ID;
//     }

//     if ( sizeof( $featured_products ) > 15 ) {
//         array_shift( $featured_products );
//     }

//     // Store for session only
//     wc_setcookie( 'woocommerce_featured_products', implode( '|', $featured_products ) );
// }

// add_action( 'template_redirect', 'custom_track_product_view', 20 );



// add_action( 'woocommerce_after_add_to_cart_button', 'add_content_after_addtocart_button_func' );
// /*
//  * Content below "Add to cart" Button.
//  */
// function add_content_after_addtocart_button_func() {

//         // Echo content.
//         echo '<div class="second_content">Other content here!</div>';

// }
// add wishlist button after add to cart button 
//  add_action( 'woocommerce_after_add_to_cart_button', 'add_content_after_addtocart_button_func' );
// /*
//  * Content below "Add to cart" Button.
//  */
// function add_content_after_addtocart_button_func() {

//         // Echo content.
//         echo '<div class="second_content">[ti_wishlists_addtowishlist]</div>';

// }


// For woocomerce custom hook field


// Display Fields
add_action('woocommerce_product_options_general_product_data', 'woocommerce_product_custom_fields');
// Save Fields
add_action('woocommerce_process_product_meta', 'woocommerce_product_custom_fields_save');
function woocommerce_product_custom_fields()
{
    global $woocommerce, $post;
    echo '<div class="product_custom_field">';


    // //Custom Product  Textarea
    // woocommerce_wp_textarea_input(
    //     array(
    //         'id' => '_custom_product_sizedescription_field',
    //         'placeholder' => 'Description',
    //         'label' => __('Product Size Details', 'woocommerce')
    //     )
    // );

     //Custom Product  Text
    woocommerce_wp_text_input(
        array(
            'id' => '_custom_product_discount_field',
            'placeholder' => 'Discount',
            'label' => __('Product Discount', 'woocommerce')
        )
    );

     //Custom Product  Text
    woocommerce_wp_text_input(
        array(
            'id' => '_custom_product_salenew_field',
            'placeholder' => 'Sale/New',
            'label' => __('Product Sale/New', 'woocommerce')
        )
    );
 
 
   
    echo '</div>';
}




function woocommerce_product_custom_fields_save($post_id)
{

   
// Custom Product Textarea Field
    // $woocommerce_custom_procut_textarea = $_POST['_custom_product_sizedescription_field'];
    // if (!empty($woocommerce_custom_procut_textarea))
    //     update_post_meta($post_id, '_custom_product_sizedescription_field', esc_html($woocommerce_custom_procut_textarea));

    $woocommerce_custom_procut_text = $_POST['_custom_product_discount_field'];
  if( isset($woocommerce_custom_procut_text) )
        update_post_meta($post_id, '_custom_product_discount_field', esc_html($woocommerce_custom_procut_text));


     $woocommerce_custom_procut_text = $_POST['_custom_product_salenew_field'];
   if( isset($woocommerce_custom_procut_text) )
        update_post_meta($post_id, '_custom_product_salenew_field', esc_html($woocommerce_custom_procut_text));
  
  
}


//1. Show Buttons
add_action( 'woocommerce_before_add_to_cart_quantity', 'display_quantity_plus' );
function display_quantity_plus() {
   echo '<button type="button" class="plus" >+</button>';
}
add_action( 'woocommerce_after_add_to_cart_quantity', 'display_quantity_minus' );
function display_quantity_minus() {
   echo '<button type="button" class="minus" >-</button>';
}
//2. Trigger jQuery script
add_action( 'wp_footer', 'add_cart_quantity_plus_minus' );
function add_cart_quantity_plus_minus() {
   // Only run this on the single product page
   if ( ! is_product() ) return; ?>
      <script type="text/javascript">  
      jQuery(document).ready(function($){   
         $('form.cart').on( 'click', 'button.plus, button.minus', function() {
            // Get current quantity values
            var qty = $( this ).closest( 'form.cart' ).find( '.qty' );
            var val   = parseFloat(qty.val());
            var max = parseFloat(qty.attr( 'max' ));
            var min = parseFloat(qty.attr( 'min' ));
            var step = parseFloat(qty.attr( 'step' ));
            // Change the value if plus or minus
            if ( $( this ).is( '.plus' ) ) {
               if ( max && ( max <= val ) ) {
                  qty.val( max );
               } else {
                  qty.val( val + step );
               }
            } else {
               if ( min && ( min >= val ) ) {
                  qty.val( min );
               } else if ( val > 1 ) {
                  qty.val( val - step );
               }
            } 
         }); 
      });  
      </script>
   <?php
}

// move price after short description. 

add_action('woocommerce_single_product_summary', 'move_single_product_price', 1);
function move_single_product_price() {
    remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_price', 10);
    add_action('woocommerce_single_product_summary', 'woocommerce_template_single_price', 29);
}



// for set regular price after selling price 
if (!function_exists('my_commonPriceHtml')) {

    function my_commonPriceHtml($price_amt, $regular_price, $sale_price) {
        $html_price = '<p class="price">';
        //if product is in sale
        if (($price_amt == $sale_price) && ($sale_price != 0)) {
            $html_price .= '<ins>' . wc_price($sale_price) . '</ins>';
            $html_price .= '<del>' . wc_price($regular_price) . '</del>';
        }
        //in sale but free
        else if (($price_amt == $sale_price) && ($sale_price == 0)) {
            $html_price .= '<ins>Free!</ins>';
            $html_price .= '<del>' . wc_price($regular_price) . '</del>';
        }
        //not is sale
        else if (($price_amt == $regular_price) && ($regular_price != 0)) {
            $html_price .= '<ins>' . wc_price($regular_price) . '</ins>';
        }
        //for free product
        else if (($price_amt == $regular_price) && ($regular_price == 0)) {
            $html_price .= '<ins>Free!</ins>';
        }
        $html_price .= '</p>';
        return $html_price;
    }

}

add_filter('woocommerce_get_price_html', 'my_simple_product_price_html', 100, 2);

function my_simple_product_price_html($price, $product) {
    if ($product->is_type('simple')) {
        $regular_price = $product->get_regular_price();
        $sale_price = $product->get_sale_price();
        $price_amt = $product->get_price();
        return my_commonPriceHtml($price_amt, $regular_price, $sale_price);
    } else {
        return $price;
    }
}

add_filter('woocommerce_variation_sale_price_html', 'my_variable_product_price_html', 10, 2);
add_filter('woocommerce_variation_price_html', 'my_variable_product_price_html', 10, 2);

function my_variable_product_price_html($price, $variation) {
    $variation_id = $variation->variation_id;
    //creating the product object
    $variable_product = new WC_Product($variation_id);

    $regular_price = $variable_product->get_regular_price();
    $sale_price = $variable_product->get_sale_price();
    $price_amt = $variable_product->get_price();

    return my_commonPriceHtml($price_amt, $regular_price, $sale_price);
}

add_filter('woocommerce_variable_sale_price_html', 'my_variable_product_minmax_price_html', 10, 2);
add_filter('woocommerce_variable_price_html', 'my_variable_product_minmax_price_html', 10, 2);

function my_variable_product_minmax_price_html($price, $product) {
    $variation_min_price = $product->get_variation_price('min', true);
    $variation_max_price = $product->get_variation_price('max', true);
    $variation_min_regular_price = $product->get_variation_regular_price('min', true);
    $variation_max_regular_price = $product->get_variation_regular_price('max', true);

    if (($variation_min_price == $variation_min_regular_price) && ($variation_max_price == $variation_max_regular_price)) {
        $html_min_max_price = $price;
    } else {
        $html_price = '<p class="price">';
        $html_price .= '<ins>' . wc_price($variation_min_price) . '-' . wc_price($variation_max_price) . '</ins>';
        $html_price .= '<del>' . wc_price($variation_min_regular_price) . '-' . wc_price($variation_max_regular_price) . '</del>';
        $html_min_max_price = $html_price;
    }

    return $html_min_max_price;
}
?>