<?php
/**
 * Custom functions that act independently of the theme templates.
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * * @package peccular Premium
 */

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function peccular_lite_body_classes( $classes ) {
	// Adds a class of group-blog to blogs with more than 1 published author.
	if ( is_multi_author() ) {
		$classes[] = 'group-blog';
	}

	// Adds a class of hfeed to non-singular pages.
	if ( ! is_singular() ) {
		$classes[] = 'hfeed';
	}

	return $classes;
}
add_filter( 'body_class', 'peccular_lite_body_classes' );



add_action( 'admin_menu', 'peccular_register_backend' );
function peccular_register_backend() {
	add_theme_page( __('Peccular Premium', 'Peccular Premium'), __('Online Flower Shop', 'peccular Premium'), 'edit_theme_options', 'about-peccular Premium', 'peccular_backend');
}

function peccular_backend(){ ?>
<div class="theme-info-wrapper">
	<div class="theme-info-inner">
		<div class="theme-info-left">
			<div class="theme-info-left-inner">
				
				<h2>Theme issues?</h2>
				<p>
					If you are having theme related problems then please contact us through our <a href="https://www.buywpthemes.net/pages/support" target="_blank">contact form</a>
				</p>	
				<h2>Need more help?</h2>
				<ul>
					<li><a href="https://www.wpthemesdemo.com/flower-shop/" target="_blank">Online Flower Shop Pro</a></li>
				</ul>
			</div>
		</div>
		<div class="theme-info-right">
			<a href="https://www.wpthemesdemo.com/docs/flower-shop/" target="_blank" style="display:block;"> 
				<img src="<?php echo get_bloginfo('template_url')?>/images/peccular-premium.png">
			</a>
		</div>
	</div>
</div>
<?php }

