<?php
/**
 * Use for the show the team at home page and in testimonial page with shortcode
 * @param int $pageId default is null the id of a post
 * @param boolean $isCustomizer default is false if set to true it mean the output is set for the home page
 * @param int $i default null
 * @param boolean $showStaticVals default is false
 * @return string
 * @author peccular <support@peccular.com>
 * */


function servicesShortCode($pageId = null, $isCustomizer = false, $i = null) {

    ob_start();

    $args = array('post_type' => 'our-logo');
    if (!empty($pageId)) {
        $args['page_id'] = absint($pageId);
    }
    $args['posts_per_page'] = -1;
    $colCls = '';
    // if($isCustomizer == true){
    $cols = get_theme_mod('peccular_service_number',2);  
    ++$cols;
    switch ($cols) {
        case 1:
        $colCls = 'col-xl-12 col-lg-12 col-md-12 col-sm-12 col-xs-12';
        break;
        case 2: 
        $colCls = 'col-xl-6 col-lg-6 col-md-6 col-sm-6 col-xs-12';
        break;
        case 3:
        case 5:
        case 6:
        case 7:
        case 8:
        $colCls = 'col-xl-4 col-lg-4 col-md-6 col-sm-6 col-xs-12';
        break;
        case 4:
        $colCls = 'col-xl-6 col-lg-6 col-md-6 col-sm-6 col-xs-12';
        break;
        default: 
        $colCls = 'col-xl-4 col-lg-4 col-md-6 col-sm-6 col-xs-12';
        break;
    }
    // }
    $text = '';
    $query = new WP_Query($args);
    if ($query->have_posts()):
        $postN = 0;

        while ($query->have_posts()) : $query->the_post();
            $peccular_image = wp_get_attachment_image_src(get_post_thumbnail_id(), 'total-project-thumb');
            $post = get_post();
            $designation = get_post_meta($post->ID, 'designation', false);
            $tm_services_designation = !empty($designation[0]) ? $designation[0] : '';

            ?>
            <?php
            $peccular_service_page_icon_left = get_theme_mod('peccular_service_page_icon_left'.$i);
            ?>
            <div class="item"> 
                <div class="logo-bx <?php echo esc_attr(get_theme_mod('peccular_service_box_onload_effects','wow zoomIn')); ?>">
                    <a href="<?php echo esc_url($tm_services_designation) ?>">  
                     <img class="img-responsive" src="<?php echo (!empty($peccular_image[0])) ? $peccular_image[0] : get_template_directory_uri() . '/serviceimg.jpg' ?>" class="img-responsive" alt="<?php the_title(); ?>" alt=""/>  
                 </a>
             </div>                  
         </div>
         <?php
     endwhile;
     $text = ob_get_contents();
     ob_clean();
 endif;
 wp_reset_postdata();
 return $text;
}

function servicesInnerpgeShortCode($pageId = null, $isCustomizer = false, $i = null) {

    ob_start();

    $args = array('post_type' => 'our-services');
    if (!empty($pageId)) {
        $args['page_id'] = absint($pageId);
    }
    $args['posts_per_page'] = -1;
    $colCls = '';
    // if($isCustomizer == true){
    $cols = get_theme_mod('peccular_service_number',2);  
    ++$cols;
    switch ($cols) {
        case 1:
        $colCls = 'col-md-12 col-sm-12 col-xs-12';
        break;
        case 2: 
        $colCls = 'col-md-6 col-sm-6 col-xs-12';
        break;
        case 3:
        case 5:
        case 6:
        case 9:
        case 11:
        case 13:
        case 15:
        case 17:
        case 19:
        case 21:
        case 23:
        $colCls = 'col-lg-4 col-md-6 col-sm-6 col-xs-12';
        break;
        default: 
        $colCls = 'col-lg-3 col-md-6 col-sm-6 col-xs-12';
        break;
    }
    // }
    $text = '';
    $query = new WP_Query($args);
    if ($query->have_posts()):
        $postN = 0;
        ?> 
        <div class="row md-1">
            <?php

            while ($query->have_posts()) : $query->the_post();
                $peccular_image = wp_get_attachment_image_src(get_post_thumbnail_id(), 'total-project-thumb');

                if ($isCustomizer === true) {
                    $service_area_designation = get_theme_mod('service_area_designation' . $i);
                } else {
                    $service_area_designation = '';
                }


                $post = get_post();

                    //designation
                $designation = get_post_meta($post->ID, 'designation', false);
                $service_area_designation = !empty($designation[0]) ? $designation[0] : '';

                ?>
                <!-- <//?php
                 $peccular_service_page_icon_ = get_theme_mod('peccular_service_page_icon_'.$i);
             ?> -->
             <div class="<?php echo $colCls;?> pd-0">
                <div  service-match-height="groupName" class="peccular-service-box <?php echo esc_attr(get_theme_mod('peccular_service_box_onload_effects','wow zoomIn')); ?>" data-wow-duration="2s">  

                    <div class="peccular-service-image">
                       <?php
                       if (has_post_thumbnail()) {
                        $image_url = $peccular_image[0];
                    } else {
                        $image_url = get_template_directory_uri() . '/images/project3.png';
                    }
                    ?> 
                    <?php
                    if(get_theme_mod('service_featured_img_on_off') != 'on' ){
                      ?>  
                      <a href="<?php the_permalink(); ?>">
                       <img class="peccular-service-img" src="<?php echo esc_url($image_url); ?>" alt="service" style="height: <?php echo esc_attr(get_theme_mod('peccular_serviceinnerpage_post_image_height','290')) ?>px;" />
                   </a>
               <?php } ?>


           </div>       
           <div class="peccular-service-content" style="text-align: <?php if(get_theme_mod('peccular_services_page_content_align','Center') == 'Center'){ ?> center <?php } elseif(get_theme_mod('peccular_services_page_content_align','Left') == 'Left'){ ?> left <?php } elseif(get_theme_mod('peccular_services_page_content_align','Right') == 'Right'){ ?> right <?php } ?> ">   
            <div class="peccular_services_overlay"></div> 

            <h4><a href="<?php the_permalink(); ?>" style="text-transform : <?php if(get_theme_mod('peccular_service_page_title_case','capitalize') == 'capitalize'){ ?> capitalize <?php } elseif(get_theme_mod('peccular_service_page_title_case','Lowercase') == 'Lowercase'){ ?> lowercase <?php } elseif(get_theme_mod('peccular_service_page_title_case','Uppercase') == 'Uppercase'){ ?> uppercase <?php } ?> "><?php the_title(); ?></a>
            </h4>  
            <p><?php $peccular_excerpt = get_the_excerpt(); echo esc_html( peccular_string_limit_words( $peccular_excerpt, esc_attr(get_theme_mod('peccular_services_post_excerpt','8')) ) ); ?>

        </p> 


        <?php
        $peccular_servicebutton = get_theme_mod('peccular_services_btn_txt', 'Read More'); 
        ?>
        <?php if( get_theme_mod('peccular_erviceinn_button_enable',true) == true){ ?>
            <a href="<?php the_permalink(); ?>" target="_blank" class="btn btn-lg"> <?php echo ($peccular_servicebutton );  ?>
        </a>

    <?php }?>


    <div class="clearfix"></div>
</div> 
<div class="clearfix"></div> 



<div class="clearfix"></div>


</div>                            

<script>
    var matchHeight = function () {

        function init() {
            eventListeners();
            matchHeight();
        }

        function eventListeners(){
            $(window).on('resize', function() {
                matchHeight();
            });
        }

        function matchHeight(){
            var groupName = $('[service-match-height]');
            var groupHeights = [];

            groupName.css('min-height', 'auto');

            groupName.each(function() {
                groupHeights.push($(this).outerHeight());
            });

            var maxHeight = Math.max.apply(null, groupHeights);
            groupName.css('min-height', maxHeight);
        };

        return {
            init: init
        };

    } ();

    $(document).ready(function() {
        matchHeight.init();
    });
</script>

</div>
<?php
endwhile;
?>
<div class="clearfix"></div>
</div> 
<?php
$text = ob_get_contents();
ob_clean();
endif;
wp_reset_postdata();
return $text;
}

    /**
     * Use for the show the pricing at home page and in pricing page with shortcode
     * @param int $pageId default is null the id of a post
     * @param boolean $isCustomizer default is false if set to true it mean the output is set for the home page
     * @param int $i default null
     * @param boolean $showStaticVals default is false
     * @return void
     * @author peccular <support@peccular.com>
     * */
    function pricingShortcode() {
      ob_start();
      $cols = get_theme_mod('peccular_pricing_npp_count', 2);
      $cols++;
      switch ($cols) {
        case 1:
        $colCls = 'col-lg-12 col-md-12 col-sm-12 col-xs-12';
        break;
        case 2: 
        $colCls = 'col-lg-6 col-md-6 col-sm-6 col-xs-12';
        break;
        case 3:
        case 5:
        case 6:
        case 9:
        case 11:
        case 13:
        case 15:
        $colCls = 'col-lg-4 col-md-6 col-sm-6 col-xs-12';
        break;
        default: 
        $colCls = 'col-lg-4 col-md-6 col-sm-6 col-xs-12';
        break;
    }

    $showStatic = true;
    for ($i = 1; $i <= $cols; $i++) {
        $peccular_PlanPageId = get_theme_mod('peccular_pricing_plan_page_' . $i);
        $peccular_pricing_page_icon = get_theme_mod('peccular_pricing_plan_page_icon_'.$i);
        $peccular_planTitle  = get_theme_mod('peccular_pricing_plan_name_' . $i, 'Basic Package');
        $peccular_planunit  = get_theme_mod('peccular_pricing_plan_unit_' . $i,'$');
        $peccular_planPrice  = get_theme_mod('peccular_pricing_plan_price_' . $i,'49.00');
        $peccular_planValid  = get_theme_mod('peccular_pricing_plan_valid_' . $i,'MONTH');
        $peccular_planContent= get_theme_mod('peccular_pricing_plan_content_' . $i, '
            <li><i class="fa fa-check" aria-hidden="true"></i> 1 Hour Session</li>
            <li><i class="fa fa-check" aria-hidden="true"></i> 10 Digital Images</li>
            <li><i class="fa fa-check" aria-hidden="true"></i> Online Gallery</li>
            <li><i class="fa fa-check" aria-hidden="true"></i>1 Photographer</li>');

        

        $link = get_theme_mod('peccular_pricing_plan_url'.$i);
        $peccular_url = get_theme_mod('peccular_pricing_plan_url_'.$i, '#');

        if ($peccular_PlanPageId || $peccular_planTitle || $peccular_planunit || $peccular_planPrice || $peccular_planValid || $peccular_planContent || $peccular_url ) {
          $showStatic = false;
          ?> 
          <div class="<?php echo $colCls; ?> pd-0 peccular-pricing-border  <?php echo esc_attr(get_theme_mod('peccular_pricing_box_onload_effects','wow zoomIn')); ?>">

            <div class="peccular-pricing-single" data-wow-duration="1s" style="text-align : <?php if(get_theme_mod('peccular_pricing_box_align','Left') == 'Left'){ ?> left <?php } elseif(get_theme_mod('peccular_pricing_box_align','Center') == 'Center'){ ?> center <?php } elseif(get_theme_mod('peccular_pricing_box_align','Right') == 'Right'){ ?> right <?php } ?> ">
               <div class="pricing-overlay-bg"></div>
               <div class="peccular-pricing-box-head">
                <h4 class="peccular-pricing-title" href="#" style="text-transform : <?php if(get_theme_mod('peccular_pricing_title_case','Capitalize') == 'Capitalize'){ ?> capitalize <?php } elseif(get_theme_mod('peccular_pricing_title_case','Lowercase') == 'Lowercase'){ ?> lowercase <?php } elseif(get_theme_mod('peccular_pricing_title_case','Uppercase') == 'Uppercase'){ ?> uppercase<?php } ?>">
                    <?php echo ($peccular_planTitle); ?>
                </h4>
                
            </div>

            <div class="peccular-pricing-currency-price"><span><?php echo ($peccular_planunit); ?></span><?php echo ($peccular_planPrice); ?><sub>/<?php echo ($peccular_planValid); ?></sub></div>
            <ul class="peccular-pricing-list"> <?php echo ($peccular_planContent); ?></ul>
            
            <?php
            $peccular_pricing_page_id = get_theme_mod('peccular_pricing_page'); 
            $peccular_planbtn  = get_theme_mod('peccular_pricing_plan_btn_' . $i,'PURCHASE NOW');          
            ?>
            <div class="peccular-pricing-btn">    
                <a class="btn" href="<?php echo esc_url(!empty($peccular_url)?$peccular_url:'#');?>">
                 <?php echo ($peccular_planbtn); ?>
             </a>
         </div>
         <!--  <div class="clearfix"></div> -->
     </div>
 </div>
 <?php
}
}
if ($showStatic === true) {
  for ($i = 1; $i <= $cols; $i++) {
    $link = get_theme_mod('pricing_plan_url'.$i);
    $url = get_theme_mod('pricing_plan_url_'.$i, '#');

    ?>
    <div class="<?php echo $colCls; ?> plan">
      <div class="pricing-plans">

        <div class="price-box">
          <div class="price-bx">

            <div class="plan-cost">$30</div>
        </div>
        <div class="clearfix"></div>
        <h4 class="plan-title">STANDARD</h4>
        <div class="table-content">
            Excepteur sint occaecat cupidatat non proi dent sunt in culpa.
        </div>
        <div class="clearfix"></div>
        <div class="pri-table-link">
          <a class="btn" href="#">DETAILS</a>
      </div>
  </div>
  <!-- <div class="clearfix"></div> -->
</div>
</div>
<?php
}

}

$pricingHtml = ob_get_contents();
        // echo $pricingHtml;
ob_flush();
ob_clean();
}

add_shortcode('SERVICES', 'servicesInnerpgeShortCode');
