<?php 
// /HEADER SETTINGS IN CUSTOMIZER
$lvl1ParentPanel = new peccular_WP_Customize_Panel( $wp_customize, 'peccular_header_panel1', array(
    'title' => 'General Settings',
    'priority' => 1,
));

$wp_customize->add_panel( $lvl1ParentPanel );

$lvl2ParentPanel = new peccular_WP_Customize_Panel( $wp_customize, 'peccular_header_panel2', array(
    'title' => 'Header',
    'panel' => 'peccular_header_panel1',
    'priority' => 1,
));  

$wp_customize->add_panel( $lvl2ParentPanel );

  // Add example section and controls to the final (third) panel
$wp_customize->add_section( 'peccular_section', array(
    'title' => 'Section Test',
    'panel' => 'peccular_header_panel2',
));

//Bottom Header
$wp_customize->add_section( 'peccular_header_section' , array(
    'title'    => __( 'All Settings', 'peccular-premium' ),
    'priority' => null,
    'panel' => 'peccular_header_panel2'
) );

$wp_customize->add_setting('peccular_allsetting_nav', array(
 'sanitize_callback' => 'wp_kses_post',
));

$wp_customize->add_control(new peccular_Tab_Control($wp_customize, 'peccular_allsetting_nav', array(
 'section' => 'peccular_header_section',
 'priority' => 1,
 'buttons' => array(
  array(
   'name' => esc_html__('General', 'peccular-premium'),
   'icon' => 'dashicons dashicons-welcome-write-blog',
   'fields' => array(
    'peccular_show_sticky_header',
    'peccular_header_style',
    'peccular_header_width',
    'mailbox',
    'phoneTaglineNumber',
    'ip_header_facebook',
    'ip_header_twitter',
    'ip_header_instagram',
    'peccular_headerslider_section_lbl',
    'Peccular_header_myaccount'     
),
   'active' => true,
),
  array(
    'name' => esc_html__('Style', 'peccular-premium'),
    'icon' => 'dashicons dashicons-art',
    'fields' => array(  
        'peccular_header_section_bg_color',
        'peccular_header_section_bg_image',
        'peccular_header_image_opacity',
        'header_searchtexticonColor',
        'header_searchformbgColor',
        'header_searchbgColor',
        'header_searchborderColor',
        'header_stickybgColor',
        'header_bgColor',
        'header_topbgColor',
        'header_SiteTitleColor',
        'header_CartIconColor',
        'header_CartIconhoverColor',
        'header_bgColorone',
        'header_PhoneemailIconColor',
        'header_PhoneemailTextColor',
        'header_headsocialsColor',
        'header_SiteTaglineColor'  
    ),
)
),
)));

$wp_customize->add_setting( 'peccular_show_sticky_header',array(
    'default' => false,
    'sanitize_callback' => 'peccular_switch_sanitization'
) );
$wp_customize->add_control( new peccular_Toggle_Switch_Custom_Control( $wp_customize, 'peccular_show_sticky_header',array(
    'label' => __( 'Show Sticky Header','peccular' ),
    'section' => 'peccular_header_section'
)));


$wp_customize->add_setting('peccular_header_style',array(
    'default' => 'Above Slider',
    'sanitize_callback' => 'peccular_sanitize_choices',
));
$wp_customize->add_control('peccular_header_style',array(
    'type' => 'select',
    'label' => __('Header Style','peccular'),
    'choices' => array (
        'Above Slider' => __('Above Slider','peccular'),
        'On Slider' => __('On Slider','peccular')
    ),
    'section' => 'peccular_header_section',
));

// $wp_customize->add_setting('peccular_header_width',array(
//     'default' => 'Box Width',
//     'sanitize_callback' => 'peccular_sanitize_choices',
// ));
// $wp_customize->add_control('peccular_header_width',array(
//     'type' => 'select',
//     'label' => __('Section Width','peccular'),
//     'choices' => array (
//         'Box Width' => __('Box Width','peccular'),
//         'Full Width' => __('Full Width','peccular')
//     ),
//     'section' => 'peccular_header_section',
// ));



$wp_customize->add_setting('Peccular_header_myaccount',  array('default'=> 'add myaccount page link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('Peccular_header_myaccount',
    array(
        'settings'      => 'Peccular_header_myaccount',
        'section'       => 'peccular_header_section',
        'type'          => 'url',
        'label'         => __( 'Add Woocommerce Account Page Url Here', 'ClassicTemplate' )
    )
); 

$wp_customize->add_setting( 'peccular_header_section_bg_color', array(
   'default' => '',
   'sanitize_callback' => 'sanitize_hex_color'
));
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'peccular_header_section_bg_color', array(
    'label' => __('Background Color','peccular'),
    'section' => 'peccular_header_section',
)));

$wp_customize->add_setting( 'peccular_header_section_bg_image', array(
   'default' => '',
   'sanitize_callback' => 'esc_url_raw'
));
$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'peccular_header_section_bg_image', array(
    'label' => __('Background Image','peccular'),
    'section' => 'peccular_header_section',
)));

$wp_customize->add_setting('peccular_header_image_opacity',array(
    'default' => 0.5,
    'sanitize_callback' => 'peccular_sanitize_float'
));
$wp_customize->add_control(new peccular_Custom_Control( $wp_customize, 'peccular_header_image_opacity',array(
    'label' => __('Header Image Opacity','peccular'),
    'section' => 'peccular_header_section',
    'input_attrs' => array(
        'min' => 0,
        'max' => 1,
        'step' => 0.1,
    ),
)));

addColorPalatOption($wp_customize, 'header_searchtexticonColor', 'peccular_header_section', 'Search Text Color', '');
addColorPalatOption($wp_customize, 'header_searchformbgColor', 'peccular_header_section', 'Search Form BG Color', '');
addColorPalatOption($wp_customize, 'header_searchbgColor', 'peccular_header_section', 'Search BG Color', '');
addColorPalatOption($wp_customize, 'header_searchborderColor', 'peccular_header_section', 'Search Border Color', '');

addColorPalatOption($wp_customize, 'header_stickybgColor', 'peccular_header_section', 'Sticky Header BG Color', '');

addColorPalatOption($wp_customize, 'header_topbgColor', 'peccular_header_section', 'Top Bar BG Color', '');

addColorPalatOption($wp_customize, 'header_SiteTitleColor', 'peccular_header_section', 'Site Title Color', '');
addColorPalatOption($wp_customize, 'header_SiteTaglineColor', 'peccular_header_section', 'Tagline Color', '');

addColorPalatOption($wp_customize, 'header_CartIconColor', 'peccular_header_section', 'Cart & Account Icon Color', '');
addColorPalatOption($wp_customize, 'header_CartIconhoverColor', 'peccular_header_section', 'Cart & Account Icon Hover Color', '');
?>