<?php 
$wp_customize->add_section( 'title_tagline', array(
    'title' => __( 'Logo Settings', 'peccular Premium' ),
     'priority' => null,
    'panel' => 'peccular_header_panel2',
) );

$wp_customize->add_setting('peccular_logosetting_nav', array(
       'sanitize_callback' => 'wp_kses_post',
    ));

    $wp_customize->add_control(new peccular_Tab_Control($wp_customize, 'peccular_logosetting_nav', array(
       'section' => 'title_tagline',
       'priority' => 1,
       'buttons' => array(
          array(
             'name' => esc_html__('General', 'peccular-premium'),
            'icon' => 'dashicons dashicons-welcome-write-blog',
            'fields' => array(
                'custom_logo',
                'blogname',
                'blogdescription',
                'site_icon',
                'peccular_show_site_title',
               'peccular_show_tagline'               
            ),
            'active' => true,
         ),
          array(
            'name' => esc_html__('Layout', 'peccular-premium'),
            'icon' => 'dashicons dashicons-art',
            'fields' => array(
                'peccular_logo_size',
               'peccular_logo_height',
               'peccular_logo_margin',
               'peccular_logo_top_margin',
               'peccular_logo_bottom_margin',
               'peccular_logo_left_margin',
               'peccular_logo_right_margin'
            ),
         )
        ),
    )));

    $wp_customize->add_setting( 'peccular_show_site_title',array(
        'default' => true,
        'sanitize_callback' => 'peccular_switch_sanitization'
   ) );
   $wp_customize->add_control( new peccular_Toggle_Switch_Custom_Control( $wp_customize, 'peccular_show_site_title',array(
        'label' => __( 'Site Title','peccular' ),
        'section' => 'title_tagline'
   )));

    $wp_customize->add_setting( 'peccular_show_tagline',array(
        'default' => false,
        'sanitize_callback' => 'peccular_switch_sanitization'
   ) );
   $wp_customize->add_control( new peccular_Toggle_Switch_Custom_Control( $wp_customize, 'peccular_show_tagline',array(
        'label' => __( 'Site Tagline','peccular' ),
        'section' => 'title_tagline'
   )));

    $wp_customize->add_setting('peccular_logo_size',array(
        'default' => 100,
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control(new peccular_Custom_Control( $wp_customize, 'peccular_logo_size',array(
    'label' => __('Logo Width','peccular'),
    'section' => 'title_tagline',
    'input_attrs' => array(
            'min' => 0,
            'max' => 100,
            'step' => 1,
        ),
    )));

    $wp_customize->add_setting('peccular_logo_height',array(
        'default' => '52',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control(new peccular_Custom_Control( $wp_customize, 'peccular_logo_height',array(
    'label' => __('Logo Height','peccular'),
    'section' => 'title_tagline',
    'input_attrs' => array(
            'min' => 0,
            'max' => 150,
            'step' => 1,
        ),
    )));

    $wp_customize->add_setting('peccular_logo_margin',array(
      'sanitize_callback'   => 'esc_html'
   ));
   $wp_customize->add_control('peccular_logo_margin',array(
      'label' => __('Logo Padding','peccular'),
      'section' => 'title_tagline'
   ));

    $wp_customize->add_setting('peccular_logo_top_margin',array(
        'default' => '0',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('peccular_logo_top_margin',array(
    'type' => 'number',
    'label' => __('Top','peccular'), 
    'section' => 'title_tagline',
    ));

    $wp_customize->add_setting('peccular_logo_bottom_margin',array(
        'default' => '00',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('peccular_logo_bottom_margin',array(
    'type' => 'number',
    'label' => __('Bottom','peccular'),
    'section' => 'title_tagline',
    ));

    $wp_customize->add_setting('peccular_logo_left_margin',array(
        'default' => '00',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('peccular_logo_left_margin',array(
    'type' => 'number',
    'label' => __('Left','peccular'),
    'section' => 'title_tagline',
    ));

    $wp_customize->add_setting('peccular_logo_right_margin',array(
        'default' => '10',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('peccular_logo_right_margin',array(
    'type' => 'number',
    'label' => __('Right','peccular'),
    'section' => 'title_tagline',
    ));
?>