<?php  
$wp_customize->add_section(
    'peccular_aboutnew_section',
    array(
        'title' => __( 'About Us Section', 'peccular' ),
        'panel' => 'peccular_premium_home_panel1',
        'priority' =>20
    )
); 
$wp_customize->add_setting('peccular_aboutnew_nav', array(
   'sanitize_callback' => 'wp_kses_post',
));
$wp_customize->add_control(new peccular_Tab_Control($wp_customize, 'peccular_aboutnew_nav', array(
   'section' => 'peccular_aboutnew_section',
   'priority' => 1,
   'buttons' => array(
      array(
         'name' => esc_html__('General', 'peccular-premium'),
         'icon' => 'dashicons dashicons-welcome-write-blog',
         'fields' => array(
            'peccular_about_new_enable', 
            'peccular_about_new_section_title1',
            'peccular_about_new_text',
            'peccular_about_new_pagelist1',
            'peccular_aboutclient_img_lbl',
            'peccular_aboutclient_image',
            'peccular_about_new_clientname',
            'peccular_about_new_clientdesg',
            'peccular_aboutcenter_img_lbl',
            'peccular_about_image',
            'peccular_aboutelement_img_lbl',
            'peccular_aboutelement_image',
            'peccular_abouttrns_img_lbl',
            'peccular_abouttrns_image',
            'peccular_about_new_time_title',
            'peccular_about_new_time_text',
        ),
         'active' => true,
     ),
      array(
        'name' => esc_html__('Style', 'peccular-premium'),
        'icon' => 'dashicons dashicons-art',
        'fields' => array(
            'peccular_aboutnew_section_bg_color',
            'peccular_aboutnew_section_bg_image',
            'peccular_aboutnew_image_opacity',                           
            'peccular_aboutnew_box_onload_effects',
            'peccular_aboutnew_head_align',
            'peccular_aboutnew_section_b_position',
            'peccular_aboutnew_sheading_color',
            'peccular_aboutnew_sheading_color2',
            'peccular_aboutnew_sheadingborder1_color',
            'peccular_aboutnew_sheadingborder2_color',
            'peccular_aboutnew_sdescriptionText_color',
            'peccular_aboutnew_listTxtClr_color',
            'peccular_aboutnew_listicnclr_color',
            'peccular_aboutnew_clientname_color',
            'peccular_aboutnew_clientdesg_color',
            'peccular_aboutnew_clientboxborder_color',
            'peccular_aboutnew_clientboxshadow_color',
            'peccular_aboutnew_clientboxanimateborder_color',
            'peccular_aboutnew_imageborder_color',
            'peccular_aboutnew_imageboxtimetitle_color',
            'peccular_aboutnew_imageboxtimetext_color',
            'peccular_aboutnew_imageboxtimeicon_color',
            'peccular_aboutnew_imageboxtimebg1_color',
            'peccular_aboutnew_imageboxtimebg2_color',
            'peccular_aboutnew_imageboxtimebg3_color'
        ),
    ),
      array(
        'name' => esc_html__('Layout', 'peccular-premium'),
        'icon' => 'dashicons dashicons-layout',
        'fields' => array(
            'peccular_aboutnew_padding',
            'peccular_aboutnew_section_t_padding',
            'peccular_aboutnew_section_b_padding',
            'peccular_aboutnew_section_leftborder_height',
            'peccular_aboutnew_section_width'
        ),
    )
  ),
))); 
$wp_customize->add_setting( 'peccular_about_new_enable',array(
    'default' => true,
    'sanitize_callback' => 'peccular_switch_sanitization'
) );
$wp_customize->add_control( new peccular_Toggle_Switch_Custom_Control( $wp_customize, 'peccular_about_new_enable',array(
    'label' => __( 'Disable Section','peccular' ),
    'section' => 'peccular_aboutnew_section'
)));

$wp_customize->add_setting(
    'peccular_about_new_section_title1',
    array(
        'sanitize_callback' => 'peccular_sanitize_text',
        'default'           => __( '<strong>Welcome</strong> to Flower Store !', 'peccular' )
    )
);
$wp_customize->add_control(
    'peccular_about_new_section_title1',
    array(
        'settings'      => 'peccular_about_new_section_title1',
        'section'       => 'peccular_aboutnew_section', 
        'type'          => 'text',
        'label'         => __( 'Section Heading', 'peccular' )
    )
);

$wp_customize->add_setting(
    'peccular_about_new_text',
    array(
        'sanitize_callback' => 'peccular_sanitize_text',
        'default'           => __( 'We will send our specialist to your home, who will conduct a detailed diagnosis your equipment perform the necessary repairs.', 'peccular' )
    )
);
$wp_customize->add_control(
    'peccular_about_new_text',
    array(
        'settings'      => 'peccular_about_new_text',
        'section'       => 'peccular_aboutnew_section', 
        'type'          => 'textarea',
        'label'         => __( 'Section Content', 'peccular' )
    )
);

$wp_customize->add_setting(
    'peccular_about_new_pagelist1',
    array(
        'sanitize_callback' => 'peccular_sanitize_text',
        'default'           => __( '<ul>
            <li>Wide Selection of Flowers</li>
            <li>International Delivery</li>
                <li>Secure Payment Option</li>
            <li>Social Media Presence</li>
            </ul>', 'peccular' )
    )
);
$wp_customize->add_control(
    'peccular_about_new_pagelist1',
    array(
        'settings'      => 'peccular_about_new_pagelist1',
        'section'       => 'peccular_aboutnew_section', 
        'type'          => 'textarea',
        'label'         => __( 'Section List', 'peccular' )
    )
);

$wp_customize->add_setting('peccular_aboutclient_img_lbl', array('sanitize_callback'=>'peccular_sanitize_text'));
$wp_customize->add_control(
    new peccular_Info_Text( 
        $wp_customize,
        'peccular_aboutclient_img_lbl',
        array(
            'settings'      => 'peccular_aboutclient_img_lbl',
            'section'       => 'peccular_aboutnew_section',
            'label'         => __( 'Note:', 'peccular Premium' ), 
            'description'   => __( 'Use 69 × 106 px Size For Client Image ', 'peccular Premium' ),
        )
    )
);



  $wp_customize->add_setting( 'peccular_aboutclient_image', array(
       'default' => '',
       'sanitize_callback' => 'esc_url_raw'
    ));
    $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'peccular_aboutclient_image', array(
        'label' => __('Client Image','peccular'),
       'section' => 'peccular_aboutnew_section',
    )));


$wp_customize->add_setting(
    'peccular_about_new_clientname',
    array(
        'sanitize_callback' => 'peccular_sanitize_text',
        'default'           => __( 'Olivia Johnson', 'peccular' )
    )
);
$wp_customize->add_control(
    'peccular_about_new_clientname',
    array(
        'settings'      => 'peccular_about_new_clientname',
        'section'       => 'peccular_aboutnew_section', 
        'type'          => 'text',
        'label'         => __( 'Name', 'peccular' )
    )
);

$wp_customize->add_setting(
    'peccular_about_new_clientdesg',
    array(
        'sanitize_callback' => 'peccular_sanitize_text',
        'default'           => __( 'Company founder', 'peccular' )
    )
);
$wp_customize->add_control(
    'peccular_about_new_clientdesg',
    array(
        'settings'      => 'peccular_about_new_clientdesg',
        'section'       => 'peccular_aboutnew_section', 
        'type'          => 'text',
        'label'         => __( 'Designation', 'peccular' )
    )
);

$wp_customize->add_setting('peccular_aboutcenter_img_lbl', array('sanitize_callback'=>'peccular_sanitize_text'));
$wp_customize->add_control(
    new peccular_Info_Text( 
        $wp_customize,
        'peccular_aboutcenter_img_lbl',
        array(
            'settings'      => 'peccular_aboutcenter_img_lbl',
            'section'       => 'peccular_aboutnew_section',
            'label'         => __( 'Note:', 'peccular Premium' ), 
            'description'   => __( 'Use 508 × 598 px Size For Center Image ', 'peccular Premium' ),
        )
    )
);


  $wp_customize->add_setting( 'peccular_about_image', array(
       'default' => '',
       'sanitize_callback' => 'esc_url_raw'
    ));
    $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'peccular_about_image', array(
        'label' => __('Center Image','peccular'),
       'section' => 'peccular_aboutnew_section',
    )));

$wp_customize->add_setting('peccular_aboutelement_img_lbl', array('sanitize_callback'=>'peccular_sanitize_text'));
$wp_customize->add_control(
    new peccular_Info_Text( 
        $wp_customize,
        'peccular_aboutelement_img_lbl',
        array(
            'settings'      => 'peccular_aboutelement_img_lbl',
            'section'       => 'peccular_aboutnew_section',
            'label'         => __( 'Note:', 'peccular Premium' ), 
            'description'   => __( 'Use 210 × 300 px Size For Top/Bottom Image ', 'peccular Premium' ),
        )
    )
);



  $wp_customize->add_setting( 'peccular_aboutelement_image', array(
       'default' => '',
       'sanitize_callback' => 'esc_url_raw'
    ));
    $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'peccular_aboutelement_image', array(
        'label' => __('Top/Bottom Image','peccular'),
       'section' => 'peccular_aboutnew_section',
    )));

$wp_customize->add_setting('peccular_abouttrns_img_lbl', array('sanitize_callback'=>'peccular_sanitize_text'));
$wp_customize->add_control(
    new peccular_Info_Text( 
        $wp_customize,
        'peccular_abouttrns_img_lbl',
        array(
            'settings'      => 'peccular_abouttrns_img_lbl',
            'section'       => 'peccular_aboutnew_section',
            'label'         => __( 'Note:', 'peccular Premium' ), 
            'description'   => __( 'Use 558 × 569 px Size For Transparent Image ', 'peccular Premium' ),
        )
    )
);

  $wp_customize->add_setting( 'peccular_abouttrns_image', array(
       'default' => '',
       'sanitize_callback' => 'esc_url_raw'
    ));
    $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'peccular_abouttrns_image', array(
        'label' => __('Transparent Image','peccular'),
       'section' => 'peccular_aboutnew_section',
    )));

$wp_customize->add_setting(
    'peccular_about_new_time_title',
    array(
        'sanitize_callback' => 'peccular_sanitize_text',
        'default'           => __( '24 Hours', 'peccular' )
    )
);
$wp_customize->add_control(
    'peccular_about_new_time_title',
    array(
        'settings'      => 'peccular_about_new_time_title',
        'section'       => 'peccular_aboutnew_section', 
        'type'          => 'text',
        'label'         => __( 'Time', 'peccular' )
    )
);

$wp_customize->add_setting(
    'peccular_about_new_time_text',
    array(
        'sanitize_callback' => 'peccular_sanitize_text',
        'default'           => __( 'Service are available', 'peccular' )
    )
);
$wp_customize->add_control(
    'peccular_about_new_time_text',
    array(
        'settings'      => 'peccular_about_new_time_text',
        'section'       => 'peccular_aboutnew_section', 
        'type'          => 'text',
        'label'         => __( 'Time Text', 'peccular' )
    )
);


$wp_customize->add_setting('peccular_aboutnew_padding',array(
  'sanitize_callback'   => 'esc_html'
));
$wp_customize->add_control('peccular_aboutnew_padding',array(
  'label' => __('Section Padding','peccular'),
  'section' => 'peccular_aboutnew_section'
));
$wp_customize->add_setting('peccular_aboutnew_section_t_padding',array(
    'default' => '2',
    'sanitize_callback' => 'sanitize_text_field'
));
$wp_customize->add_control('peccular_aboutnew_section_t_padding',array(
    'type' => 'number',
    'label' => __('Top','peccular'),
    'section' => 'peccular_aboutnew_section',
));
$wp_customize->add_setting('peccular_aboutnew_section_b_padding',array(
    'default' => '6',
    'sanitize_callback' => 'sanitize_text_field'
));
$wp_customize->add_control('peccular_aboutnew_section_b_padding',array(
    'type' => 'number',
    'label' => __('Bottom','peccular'),
    'section' => 'peccular_aboutnew_section',
));
$wp_customize->add_setting( 'peccular_aboutnew_section_bg_color', array(
   'default' => '',
   'sanitize_callback' => 'sanitize_hex_color'
));
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'peccular_aboutnew_section_bg_color', array(
    'label' => __('Section Background Color','peccular'),
    'section' => 'peccular_aboutnew_section',
)));
$wp_customize->add_setting( 'peccular_aboutnew_section_bg_image', array(
   'default' => '',
   'sanitize_callback' => 'esc_url_raw'
));
$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'peccular_aboutnew_section_bg_image', array(
    'label' => __('Section Background Image','peccular'),
    'section' => 'peccular_aboutnew_section',
)));
$wp_customize->add_setting('peccular_aboutnew_image_opacity',array(
    'default' => 1,
    'sanitize_callback' => 'peccular_sanitize_float'
));
$wp_customize->add_control(new peccular_Custom_Control( $wp_customize, 'peccular_aboutnew_image_opacity',array(
    'label' => __('Background Opacity','peccular'),
    'section' => 'peccular_aboutnew_section',
    'input_attrs' => array(
        'min' => 0,
        'max' => 1,
        'step' => 0.1,
    ),
)));
$wp_customize->add_setting('peccular_aboutnew_box_onload_effects',array(
    'default' => 'Bounce In Up',
    'sanitize_callback' => 'peccular_sanitize_choices',
));
$wp_customize->add_control('peccular_aboutnew_box_onload_effects',array(
    'type' => 'select',
    'label' => __('Onload Transition Effects','peccular'),
    'choices' => array (
        'wow bounceInLeft' => __('Bounce In Left','peccular'),
        'wow bounceInRight' => __('Bounce In Right','peccular'),
        'wow bounceInUp' => __('Bounce In Up','peccular'),
        'wow bounceInDown' => __('Bounce In Down','peccular'),
        'wow zoomIn' => __('Zoom In','peccular'),
        'wow zoomOut' => __('Zoom Out','peccular'),
        'wow fadeInDown' => __('Fade In Down','peccular'),            
        'wow fadeInUp' => __('Fade In Up','peccular'),
        'wow fadeInLeft' => __('Fade In Left','peccular'),
        'wow fadeInRight' => __('Fade In Right','peccular'),
        'flip-up' => __('Flip Up','peccular'),
        'none' => __('None','peccular')
    ),
    'section' => 'peccular_aboutnew_section',
));
// $wp_customize->add_setting('peccular_aboutnew_head_align',array(
//     'default' => 'Left',
//     'sanitize_callback' => 'peccular_sanitize_choices',
// ));
// $wp_customize->add_control('peccular_aboutnew_head_align',array(
//     'type' => 'select',
//     'label' => __('Section Content Alignment','peccular'),
//     'choices' => array (
//         'Center' => __('Center','peccular'),
//         'Left' => __('Left','peccular'),
//         'Right' => __('Right','peccular')
//     ),
//     'section' => 'peccular_aboutnew_section',
// )); 

$wp_customize->add_setting('peccular_aboutnew_section_width',array(
    'default' => 'Full Width',
    'sanitize_callback' => 'peccular_sanitize_choices',
));
$wp_customize->add_control('peccular_aboutnew_section_width',array(
    'type' => 'select',
    'label' => __('Section Width','peccular'),
    'choices' => array (
        'Box Width' => __('Box Width','peccular'),
        'Full Width' => __('Full Width','peccular')
    ),
    'section' => 'peccular_aboutnew_section',
));

addColorPalatOption($wp_customize, 'peccular_aboutnew_sheading_color', 'peccular_aboutnew_section', 'Section Heading Color', '');
addColorPalatOption($wp_customize, 'peccular_aboutnew_sheading_color2', 'peccular_aboutnew_section', 'Section Heading Color', '');
addColorPalatOption($wp_customize, 'peccular_aboutnew_sheadingborder1_color', 'peccular_aboutnew_section', 'Section Heading Border Color', '');
addColorPalatOption($wp_customize, 'peccular_aboutnew_sheadingborder2_color', 'peccular_aboutnew_section', 'Section Heading Border Color', '');

addColorPalatOption($wp_customize, 'peccular_aboutnew_sdescriptionText_color', 'peccular_aboutnew_section', 'Section Content Color', '');


addColorPalatOption($wp_customize, 'peccular_aboutnew_listTxtClr_color', 'peccular_aboutnew_section', 'List Color', '');
addColorPalatOption($wp_customize, 'peccular_aboutnew_listicnclr_color', 'peccular_aboutnew_section', 'List Icon Color', '');
addColorPalatOption($wp_customize, 'peccular_aboutnew_clientname_color', 'peccular_aboutnew_section', 'Client Name Color', '');

addColorPalatOption($wp_customize, 'peccular_aboutnew_clientdesg_color', 'peccular_aboutnew_section', 'Client Designation Color', '');

addColorPalatOption($wp_customize, 'peccular_aboutnew_clientboxborder_color', 'peccular_aboutnew_section', 'Client Box Border Color', '');
addColorPalatOption($wp_customize, 'peccular_aboutnew_clientboxshadow_color', 'peccular_aboutnew_section', 'Client Box Shadow Color', '');
addColorPalatOption($wp_customize, 'peccular_aboutnew_clientboxanimateborder_color', 'peccular_aboutnew_section', 'Client Box Animated Border Color', '');


addColorPalatOption($wp_customize, 'peccular_aboutnew_imageborder_color', 'peccular_aboutnew_section', 'Image Border Color', '');

addColorPalatOption($wp_customize, 'peccular_aboutnew_imageboxtimetitle_color', 'peccular_aboutnew_section', 'Time Box Title Color', '');
addColorPalatOption($wp_customize, 'peccular_aboutnew_imageboxtimetext_color', 'peccular_aboutnew_section', 'Time Box Text Color', '');
addColorPalatOption($wp_customize, 'peccular_aboutnew_imageboxtimeicon_color', 'peccular_aboutnew_section', 'Time Box Icon Color', '');

addColorPalatOption($wp_customize, 'peccular_aboutnew_imageboxtimebg1_color', 'peccular_aboutnew_section', 'Time Box BG Color', '');
addColorPalatOption($wp_customize, 'peccular_aboutnew_imageboxtimebg2_color', 'peccular_aboutnew_section', 'Time Box BG Color', '');
addColorPalatOption($wp_customize, 'peccular_aboutnew_imageboxtimebg3_color', 'peccular_aboutnew_section', 'Time Box BG Color', '');

?>