<?php  
$wp_customize->add_section(
    'peccular_bestseller_products_section',
    array(
        'title' => __( 'Best Seller', 'peccular-premium' ),
        'panel' => 'peccular_premium_home_panel1',
        'priority' =>19
    ) 
); 

$wp_customize->add_setting('peccular_bestseller_products_nav', array(
    'sanitize_callback' => 'wp_kses_post',
)); 

$wp_customize->add_control(new peccular_Tab_Control($wp_customize, 'peccular_bestseller_products_nav', array(
    'section' => 'peccular_bestseller_products_section',
    'priority' => 1,
    'buttons' => array(
        array(
            'name' => esc_html__('General', 'peccular-premium'),
            'icon' => 'dashicons dashicons-welcome-write-blog',
            'fields' => array(
                'peccular_bestseller_products_enable',
                'peccular_bestseller_carousel_style',
                'peccular_bestseller_products_section_lbl',
                'ct__bestsellerproduct__page_title',
                'sec_addtocart_txtnew_id',
                'sec_addtocart_txtnew',
                'ct__bestsellerproduct__page_content',
                'ct__bestseller__page_title'

            ),
            'active' => true,
        ),
        array(
            'name' => esc_html__('Style', 'peccular-premium'),
            'icon' => 'dashicons dashicons-art',
            'fields' => array(
                'peccular_bestseller_products_section_bg_color',
                'peccular_bestseller_products_section_bg_image',
                'peccular_bestseller_products_image_opacity',
                'peccular_bestseller_products_box_onload_effects',
                'peccular_bestsellerproducts_head_align',
                'peccular_bestsellerproducts_head_case',
                'curtains_bestsellerproduct_title_case',
                'peccular_bestsellerproducts_mainheading_color',
                'peccular_bestsellerproducts_contdescr_color',
                'peccular_bestsellerproducts_proheading_color',
                'peccular_bestsellerproducts_proheadinghover_color',
                'peccular_bestsellerproducts_proheadinghoverbrs_color',
                'peccular_bestsellerproducts_saleprice_color',
                'peccular_bestsellerproducts_regprice_color',
                'peccular_bestsellerproducts_addtcart_color',
                'peccular_bestsellerproducts_addtcartbg_color',
                'peccular_bestsellerproducts_addtcarthover_color',
                'peccular_bestsellerproducts_addtcarthvrbg_color',
                'peccular_bestsellerproducts_viewicon_color',
                'peccular_bestsellerproducts_viewiconhover_color',
                'peccular_bestsellerproducts_viewiconbg1_color',
                'peccular_bestsellerproducts_viewiconbg2_color',
                'peccular_bestsellerproducts_viewiconbg3_color',
                'peccular_bestsellerproducts_viewiconbg4_color',
                'peccular_bestsellerproducts_viewlabelbghover_color',
                'peccular_bestsellerproductslabel_head_case',
                'peccular_bestseller_products_height',
                'peccular_bestsellerproducts_indicators_color',
                'peccular_bestsellerproducts_pihanimation_color',
                'peccular_bestsellerproducts_headbrss_color',
                'peccular_bestseller_products_lblwidth',
                'peccular_bestseller_products_disclblwidth',
                'peccular_bestseller_products_disclblwidth',
                'peccular_bestsellerproducts_viewiconbgc_color'      

            ),
        ),
        array(
            'name' => esc_html__('Layout', 'peccular-premium'),
            'icon' => 'dashicons dashicons-layout',
            'fields' => array(
                'peccular_bestseller_products_padding',
                'peccular_bestseller_products_section_t_padding',
                'peccular_bestseller_products_section_b_padding',
                'peccular_bestsellerproducts_section_width'
            ),
        )
    ),
)));
$wp_customize->add_setting( 'peccular_bestseller_products_enable',array(
    'default' => true,
    'sanitize_callback' => 'peccular_switch_sanitization'
) );
$wp_customize->add_control( new peccular_Toggle_Switch_Custom_Control( $wp_customize, 'peccular_bestseller_products_enable',array(
    'label' => __( 'Disable Section','peccular' ),
    'section' => 'peccular_bestseller_products_section'
)));

$wp_customize->add_setting('peccular_bestseller_carousel_style',array(
    'default' => 'No Carousel',
    'sanitize_callback' => 'peccular_sanitize_choices',
));
$wp_customize->add_control('peccular_bestseller_carousel_style',array(
    'type' => 'select',
    'label' => __('Carousel Style','peccular'),
    'choices' => array (
        'Carousel' => __('Carousel','peccular'),
        'No Carousel' => __('No Carousel','peccular')
    ),
    'section' => 'peccular_bestseller_products_section',
));

$wp_customize->add_setting('peccular_bestseller_products_section_lbl', array('sanitize_callback'=>'peccular_sanitize_text'));
$wp_customize->add_control(
    new peccular_Info_Text( 
        $wp_customize,
        'peccular_bestseller_products_section_lbl',
        array(
            'settings'      => 'peccular_bestseller_products_section_lbl',
            'section'       => 'peccular_bestseller_products_section',
            'label'         => __( 'Note:', 'peccular Premium' ), 
            'description'   => __( 'Add Product Images Of Height 270px To Show In A Proper Way.', 'peccular Premium' ),
        )
    )
);

$wp_customize->add_setting(
    'ct__bestsellerproduct__page_title',
    array(
        'sanitize_callback' => 'peccular_sanitize_text',
        'default'           => __( 'Best Seller', 'peccular-premium' )
    )
);
$wp_customize->add_control(
    'ct__bestsellerproduct__page_title',
    array(
        'settings'      => 'ct__bestsellerproduct__page_title',
        'section'       => 'peccular_bestseller_products_section', 
        'type'          => 'text',
        'label'         => __( 'Section Heading', 'peccular-premium' )
    )
);



$wp_customize->add_setting( 'peccular_bestseller_products_section_bg_color', array(
    'default' => '',
    'sanitize_callback' => 'sanitize_hex_color'
));
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'peccular_bestseller_products_section_bg_color', array(
    'label' => __('Section Background Color','peccular'),
    'section' => 'peccular_bestseller_products_section',
)));

$wp_customize->add_setting( 'peccular_bestseller_products_section_bg_image', array(
    'default' => '',
    'sanitize_callback' => 'esc_url_raw'
));
$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'peccular_bestseller_products_section_bg_image', array(
    'label' => __('Section Background Image','peccular'),
    'section' => 'peccular_bestseller_products_section',
)));

$wp_customize->add_setting('peccular_bestseller_products_image_opacity',array(
    'default' => 1,
    'sanitize_callback' => 'peccular_sanitize_float'
));
$wp_customize->add_control(new peccular_Custom_Control( $wp_customize, 'peccular_bestseller_products_image_opacity',array(
    'label' => __('Background Opacity','peccular'),
    'section' => 'peccular_bestseller_products_section',
    'input_attrs' => array(
        'min' => 0,
        'max' => 1,
        'step' => 0.1,
    ),
)));



$wp_customize->add_setting('peccular_bestseller_products_box_onload_effects',array(
    'default' => 'Zoom In',
    'sanitize_callback' => 'peccular_sanitize_choices',
));
$wp_customize->add_control('peccular_bestseller_products_box_onload_effects',array(
    'type' => 'select',
    'label' => __('Onload Transition Effects','peccular'),
    'choices' => array (
        'wow bounceInLeft' => __('Bounce In Left','peccular'),
        'wow bounceInRight' => __('Bounce In Right','peccular'),
        'wow bounceInUp' => __('Bounce In Up','peccular'),
        'wow bounceInDown' => __('Bounce In Down','peccular'),
        'wow zoomIn' => __('Zoom In','peccular'),
        'wow zoomOut' => __('Zoom Out','peccular'),
        'wow slideInDown' => __('Slide In Down','peccular'),            
        'wow slideInUp' => __('Slide In Up','peccular'),
        'wow slideInLeft' => __('Slide In Left','peccular'),
        'wow slideInRight' => __('Slide In Right','peccular'),
        'flip-up' => __('Flip Up','peccular'),
        'none' => __('None','peccular')
    ),
    'section' => 'peccular_bestseller_products_section',
));

$wp_customize->add_setting('peccular_bestsellerproducts_head_align',array(
    'default' => 'Center',
    'sanitize_callback' => 'peccular_sanitize_choices',
));
$wp_customize->add_control('peccular_bestsellerproducts_head_align',array(
    'type' => 'select',
    'label' => __('Products Content Alignment','peccular'),
    'choices' => array (
        'Center' => __('Center','peccular'),
        'Left' => __('Left','peccular'),
        'Right' => __('Right','peccular')
    ),
    'section' => 'peccular_bestseller_products_section',
));
$wp_customize->add_setting('peccular_bestsellerproducts_head_case',array(
    'default' => 'Capitalize',
    'sanitize_callback' => 'peccular_sanitize_choices',
));
$wp_customize->add_control('peccular_bestsellerproducts_head_case',array(
    'type' => 'select',
    'label' => __('Section Heading Case','peccular'),
    'choices' => array (
        'None' => __('None','peccular'),
        'Uppercase' => __('Uppercase','peccular'),
        'Lowercase' => __('Lowercase','peccular'),
        'Capitalize' => __('Capitalize','peccular')
    ),
    'section' => 'peccular_bestseller_products_section',
));
$wp_customize->add_setting('curtains_bestsellerproduct_title_case',array(
    'default' => 'Capitalize',
    'sanitize_callback' => 'peccular_sanitize_choices',
));
$wp_customize->add_control('curtains_bestsellerproduct_title_case',array(
    'type' => 'select',
    'label' => __('Products Title Case','peccular'),
    'choices' => array (
        'None' => __('None','peccular'),
        'Uppercase' => __('Uppercase','peccular'),
        'Lowercase' => __('Lowercase','peccular'),
        'Capitalize' => __('Capitalize','peccular')
    ),
    'section' => 'peccular_bestseller_products_section',
));

// $wp_customize->add_setting('peccular_bestsellerproductslabel_head_case',array(
//  'default' => 'Uppercase',
//  'sanitize_callback' => 'peccular_sanitize_choices',
// ));
// $wp_customize->add_control('peccular_bestsellerproductslabel_head_case',array(
//  'type' => 'select',
//  'label' => __('Products Label Case','peccular'),
//  'choices' => array (
//      'Uppercase' => __('Uppercase','peccular'),
//      'Lowercase' => __('Lowercase','peccular'),
//      'Capitalize' => __('Capitalize','peccular')
//  ),
//  'section' => 'peccular_bestseller_products_section',
// ));

$wp_customize->add_setting('peccular_bestseller_products_padding',array(
    'sanitize_callback'   => 'esc_html'
));
$wp_customize->add_control('peccular_bestseller_products_padding',array(
    'label' => __('Section Padding','peccular'),
    'section' => 'peccular_bestseller_products_section'
));

$wp_customize->add_setting('peccular_bestseller_products_section_t_padding',array(
    'default' => '1.5',
    'sanitize_callback' => 'sanitize_text_field'
));
$wp_customize->add_control('peccular_bestseller_products_section_t_padding',array(
    'type' => 'number',
    'label' => __('Top','peccular'),
    'section' => 'peccular_bestseller_products_section',
));
$wp_customize->add_setting('peccular_bestseller_products_section_b_padding',array(
    'default' => '4.5',
    'sanitize_callback' => 'sanitize_text_field'
));
$wp_customize->add_control('peccular_bestseller_products_section_b_padding',array(
    'type' => 'number',
    'label' => __('Bottom','peccular'),
    'section' => 'peccular_bestseller_products_section',
));

$wp_customize->add_setting('peccular_bestsellerproducts_section_width',array(
    'default' => 'Box Width',
    'sanitize_callback' => 'peccular_sanitize_choices',
));
$wp_customize->add_control('peccular_bestsellerproducts_section_width',array(
    'type' => 'select',
    'label' => __('Section Width','peccular'),
    'choices' => array (
        'Box Width' => __('Box Width','peccular'),
        'Full Width' => __('Full Width','peccular')
    ),
    'section' => 'peccular_bestseller_products_section',
));

$wp_customize->add_setting('peccular_bestseller_products_height',array(
    'default' => '300',
    'sanitize_callback' => 'sanitize_text_field'
));
$wp_customize->add_control('peccular_bestseller_products_height',array(
    'type' => 'number',
    'label' => __('Set Product Image Height','peccular'),
    'section' => 'peccular_bestseller_products_section',
));
// $wp_customize->add_setting('peccular_bestseller_products_lblwidth',array(
//  'default' => '49',
//  'sanitize_callback' => 'sanitize_text_field'
// ));
// $wp_customize->add_control('peccular_bestseller_products_lblwidth',array(
//  'type' => 'number',
//  'label' => __('Set Products Label Width','peccular'),
//  'section' => 'peccular_bestseller_products_section',
// ));
// $wp_customize->add_setting('peccular_bestseller_products_disclblwidth',array(
//  'default' => '49',
//  'sanitize_callback' => 'sanitize_text_field'
// ));
// $wp_customize->add_control('peccular_bestseller_products_disclblwidth',array(
//  'type' => 'number',
//  'label' => __('Set Products Discount Label Width','peccular'),
//  'section' => 'peccular_bestseller_products_section',
// ));

addColorPalatOption($wp_customize, 'peccular_bestsellerproducts_mainheading_color', 'peccular_bestseller_products_section', 'Section Heading Color', '');

addColorPalatOption($wp_customize, 'peccular_bestsellerproducts_proheading_color', 'peccular_bestseller_products_section', 'Product Title Color', '');

addColorPalatOption($wp_customize, 'peccular_bestsellerproducts_proheadinghover_color', 'peccular_bestseller_products_section', 'Product Title Hover Color', '');

addColorPalatOption($wp_customize, 'peccular_bestsellerproducts_proheadinghoverbrs_color', 'peccular_bestseller_products_section', 'Product Title Hover Border Color', '');

addColorPalatOption($wp_customize, 'peccular_bestsellerproducts_saleprice_color', 'peccular_bestseller_products_section', 'Sale Price Text Color', '');

addColorPalatOption($wp_customize, 'peccular_bestsellerproducts_regprice_color', 'peccular_bestseller_products_section', 'Regular Price Text Color', '');

addColorPalatOption($wp_customize, 'peccular_bestsellerproducts_addtcart_color', 'peccular_bestseller_products_section', 'Cart / Plus Icon Color', '');

addColorPalatOption($wp_customize, 'peccular_bestsellerproducts_addtcarthover_color', 'peccular_bestseller_products_section', 'Cart Icon Hover Color', '');

addColorPalatOption($wp_customize, 'peccular_bestsellerproducts_addtcartbg_color', 'peccular_bestseller_products_section', 'Cart / Plus Icon BG Color', '');

addColorPalatOption($wp_customize, 'peccular_bestsellerproducts_addtcarthvrbg_color', 'peccular_bestseller_products_section', 'Cart Icon Hover BG Color', '');

addColorPalatOption($wp_customize, 'peccular_bestsellerproducts_viewicon_color', 'peccular_bestseller_products_section', 'Products Discount Color', '');

addColorPalatOption($wp_customize, 'peccular_bestsellerproducts_viewiconbg1_color', 'peccular_bestseller_products_section', 'Products Discount BG Color', '');

addColorPalatOption($wp_customize, 'peccular_bestsellerproducts_viewiconbg2_color', 'peccular_bestseller_products_section', 'Products Discount BG Color', '');
addColorPalatOption($wp_customize, 'peccular_bestsellerproducts_viewiconbg3_color', 'peccular_bestseller_products_section', 'Products Discount BG Color', '');
addColorPalatOption($wp_customize, 'peccular_bestsellerproducts_viewiconbg4_color', 'peccular_bestseller_products_section', 'Products Discount BG Color', '');

addColorPalatOption($wp_customize, 'peccular_bestsellerproducts_viewlabelbghover_color', 'peccular_bestseller_products_section', 'Products Discount BG Hover Color', '');

addColorPalatOption($wp_customize, 'peccular_bestsellerproducts_indicators_color', 'peccular_bestseller_products_section', 'Products Slider Indicator Color', '');

?>