/*
 * Theme Name: Private Tutor Pro
 */

/*----------------------------------------------------
/* Responsive Navigation
/*--------------------------------------------------*/
jQuery(document).ready(function($){
    $('.primary-navigation').append('<div id="mobile-menu-overlay" />');

    $('.toggle-mobile-menu').click(function(e) {
        e.preventDefault();
        e.stopPropagation();
        $('body').toggleClass('mobile-menu-active');

        if ( $('body').hasClass('mobile-menu-active') ) {
            if ( $(document).height() > $(window).height() ) {
                var scrollTop = ( $('html').scrollTop() ) ? $('html').scrollTop() : $('body').scrollTop();
                $('html').addClass('noscroll').css( 'top', -scrollTop );
            }
            $('#mobile-menu-overlay').fadeIn();
        } else {
            var scrollTop = parseInt( $('html').css('top') );
            $('html').removeClass('noscroll');
            $('html,body').scrollTop( -scrollTop );
            $('#mobile-menu-overlay').fadeOut();
        }
    });
}).on('click', function(event) {

    var $target = jQuery(event.target);
    if ( ( $target.hasClass("publishable-icon") && $target.parent().hasClass("toggle-caret") ) ||  $target.hasClass("toggle-caret") ) {// allow clicking on menu toggles
        return;
    }
    jQuery('body').removeClass('mobile-menu-active');
    jQuery('html').removeClass('noscroll');
    jQuery('#mobile-menu-overlay').fadeOut();
});

/*----------------------------------------------------
/*  Dropdown menu
/* ------------------------------------------------- */
jQuery(document).ready(function($) {

    function mtsDropdownMenu() {
        var wWidth = $(window).width();
        if(wWidth > 865) {
            $('#navigation ul.sub-menu, #navigation ul.children').hide();
            var timer;
            var delay = 100;
            $('#navigation li').hover( 
              function() {
                var $this = $(this);
                timer = setTimeout(function() {
                    $this.children('ul.sub-menu, ul.children').slideDown('fast');
                }, delay);
                
            },
            function() {
                $(this).children('ul.sub-menu, ul.children').hide();
                clearTimeout(timer);
            }
            );
        } else {
            $('#navigation li').unbind('hover');
            $('#navigation li.active > ul.sub-menu, #navigation li.active > ul.children').show();
        }
    }

    mtsDropdownMenu();

    $(window).resize(function() {
        mtsDropdownMenu();
    });
});

/*---------------------------------------------------
/*  Vertical menus toggles
/* -------------------------------------------------*/
jQuery(document).ready(function($) {

    $('.widget_nav_menu, #navigation .menu').addClass('toggle-menu');
    $('.toggle-menu ul.sub-menu, .toggle-menu ul.children').addClass('toggle-submenu');
    $('.toggle-menu ul.sub-menu').parent().addClass('toggle-menu-item-parent');

    $('.toggle-menu .toggle-menu-item-parent').append('<span class="toggle-caret"><i class="publishable-icon icon-plus"></i></span>');

    $('.toggle-caret').click(function(e) {
        e.preventDefault();
        $(this).parent().toggleClass('active').children('.toggle-submenu').slideToggle('fast');
    });
});

/*----------------------------------------------------
/* Back to top smooth scrolling
/*--------------------------------------------------*/
jQuery(document).ready(function($) {
    jQuery('a[href=#top]').click(function(){
        jQuery('html, body').animate({scrollTop:0}, 'slow');
        return false;
    });
});

/*----------------------------------------------------
/* Slider  
/*--------------------------------------------------*/

$('div#main-slider .owl-carousel').owlCarousel({
     margin:0,
    loop: true,
      dots: true,
      nav: true,
      items: 1,
    mouseDrag:true,
    autoplay:true,
     autoplaySpeed: 7000,
    animateOut: 'zoomInImage',
    responsive:{
        0:{
            items:1
        },
        600:{
            items:1
        },
        1000:{
            items:1
        }
    }
}); 

/*----------------------------------------------------
/* Recent Products 
/*--------------------------------------------------*/

$('section#recent-products .owl-carousel').owlCarousel({
    loop:true,
    margin:50,
    dots:true,
    nav:false,
    mouseDrag:true,
    autoplay:false,
    autoplaySpeed: 7000,
    autoplayTimeout: 5000,
    autoplayHoverPause: true,
    slideTransition: 'linear',
    responsive:{
         0:{
            items:2,
            margin:25
        },
        600:{
            items:3,
            margin:25
        },
        1200:{
            items:4
        },
        1000:{
            items:3
        }
    }
}); 

/*----------------------------------------------------
/* Best Seller Products 
/*--------------------------------------------------*/

$('section#best-seller-products .owl-carousel').owlCarousel({
    loop:true,
    margin:50,
    dots:true,
    nav:false,
    mouseDrag:true,
    autoplay:false,
    autoplaySpeed: 7000,
    autoplayTimeout: 5000,
    autoplayHoverPause: true,
    slideTransition: 'linear',
    responsive:{
        0:{
            items:2,
            margin:25
        },
        600:{
            items:3,
            margin:25
        },
        1200:{
            items:4
        },
        1000:{
            items:3
        }
    }
}); 


$('section#featuredproduct-section .owl-carousel').owlCarousel({
    loop:true,
    margin:50,
    dots:true,
    nav:false,
    mouseDrag:true,
    autoplay:false,
    responsive:{
    autoplaySpeed: 7000,
    autoplayTimeout: 5000,
    autoplayHoverPause: true,
    slideTransition: 'linear',
        0:{
            items:2,
            margin:25
        },
        600:{
            items:3,
            margin:25
        },
        1200:{
            items:4
        },
        1000:{
            items:3
        }
    }
}); 

$('#blog .owl-carousel').owlCarousel({
    loop:true,
    margin:30,
    dots:true,
    nav:false,
    mouseDrag:true,
    autoplay:true,
    autoplaySpeed: 7000,
    autoplayTimeout: 5000,
    autoplayHoverPause: true,
    slideTransition: 'linear',
    responsive:{
        0:{
            items:1
        },
        600:{
            items:2
        },
        1300:{
            items:3
        },
        1000:{
            items:3
        }
    }
}); 

$('#services .owl-carousel').owlCarousel({
    loop:true,
    margin:30,
    dots:false,
    nav:true,
    mouseDrag:true,
    autoplay:false,
    autoplaySpeed: 7000,
    autoplayTimeout: 5000,
    autoplayHoverPause: true,
    slideTransition: 'linear',
    responsive:{
        0:{
            items:2
        },
        600:{
            items:3
        },
        1300:{
            items:5
        },
        1000:{
            items:5
        }
    }
}); 

// $('#testimonials .owl-carousel').owlCarousel({
//     loop:true,
//     margin:50,
//     dots:false,
//     nav:true,
//     activeElement:1,
//     mouseDrag:true,
//     autoplay:false,
//     autoplaySpeed: 7000,
//     autoplayTimeout: 5000,
//     autoplayHoverPause: true,
//     slideTransition: 'linear',
//     responsive:{
//         0:{
//             items:1
//         },
//         600:{
//             items:2
//         },
//         1300:{
//             items:5
//         },
//         1000:{
//             items:5
//         }
//     }
// }); 


/*----------------------------------------------------
/* features section
/*--------------------------------------------------*/

$('#features .owl-carousel').owlCarousel({
    loop:true,
    margin:50,
    dots:true,
    nav:false,
    mouseDrag:true,
    autoplay:false,
    autoplaySpeed: 7000,
    autoplayTimeout: 5000,
    autoplayHoverPause: true,
    slideTransition: 'linear',
    responsive:{
        0:{
            items:1,
            margin:25
        },
        600:{
            items:2,
            margin:25
        },
        1200:{
            items:4
        },
        1000:{
            items:3
        }
    }
}); 





// quantity 
$('.plus').on('click',function(e){

    var val = parseInt($(this).prev('input').val());

    $(this).prev('input').val( val+1 );


});

$('.minus').on('click',function(e){

    var val = parseInt($(this).next('input').val());

    $(this).next('input').val( val-1 );


});
/*----------------------------------------------------
/* Video pop up
/*--------------------------------------------------*/

var links = $('.boxes a');
links.colorbox({
  inline: true,
  rel: 'gallery'
});

/* Colorbox resize function */
var resizeTimer;
function resizeColorBox()
{
    if (resizeTimer) clearTimeout(resizeTimer);
    resizeTimer = setTimeout(function() {
        if ($('#cboxOverlay').is(':visible')) {
            $.colorbox.load(true);
        }
    }, 300)
}

// Resize Colorbox when resizing window or changing mobile device orientation
$(window).resize(resizeColorBox);
window.addEventListener("orientationchange", resizeColorBox, false);


$('.boxes a').colorbox({maxWidth:'95%', maxHeight:'95%'});