const popup = document.querySelector('.popup');
const popupContent = document.querySelector('.popup_content');
const close = document.querySelector('.popup_close');
const popupImg = document.querySelector('.popup_img');
const Teams = document.querySelectorAll('.teams');
const name = document.querySelector('.detail_name');
const designation = document.querySelector('.detail_designation');
const experience = document.querySelector('.detail_experience');
const content = document.querySelector('.detail_content');
const socialicon = document.querySelector('.detail_socialicon');


Teams.forEach((list, index) => {
  const view = list.querySelector('.teams_click');
  const teamImage = list.querySelector('.team_img').getAttribute('src');
  const teamName = list.querySelector('.team_name').getAttribute('id');
  const teamDesignation = list.querySelector('.team_designation').getAttribute('id');
  const teamExperience = list.querySelector('.team_experience').getAttribute('id');
  const teamContent = list.querySelector('.team_content').getAttribute('id');
  const teamSocialicon = list.querySelector('.team_socialicon').getAttribute('id');

  

  view.addEventListener('click', () => {
    popup.classList.add('popup--bg');
    popupContent.classList.add('popup_content--show');
    popupImg.setAttribute('src', teamImage);

    name.innerText = teamName;
    designation.innerText = teamDesignation;
    experience.innerText = teamExperience;
    content.innerText = teamContent;
    socialicon.innerText = teamSocialicon;


  });
});

close.addEventListener('click', () => {
  popup.classList.remove('popup--bg');
  popupContent.classList.remove('popup_content--show');
});

popup.addEventListener('click', () => {
  popup.classList.remove('popup--bg');
  popupContent.classList.remove('popup_content--show');
});
