<?php
function petcareveterinarycenter_custom_header_setup() {
	add_theme_support( 'custom-header', apply_filters( 'petcareveterinarycenter_custom_header_args', array(
		'default-image'      => '',
		'default-text-color' => 'fff',
		'width'              => 2000, 
		'height'             => 200,
		'flex-height'        => true,
		'wp-head-callback'   => 'petcareveterinarycenter_header_style',
	) ) );
}
add_action( 'after_setup_theme', 'petcareveterinarycenter_custom_header_setup' );

if ( ! function_exists( 'petcareveterinarycenter_header_style' ) ) :

function petcareveterinarycenter_header_style() {
	$header_text_color = get_header_textcolor();

	$topheader_logowidth = esc_attr(get_theme_mod('topheader_logowidth','auto'));

	$petcareveterinarycenter_logo_top_padding    = esc_attr(get_theme_mod('petcareveterinarycenter_logo_top_padding','2'));
	$petcareveterinarycenter_logo_left_padding   = esc_attr(get_theme_mod('petcareveterinarycenter_logo_left_padding','2'));
	$petcareveterinarycenter_logo_bottom_padding = esc_attr(get_theme_mod('petcareveterinarycenter_logo_bottom_padding','2'));
	$petcareveterinarycenter_logo_right_padding  = esc_attr(get_theme_mod('petcareveterinarycenter_logo_right_padding','2'));

  	$feature_disable_section    = esc_attr(get_theme_mod('feature_disable_section','YES'));
  	$ourservice_disable_section = esc_attr(get_theme_mod('ourservice_disable_section','YES'));
  	$aboutus_disable_section    = esc_attr(get_theme_mod('aboutus_disable_section','YES'));

	$custom_css = "";

	
	// Logo
	$custom_css .= "
	.site-logo img {
		width: {$topheader_logowidth};
		padding-top: {$petcareveterinarycenter_logo_top_padding}px;
		padding-left: {$petcareveterinarycenter_logo_left_padding}px;
		padding-bottom: {$petcareveterinarycenter_logo_bottom_padding}px;
		padding-right: {$petcareveterinarycenter_logo_right_padding}px;
	}
	";

	// Header colors
	$custom_css .= "
	header.site-header .site-title {
		color: " . esc_attr(get_theme_mod('topheader_sitetitlecol')) . ";
	}
	header.site-header .site-logo a {
		text-decoration-color: " . esc_attr(get_theme_mod('topheader_sitetitlecol')) . " !important;
	}
	p.site-description {
		color: " . esc_attr(get_theme_mod('topheader_taglinecol')) . ";
	}
	


	header .tphead {
		background-image: linear-gradient(90deg, " . esc_attr(get_theme_mod('topheader_bgcolor1')) . " 15%, " . esc_attr(get_theme_mod('topheader_bgcolor2')) . " 95%);
	}
	
	header .tphead .phbx a {
		color: " . esc_attr(get_theme_mod('topheader_phoneemergencytext_color')) . ";
	}

	header .tphead .phbx a:hover {
		color: " . esc_attr(get_theme_mod('topheader_phoneemergencytexthovr_color')) . ";
	}

	header .tphead .timebx p {
		color: " . esc_attr(get_theme_mod('topheader_datetimetext_color')) . ";
	}

	header .tphead .socialbx li a {
		color: " . esc_attr(get_theme_mod('topheader_socialicons_color')) . ";
	}

	header .tphead .socialbx li a:hover {
		color: " . esc_attr(get_theme_mod('topheader_socialiconshvr_color')) . ";
	}

	.main-header .navbar .navbar-menu ul li a, 
	.main-header .navbar .navbar-menu ul li.dropdown>a::after {
		color: " . esc_attr(get_theme_mod('header_menuscolor')) . ";
	}
	.main-header .navbar .navbar-nav > li:hover a, 
	.main-header .navbar .navbar-nav > li.focus a, 
	.main-header .navbar .navbar-nav > li.active a, 
	.main-header .navbar .navbar-nav > li a.active,
	.main-header .navbar .navbar-menu ul li:hover.dropdown>a::after {
		color: " . esc_attr(get_theme_mod('header_menushovercolor')) . ";
	}
	.main-header .navbar .navbar-menu ul li.dropdown .sub-menu a:not(.remove) {
		color: " . esc_attr(get_theme_mod('header_submenutextcolor')) . ";
	}
	.main-header .navbar .navbar-menu ul li.dropdown .sub-menu a {
		background: " . esc_attr(get_theme_mod('header_submenusbgcolor')) . ";
	}
	.main-header .navbar .navbar-menu ul li.dropdown .sub-menu a:not(.remove) {
		border-left-color: " . esc_attr(get_theme_mod('header_submenusbordercolor')) . ";
	}
	.main-header .navbar .navbar-menu ul li.dropdown .sub-menu a:hover {
		background: " . esc_attr(get_theme_mod('header_submenusbghovercolor')) . " !important;
		color: " . esc_attr(get_theme_mod('header_submenustxthovercolor')) . ";
	}
	
	header .phonenumber a {
		color: " . esc_attr(get_theme_mod('header_buttontextcolor')) . ";
	}

	header .phonenumber a:hover {
		color: " . esc_attr(get_theme_mod('header_buttontexthvrcolor')) . ";
	}

	header .phonenumber a {
		background-image: linear-gradient(90deg, " . esc_attr(get_theme_mod('header_buttonbgcolor1')) . " 10%, " . esc_attr(get_theme_mod('header_buttonbgcolor2')) . " 95%);
	}
	
	";

	// Slider
	$custom_css .= "
	.slider-area .slide-title h3, 
	.slider-area .slide-title h3:after {
		color: " . esc_attr(get_theme_mod('slider_subtitlecolor')) . " !important;
	}
	.hero-style .slide-title h2 {
		color: " . esc_attr(get_theme_mod('slider_titlecolor')) . " !important;
	}
	.hero-style .slide-text p {
		color: " . esc_attr(get_theme_mod('slider_descriptioncolor')) . ";
	}

	.hero-style a.btn-bookappoint {
		color: " . esc_attr(get_theme_mod('slider_btn1textcolor')) . ";
	}

	.hero-style a.btn-bookappoint:hover {
		color: " . esc_attr(get_theme_mod('slider_btn1texthvrcolor')) . ";
	}
	
	.hero-style a.btn-bookappoint {
		background-image: linear-gradient(90deg, " . esc_attr(get_theme_mod('slider_btntxtbgcolor1')) . " 22%, " . esc_attr(get_theme_mod('slider_btntxtbgcolor2')) . " 95%);
	}

	.hero-style a.btn-exploreservices {
		color: " . esc_attr(get_theme_mod('slider_btn2textcolor')) . ";
		border-color: " . esc_attr(get_theme_mod('slider_btn2textcolor')) . ";
	}

	.hero-style a.btn-exploreservices:hover {
		color: " . esc_attr(get_theme_mod('slider_btn2texthvrcolor')) . ";
	}
	
	.hero-slider .pet_care_veterinary_centerswiper-button-prev i, 
	.hero-slider .pet_care_veterinary_centerswiper-button-next i {
		color: " . esc_attr(get_theme_mod('slider_arrowiconcolor')) . " !important;
	}
	.hero-slider .pet_care_veterinary_centerswiper-button-prev, 
	.hero-slider .pet_care_veterinary_centerswiper-button-next {
		background: " . esc_attr(get_theme_mod('slider_arrowiconbgcolor')) . " !important;
	}
	.hero-slider .pet_care_veterinary_centerswiper-button-prev:hover i,
	.hero-slider .pet_care_veterinary_centerswiper-button-next:hover i {
		color: " . esc_attr(get_theme_mod('slider_arrowiconhrvcolor')) . " !important;
	}
	";

	// Feature
	$custom_css .= "
	#feature-section .headingbx h6 {
		color: " . esc_attr(get_theme_mod('feature_head_subheading_color')) . ";
	}
	#feature-section .headingbx h4 {
		color: " . esc_attr(get_theme_mod('feature_head_heading_color')) . ";
	}
	#feature-section .headingbx p {
		color: " . esc_attr(get_theme_mod('feature_head_description_color')) . ";
	}
	#feature-section .box-space i {
		color: " . esc_attr(get_theme_mod('feature_iconcolor')) . ";
	}
	#feature-section .box-space h3 {
		color: " . esc_attr(get_theme_mod('feature_titlecolor')) . ";
	}
	#feature-section .box-space p {
		color: " . esc_attr(get_theme_mod('feature_descriptioncolor')) . ";
	}
	";

	// Our Service
	$custom_css .= "
	#ourservice-section .headingbx h6 {
		color: " . esc_attr(get_theme_mod('ourservice_subheadingcolor')) . ";
	}
	#ourservice-section .headingbx h4 {
		color: " . esc_attr(get_theme_mod('ourservice_head_headingcolor')) . ";
	}
	#ourservice-section .headingbx p {
		color: " . esc_attr(get_theme_mod('ourservice_head_descriptioncolor')) . ";
	}
	#ourservice-section .ourtbx .sercontbx h3 {
		color: " . esc_attr(get_theme_mod('ourservice_headingcolor')) . ";
	}
	#ourservice-section .sercontbx p {
		color: " . esc_attr(get_theme_mod('ourservice_descriptioncolor')) . ";
	}
	
	#ourservice-section .bttn a {
		color: " . esc_attr(get_theme_mod('ourservice_btncolor')) . ";
	}

	";

	// About us
	$custom_css .= "
	#aboutus-section .abt-dscbx .num, #aboutus-section .abt-dscbx .numtxt {
		color: " . esc_attr(get_theme_mod('aboutus_yearofexpnumcolor')) . ";
	}
	#aboutus-section .abt-dscbx {
		background-image: linear-gradient(144deg, " . esc_attr(get_theme_mod('aboutus_yearofexpnumbgcolor')) . " 0%, " . esc_attr(get_theme_mod('aboutus_yearofexpnumbg2color')) . " 71%);
	}
	#aboutus-section .abt-subtitle h4 {
		color: " . esc_attr(get_theme_mod('aboutus_subtitlecolor')) . ";
	}
	#aboutus-section .abt-dbx h2 {
		color: " . esc_attr(get_theme_mod('aboutus_titlecolor')) . ";
	}
	#aboutus-section .abt-box, #aboutus-section .abt-box p {
		color: " . esc_attr(get_theme_mod('aboutus_descriptioncolor')) . ";
	}
	#aboutus-section .icnbx i {
		color: " . esc_attr(get_theme_mod('aboutus_listiconcolor')) . ";
	}
	#aboutus-section .conbx h5 {
		color: " . esc_attr(get_theme_mod('aboutus_listcolor')) . ";
	}
	#aboutus-section .conbx p {
		color: " . esc_attr(get_theme_mod('aboutus_listtextcolor')) . ";
	}
	#aboutus-section .abtbtn a {
		color: " . esc_attr(get_theme_mod('aboutus_btntextcolor')) . ";
		background: " . esc_attr(get_theme_mod('aboutus_btnbgcolor')) . ";
	}
	#aboutus-section .abtbtn a:hover {
		color: " . esc_attr(get_theme_mod('aboutus_btntexthvrcolor')) . ";
	}
	
	";

	// Footer
	$custom_css .= "
	.footer-area {
		background: " . esc_attr(get_theme_mod('footer_bgcolor')) . ";
	}
	.copy-right p,.copy-right p a {
		color: " . esc_attr(get_theme_mod('footer_copyrightcolor')) . ";
	}
	.copy-right {
		border-color: " . esc_attr(get_theme_mod('footer_copyrightbrdcolor')) . ";
	}
	.footer-area .footer-widget .w-title {
		color: " . esc_attr(get_theme_mod('footer_widgettilecolor')) . ";
	}
	.footer-area .widget_text, .footer-area .widget_text p, .wp-block-latest-comments__comment-excerpt p, 
	.wp-block-latest-comments__comment-date, 
	.has-avatars .wp-block-latest-comments__comment .wp-block-latest-comments__comment-excerpt, 
	.has-avatars .wp-block-latest-comments__comment .wp-block-latest-comments__comment-meta,
	.footer-area .widget_block h1, 
	.footer-area .widget_block h2, 
	.footer-area .widget_block h3, 
	.footer-area .widget_block h4, 
	.footer-area .widget_block h5, 
	.footer-area .widget_block h6,
	.footer-area .footer-widget .widget:not(.widget_social_widget):not(.widget_tag_cloud) li a {
		color: " . esc_attr(get_theme_mod('footer_textcolor')) . ";
	}
	.footer-area li:before, 
	.page-template-home-template .footer-area li:before, 
	.page .footer-area li:before, 
	.single .footer-area li:before {
		color: " . esc_attr(get_theme_mod('footer_iconcolor')) . ";
	}
	.footer-area .footer-widget .widget:not(.widget_social_widget):not(.widget_tag_cloud) li a:hover {
		color: " . esc_attr(get_theme_mod('footer_listhovercolor')) . ";
	}
	.scroll-top i {
		color: " . esc_attr(get_theme_mod('footer_scrolltotopiconcolor')) . ";
	}
	.scroll-top {
		background: " . esc_attr(get_theme_mod('footer_scrolltotopiconbgcolor')) . ";
	}
	.scroll-top:hover {
		background: " . esc_attr(get_theme_mod('footer_scrolltotopiconbghrvcolor')) . ";
	}
	";

	// Header text
	if ( ! display_header_text() ) {
		$custom_css .= "
		.site-title,
		.site-description {
			position: absolute;
			clip: rect(1px,1px,1px,1px);
		}";
	} else {
		$custom_css .= "
		.breadcrumb-section h1, .breadcrumb-list li a, .breadcrumb-list li, breadcrumb-list span{
			color: #{$header_text_color} !important;
		}";
	}

	// Section disable
	if ( $feature_disable_section == 1 ) {
		$custom_css .= "#feature-section { display: none; }";
	} else {
		$custom_css .= "#feature-section { display: block; }";
	}
	if ( $ourservice_disable_section == 1 ) {
		$custom_css .= "#ourservice-section { display: none; }";
	} else {
		$custom_css .= "#ourservice-section { display: block; }";
	}
	if ( $aboutus_disable_section == 1 ) {
		$custom_css .= "#aboutus-section { display: none; }";
	} else {
		$custom_css .= "#aboutus-section { display: block; }";
	}

	// Add inline style
	if ( ! empty( $custom_css ) ) {
		wp_add_inline_style( 'petcareveterinarycenter-style', $custom_css );
	}
}
endif;
add_action( 'wp_enqueue_scripts', 'petcareveterinarycenter_header_style' );
