<?php
function petcareveterinarycenter_blog_setting( $wp_customize ) {
$selective_refresh = isset( $wp_customize->selective_refresh ) ? 'postMessage' : 'refresh';
	$wp_customize->add_panel(
		'petcareveterinarycenter_frontpage_sections', array(
			'priority' => 32,
			'title' => esc_html__( 'Frontpage Sections', 'pet-care-veterinary-center' ),
		)
	);
	

	/*=========================================
	Slider Section
	=========================================*/
	$wp_customize->add_section(
		'slider_setting', array(
			'title' => esc_html__( 'Slider Section', 'pet-care-veterinary-center' ),
			'description'=> __('<a>Note :</a> Image Size Should Be 800*800','pet-care-veterinary-center'),
			'priority' => 1,
			'panel' => 'petcareveterinarycenter_frontpage_sections',
		)
	);


	$wp_customize->add_setting('petcareveterinarycenter_slider_tabs', array(
	   'sanitize_callback' => 'wp_kses_post',
	));

	$wp_customize->add_control(new petcareveterinarycenter_Tab_Control($wp_customize, 'petcareveterinarycenter_slider_tabs', array(
	   'section' => 'slider_setting',
	   'priority' => 2,
	   'buttons' => array(
	      array(
         	'name' => esc_html__('General', 'pet-care-veterinary-center'),
            'icon' => 'dashicons dashicons-welcome-write-blog',
            'fields' => array(
				'slider_trusttext',
				'slider_subtitle',
            	'slider1',
            	'slider2',
            	'slider3',
            	'slider4',
            	'slider5',
            	'slider6',
				'slider_btntext1',
				'slider_btnlink1',
				'slider_btntext2',
				'slider_btnlink2',
				'slider_phonetext',
				'slider_phonenumber'
            ),
            'active' => true,
         ), 
	      array(
            'name' => esc_html__('Style', 'pet-care-veterinary-center'),
        	'icon' => 'dashicons dashicons-art',
            'fields' => array(
				'slider_subtitlecolor',
                'slider_titlecolor',
                'slider_descriptioncolor',
                'slider_btn1textcolor',
				'slider_btn1texthvrcolor',
				'slider_btntxtbgcolor1',
				'slider_btntxtbgcolor2',
				'slider_btn2textcolor',
				'slider_btn2texthvrcolor',
				'slider_arrowiconcolor',
				'slider_arrowiconbgcolor',
				'slider_arrowiconhrvcolor'

            ),
     	)
	    
    	),
	))); 


	

	// General Tab

	// slider trusttext
	$slidertrusttext = esc_html__('🎉 Trusted by 10,000+ Pet Parents', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'slider_trusttext',
    	array(
			'default' => $slidertrusttext,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 7,
		)
	);	

	$wp_customize->add_control( 
		'slider_trusttext',
		array(
		    'label'   		=> __('Trust Text','pet-care-veterinary-center'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	// slider subtitle
	$slidersubtitle = esc_html__('Home Repair Services', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'slider_subtitle',
    	array(
			'default' => $slidersubtitle,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 7,
		)
	);	

	$wp_customize->add_control( 
		'slider_subtitle',
		array(
		    'label'   		=> __('Sub Title','pet-care-veterinary-center'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	// Slider 1
	$wp_customize->add_setting( 
    	'slider1',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'slider1',
		array(
		    'label'   		=> __('Slider 1','pet-care-veterinary-center'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);		



	// Slider 2
	$wp_customize->add_setting(
    	'slider2',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'slider2',
		array(
		    'label'   		=> __('Slider 2','pet-care-veterinary-center'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);	


	// Slider 3
	$wp_customize->add_setting(
    	'slider3',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 5,
		)
	);	

	$wp_customize->add_control( 
		'slider3',
		array(
		    'label'   		=> __('Slider 3','pet-care-veterinary-center'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);	


	// Slider 4
	$wp_customize->add_setting(
    	'slider4',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 6,
		)
	);	

	$wp_customize->add_control( 
		'slider4',
		array(
		    'label'   		=> __('Slider 4','pet-care-veterinary-center'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);



	// Slider 5
	$wp_customize->add_setting(
    	'slider5',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 7,
		)
	);	

	$wp_customize->add_control( 
		'slider5',
		array(
		    'label'   		=> __('Slider 5','pet-care-veterinary-center'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);

	// Slider 6
	$wp_customize->add_setting(
    	'slider6',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 7,
		)
	);	

	$wp_customize->add_control( 
		'slider6',
		array(
		    'label'   		=> __('Slider 6','pet-care-veterinary-center'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);

	// slider btntext1
	$sliderbtntext1 = esc_html__('Book Appointment', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'slider_btntext1',
    	array(
			'default' => $sliderbtntext1,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 7,
		)
	);	

	$wp_customize->add_control( 
		'slider_btntext1',
		array(
		    'label'   		=> __('Button 1 Text','pet-care-veterinary-center'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);


	// slider btnlink1
	$sliderbtnlink1 = esc_html__('#', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'slider_btnlink1',
    	array(
			'default' => $sliderbtnlink1,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 7,
		)
	);	

	$wp_customize->add_control( 
		'slider_btnlink1',
		array(
		    'label'   		=> __('Button 1 Link','pet-care-veterinary-center'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	// slider btntext2
	$sliderbtntext2 = esc_html__('Explore Services', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'slider_btntext2',
    	array(
			'default' => $sliderbtntext2,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 7,
		)
	);	

	$wp_customize->add_control( 
		'slider_btntext2',
		array(
		    'label'   		=> __('Button 2 Text','pet-care-veterinary-center'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);


	// slider btnlink2
	$sliderbtnlink2 = esc_html__('#', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'slider_btnlink2',
    	array(
			'default' => $sliderbtnlink2,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 7,
		)
	);	

	$wp_customize->add_control( 
		'slider_btnlink2',
		array(
		    'label'   		=> __('Button 2 Link','pet-care-veterinary-center'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	// slider phonetext
	$sliderphonetext = esc_html__('24/7 Emergency', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'slider_phonetext',
    	array(
			'default' => $sliderphonetext,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 7,
		)
	);	

	$wp_customize->add_control( 
		'slider_phonetext',
		array(
		    'label'   		=> __('Phone Text','pet-care-veterinary-center'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	// slider phonenumber
	$sliderphonenumber = esc_html__('(555) 123-4567', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'slider_phonenumber',
    	array(
			'default' => $sliderphonenumber,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 7,
		)
	);	

	$wp_customize->add_control( 
		'slider_phonenumber',
		array(
		    'label'   		=> __('Phone Number','pet-care-veterinary-center'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);



	// Style setting

	// slider subtitle Color
	$slidersubtitlecolor = esc_html__('#4BB7A8', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'slider_subtitlecolor',
    	array(
			'default' => $slidersubtitlecolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'slider_subtitlecolor',
		array(
		    'label'   		=> __('Sub Title Color','pet-care-veterinary-center'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// slider title Color
	$slidertitlecolor = esc_html__('#000', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'slider_titlecolor',
    	array(
			'default' => $slidertitlecolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'slider_titlecolor',
		array(
		    'label'   		=> __('Title Color','pet-care-veterinary-center'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);


	// slider description Color
	$sliderdescriptioncolor = esc_html__('#717182', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'slider_descriptioncolor',
    	array(
			'default' => $sliderdescriptioncolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'slider_descriptioncolor',
		array(
		    'label'   		=> __('Description Color','pet-care-veterinary-center'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// slider btn1text Color
	$sliderbtn1textcolor = esc_html__('#fff', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'slider_btn1textcolor',
    	array(
			'default' => $sliderbtn1textcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'slider_btn1textcolor',
		array(
		    'label'   		=> __('Button 1 Text Color','pet-care-veterinary-center'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// slider btn1texthvr Color
	$sliderbtn1texthvrcolor = esc_html__('#000', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'slider_btn1texthvrcolor',
    	array(
			'default' => $sliderbtn1texthvrcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'slider_btn1texthvrcolor',
		array(
		    'label'   		=> __('Button 1 Text Hover Color','pet-care-veterinary-center'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// slider btntxtbgcolor1 Color
	$sliderbtntxtbgcolor1= esc_html__('#4bb7a8', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'slider_btntxtbgcolor1',
    	array(
			'default' => $sliderbtntxtbgcolor1,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'slider_btntxtbgcolor1',
		array(
		    'label'   		=> __('Button BG Color 1','pet-care-veterinary-center'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// slider btntxtbgcolor2 Color
	$sliderbtntxtbgcolor2= esc_html__('#42a5f5', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'slider_btntxtbgcolor2',
    	array(
			'default' => $sliderbtntxtbgcolor2,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'slider_btntxtbgcolor2',
		array(
		    'label'   		=> __('Button BG Color 2','pet-care-veterinary-center'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// slider btn2text Color
	$sliderbtn2textcolor = esc_html__('#ffa726', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'slider_btn2textcolor',
    	array(
			'default' => $sliderbtn2textcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'slider_btn2textcolor',
		array(
		    'label'   		=> __('Button 2 Text Color','pet-care-veterinary-center'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// slider btn2texthvr Color
	$sliderbtn2texthvrcolor = esc_html__('#000', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'slider_btn2texthvrcolor',
    	array(
			'default' => $sliderbtn2texthvrcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'slider_btn2texthvrcolor',
		array(
		    'label'   		=> __('Button 2 Text Hover Color','pet-care-veterinary-center'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);
	


	// slider arrowicon Color
	$sliderarrowiconcolor = esc_html__('#fff', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'slider_arrowiconcolor',
    	array(
			'default' => $sliderarrowiconcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'slider_arrowiconcolor',
		array(
		    'label'   		=> __('Arrows Icon Color','pet-care-veterinary-center'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// slider arrowiconbg Color
	$sliderarrowiconbgcolor = esc_html__('#182333', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'slider_arrowiconbgcolor',
    	array(
			'default' => $sliderarrowiconbgcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'slider_arrowiconbgcolor',
		array(
		    'label'   		=> __('Arrows Icon BG Color','pet-care-veterinary-center'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// slider arrowiconhrv Color
	$sliderarrowiconhrvcolor = esc_html__('#ffa726', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'slider_arrowiconhrvcolor',
    	array(
			'default' => $sliderarrowiconhrvcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'slider_arrowiconhrvcolor',
		array(
		    'label'   		=> __('Arrows Icon Hover Color','pet-care-veterinary-center'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);
	

	/*=========================================
	aboutus Section
	=========================================*/
	$wp_customize->add_section(
		'aboutus_setting', array(
			'title' => esc_html__( 'AboutUs Section', 'pet-care-veterinary-center' ),
			'priority' => 2,
			'panel' => 'petcareveterinarycenter_frontpage_sections',
		)
	);

	$wp_customize->add_setting('petcareveterinarycenter_aboutus_tabs', array(
	   'sanitize_callback' => 'wp_kses_post',
	));

	$wp_customize->add_control(new petcareveterinarycenter_Tab_Control($wp_customize, 'petcareveterinarycenter_aboutus_tabs', array(
	   'section' => 'aboutus_setting',
	   'priority' => 2,
	   'buttons' => array(
	      array(
         	'name' => esc_html__('General', 'pet-care-veterinary-center'),
            'icon' => 'dashicons dashicons-welcome-write-blog',
            'fields' => array(
				'aboutus_disable_section',
				'aboutus_image',
				'aboutus_yearofexperience_number',
				'aboutus_subtitle',
				'aboutus_title',
				'aboutus_description',
				'aboutus_description2',
				'aboutus_list1',
				'aboutus_list1text',
				'aboutus_list2',
				'aboutus_list2text',
				'aboutus_list3',
				'aboutus_list3text',
				'aboutus_list4',
				'aboutus_list4text',
				'aboutus_btn_text',
				'aboutus_btn_link'
            ),
            'active' => true,
		),
		array(
		'name' => esc_html__('Style', 'pet-care-veterinary-center'),
		'icon' => 'dashicons dashicons-art',
		'fields' => array(
			'aboutus_yearofexpnumcolor',
			'aboutus_yearofexpnumbgcolor',
			'aboutus_yearofexpnumbg2color',
			'aboutus_subtitlecolor',
			'aboutus_titlecolor',
			'aboutus_descriptioncolor',
			'aboutus_listiconcolor',
			'aboutus_listcolor',
			'aboutus_listtextcolor',
			'aboutus_btntextcolor',
			'aboutus_btnbgcolor',
			'aboutus_btntexthvrcolor'
		),
     	)
    	),
	))); 


	// hide show aboutus section
	$wp_customize->add_setting(
        'aboutus_disable_section',
        array(
            'sanitize_callback' => 'wp_kses_post',
        )
    ); 
    $wp_customize->add_control(
        new petcareveterinarycenter_Toggle_Switch_Custom_Control(
            $wp_customize,
            'aboutus_disable_section',
            array(
                'settings'      => 'aboutus_disable_section',
                'section'       => 'aboutus_setting',
                'label'         => __( 'Disable Section', 'pet-care-veterinary-center' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'pet-care-veterinary-center' ),
                    'off' => __( 'No', 'pet-care-veterinary-center' )
                ),
            )
        )
    );

	// aboutus_image
	$wp_customize->add_setting(
    	'aboutus_image',
	    array(
	        'sanitize_callback' => 'esc_url_raw'
	    )
	);
	$wp_customize->add_control(
	    new WP_Customize_Image_Control(
	        $wp_customize,
	        'aboutus_image',
	        array(
			    'label'   		=> __('Image 1','pet-care-veterinary-center'),
				'description'=> __('Image Size Should Be 1080*608','pet-care-veterinary-center'),
	            'section' => 'aboutus_setting',
	            'settings' => 'aboutus_image'
	        )
	    )
	);

	// aboutus_yearofexperience_number
	$wp_customize->add_setting(
    	'aboutus_yearofexperience_number',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_yearofexperience_number',
		array(
		    'label'   		=> __('Year Of Experience Number','pet-care-veterinary-center'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);


	// aboutus_subtitle
	$wp_customize->add_setting(
    	'aboutus_subtitle',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_subtitle',
		array(
		    'label'   		=> __('Sub Title','pet-care-veterinary-center'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	

	// aboutus_title
	$wp_customize->add_setting(
    	'aboutus_title',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_title',
		array(
		    'label'   		=> __('Title','pet-care-veterinary-center'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	

	// aboutus_description
	$wp_customize->add_setting(
    	'aboutus_description',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_description',
		array(
		    'label'   		=> __('Description','pet-care-veterinary-center'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	

	// aboutus_description2
	$wp_customize->add_setting(
    	'aboutus_description2',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_description2',
		array(
		    'label'   		=> __('Description 2','pet-care-veterinary-center'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	

	// aboutus_list1
	$wp_customize->add_setting(
    	'aboutus_list1',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_list1',
		array(
		    'label'   		=> __('List 1','pet-care-veterinary-center'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	

	// aboutus_list1text
	$wp_customize->add_setting(
    	'aboutus_list1text',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_list1text',
		array(
		    'label'   		=> __('List 1 Text','pet-care-veterinary-center'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	

	// aboutus_list2
	$wp_customize->add_setting(
    	'aboutus_list2',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_list2',
		array(
		    'label'   		=> __('List 2','pet-care-veterinary-center'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	

	// aboutus_list2text
	$wp_customize->add_setting(
    	'aboutus_list2text',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_list2text',
		array(
		    'label'   		=> __('List 2 Text','pet-care-veterinary-center'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	

	// aboutus_list3
	$wp_customize->add_setting(
    	'aboutus_list3',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_list3',
		array(
		    'label'   		=> __('List 3','pet-care-veterinary-center'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	

	// aboutus_list3text
	$wp_customize->add_setting(
    	'aboutus_list3text',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_list3text',
		array(
		    'label'   		=> __('List 3 Text','pet-care-veterinary-center'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	

	// aboutus_list4
	$wp_customize->add_setting(
    	'aboutus_list4',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_list4',
		array(
		    'label'   		=> __('List 4','pet-care-veterinary-center'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	

	// aboutus_list4text
	$wp_customize->add_setting(
    	'aboutus_list4text',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_list4text',
		array(
		    'label'   		=> __('List 4 Text','pet-care-veterinary-center'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	
	
	// aboutus_btn_text
	$wp_customize->add_setting(
    	'aboutus_btn_text',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_btn_text',
		array(
		    'label'   		=> __('Button Text','pet-care-veterinary-center'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	
	
	// aboutus btn link
	$wp_customize->add_setting(
    	'aboutus_btn_link',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_btn_link',
		array(
		    'label'   		=> __('Button Link','pet-care-veterinary-center'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	
	//style

	// aboutus yearofexpnum Color
	$aboutusyearofexpnumcolor = esc_html__('#fff', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'aboutus_yearofexpnumcolor',
    	array(
			'default' => $aboutusyearofexpnumcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_yearofexpnumcolor',
		array(
		    'label'   		=> __('Year of Exprience Number Color','pet-care-veterinary-center'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// aboutus yearofexpnumbg Color
	$aboutusyearofexpnumbgcolor = esc_html__('#ffa726', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'aboutus_yearofexpnumbgcolor',
    	array(
			'default' => $aboutusyearofexpnumbgcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_yearofexpnumbgcolor',
		array(
		    'label'   		=> __('Year of Exprience Number BG Color 1','pet-care-veterinary-center'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// aboutus yearofexpnumbg2 Color
	$aboutusyearofexpnumbg2color = esc_html__('#f06292', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'aboutus_yearofexpnumbg2color',
    	array(
			'default' => $aboutusyearofexpnumbg2color,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_yearofexpnumbg2color',
		array(
		    'label'   		=> __('Year of Exprience Number BG Color 2','pet-care-veterinary-center'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);


	// aboutus subtitle Color
	$aboutussubtitlecolor = esc_html__('#000', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'aboutus_subtitlecolor',
    	array(
			'default' => $aboutussubtitlecolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_subtitlecolor',
		array(
		    'label'   		=> __('Sub Title Color','pet-care-veterinary-center'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// aboutus title Color
	$aboutustitlecolor = esc_html__('#182333', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'aboutus_titlecolor',
    	array(
			'default' => $aboutustitlecolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_titlecolor',
		array(
		    'label'   		=> __('Title Color','pet-care-veterinary-center'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);


	// aboutus description Color
	$aboutusdescriptioncolor = esc_html__('#696868', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'aboutus_descriptioncolor',
    	array(
			'default' => $aboutusdescriptioncolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_descriptioncolor',
		array(
		    'label'   		=> __('Description Color','pet-care-veterinary-center'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// aboutus listicon Color
	$aboutuslistcolor = esc_html__('#FDA12B', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'aboutus_listiconcolor',
    	array(
			'default' => $aboutuslistcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_listiconcolor',
		array(
		    'label'   		=> __('List Icon Color','pet-care-veterinary-center'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// aboutus list Color
	$aboutuslistcolor = esc_html__('#000', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'aboutus_listcolor',
    	array(
			'default' => $aboutuslistcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_listcolor',
		array(
		    'label'   		=> __('List Color','pet-care-veterinary-center'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// aboutus listtext Color
	$aboutuslisttextcolor = esc_html__('#717182', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'aboutus_listtextcolor',
    	array(
			'default' => $aboutuslisttextcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_listtextcolor',
		array(
		    'label'   		=> __('List Text Color','pet-care-veterinary-center'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// aboutus btntext Color
	$aboutusbtntextcolor = esc_html__('#fff', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'aboutus_btntextcolor',
    	array(
			'default' => $aboutusbtntextcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_btntextcolor',
		array(
		    'label'   		=> __('Button Text Color','pet-care-veterinary-center'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// aboutus btnbg Color
	$aboutusbtnbgcolor = esc_html__('#FDA12B', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'aboutus_btnbgcolor',
    	array(
			'default' => $aboutusbtnbgcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_btnbgcolor',
		array(
		    'label'   		=> __('Button BG Color','pet-care-veterinary-center'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	
	// aboutus btntexthvr Color
	$aboutusbtntexthvrcolor = esc_html__('#000', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'aboutus_btntexthvrcolor',
    	array(
			'default' => $aboutusbtntexthvrcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_btntexthvrcolor',
		array(
		    'label'   		=> __('Button Text Color','pet-care-veterinary-center'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	

	/*=========================================
	feature Section
	=========================================*/
	$wp_customize->add_section(
		'feature_setting', array(
			'title' => esc_html__( 'Feature Section', 'pet-care-veterinary-center' ),
			'priority' => 2,
			'panel' => 'petcareveterinarycenter_frontpage_sections',
		)
	);
	

	$wp_customize->add_setting('petcareveterinarycenter_feature_tabs', array(
	   'sanitize_callback' => 'wp_kses_post',
	));

	$wp_customize->add_control(new petcareveterinarycenter_Tab_Control($wp_customize, 'petcareveterinarycenter_feature_tabs', array(
	   'section' => 'feature_setting',
	   'priority' => 2,
	   'buttons' => array(
	      array(
         	'name' => esc_html__('General', 'pet-care-veterinary-center'),
            'icon' => 'dashicons dashicons-welcome-write-blog',
            'fields' => array(
            	'feature_disable_section',
				'feature_head_subheading',
				'feature_head_heading',
				'feature_head_description',
            	'feature1',
				'featureicon1',
            	'feature2',
				'featureicon2',
            	'feature3',
				'featureicon3',
				'feature4',
				'featureicon4',
            	'feature5',
				'featureicon5',
            	'feature6',
				'featureicon6'
            ),
            'active' => true,
         ),
	      array(
            'name' => esc_html__('Style', 'pet-care-veterinary-center'),
        	'icon' => 'dashicons dashicons-art',
            'fields' => array(
				'feature_head_subheading_color',
				'feature_head_heading_color',
				'feature_head_description_color',
				'feature_iconcolor',
				'feature_titlecolor',
				'feature_descriptioncolor'
            ),
     	)
	    
    	),
	))); 



	// General

	// hide show feature section
	$wp_customize->add_setting(
        'feature_disable_section',
        array(
            'sanitize_callback' => 'wp_kses_post',
        )
    ); 
    $wp_customize->add_control(
        new petcareveterinarycenter_Toggle_Switch_Custom_Control(
            $wp_customize,
            'feature_disable_section',
            array(
                'settings'      => 'feature_disable_section',
                'section'       => 'feature_setting',
                'label'         => __( 'Disable Section', 'pet-care-veterinary-center' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'pet-care-veterinary-center' ),
                    'off' => __( 'No', 'pet-care-veterinary-center' )
                ),
            )
        )
    );

	// feature_head_subheading
	$wp_customize->add_setting(
    	'feature_head_subheading',
    	array(
			'default' => 'Why Choose Us',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'feature_head_subheading',
		array(
		    'label'   		=> __('Sub Heading','pet-care-veterinary-center'),
		    'section'		=> 'feature_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	

	// feature_head_heading
	$wp_customize->add_setting(
    	'feature_head_heading',
    	array(
			'default' => 'What Makes Us Different',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'feature_head_heading',
		array(
		    'label'   		=> __('Heading','pet-care-veterinary-center'),
		    'section'		=> 'feature_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	

	// feature_head_description
	$wp_customize->add_setting(
    	'feature_head_description',
    	array(
			'default' => 'We combine expertise, compassion, and cutting-edge technology to provide the best possible care for your beloved pets.',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'feature_head_description',
		array(
		    'label'   		=> __('Description','pet-care-veterinary-center'),
		    'section'		=> 'feature_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	

	// feature 1
	$wp_customize->add_setting( 
    	'feature1',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'feature1',
		array(
		    'label'   		=> __('Feature 1','pet-care-veterinary-center'),
		    'section'		=> 'feature_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);		

	// featureicon1
	$wp_customize->add_setting(
		'featureicon1',
		array(
			'default' => 'fa fa-camera',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'featureicon1',
		array(
			'label'   		=> __('Feature 1 Icon','pet-care-veterinary-center'),
			'section'		=> 'feature_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);		

	// feature 2
	$wp_customize->add_setting(
    	'feature2',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 2,
		)
	);	

	$wp_customize->add_control( 
		'feature2',
		array(
		    'label'   		=> __('Feature 2','pet-care-veterinary-center'),
		    'section'		=> 'feature_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);	

	// featureicon2
	$wp_customize->add_setting(
		'featureicon2',
		array(
			'default' => 'fa fa-camera',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'featureicon2',
		array(
			'label'   		=> __('Feature 2 Icon','pet-care-veterinary-center'),
			'section'		=> 'feature_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	// feature 3
	$wp_customize->add_setting(
    	'feature3',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'feature3',
		array(
		    'label'   		=> __('Feature 3','pet-care-veterinary-center'),
		    'section'		=> 'feature_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);	

	// featureicon3
	$wp_customize->add_setting(
		'featureicon3',
		array(
			'default' => 'fa fa-camera',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'featureicon3',
		array(
			'label'   		=> __('Feature 3 Icon','pet-care-veterinary-center'),
			'section'		=> 'feature_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	// feature 4
	$wp_customize->add_setting( 
    	'feature4',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'feature4',
		array(
		    'label'   		=> __('Feature 4','pet-care-veterinary-center'),
		    'section'		=> 'feature_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);		

	// featureicon4
	$wp_customize->add_setting(
		'featureicon4',
		array(
			'default' => 'fa fa-camera',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'featureicon4',
		array(
			'label'   		=> __('Feature 4 Icon','pet-care-veterinary-center'),
			'section'		=> 'feature_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	// feature 5
	$wp_customize->add_setting(
    	'feature5',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 5,
		)
	);	

	$wp_customize->add_control( 
		'feature5',
		array(
		    'label'   		=> __('Feature 5','pet-care-veterinary-center'),
		    'section'		=> 'feature_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);	

	// featureicon5
	$wp_customize->add_setting(
		'featureicon5',
		array(
			'default' => 'fa fa-camera',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'featureicon5',
		array(
			'label'   		=> __('Feature 5 Icon','pet-care-veterinary-center'),
			'section'		=> 'feature_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	// feature 6
	$wp_customize->add_setting(
    	'feature6',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 6,
		)
	);	

	$wp_customize->add_control( 
		'feature6',
		array(
		    'label'   		=> __('Feature 6','pet-care-veterinary-center'),
		    'section'		=> 'feature_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);	

	// featureicon6
	$wp_customize->add_setting(
		'featureicon6',
		array(
			'default' => 'fa fa-camera',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'featureicon6',
		array(
			'label'   		=> __('Feature 6 Icon','pet-care-veterinary-center'),
			'section'		=> 'feature_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);


	// style

	// feature head_subheading_color
	$featurehead_subheading_color = esc_html__('#fff', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'feature_head_subheading_color',
    	array(
			'default' => $featurehead_subheading_color,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'feature_head_subheading_color',
		array(
		    'label'   		=> __('Sub Heading Color','pet-care-veterinary-center'),
		    'section'		=> 'feature_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// feature head_heading_color
	$featurehead_heading_color = esc_html__('#fff', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'feature_head_heading_color',
    	array(
			'default' => $featurehead_heading_color,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'feature_head_heading_color',
		array(
		    'label'   		=> __('Heading Color','pet-care-veterinary-center'),
		    'section'		=> 'feature_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// feature head_description_color
	$featurehead_description_color = esc_html__('#fff', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'feature_head_description_color',
    	array(
			'default' => $featurehead_description_color,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'feature_head_description_color',
		array(
		    'label'   		=> __('Description Color','pet-care-veterinary-center'),
		    'section'		=> 'feature_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// feature icon color
	$featureiconcolor = esc_html__('#f06292', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'feature_iconcolor',
    	array(
			'default' => $featureiconcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'feature_iconcolor',
		array(
		    'label'   		=> __('Icon Color','pet-care-veterinary-center'),
		    'section'		=> 'feature_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// feature title color
	$featuretitlecolor = esc_html__('#fff', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'feature_titlecolor',
    	array(
			'default' => $featuretitlecolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'feature_titlecolor',
		array(
		    'label'   		=> __('Title Color','pet-care-veterinary-center'),
		    'section'		=> 'feature_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// feature description color
	$featuredescriptioncolor = esc_html__('#fff', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'feature_descriptioncolor',
    	array(
			'default' => $featuredescriptioncolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'feature_descriptioncolor',
		array(
		    'label'   		=> __('Description Color','pet-care-veterinary-center'),
		    'section'		=> 'feature_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	
	/*=========================================
	ourservice Section
	=========================================*/
	$wp_customize->add_section(
		'ourservice_setting', array(
			'title' => esc_html__( 'Our Service Section', 'pet-care-veterinary-center' ),
			'priority' => 2,
			'panel' => 'petcareveterinarycenter_frontpage_sections',
		)
	);
	

	$wp_customize->add_setting('petcareveterinarycenter_ourservice_tabs', array(
	   'sanitize_callback' => 'wp_kses_post',
	));

	$wp_customize->add_control(new petcareveterinarycenter_Tab_Control($wp_customize, 'petcareveterinarycenter_ourservice_tabs', array(
	   'section' => 'ourservice_setting',
	   'priority' => 2,
	   'buttons' => array(
	      array(
         	'name' => esc_html__('General', 'pet-care-veterinary-center'),
            'icon' => 'dashicons dashicons-welcome-write-blog',
            'fields' => array(
            	'ourservice_disable_section',
				'ourservice_subtitle',
				'ourservice_title',
				'ourservice_description',
            	'ourservice1',
            	'ourservice2',
            	'ourservice3'
            ),
            'active' => true,
         ),
	      array(
            'name' => esc_html__('Style', 'pet-care-veterinary-center'),
        	'icon' => 'dashicons dashicons-art',
            'fields' => array(
            	'ourservice_subheadingcolor',
				'ourservice_head_headingcolor',
				'ourservice_head_descriptioncolor',
            	'ourservice_headingcolor',
				'ourservice_descriptioncolor',
				'ourservice_btncolor'

            ),
     	)
	    
    	),
	))); 



	// General

	// hide show ourservice section
	$wp_customize->add_setting(
        'ourservice_disable_section',
        array(
            'sanitize_callback' => 'wp_kses_post',
        )
    ); 
    $wp_customize->add_control(
        new petcareveterinarycenter_Toggle_Switch_Custom_Control(
            $wp_customize,
            'ourservice_disable_section',
            array(
                'settings'      => 'ourservice_disable_section',
                'section'       => 'ourservice_setting',
                'label'         => __( 'Disable Section', 'pet-care-veterinary-center' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'pet-care-veterinary-center' ),
                    'off' => __( 'No', 'pet-care-veterinary-center' )
                ),
            )
        )
    );

	// ourservice_subtitle
	$wp_customize->add_setting(
		'ourservice_subtitle',
		array(
			'default' => 'Our Services',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'ourservice_subtitle',
		array(
			'label'   		=> __('Sub Title','pet-care-veterinary-center'),
			'section'		=> 'ourservice_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	

	// ourservice_title
	$wp_customize->add_setting(
		'ourservice_title',
		array(
			'default' => 'Making Your Home Feel New Again',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'ourservice_title',
		array(
			'label'   		=> __('Title','pet-care-veterinary-center'),
			'section'		=> 'ourservice_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	

	// ourservice_description
	$wp_customize->add_setting(
		'ourservice_description',
		array(
			'default' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Ipsum has been the indust specimen book.',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'ourservice_description',
		array(
			'label'   		=> __('Description','pet-care-veterinary-center'),
			'section'		=> 'ourservice_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	

	// ourservice 1
	$wp_customize->add_setting( 
    	'ourservice1',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'ourservice1',
		array(
		    'label'   		=> __('Our Service 1','pet-care-veterinary-center'),
		    'section'		=> 'ourservice_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);		

	// ourservice 2
	$wp_customize->add_setting(
    	'ourservice2',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 2,
		)
	);	

	$wp_customize->add_control( 
		'ourservice2',
		array(
		    'label'   		=> __('Our Service 2','pet-care-veterinary-center'),
		    'section'		=> 'ourservice_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);	


	// ourservice 3
	$wp_customize->add_setting(
    	'ourservice3',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'ourservice3',
		array(
		    'label'   		=> __('Our Service 3','pet-care-veterinary-center'),
		    'section'		=> 'ourservice_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);	

	// style

	// ourservice subheading color
	$ourservicesubheadingcolor = esc_html__('#4bb7a8', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'ourservice_subheadingcolor',
    	array(
			'default' => $ourservicesubheadingcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'ourservice_subheadingcolor',
		array(
		    'label'   		=> __('Sub Heading Color','pet-care-veterinary-center'),
		    'section'		=> 'ourservice_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// ourservice head_heading color
	$ourservicehead_headingcolor = esc_html__('#000', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'ourservice_head_headingcolor',
    	array(
			'default' => $ourservicehead_headingcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'ourservice_head_headingcolor',
		array(
		    'label'   		=> __('Heading Color','pet-care-veterinary-center'),
		    'section'		=> 'ourservice_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// ourservice head_description color
	$ourservicehead_descriptioncolor = esc_html__('#000', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'ourservice_head_descriptioncolor',
    	array(
			'default' => $ourservicehead_descriptioncolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'ourservice_head_descriptioncolor',
		array(
		    'label'   		=> __('Description Color','pet-care-veterinary-center'),
		    'section'		=> 'ourservice_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// ourservice heading color
	$ourserviceheadingcolor = esc_html__('#000', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'ourservice_headingcolor',
    	array(
			'default' => $ourserviceheadingcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'ourservice_headingcolor',
		array(
		    'label'   		=> __('Heading Color','pet-care-veterinary-center'),
		    'section'		=> 'ourservice_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// ourservice description color
	$ourservicedescriptioncolor = esc_html__('#000', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'ourservice_descriptioncolor',
    	array(
			'default' => $ourservicedescriptioncolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'ourservice_descriptioncolor',
		array(
		    'label'   		=> __('Description Color','pet-care-veterinary-center'),
		    'section'		=> 'ourservice_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// ourservice boxarrowbg color
	$ourserviceboxarrowbgcolor = esc_html__('#4bb7a8', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'ourservice_btncolor',
    	array(
			'default' => $ourserviceboxarrowbgcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'ourservice_btncolor',
		array(
		    'label'   		=> __('Button Color','pet-care-veterinary-center'),
		    'section'		=> 'ourservice_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	
	$wp_customize->register_control_type('petcareveterinarycenter_Tab_Control');

}

add_action( 'customize_register', 'petcareveterinarycenter_blog_setting' );

// feature selective refresh
function petcareveterinarycenter_blog_section_partials( $wp_customize ){	
	// blog_title
	$wp_customize->selective_refresh->add_partial( 'blog_title', array(
		'selector'            => '.home-blog .title h6',
		'settings'            => 'blog_title',
		'render_callback'  => 'petcareveterinarycenter_blog_title_render_callback',
	
	) );
	
	// blog_subtitle
	$wp_customize->selective_refresh->add_partial( 'blog_subtitle', array(
		'selector'            => '.home-blog .title h2',
		'settings'            => 'blog_subtitle',
		'render_callback'  => 'petcareveterinarycenter_blog_subtitle_render_callback',
	
	) );
	
	// blog_description
	$wp_customize->selective_refresh->add_partial( 'blog_description', array(
		'selector'            => '.home-blog .title p',
		'settings'            => 'blog_description',
		'render_callback'  => 'petcareveterinarycenter_blog_description_render_callback',
	
	) );	
	}

add_action( 'customize_register', 'petcareveterinarycenter_blog_section_partials' );

// blog_title
function petcareveterinarycenter_blog_title_render_callback() {
	return get_theme_mod( 'blog_title' );
}

// blog_subtitle
function petcareveterinarycenter_blog_subtitle_render_callback() {
	return get_theme_mod( 'blog_subtitle' );
}

// feature description
function petcareveterinarycenter_blog_description_render_callback() {
	return get_theme_mod( 'blog_description' );
}


