<?php
function petcareveterinarycenter_header_settings( $wp_customize ) {
$selective_refresh = isset( $wp_customize->selective_refresh ) ? 'postMessage' : 'refresh';
	/*=========================================
	Header Settings Panel
	=========================================*/
	$wp_customize->add_panel( 
		'header_section', 
		array(
			'priority'      => 2,
			'capability'    => 'edit_theme_options',
			'title'			=> __('Header', 'pet-care-veterinary-center'),
		) 
	);

	
	/*=========================================
	Pet Care Veterinary Center Site Identity
	=========================================*/
	$wp_customize->add_section(
        'title_tagline',
        array(
        	'priority'      => 1,
            'title' 		=> __('Site Identity','pet-care-veterinary-center'),
			'panel'  		=> 'header_section',
		)
    );


	// topheader Logo Width
    $wp_customize->add_setting('topheader_logowidth',array(
        'default' => 100,
        'sanitize_callback' => 'petcareveterinarycenter_sanitize_float'
    ));
    $wp_customize->add_control(new petcareveterinarycenter_Custom_Control( $wp_customize, 'topheader_logowidth',array(
	    'label' => __('Logo Width','pet-care-veterinary-center'),
	    'section' => 'title_tagline',
	    'input_attrs' => array(
	            'min' => 0,
	            'max' => 500,
	            'step' => 1,
	        ),
    )));

	
	// logo section padding 
	$wp_customize->add_setting('petcareveterinarycenter_logo_padding',array(
		'sanitize_callback'   => 'esc_html'
	));
	$wp_customize->add_control('petcareveterinarycenter_logo_padding',array(
		'label' => __('Logo Padding','pet-care-veterinary-center'),
		'section' => 'title_tagline'
	));

	$wp_customize->add_setting('petcareveterinarycenter_logo_top_padding',array(
		'default' => '2',
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('petcareveterinarycenter_logo_top_padding',array(
		'type' => 'number',
		'label' => __('Top','pet-care-veterinary-center'),
		'section' => 'title_tagline',
	));

	$wp_customize->add_setting('petcareveterinarycenter_logo_left_padding',array(
		'default' => '2',
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('petcareveterinarycenter_logo_left_padding',array(
		'type' => 'number',
		'label' => __('Left','pet-care-veterinary-center'),
		'section' => 'title_tagline',
	));

	$wp_customize->add_setting('petcareveterinarycenter_logo_bottom_padding',array(
		'default' => '2',
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('petcareveterinarycenter_logo_bottom_padding',array(
		'type' => 'number',
		'label' => __('Bottom','pet-care-veterinary-center'),
		'section' => 'title_tagline',
	));

	$wp_customize->add_setting('petcareveterinarycenter_logo_right_padding',array(
		'default' => '2',
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('petcareveterinarycenter_logo_right_padding',array(
		'type' => 'number',
		'label' => __('Right','pet-care-veterinary-center'),
		'section' => 'title_tagline',
	));


    // top header Site Title Color
	$topheadersitetitlecol = esc_html__('#000', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'topheader_sitetitlecol',
    	array(
			'default' => $topheadersitetitlecol,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'topheader_sitetitlecol',
		array(
		    'label'   		=> __('Site Title Color','pet-care-veterinary-center'),
		    'section'		=> 'title_tagline',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);


	// top header Tagline Color
	$topheadertaglinecol = esc_html__('#293C4B', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'topheader_taglinecol',
    	array(
			'default' => $topheadertaglinecol,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'topheader_taglinecol',
		array(
		    'label'   		=> __('Tagline Color','pet-care-veterinary-center'),
		    'section'		=> 'title_tagline',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);
	
 
	/*=========================================
	Pet Care Veterinary Center header
	=========================================*/
	$wp_customize->add_section(
        'top_header',
        array(
        	'priority'      => 5,
            'title' 		=> __('Header','pet-care-veterinary-center'),
			'panel'  		=> 'header_section',
		)
    );	

	
    $wp_customize->add_setting('petcareveterinarycenter_top_header_tabs', array(
	   'sanitize_callback' => 'wp_kses_post',
	));

	$wp_customize->add_control(new petcareveterinarycenter_Tab_Control($wp_customize, 'petcareveterinarycenter_top_header_tabs', array(
	   'section' => 'top_header',
	   'priority' => 1,
	   'buttons' => array(
	      array(
     		'name' => esc_html__('General', 'pet-care-veterinary-center'),
 			'icon' => 'dashicons dashicons-welcome-write-blog',
            'fields' => array(
            	'hide_show_sticky',
				'topheader_phoneemergencytext',
				'topheader_timedatetext',
				'topheader_fblink',
				'topheader_twitterlink',
				'topheader_pinterestlink',
				'topheader_linkedinlink',
				'topheader_youtubelink',
				'topheader_phone',
				'topheader_phonelink'
            ),
            'active' => true,
         ),
	      array(
            'name' => esc_html__('Style', 'pet-care-veterinary-center'),
            'icon' => 'dashicons dashicons-art',
            'fields' => array(
				'topheader_bgcolor1',
				'topheader_bgcolor2',
				'topheader_phoneemergencytext_color',
				'topheader_phoneemergencytexthovr_color',
				'topheader_datetimetext_color',
				'topheader_socialicons_color',
				'topheader_socialiconshvr_color',
            	'header_menuscolor',
            	'header_menushovercolor',
            	'header_submenusbgcolor',
            	'header_submenusbordercolor',
            	'header_submenutextcolor',
            	'header_submenusbghovercolor',
            	'header_submenustxthovercolor',
				'header_buttontextcolor',
				'header_buttontexthvrcolor',
				'header_buttonbgcolor1',
				'header_buttonbgcolor2'
            ),
         )
	    
    	),
	)));


	// general setting

	// sticky header
	$wp_customize->add_setting( 'hide_show_sticky',array(
        'default' => false,
        'sanitize_callback' => 'petcareveterinarycenter_switch_sanitization'
   	) );
   	$wp_customize->add_control( new petcareveterinarycenter_Toggle_Switch_Custom_Control( $wp_customize, 'hide_show_sticky',array(
        'label' => __( 'Show Sticky Header','pet-care-veterinary-center' ),
        'section' => 'top_header'
   	)));
	
	// topheader phoneemergencytext
	$topheaderphoneemergencytext = esc_html__(' 24/7 Emergency: (555) 123-4567', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'topheader_phoneemergencytext',
    	array(
			'default' => $topheaderphoneemergencytext,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 7,
		)
	);	

	$wp_customize->add_control( 
		'topheader_phoneemergencytext',
		array(
		    'label'   		=> __('Phone Emergency Text','pet-care-veterinary-center'),
		    'section'		=> 'top_header',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	// topheader timedatetext
	$topheadertimedatetext = esc_html__('Mon-Sat: 8AM-8PM | Sun: 9AM-5PM', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'topheader_timedatetext',
    	array(
			'default' => $topheadertimedatetext,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 7,
		)
	);	

	$wp_customize->add_control( 
		'topheader_timedatetext',
		array(
		    'label'   		=> __('Time Date Text','pet-care-veterinary-center'),
		    'section'		=> 'top_header',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	// topheader fblink
	$topheaderfblink = esc_html__('#', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'topheader_fblink',
    	array(
			'default' => $topheaderfblink,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 7,
		)
	);	

	$wp_customize->add_control( 
		'topheader_fblink',
		array(
		    'label'   		=> __('Facebook Link','pet-care-veterinary-center'),
		    'section'		=> 'top_header',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	// topheader twitterlink
	$topheadertwitterlink = esc_html__('#', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'topheader_twitterlink',
    	array(
			'default' => $topheadertwitterlink,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 7,
		)
	);	

	$wp_customize->add_control( 
		'topheader_twitterlink',
		array(
		    'label'   		=> __('Twitter Link','pet-care-veterinary-center'),
		    'section'		=> 'top_header',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	// topheader pinterestlink
	$topheaderpinterestlink = esc_html__('#', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'topheader_pinterestlink',
    	array(
			'default' => $topheaderpinterestlink,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 7,
		)
	);	

	$wp_customize->add_control( 
		'topheader_pinterestlink',
		array(
		    'label'   		=> __('Pinterest Link','pet-care-veterinary-center'),
		    'section'		=> 'top_header',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	// topheader linkedinlink
	$topheaderlinkedinlink = esc_html__('#', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'topheader_linkedinlink',
    	array(
			'default' => $topheaderlinkedinlink,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 7,
		)
	);	

	$wp_customize->add_control( 
		'topheader_linkedinlink',
		array(
		    'label'   		=> __('Linkedin Link','pet-care-veterinary-center'),
		    'section'		=> 'top_header',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	// topheader youtubelink
	$topheaderyoutubelink = esc_html__('#', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'topheader_youtubelink',
    	array(
			'default' => $topheaderyoutubelink,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 7,
		)
	);	

	$wp_customize->add_control( 
		'topheader_youtubelink',
		array(
		    'label'   		=> __('Youtube Link','pet-care-veterinary-center'),
		    'section'		=> 'top_header',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	// topheader phone
	$topheaderphone = esc_html__('Book Now', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'topheader_phone',
    	array(
			'default' => $topheaderphone,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 7,
		)
	);	

	$wp_customize->add_control( 
		'topheader_phone',
		array(
		    'label'   		=> __('Phone Button Text','pet-care-veterinary-center'),
		    'section'		=> 'top_header',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	// topheader phonelink
	$topheaderphonelink = esc_html__('#', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'topheader_phonelink',
    	array(
			'default' => $topheaderphonelink,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 7,
		)
	);	

	$wp_customize->add_control( 
		'topheader_phonelink',
		array(
		    'label'   		=> __('Phone Button Link','pet-care-veterinary-center'),
		    'section'		=> 'top_header',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	// Style setting

	// topheader bg Colo1r
	$topheaderbgcolor1 = esc_html__('#4bb7a8', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'topheader_bgcolor1',
    	array(
			'default' => $topheaderbgcolor1,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'topheader_bgcolor1',
		array(
		    'label'   		=> __('Top Head BG Color 1','pet-care-veterinary-center'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// topheader bgColor2
	$topheaderbgcolor2 = esc_html__('#42a5f5', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'topheader_bgcolor2',
    	array(
			'default' => $topheaderbgcolor2,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'topheader_bgcolor2',
		array(
		    'label'   		=> __('Top Head BG Color 2','pet-care-veterinary-center'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// topheader phoneemergencytext_color
	$topheaderphoneemergencytext_color = esc_html__('#fff', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'topheader_phoneemergencytext_color',
    	array(
			'default' => $topheaderphoneemergencytext_color,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'topheader_phoneemergencytext_color',
		array(
		    'label'   		=> __('Phone Emergency Text Color','pet-care-veterinary-center'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// topheader phoneemergencytexthovr_color
	$topheaderphoneemergencytexthovr_color = esc_html__('#f06292', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'topheader_phoneemergencytexthovr_color',
    	array(
			'default' => $topheaderphoneemergencytexthovr_color,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'topheader_phoneemergencytexthovr_color',
		array(
		    'label'   		=> __('Phone Emergency Text Hover Color','pet-care-veterinary-center'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// topheader datetimetext_color
	$topheaderdatetimetext_color = esc_html__('#fff', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'topheader_datetimetext_color',
    	array(
			'default' => $topheaderdatetimetext_color,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'topheader_datetimetext_color',
		array(
		    'label'   		=> __('Date Time Text Color','pet-care-veterinary-center'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// topheader socialicons_color
	$topheadersocialicons_color = esc_html__('#fff', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'topheader_socialicons_color',
    	array(
			'default' => $topheadersocialicons_color,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'topheader_socialicons_color',
		array(
		    'label'   		=> __('Social Icons Color','pet-care-veterinary-center'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// topheader socialiconshvr_color
	$topheadersocialiconshvr_color = esc_html__('#f06292', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'topheader_socialiconshvr_color',
    	array(
			'default' => $topheadersocialiconshvr_color,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'topheader_socialiconshvr_color',
		array(
		    'label'   		=> __('Social Icons Hover Color','pet-care-veterinary-center'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// header menus Color
	$headermenuscolor = esc_html__('#000', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'header_menuscolor',
    	array(
			'default' => $headermenuscolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'header_menuscolor',
		array(
		    'label'   		=> __('Menus Color','pet-care-veterinary-center'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// header menushover Color
	$headermenushovercolor = esc_html__('#4bb7a8', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'header_menushovercolor',
    	array(
			'default' => $headermenushovercolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'header_menushovercolor',
		array(
		    'label'   		=> __('Menus Hover & Active Color','pet-care-veterinary-center'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	$headersubmenusbgcolor = esc_html__('#fff', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'header_submenusbgcolor',
    	array(
			'default' => $headersubmenusbgcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'header_submenusbgcolor',
		array(
		    'label'   		=> __('SubMenus BG Color','pet-care-veterinary-center'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	$headersubmenusbordercolor = esc_html__('#4bb7a8', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'header_submenusbordercolor',
    	array(
			'default' => $headersubmenusbordercolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'header_submenusbordercolor',
		array(
		    'label'   		=> __('SubMenus Border Color','pet-care-veterinary-center'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);


	// header submenutext Color
	$headersubmenutextcolor = esc_html__('#4bb7a8', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'header_submenutextcolor',
    	array(
			'default' => $headersubmenutextcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'header_submenutextcolor',
		array(
		    'label'   		=> __('SubMenus Text Color','pet-care-veterinary-center'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// header submenusbghover Color
	$headersubmenusbghovercolor = esc_html__('#4bb7a8', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'header_submenusbghovercolor',
    	array(
			'default' => $headersubmenusbghovercolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'header_submenusbghovercolor',
		array(
		    'label'   		=> __('SubMenus BG Hover Color','pet-care-veterinary-center'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// header submenustxthover Color
	$headersubmenustxthovercolor = esc_html__('#fff', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'header_submenustxthovercolor',
    	array(
			'default' => $headersubmenustxthovercolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'header_submenustxthovercolor',
		array(
		    'label'   		=> __('SubMenus Text Hover Color','pet-care-veterinary-center'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);
	
	// header buttontext Color
	$headerbuttontextcolor = esc_html__('#fff', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'header_buttontextcolor',
    	array(
			'default' => $headerbuttontextcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'header_buttontextcolor',
		array(
		    'label'   		=> __('Button Text Color','pet-care-veterinary-center'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// header buttontexthvr Color
	$headerbuttontexthvrcolor = esc_html__('#f06292', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'header_buttontexthvrcolor',
    	array(
			'default' => $headerbuttontexthvrcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'header_buttontexthvrcolor',
		array(
		    'label'   		=> __('Button Text Hover Color','pet-care-veterinary-center'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// header buttonbg Colo1r
	$headerbuttonbgcolor1 = esc_html__('#4bb7a8', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'header_buttonbgcolor1',
    	array(
			'default' => $headerbuttonbgcolor1,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'header_buttonbgcolor1',
		array(
		    'label'   		=> __('Button BG Color 1','pet-care-veterinary-center'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// header buttonbg Colo1r
	$headerbuttonbgcolor2 = esc_html__('#42a5f5', 'pet-care-veterinary-center' );
	$wp_customize->add_setting(
    	'header_buttonbgcolor2',
    	array(
			'default' => $headerbuttonbgcolor2,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'header_buttonbgcolor2',
		array(
		    'label'   		=> __('Button BG Color 2','pet-care-veterinary-center'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);


	$wp_customize->register_control_type('petcareveterinarycenter_Tab_Control');
	$wp_customize->register_panel_type( 'petcareveterinarycenter_WP_Customize_Panel' );
	$wp_customize->register_section_type( 'petcareveterinarycenter_WP_Customize_Section' );

}
add_action( 'customize_register', 'petcareveterinarycenter_header_settings' );



if ( class_exists( 'WP_Customize_Panel' ) ) {
  	class petcareveterinarycenter_WP_Customize_Panel extends WP_Customize_Panel {
	   public $panel;
	   public $type = 'petcareveterinarycenter_panel';
	   public function json() {

	      $array = wp_array_slice_assoc( (array) $this, array( 'id', 'description', 'priority', 'type', 'panel', ) );
	      $array['title'] = html_entity_decode( $this->title, ENT_QUOTES, get_bloginfo( 'charset' ) );
	      $array['content'] = $this->get_content();
	      $array['active'] = $this->active();
	      $array['instanceNumber'] = $this->instance_number;
	      return $array;
    	}
  	}
}

if ( class_exists( 'WP_Customize_Section' ) ) {
  	class petcareveterinarycenter_WP_Customize_Section extends WP_Customize_Section {
	   public $section;
	   public $type = 'petcareveterinarycenter_section';
	   public function json() {

	      $array = wp_array_slice_assoc( (array) $this, array( 'id', 'description', 'priority', 'panel', 'type', 'description_hidden', 'section', ) );
	      $array['title'] = html_entity_decode( $this->title, ENT_QUOTES, get_bloginfo( 'charset' ) );
	      $array['content'] = $this->get_content();
	      $array['active'] = $this->active();
	      $array['instanceNumber'] = $this->instance_number;

	      if ( $this->panel ) {
	        $array['customizeAction'] = sprintf( 'Customizing &#9656; %s', esc_html( $this->manager->get_panel( $this->panel )->title ) );
	      } else {
	        $array['customizeAction'] = 'Customizing';
	      }
	      return $array;
    	}
  	}
}






