<section id="feature-section" class="feature-area home-feature">
    <div class="container">
        <div class="headingbx">
            <h6><?php echo esc_html(get_theme_mod('feature_head_subheading', 'Why Choose Us')); ?></h6>
            <h4><?php echo esc_html(get_theme_mod('feature_head_heading', 'What Makes Us Different')); ?></h4>
            <P><?php echo esc_html(get_theme_mod('feature_head_description', 'We combine expertise, compassion, and cutting-edge technology to provide the best possible care for your beloved pets.')); ?></P>
        </div>
        <div class="ourtbx"> 
            <div class="row m-0">
                <?php for($p=1; $p<11; $p++) { ?>
                    <?php if( get_theme_mod('feature'.$p,false)) { ?>
                    <?php $querycolumns = new WP_query('page_id='.get_theme_mod('feature'.$p,true)); ?>
                    <?php while( $querycolumns->have_posts() ) : $querycolumns->the_post(); 
                ?>
                <div class="box-space">
                    <div class="threebox box<?php echo esc_attr( $p ) ?> <?php if($p % 3 == 0) { echo "last_column"; } ?>">  
                        <div class="single-feature">
                            <i class="<?php echo esc_attr( get_theme_mod( 'featureicon' . $p, 'fa fa-camera' ) ); ?>" aria-hidden="true"></i>
                            
                            <div class="sercontbx">
                                <a href="<?php echo esc_url( get_permalink() ); ?>">
                                    <h3 class="title"><?php the_title_attribute(); ?></h3>
                                    <P>
                                        <?php
                                            if (has_excerpt()) {
                                                echo get_the_excerpt();
                                            } else {
                                                echo get_the_content();
                                            }
                                        ?>  
                                    </P>
                                </a>
                            </div>    		
                        </div>
                        <div class="clear"></div>
                    </div>
                </div>
                <?php endwhile;
            wp_reset_postdata(); ?>
            <?php } } ?>
            <div class="clear"></div> 
            </div>
        </div> 
	</div>
</section>
