<?php if ( get_header_image() ) : ?>
	<a href="<?php echo esc_url( home_url( '/' ) ); ?>" id="custom-header" rel="home">
		<img src="<?php esc_url(header_image()); ?>" width="<?php echo esc_attr( get_custom_header()->width ); ?>" height="<?php echo esc_attr( get_custom_header()->height ); ?>" alt="<?php echo esc_attr(get_bloginfo( 'title' )); ?>">
	</a>	
<?php endif;  ?>
<!-- Header Area -->

	<?php 
		// header
		$topheader_phone = esc_attr(get_theme_mod('topheader_phone','Book Now'));
		$stickyheader = esc_attr(petcareveterinarycenter_sticky_menu());
	?>

<div class="main">
    <header class="main-header site-header <?php echo esc_attr(petcareveterinarycenter_sticky_menu()); ?>">
		<div class="header-section">
			<div class="h-sectionbx">
				<div class="tphead">
					<div class="container">	
						<div class="row m-0">
							<div class="phbx">
								<a> 
									<i class="fa-solid fa-phone"></i> 
									<?php echo esc_html(get_theme_mod('topheader_phoneemergencytext', '24/7 Emergency: (555) 123-4567')); ?>
								</a>
							</div>
							<div class="timebx">
								<p> 
									<?php echo esc_html(get_theme_mod('topheader_timedatetext', 'Mon-Sat: 8AM-8PM | Sun: 9AM-5PM')); ?>
								</p>
							</div>
							<div class="socialbx">
								<li> <a href="<?php echo esc_attr(get_theme_mod('topheader_fblink', '#')); ?>"> <i class="fa-brands fa-facebook-f"></i> </a></li>
								<li> <a href="<?php echo esc_attr(get_theme_mod('topheader_twitterlink', '#')); ?>"> <i class="fa-brands fa-x-twitter"></i> </a></li>
								<li> <a href="<?php echo esc_attr(get_theme_mod('topheader_pinterestlink', '#')); ?>"> <i class="fa-brands fa-pinterest-p"></i> </a></li>
								<li> <a href="<?php echo esc_attr(get_theme_mod('topheader_linkedinlink', '#')); ?>"> <i class="fa-brands fa-linkedin-in"></i> </a></li>
								<li> <a href="<?php echo esc_attr(get_theme_mod('topheader_youtubelink', '#')); ?>"> <i class="fa-brands fa-youtube"></i> </a></li>
							</div>
						</div>
					</div>			
				</div>
				<div class="container">			
					<div class="btmmhead">
						<div class="row mr-0">
							<div class="lbxot ">
								<div class="logobx">
									<div class="site-logo">
										<?php
										if(has_custom_logo())
											{	
												the_custom_logo();
											}
											else { 
											?>
											<a class="site-title" href="<?php echo esc_url( home_url( '/' ) ); ?>">
												
												<?php 
													echo esc_html(bloginfo('name'));
												?>
											</a>	

											<div class="box-info">
												<?php
													$petcareveterinarycenter_site_desc = get_bloginfo( 'description');
													if ($petcareveterinarycenter_site_desc) : ?>
														<p class="site-description"><?php echo esc_html($petcareveterinarycenter_site_desc); ?></p>
												<?php endif; ?>
											</div>
										<?php 						
											}
										?>
									</div>
								</div>
							</div>
							<div class="m-mbx">					
								<div class="bottomhead ">
									<div class="m-bxinn">
										<div class="menus">
											<nav class="navbar navbar-expand-lg navbaroffcanvase">
											<div class="navbar-menubar">
												<!-- Small Divice Menu-->
												<button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target=".navbar-menu"  aria-label="<?php echo esc_attr_e('Toggle navigation','pet-care-veterinary-center'); ?>"> 
													<i class="fa fa-bars"></i>
												</button>
												<div class="collapse navbar-collapse navbar-menu">
													<button class="navbar-toggler navbar-toggler-close" type="button" data-bs-toggle="collapse" data-bs-target=".navbar-menu"  aria-label="<?php echo esc_attr_e('Toggle navigation','pet-care-veterinary-center'); ?>"> 
														<i class="fa fa-times"></i>
													</button> 
													<?php 
														wp_nav_menu( 
															array(  
																'theme_location' => 'primary_menu',
																'container'  => '',
																'container_id'    => '',
																'menu_class' => 'navbar-nav main-nav',
																'fallback_cb' => 'WP_Bootstrap_Navwalker::fallback',
																'walker' => new WP_Bootstrap_Navwalker()
																) 
															);
													?>
												</div>
											</div>
											</nav>
										</div>
									</div>									
									<div class="clearfix"></div>
								</div>
							</div>
							<?php if ($topheader_phone) { ?>
							<div class="phonenumber">	
								<a href="<?php echo esc_attr(get_theme_mod('topheader_phonelink', '#')); ?>">
									<i class="fa-solid fa-phone"></i> <?php echo esc_html(get_theme_mod('topheader_phone', 'Book Now')); ?>
								</a>
							</div>
							<?php } ?>					
						</div>
					</div>
				</div>
			</div>
		</div>
    </header>
	<div class="clearfix"></div>

</div>
