<?php    
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package peccular Premium
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<script src="https://use.fontawesome.com/18a9c36ed1.js"></script>
	
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/bootstrap.min.css">
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/animate.css" />
	<link rel="preconnect" href="https://fonts.gstatic.com"> 
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Open+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;0,800;1,300;1,400;1,500;1,600;1,700;1,800&display=swap" rel="stylesheet">
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">

<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Kaushan+Script&display=swap" rel="stylesheet">

<link rel="preconnect" href="https://fonts.gstatic.com"> 
<link href="https://fonts.googleapis.com/css2?family=Allerta&display=swap" rel="stylesheet">
<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/home1.css">
<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/teampopup.css">

	<script src="<?php echo get_template_directory_uri(); ?>/js/jquery-3.1.1.slim.min.js" crossorigin="anonymous"></script>
	<script src="<?php echo get_template_directory_uri(); ?>/js/bootstrap.min.js" type="text/javascript"  ></script>
	<script src="<?php echo get_template_directory_uri(); ?>/js/wow.js" ></script>


<!-- new ico -->
	<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css
	" rel="stylesheet">

 <link rel="stylesheet" href="https://md-aqil.github.io/images/swiper.min.css">
 <script src="https://md-aqil.github.io/images/swiper.min.js"></script>

<script src="https://code.jquery.com/jquery-1.12.4.min.js"></script>

 	<script type="text/javascript">
		$(document).ready(function(){
			$(".phone-box i.fa-phone").click(function(){
				$(".phone-box a.h-phone").toggle();
			});
		});
	 </script>
	  	<script type="text/javascript">
		$(document).ready(function(){
			$(".phone-box i.fa-envelope-o").click(function(){
				$(".phone-box a.h-email").toggle();
			});
		});
	 </script>
	 	  	<script type="text/javascript">
		$(document).ready(function(){
			$(".mob-socials i.fa.fa-share-alt").click(function(){
				$(".mob-socials .soc").toggle();
			});
		});
	 </script>
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
	<div class="main-container">
		
	<div id="loading-area"><div class="la-anim-10"></div></div>
	<!-- header -->
	<!-- #masthead -->


<?php if(get_theme_mod('peccular_header_style', 'On Slider') == 'On Slider' ){ ?>
<header class="site-header header-transparent header mo-left header-seo" style="position:absolute;">
	 <div class="header-overlay"></div> 
	
	<div class="<?php if(get_theme_mod('peccular_header_width','Box Width') == 'Box Width'){ ?>container <?php } elseif(get_theme_mod('peccular_header_width','Box Width') == 'Full Width'){ ?> container-fluid pd-0<?php }?>">
		
		<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-xs-12 stickyheader <?php echo esc_attr(bakerystore_sticky_menu()); ?>">
			<div class="row md-1">
				<div class="col-xl-3 col-lg-3 col-md-4 col-sm-4 col-xs-3 logo">
							<div class="inside-full-height">
							
							<?php 
							
								if( get_theme_mod('pages_logoTopsetmaxwidth',true) ) {
									$pages_logoTopsetmaxwidth = 'max-width:'.esc_attr(get_theme_mod('pages_logoTopsetmaxwidth')).';';
								}
								if( get_theme_mod('pages_logoheight',true) ) {
									$pages_logoheight = 'height:'.esc_attr(get_theme_mod('pages_logoheight')).';';
								}
								if( get_theme_mod('pages_logoToppadding',true) ) {
									$pages_logoToppadding = 'padding-top:'.esc_attr(get_theme_mod('pages_logoToppadding')).';';
								}
								if( get_theme_mod('pages_logobottompadding',true) ) {
									$pages_logobottompadding = 'padding-bottom:'.esc_attr(get_theme_mod('pages_logobottompadding')).';';
								}
								if( get_theme_mod('pages_logoTopmargin',true) ) {
									$pages_logoTopmargin = 'margin-top:'.esc_attr(get_theme_mod('pages_logoTopmargin')).';';
								}
								if( get_theme_mod('pages_logobottommargin',true) ) {
									$pages_logobottommargin = 'margin-bottom:'.esc_attr(get_theme_mod('pages_logobottommargin')).';';
								}


								?>
								<!-- website logo -->
								<div class="logo-header">						

				            <?php 
									if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
										the_custom_logo();
								else : 
									if ( is_front_page() ) : ?>
										<?php if (get_theme_mod('peccular_show_site_title',true)) : ?>
										<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
										<?php if (get_theme_mod('peccular_show_tagline',true)) {?>
							<p class="ht-site-description"><?php bloginfo( 'description' ); ?></p>
							<?php }?>
										<?php endif; ?>
										<?php else : ?>
											<p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
											<?php if (get_theme_mod('peccular_show_tagline',true)) {?>
							<p class="ht-site-description"><?php bloginfo( 'description' ); ?></p>
							<?php }?>
										<?php endif; ?>
									<?php endif; ?>
								
							
							</div>
							</div>
					 
		</div><!--logo div 3 -->
				
					
		<div class="col-xl-9 col-lg-9 col-md-8 col-sm-8 col-xs-9 pd-0">

			<div class="maintop-header">
				<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-xs-12 pd-0">
					<div class="row md-1">
					<?php						
						$emailtxt = get_theme_mod('peccular_topheader_emailtext', 'info@fakemail.com');
						$phone = get_theme_mod('peccular_topheader_phone', '1110-222-333');						
					?>				


					<?php if($phone){ ?>
					<div class="col-lg-4 col-md-6 col-sm-6 col-xs-12 pd-0 headphone">							
						<i class="fa fa-phone" aria-hidden="true"></i><a class="h-phone" href="telto:<?php echo $phone;?>"><?php echo $phone ;?></a>									
					</div>
					<?php }?>	

					<?php if($emailtxt){ ?>
					<div class="col-lg-4 col-md-6 col-sm-6 col-xs-12 pd-0 heademail">							
						<i class="fa fa-envelope-o" aria-hidden="true"></i><a class="h-email" href="mailto:<?php echo $emailtxt;?>"><?php echo $emailtxt ;?></a>									
					</div>
					<?php }?>	

					<div class="col-lg-4 col-md-6 col-sm-6 col-xs-12 socials pd-0">
							<?php
							$facebook = get_theme_mod('peccular_header_fb', '//facebook.com/');
							$twitter = get_theme_mod('peccular_header_tw', '//twitter.com/');	
							$instagram = get_theme_mod('peccular_header_instagram', '//instagram.com/');			
							$pinterest = get_theme_mod('peccular_header_pinterest', 'https://www.pinterest.com');
							?>

								<div class="clearfix">
									<?php if(!empty($facebook)){ ?>
										<a href="<?php echo $facebook ?>" title="Facebook" class="site-button sharp" target="_blank"><i class="fa fa-facebook"></i></a>
									<?php }?>

									<?php if(!empty($twitter)){ ?>
										<a href="<?php echo $twitter ?>" title="Twitter" class="site-button sharp" target="_blank"><i class="fa-brands fa-x-twitter"></i></a>
									<?php }?>
									
									<?php if(!empty($pinterest)){ ?>
										<a href="<?php echo $pinterest ?>" title="Pinterest" class="site-button sharp" target="_blank"><i class="fa fa-pinterest"></i></a>
									<?php }?>
									
									<?php if(!empty($instagram)){ ?>
										<a href="<?php echo $instagram ?>" title="Instagram" class="site-button sharp" target="_blank"><i class="fa fa-instagram"></i></a>
									<?php }?>									

								</div>
						</div><!--social icon -->		
					</div>
				 </div>
				</div><!--maintop header -->
				
				<div class="clearfix"></div>				
				
			<div class="mainbottom-header top-bar-head bottom-header" style="border-radius: 0px;">
						
			<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-xs-12 head-menu pd-0">

			<div class="row md-1">								
						
			<div class="col-lg-9 col-md-9 col-sm-9 col-xs-9 head-menu pd-0">
	<div class="maintop-header phone-box">
		<div class="row ">
				<?php if($phone){ ?>
					<div class="col-lg-4 col-md-6 col-sm-6 col-xs-12 pd-0 headphone">							
						<i class="fa fa-phone" aria-hidden="true"></i><a class="h-phone" href="telto:<?php echo $phone;?>"><?php echo $phone ;?></a>									
					</div>
					<?php }?>
						<?php if($emailtxt){ ?>
					<div class="col-lg-4 col-md-6 col-sm-6 col-xs-12 pd-0 heademail">							
						<i class="fa fa-envelope-o" aria-hidden="true"></i><a class="h-email" href="mailto:<?php echo $emailtxt;?>"><?php echo $emailtxt ;?></a>	
					</div>
					<?php }?>	


<div class="col-lg-4 col-md-6 col-sm-6 col-xs-12 socials mob-socials pd-0">
							<i class="fa fa-share-alt"></i>
							<?php
							$facebook = get_theme_mod('peccular_header_fb', '//facebook.com/');
							$twitter = get_theme_mod('peccular_header_tw', '//twitter.com/');	
							$instagram = get_theme_mod('peccular_header_instagram', '//instagram.com/');			
							$pinterest = get_theme_mod('peccular_header_pinterest', 'https://www.pinterest.com');
							?>

								<div class="soc">
									<?php if(!empty($facebook)){ ?>
										<a href="<?php echo $facebook ?>" title="Facebook" class="site-button sharp" target="_blank"><i class="fa fa-facebook"></i></a>
									<?php }?>

									<?php if(!empty($twitter)){ ?>
										<a href="<?php echo $twitter ?>" title="Twitter" class="site-button sharp" target="_blank"><i class="fa-brands fa-x-twitter"></i></a>
									<?php }?>
									
									<?php if(!empty($pinterest)){ ?>
										<a href="<?php echo $pinterest ?>" title="Pinterest" class="site-button sharp" target="_blank"><i class="fa fa-pinterest"></i></a>
									<?php }?>
									
									<?php if(!empty($instagram)){ ?>
										<a href="<?php echo $instagram ?>" title="Instagram" class="site-button sharp" target="_blank"><i class="fa fa-instagram"></i></a>
									<?php }?>									

								</div>
						</div><!--social icon -->	

		</div>
					</div>
				<div class="header-nav-area">		
							
					<div class="inside-full-height">
							<?php
								if( get_theme_mod('menu_fontsize',true) ) {
									$menu_fontsize = 'font-size:'.esc_attr(get_theme_mod('menu_fontsize')).';';
								}
								if( get_theme_mod('dropdown_menu_fontsize',true) ) {
									$dropdown_menu_fontsize = 'font-size:'.esc_attr(get_theme_mod('dropdown_menu_fontsize')).';';
								}
							?>
					<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-xs-12 ">
						<div class="row md-1">
							<div class="site-navigation">
		                        <div class="hamburger-menus">
		                            <span></span>
		                            <span></span>
		                            <span></span>
		                            <span></span>
		                            <span></span>
		                            <span></span>
		                            <span></span>
		                            <span></span>
		                            <span></span>
		                        </div>
		                   <nav class="navigation">
		                        <div class="overlaybg"></div><!--  /.overlaybg -->
		                            <!-- Main Menu -->
		                         <div class="menu-wrapper">
		                          <div class="menu-content">
		                              <?php
		                                 if( get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true) !=='0') {
		                                 wp_nav_menu ( array(
		                                    'menu_class' => 'mainmenu ht-clearfix',
		                                    'container'=> 'ul',
		                                    'menu' => get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true),
		                                    'theme_location' => 'primary',  
		                                       )); 
		                              } else {
		                                 wp_nav_menu ( array(
		                                    'menu_class' => 'mainmenu ht-clearfix',
		                                    'container'=> 'ul',
		                              	   'theme_location' => 'primary',  
		                                        )); 
		                                 }
		                              ?>
		                           </div> <!-- /.hours-content-->	                 

									<div class="clearfix"></div>

		                        </div><!-- /.menu-wrapper --> 
		                         <div class="col-lg-3 col-md-12 col-sm-12 col-xs-3 pd-0 head-inner-conbtn">
			   	<?php
                    $peccular_header_acbutton_text = get_theme_mod('peccular_header_acbutton_text', 'Contact us'); 
                  $peccular_headermyaccounturl = get_theme_mod('peccular_headermyaccounturl', 'Add "Header Button" link here');
               ?>
                <?php if( get_theme_mod('peccular_header_sbutton_enable',true) == true){ ?>
               		<?php if(!empty($peccular_header_acbutton_text)){ ?>
                  <a href="<?php echo $peccular_headermyaccounturl; ?>" class="header-shopbtn" title="headermyaccount"><span><?php echo ($peccular_header_acbutton_text );  ?></span>
                  	 <div class="transition"></div>
                  </a>
                   <?php }?>
               <?php }?>
				</div>
		                    </nav>	

		                   
		                     	                       
		              </div><!--  /.site-navigation -->		                   
						</div>
					</div><!-- col 12 icons -->							

		         </div>
		              <div class="clearfix"></div>
		         </div>     
				</div><!-- col 10 icons -->
						
						
				<div class="col-lg-3 col-md-3 col-sm-3 col-xs-3 pd-0 head-conbtn">
			   	<?php
                  $peccular_header_acbutton_text = get_theme_mod('peccular_header_acbutton_text', 'Contact us'); 
                  $peccular_headermyaccounturl = get_theme_mod('peccular_headermyaccounturl', 'Add "Header Button" link here');
               ?>
               <?php if( get_theme_mod('peccular_header_sbutton_enable',true) == true){ ?>
               		<?php if(!empty($peccular_header_acbutton_text)){ ?>
                  <a href="<?php echo $peccular_headermyaccounturl; ?>" class="header-shopbtn" title="headermyaccount"><span><?php echo ($peccular_header_acbutton_text );  ?></span>
                  	 <div class="transition"></div>
                  </a>
                   <?php }?>
               <?php }?>
				</div>
			</div><!-- row-->		
			
			</div>				
			</div><!-- sticky header -->			
				<div class="clearfix"></div>
			</div>
		</div>
	</div>
</div>
<div class="header-bottom-border"></div>
	
</header>
	
		 <?php } elseif(get_theme_mod('peccular_header_style', 'On Slider') == 'Above Slider' ){ ?>

<header class="site-header header-transparent header mo-left header-seo slider-above" style="position:relative">
			 <div class="header-overlay"></div> 
	
	<div class="<?php if(get_theme_mod('peccular_header_width','Box Width') == 'Box Width'){ ?>container <?php } elseif(get_theme_mod('peccular_header_width','Box Width') == 'Full Width'){ ?> container-fluid pd-0<?php }?>">
		
		<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-xs-12 stickyheader <?php echo esc_attr(bakerystore_sticky_menu()); ?>">
			<div class="row md-1">
				<div class="col-xl-4 col-lg-4 col-md-4 col-sm-3 col-xs-3 logo">
							<div class="inside-full-height">
							
							<?php 
							
								if( get_theme_mod('pages_logoTopsetmaxwidth',true) ) {
									$pages_logoTopsetmaxwidth = 'max-width:'.esc_attr(get_theme_mod('pages_logoTopsetmaxwidth')).';';
								}
								if( get_theme_mod('pages_logoheight',true) ) {
									$pages_logoheight = 'height:'.esc_attr(get_theme_mod('pages_logoheight')).';';
								}
								if( get_theme_mod('pages_logoToppadding',true) ) {
									$pages_logoToppadding = 'padding-top:'.esc_attr(get_theme_mod('pages_logoToppadding')).';';
								}
								if( get_theme_mod('pages_logobottompadding',true) ) {
									$pages_logobottompadding = 'padding-bottom:'.esc_attr(get_theme_mod('pages_logobottompadding')).';';
								}
								if( get_theme_mod('pages_logoTopmargin',true) ) {
									$pages_logoTopmargin = 'margin-top:'.esc_attr(get_theme_mod('pages_logoTopmargin')).';';
								}
								if( get_theme_mod('pages_logobottommargin',true) ) {
									$pages_logobottommargin = 'margin-bottom:'.esc_attr(get_theme_mod('pages_logobottommargin')).';';
								}


								?>
								<!-- website logo -->
								<div class="logo-header">						

				            <?php 
									if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
										the_custom_logo();
								else : 
									if ( is_front_page() ) : ?>
										<?php if (get_theme_mod('peccular_show_site_title',true)) : ?>
										<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
										<?php if (get_theme_mod('peccular_show_tagline',true)) {?>
							<p class="ht-site-description"><?php bloginfo( 'description' ); ?></p>
							<?php }?>
										<?php endif; ?>
										<?php else : ?>
											<p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
											<?php if (get_theme_mod('peccular_show_tagline',true)) {?>
							<p class="ht-site-description"><?php bloginfo( 'description' ); ?></p>
							<?php }?>
										<?php endif; ?>
									<?php endif; ?>
								
							
							</div>
							</div>
					 
		</div><!--logo div 3 -->
				
					
		<div class="col-xl-8 col-lg-8 col-md-8 col-sm-9 col-xs-9 pd-0">

			<div class="maintop-header">
				<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-xs-12 pd-0">
					<div class="row md-1">
					<?php						
						$emailtxt = get_theme_mod('peccular_topheader_emailtext', 'info@fakemail.com');
						$phone = get_theme_mod('peccular_topheader_phone', '1110-222-333');						
					?>				

			
					<?php if($phone){ ?>
					<div class="col-lg-3 col-md-6 col-sm-12 col-xs-12 pd-0">							
						<i class="fa fa-phone" aria-hidden="true"></i><a class="h-phone" href="telto:<?php echo $phone;?>"><?php echo $phone ;?></a>									
					</div>
					<?php }?>	

					<?php if($emailtxt){ ?>
					<div class="col-lg-5 col-md-8 col-sm-8 col-xs-12 pd-0">							
						<i class="fa fa-envelope-o" aria-hidden="true"></i><a class="h-email" href="mailto:<?php echo $emailtxt;?>"><?php echo $emailtxt ;?></a>									
					</div>
					<?php }?>	

					<div class="col-lg-3 col-md-6 col-sm-12 col-xs-12 socials pd-0">
							<?php
							$facebook = get_theme_mod('peccular_header_fb', '//facebook.com/');
							$twitter = get_theme_mod('peccular_header_tw', '//twitter.com/');	
							$instagram = get_theme_mod('peccular_header_instagram', '//instagram.com/');			
							$pinterest = get_theme_mod('peccular_header_pinterest', 'https://www.pinterest.com');
							?>

								<div class="clearfix">
									<?php if(!empty($facebook)){ ?>
										<a href="<?php echo $facebook ?>" title="Facebook" class="site-button sharp" target="_blank"><i class="fa fa-facebook"></i></a>
									<?php }?>

									<?php if(!empty($twitter)){ ?>
										<a href="<?php echo $twitter ?>" title="Twitter" class="site-button sharp" target="_blank"><i class="fa fa-twitter"></i></a>
									<?php }?>
									
									<?php if(!empty($pinterest)){ ?>
										<a href="<?php echo $pinterest ?>" title="Pinterest" class="site-button sharp" target="_blank"><i class="fa fa-pinterest"></i></a>
									<?php }?>
									
									<?php if(!empty($instagram)){ ?>
										<a href="<?php echo $instagram ?>" title="Instagram" class="site-button sharp" target="_blank"><i class="fa fa-instagram"></i></a>
									<?php }?>									

								</div>
						</div><!--social icon -->		
					</div>
				 </div>
				</div><!--maintop header -->
				
				<div class="clearfix"></div>				
				
			<div class="mainbottom-header top-bar-head bottom-header " style="border-radius: 0px;">
						
			<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-xs-12 head-menu pd-0">

			<div class="row md-1">								
						
			<div class="col-lg-9 col-md-9 col-sm-9 col-xs-9 head-menu pd-0">

				<div class="header-nav-area">		
							
					<div class="inside-full-height">
							<?php
								if( get_theme_mod('menu_fontsize',true) ) {
									$menu_fontsize = 'font-size:'.esc_attr(get_theme_mod('menu_fontsize')).';';
								}
								if( get_theme_mod('dropdown_menu_fontsize',true) ) {
									$dropdown_menu_fontsize = 'font-size:'.esc_attr(get_theme_mod('dropdown_menu_fontsize')).';';
								}
							?>
					<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-xs-12 ">
						<div class="row md-1">
							<div class="site-navigation">
		                        <div class="hamburger-menus">
		                            <span></span>
		                            <span></span>
		                            <span></span>
		                            <span></span>
		                            <span></span>
		                            <span></span>
		                            <span></span>
		                            <span></span>
		                            <span></span>
		                        </div>
		                   <nav class="navigation">
		                        <div class="overlaybg"></div><!--  /.overlaybg -->
		                            <!-- Main Menu -->
		                         <div class="menu-wrapper">
		                          <div class="menu-content">
		                              <?php
		                                 if( get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true) !=='0') {
		                                 wp_nav_menu ( array(
		                                    'menu_class' => 'mainmenu ht-clearfix',
		                                    'container'=> 'ul',
		                                    'menu' => get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true),
		                                    'theme_location' => 'primary',  
		                                       )); 
		                              } else {
		                                 wp_nav_menu ( array(
		                                    'menu_class' => 'mainmenu ht-clearfix',
		                                    'container'=> 'ul',
		                              	   'theme_location' => 'primary',  
		                                        )); 
		                                 }
		                              ?>
		                           </div> <!-- /.hours-content-->	                 

									<div class="clearfix"></div>

		                        </div><!-- /.menu-wrapper --> 
		                        <div class="col-lg-3 col-md-3 col-sm-3 col-xs-3 pd-0 head-inner-conbtn">
			   	<?php
                  $peccular_header_acbutton_text = get_theme_mod('peccular_header_acbutton_text', 'Contact us'); 
                  $peccular_headermyaccounturl = get_theme_mod('peccular_headermyaccounturl', 'Add "Header Button" link here');
               ?>
               <?php if( get_theme_mod('peccular_header_sbutton_enable',true) == true){ ?>
               		<?php if(!empty($peccular_header_acbutton_text)){ ?>
                  <a href="<?php echo $peccular_headermyaccounturl; ?>" class="header-innershopbtn" title="headermyaccount"><?php echo ($peccular_header_acbutton_text );  ?></a>
                   <?php }?>
               <?php }?>
				</div>    	    
		                    </nav>	
		                     	   
		                                      
		              </div><!--  /.site-navigation -->		                   
						</div>
					</div><!-- col 12 icons -->							

		         </div>
		              <div class="clearfix"></div>
		         </div>     
				</div><!-- col 10 icons -->
						
						
				<div class="col-lg-3 col-md-3 col-sm-3 col-xs-3 pd-0 head-conbtn">
			   	<?php
                  $peccular_header_acbutton_text = get_theme_mod('peccular_header_acbutton_text', 'Contact us'); 
                  $peccular_headermyaccounturl = get_theme_mod('peccular_headermyaccounturl', 'Add "Header Button" link here');
               ?>
               <?php if( get_theme_mod('peccular_header_sbutton_enable',true) == true){ ?>
               	<?php if(!empty($peccular_header_acbutton_text)){ ?>
                  <a href="<?php echo $peccular_headermyaccounturl; ?>" class="header-shopbtn" title="headermyaccount"><span><?php echo ($peccular_header_acbutton_text );  ?></span>
                   <div class="transition"></div></a>
                 <?php }?> 
               <?php }?>
				</div>
			</div><!-- row-->		
			
			</div>				
			</div><!-- sticky header -->			
				<div class="clearfix"></div>
			</div>
		</div>
	</div>
</div>
	</header>

	 <?php }?>

	</div>