<?php
/**
 * Createing a bog pannel for customizer
 *
 *
 */

$peccular_categories = get_categories(array('hide_empty' => 0));
foreach ($peccular_categories as $peccular_category) {
	$peccular_cat[$peccular_category->term_id] = $peccular_category->cat_name;
}

// CREATING A SECTION IN CUSTOMIZER
$wp_customize->add_section(
	'peccular_premium_blog_section',
	array(
		'title' => __( 'Blog Section', 'peccular Premium' ),
        // 'panel' => 'peccular_premium_home_panel'
		'priority' =>19
	)
);

$wp_customize->add_setting(
	'peccular_premium_blog_section_disable',
	array(
		'sanitize_callback' => 'peccular_sanitize_text',
	)
);
$wp_customize->add_control(
	new peccular_Switch_Control(
		$wp_customize,
		'peccular_premium_blog_section_disable',
		array(
			'settings'      => 'peccular_premium_blog_section_disable',
			'section'       => 'peccular_premium_blog_section',
			'label'         => __( 'Show Title and description at top', 'peccular Premium' ),
			'on_off_label'  => array(
				'on' => __( 'Yes', 'peccular Premium' ),
				'off' => __( 'No', 'peccular Premium' )
			),
		)
	)
);
$wp_customize->add_setting(
	'peccular_blog_title_heading',
	array(
		'sanitize_callback' => 'peccular_sanitize_text'
	)
);
$wp_customize->add_control(
	new peccular_Customize_Heading(
		$wp_customize,
		'peccular_blog_title_heading',
		array(
			'settings'      => 'peccular_blog_title_heading',
			'section'       => 'peccular_premium_blog_section',
			'label'         => __( 'Blog Title & description', 'peccular Premium' ),
		)
	)
);
//BLOG PAGE TITLE
$wp_customize->add_setting('peccular_blog_title', array('sanitize_callback' => 'peccular_sanitize_text'));
$wp_customize->add_control('peccular_blog_title', array('settings'=>'peccular_blog_title', 'section'=>'peccular_premium_blog_section','type'=>'text', 'label'=> __('Blog page title', 'peccular Premium')));
// BLOG PAGE DESCRIPTION
$wp_customize->add_setting('peccular_blog_desc', array('sanitize_callback' => 'peccular_sanitize_text'));
$wp_customize->add_control('peccular_blog_desc', array('settings'=>'peccular_blog_desc', 'section'=>'peccular_premium_blog_section','type'=>'textarea', 'label'=> __('Blog page description', 'peccular Premium')));
// ADDING THE CATEGORY TO SELECT
$wp_customize->add_setting('peccular_blog_categories', array('sanitize_callback' => 'peccular_sanitize_text'));
$wp_customize->add_control(
	new peccular_Customize_Checkbox_Multiple(
        $wp_customize,
        'peccular_blog_categories',
        array(
            'label' => __('Exclude Category from Blog Posts', 'total'),
            'section' => 'peccular_premium_blog_section',
            'settings' => 'peccular_blog_categories',
            'choices' => $peccular_cat
        )
    )
);



