<?php 
// /HEADER SETTINGS IN CUSTOMIZER
  $lvl1ParentPanel = new peccular_WP_Customize_Panel( $wp_customize, 'peccular_header_panel1', array(
    'title' => 'General Settings',
    'priority' => 1,
  ));

  $wp_customize->add_panel( $lvl1ParentPanel );

  $lvl2ParentPanel = new peccular_WP_Customize_Panel( $wp_customize, 'peccular_header_panel2', array(
    'title' => 'Header',
    'panel' => 'peccular_header_panel1',
    'priority' => 1,
  ));

  $wp_customize->add_panel( $lvl2ParentPanel );


  // Add example section and controls to the final (third) panel
  $wp_customize->add_section( 'peccular_section', array(
    'title' => 'Section Test',
    'panel' => 'peccular_header_panel2',
  ));

//Bottom Header
    $wp_customize->add_section( 'peccular_header_section' , array(
        'title'    => __( 'All Settings', 'peccular-premium' ),
        'priority' => null,
        'panel' => 'peccular_header_panel2'
    ) );


    $wp_customize->add_setting('peccular_allsetting_nav', array(
       'sanitize_callback' => 'wp_kses_post',
    ));

    $wp_customize->add_control(new peccular_Tab_Control($wp_customize, 'peccular_allsetting_nav', array(
       'section' => 'peccular_header_section',
       'priority' => 1,
       'buttons' => array(
          array(
             'name' => esc_html__('General', 'peccular-premium'),
            'icon' => 'dashicons dashicons-welcome-write-blog',
            'fields' => array(
                'peccular_show_sticky_header',
                'peccular_header_style',
                'peccular_header_width',
                'peccular_topheader_phone',
                'peccular_topheader_emailtext',
                'peccular_header_sbutton_enable',
                'peccular_header_acbutton_text',
                'peccular_headermyaccounturl',
                'peccular_header_fb',
                'peccular_header_tw',
                'peccular_header_instagram',
                'peccular_header_pinterest'
                
            ),
            'active' => true,
         ),
          array(
            'name' => esc_html__('Style', 'peccular-premium'),
            'icon' => 'dashicons dashicons-art',
            'fields' => array(  
                'header_bgColor',      
                'header_abovebgColor',        
                'header_stickybgColor',
                'header_SiteTitleColor',
                'header_SiteTaglineColor',                
                'headerephoneicon_color',
                'headerphone_color',
                'headereemailhove_color',
                'header_btnbgColor',
                'header_btntextColor',
                'header_btnhvslibgColor',
                'header_btnhvbgColor',
                'header_btnhvtextColor',
                'header_cartbtnbgcolor',
                'header_cartbtnhovbgColor',
                'header_cartbtncounterbgcolor',
                'header_cartbtncountrtxtColor',
                'headereemailicon_color', 
                'headeremail_color',
                'headereemailhove_color',
                'headersicon_color',
                'header_bttomborColor',
                'headersiconhov_color',
                'headerphonehove_color'
      

            ),
         )
        ),
    )));

    $wp_customize->add_setting( 'peccular_show_sticky_header',array(
        'default' => false,
        'sanitize_callback' => 'peccular_switch_sanitization'
   ) );
   $wp_customize->add_control( new peccular_Toggle_Switch_Custom_Control( $wp_customize, 'peccular_show_sticky_header',array(
        'label' => __( 'Show Sticky Header','peccular' ),
        'section' => 'peccular_header_section'
   )));

   
    $wp_customize->add_setting('peccular_header_style',array(
        'default' => 'On Slider',
        'sanitize_callback' => 'peccular_sanitize_choices',
    ));
    $wp_customize->add_control('peccular_header_style',array(
        'type' => 'select',
        'label' => __('Header Style','peccular'),
        'choices' => array (
            'Above Slider' => __('Above Slider','peccular'),
            'On Slider' => __('On Slider','peccular')
        ),
        'section' => 'peccular_header_section',
    ));


    $wp_customize->add_setting('peccular_header_width',array(
        'default' => 'Box Width',
        'sanitize_callback' => 'peccular_sanitize_choices',
    ));
    $wp_customize->add_control('peccular_header_width',array(
        'type' => 'select',
        'label' => __('Section Width','peccular'),
        'choices' => array (
            'Box Width' => __('Box Width','peccular'),
            'Full Width' => __('Full Width','peccular')
        ),
        'section' => 'peccular_header_section',
    ));


$wp_customize->add_setting('peccular_topheader_emailtext',array(       
        'sanitize_callback' => 'sanitize_email',
        'default' => __('info@fakemail.com','peccular-premium')
    ));
    $wp_customize->add_control('peccular_topheader_emailtext',array(
        'settings'      => 'peccular_topheader_emailtext',
        'type' => 'text',
        'label' => __('Add Email Address','peccular-premium'),
        'section' => 'peccular_header_section',
    ));

$wp_customize->add_setting('peccular_topheader_phone',array(
        'sanitize_callback' => 'peccular_sanitize_phone_number',
        'default' => __('1110-222-333','peccular-premium')
    ));
    $wp_customize->add_control('peccular_topheader_phone',array(
        'settings'      => 'peccular_topheader_phone',
        'type' => 'text',
        'label' => __('Add Phone Number','peccular-premium'),
        'section' => 'peccular_header_section',
    ));

   $wp_customize->add_setting( 'peccular_header_sbutton_enable',array(
        'default' => true,
        'sanitize_callback' => 'peccular_switch_sanitization'
   ) );
   $wp_customize->add_control( new peccular_Toggle_Switch_Custom_Control( $wp_customize, 'peccular_header_sbutton_enable',array(
        'label' => __( 'Show Header Button','peccular' ),
        'section' => 'peccular_header_section'
   )));   

 $wp_customize->add_setting(
    'peccular_header_acbutton_text',
    array(
        'sanitize_callback' => 'peccular_sanitize_text',
        'default'           => __( 'Contact us' )
    )
);
$wp_customize->add_control(
    'peccular_header_acbutton_text',
    array(
        'settings'      => 'peccular_header_acbutton_text',
        'section'       => 'peccular_header_section',
        'type'          => 'text',
        'label'         => __( 'Header Button Text', 'peccular-premium' )
    )
);
$wp_customize->add_setting(
    'peccular_headermyaccounturl', 
    array('default'=> 'add link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control(
    'peccular_headermyaccounturl',
    array(
        'settings'      => 'peccular_headermyaccounturl',
        'section'       => 'peccular_header_section',
        'type'          => 'url',
        'label'         => __( 'Add "Header Button" link here', 'peccular-premium' )
    )
);   

// FACEBOOK 
$wp_customize->add_setting('peccular_header_fb', array('default'=> 'https://facebook.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('peccular_header_fb',
    array(
        'settings'      => 'peccular_header_fb',
        'section'       => 'peccular_header_section',
        'type'          => 'url',
        'label'         => __( 'Facebook Url', 'peccular-premium' )
    )
);
// TWITTER
$wp_customize->add_setting('peccular_header_tw', array('default'=> 'https://twitter.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('peccular_header_tw',
    array(
        'settings'      => 'peccular_header_tw',
        'section'       => 'peccular_header_section',
        'type'          => 'url',
        'label'         => __( 'Twitter Url', 'peccular-premium' )
    )
);


// Instagram IN
$wp_customize->add_setting('peccular_header_instagram',array('default'=> 'https://instagram.com','sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('peccular_header_instagram',
    array(
        'settings'      => 'peccular_header_instagram',
        'section'       => 'peccular_header_section',
        'type'          => 'url',
        'label'         => __( 'Instagram Url', 'peccular-premium' )
    )
);


// Pinterest
$wp_customize->add_setting('peccular_header_pinterest',array('default'=> 'https://pinterest.com','sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('peccular_header_pinterest',
    array(
        'settings'      => 'peccular_header_pinterest',
        'section'       => 'peccular_header_section',
        'type'          => 'url',
        'label'         => __( 'Pinterest Url', 'peccular-premium' )
    )
);

addColorPalatOption($wp_customize, 'header_bgColor', 'peccular_header_section', 'Header BG Color', '');
addColorPalatOption($wp_customize, 'header_abovebgColor', 'peccular_header_section', 'Above Slider Header BG Color', '');

addColorPalatOption($wp_customize, 'header_stickybgColor', 'peccular_header_section', 'Sticky BG Color', '');

addColorPalatOption($wp_customize, 'header_SiteTitleColor', 'peccular_header_section', 'Site Title Color', '');
addColorPalatOption($wp_customize, 'header_SiteTaglineColor', 'peccular_header_section', 'Tagline Color', '');

addColorPalatOption($wp_customize, 'headerephoneicon_color', 'peccular_header_section', 'Phone Icon Color', '');
addColorPalatOption($wp_customize, 'headerphone_color', 'peccular_header_section', 'Phone Text Color', '');
addColorPalatOption($wp_customize, 'headerphonehove_color', 'peccular_header_section', 'Phone Hover Color', '');
addColorPalatOption($wp_customize, 'headereemailicon_color', 'peccular_header_section', 'Email Icon Color', '');
addColorPalatOption($wp_customize, 'headeremail_color', 'peccular_header_section', 'Email Text Color', '');
addColorPalatOption($wp_customize, 'headereemailhove_color', 'peccular_header_section', 'Email Hover Color', '');

addColorPalatOption($wp_customize, 'headersicon_color', 'peccular_header_section', 'Social Icon Color', '');
addColorPalatOption($wp_customize, 'headersiconhov_color', 'peccular_header_section', 'Social Icon BG Color', '');

addColorPalatOption($wp_customize, 'header_btnbgColor', 'peccular_header_section', 'Button Border Color', '');
addColorPalatOption($wp_customize, 'header_btntextColor', 'peccular_header_section', 'Button Text Color','');
addColorPalatOption($wp_customize, 'header_btnhvslibgColor', 'peccular_header_section', 'Button Hover BG  Color','');
addColorPalatOption($wp_customize, 'header_btnhvbgColor', 'peccular_header_section', 'Button Hover BG Slider Color','');
addColorPalatOption($wp_customize, 'header_btnhvtextColor', 'peccular_header_section', 'Button Hover Text Color','');

// addColorPalatOption($wp_customize, 'header_bttomborColor', 'peccular_header_section', 'Header Bottom Border Color','');
// addColorPalatOption($wp_customize, 'header_cartbtnhovbgColor', 'peccular_header_section', 'Cart Button Hover BG Color','');
// addColorPalatOption($wp_customize, 'header_cartbtncounterbgcolor', 'peccular_header_section', 'Cart Counter BG Color','');
// addColorPalatOption($wp_customize, 'header_cartbtncountrtxtColor', 'peccular_header_section', 'Cart Counter Text Color','');


?>