<?php 
    $wp_customize->add_section(
        'peccular_aboutus_section',
        array(
            'title' => __( 'About us', 'peccular-premium' ),
            'panel' => 'peccular_premium_home_panel1',
            'priority' =>19
        )
    );


$wp_customize->add_setting('peccular_aboutus_nav', array(
       'sanitize_callback' => 'wp_kses_post',
    ));

    $wp_customize->add_control(new peccular_Tab_Control($wp_customize, 'peccular_aboutus_nav', array(
       'section' => 'peccular_aboutus_section',
       'priority' => 1,
       'buttons' => array(
          array(
             'name' => esc_html__('General', 'peccular-premium'),
            'icon' => 'dashicons dashicons-welcome-write-blog',
            'fields' => array(
                'peccular_aboutus_enable',
                'peccular_aboutus_image',                
                'peccular_aboutus_subtitle',
                'peccular_aboutus_section_lbl1',
                'peccular_aboutus_section_title1',
                'peccular_aboutus_section_title2',
                'peccular_aboutus_section_secondpara',
                'peccular_aboutus_section_snum',
                'peccular_aboutus_section_firstpara',
                'peccular_aboutus_section_fnum',
                'peccular_aboutus_section_callt',
                 'peccular_aboutus_section_callnum',
                'peccular_aboutus_section_icon',
                'peccular_aboutus_solar_icon',
                'peccular_aboutus_text',
                'peccular_about_acbutton_text',
                'aboutanimations_icon_display',
                'peccular_aboutmyaccounturl'               
                
               
            ),
            'active' => true,
         ),
          array(
            'name' => esc_html__('Style', 'peccular-premium'),
            'icon' => 'dashicons dashicons-art',
            'fields' => array(
                'peccular_aboutus_section_bg_color',
                'peccular_aboutus_section_bg_image',
                'peccular_aboutus_box_onload_effects',
                'peccular_aboutus_head_align',                               
                'peccular_aboutus_sheading_color',
                'peccular_aboutus_sdescription_color',
                'peccular_aboutus_sheadingsub_color',
                'peccular_aboutus_btntext_color',
                'peccular_aboutus_btntexthov_color',
                'peccular_aboutus_btnbg_color1',
                'peccular_aboutus_btnbg_color2',
                'peccular_aboutus_btnhovbg_color',
                'peccular_aboutus_leftcirclebg_color',
                'peccular_aboutus_sheadingsubspan_color',
                'peccular_aboutus_counticon_color', 
                'peccular_aboutus_counttext_color',
                'peccular_aboutus_sleftbor_color',
                'peccular_aboutus_bottomborder_color',
                'peccular_aboutus_callicon_color',
                'peccular_aboutus_calliconbor_color',
                'peccular_aboutus_calltit_color',
                'peccular_aboutus_callnumber_color',
                'peccular_aboutus_middicon_color',
                'peccular_aboutus_middiconbor_color',
                'peccular_aboutus_sheadingsubhov_color'

            ),
         ),
          array(
            'name' => esc_html__('Layout', 'peccular-premium'),
            'icon' => 'dashicons dashicons-layout',
            'fields' => array(
                'peccular_aboutus_padding',
                'peccular_aboutus_section_t_padding',
                'peccular_aboutus_section_b_padding',
                'peccular_aboutus_section_width'
            ),
         )
        ),
    )));

    $wp_customize->add_setting( 'peccular_aboutus_enable',array(
        'default' => true,
        'sanitize_callback' => 'peccular_switch_sanitization'
    ) );
    $wp_customize->add_control( new peccular_Toggle_Switch_Custom_Control( $wp_customize, 'peccular_aboutus_enable',array(
        'label' => __( 'Disable Section','peccular' ),
        'section' => 'peccular_aboutus_section'
    )));

    $wp_customize->add_setting( 'peccular_aboutus_image', array(
       'default' => '',
       'sanitize_callback' => 'esc_url_raw'
    ));
    $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'peccular_aboutus_image', array(
        'label' => __('Our Story Image','peccular'),
       'section' => 'peccular_aboutus_section',
    )));


    $wp_customize->add_setting('peccular_aboutus_section_lbl1', array('sanitize_callback'=>'peccular_sanitize_text'));
    $wp_customize->add_control(
    new peccular_Info_Text( 
        $wp_customize,
        'peccular_aboutus_section_lbl1',
        array(
            'settings'      => 'peccular_aboutus_section_lbl1',
            'section'       => 'peccular_aboutus_section',
            'label'         => __( 'Note:', 'peccular Premium' ), 
            'description'   => __( 'Take Left Image size 630px x 472px  ', 'peccular Premium' ),
        )
    )
);

    // to show & hide Heading Image
$wp_customize->add_setting( 'aboutanimations_icon_display' , array( 'default' => true, 'transport' => 'refresh', ) );
 $wp_customize->add_control( 'aboutanimations_icon_display', array( 'label' => 'Animation Image Display', 'section' => 'peccular_aboutus_section', 'settings' => 'aboutanimations_icon_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Image', 'hide' => 'Hide Image', ), ) );  


$wp_customize->add_setting(
        'peccular_aboutus_solar_icon',
        array(
            'default'           => 'fa fa-home',
            'sanitize_callback' => 'peccular_sanitize_text'
        )
    );        
    $wp_customize->add_control(
        new peccular_Fontawesome_Icon_Chooser(
            $wp_customize,
            'peccular_aboutus_solar_icon',
            array(
                'settings'      => 'peccular_aboutus_solar_icon',
                'section'       => 'peccular_aboutus_section',
                'type'          => 'icon',
                'label'         => __( 'Image FontAwesome Icon', 'peccular-premium' ),
            )
        )
    );

$wp_customize->add_setting(
    'peccular_aboutus_section_title1',
    array(
        'sanitize_callback' => 'peccular_sanitize_text',
        'default'           => __( 'About Our Company ~', 'peccular-premium' )
    )
);
$wp_customize->add_control(
    'peccular_aboutus_section_title1',
    array(
        'settings'      => 'peccular_aboutus_section_title1',
        'section'       => 'peccular_aboutus_section', 
        'type'          => 'text',
        'label'         => __( 'Section Title', 'peccular-premium' )
    )
);


$wp_customize->add_setting(
    'peccular_aboutus_section_title2',
    array(
        'sanitize_callback' => 'peccular_sanitize_text',
        'default'           => __( 'Ready To <span>Foster Growth</span> Of Solar Energy', 'peccular-premium' )
    )
);
$wp_customize->add_control(
    'peccular_aboutus_section_title2',
    array(
        'settings'      => 'peccular_aboutus_section_title2',
        'section'       => 'peccular_aboutus_section', 
        'type'          => 'text',
        'label'         => __( 'Section Sub Title', 'peccular-premium' )
    )
);


$wp_customize->add_setting(
    'peccular_aboutus_text',
    array(
        'sanitize_callback' => 'peccular_sanitize_text',
        'default'           => __( 'There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly' )
    )
);
$wp_customize->add_control(
    'peccular_aboutus_text',
    array(
        'settings'      => 'peccular_aboutus_text',
        'section'       => 'peccular_aboutus_section', 
        'type'          => 'textarea',
        'label'         => __( 'Section Description', 'peccular-premium' )
    )
);

$wp_customize->add_setting(
        'peccular_aboutus_section_icon',
        array(
            'default'           => 'fa fa-cogs',
            'sanitize_callback' => 'peccular_sanitize_text'
        )
    );        
    $wp_customize->add_control(
        new peccular_Fontawesome_Icon_Chooser(
            $wp_customize,
            'peccular_aboutus_section_icon',
            array(
                'settings'      => 'peccular_aboutus_section_icon',
                'section'       => 'peccular_aboutus_section',
                'type'          => 'icon',
                'label'         => __( 'FontAwesome Icon', 'peccular-premium' ),
            )
        )
    );


$wp_customize->add_setting(
    'peccular_aboutus_section_fnum',
    array(
        'sanitize_callback' => 'peccular_sanitize_text',
        'default'           => __( '11000+' )
    )
);
$wp_customize->add_control(
    'peccular_aboutus_section_fnum',
    array(
        'settings'      => 'peccular_aboutus_section_fnum',
        'section'       => 'peccular_aboutus_section', 
        'type'          => 'text',
        'label'         => __( 'About Plan 1', 'peccular-premium' )
    )
);
$wp_customize->add_setting(
    'peccular_aboutus_section_firstpara',
    array(
        'sanitize_callback' => 'peccular_sanitize_text',
        'default'           => __( 'Wtgs Installed' )
    )
);
$wp_customize->add_control(
    'peccular_aboutus_section_firstpara',
    array(
        'settings'      => 'peccular_aboutus_section_firstpara',
        'section'       => 'peccular_aboutus_section', 
        'type'          => 'text',
        'label'         => __( 'About 1 Text', 'peccular-premium' )
    )
);

$wp_customize->add_setting(
    'peccular_aboutus_section_snum',
    array(
        'sanitize_callback' => 'peccular_sanitize_text',
        'default'           => __( '16000+' )
    )
);
$wp_customize->add_control(
    'peccular_aboutus_section_snum',
    array(
        'settings'      => 'peccular_aboutus_section_snum',
        'section'       => 'peccular_aboutus_section', 
        'type'          => 'text',
        'label'         => __( 'About Plan 2', 'peccular-premium' )
    )
);
$wp_customize->add_setting(
    'peccular_aboutus_section_secondpara',
    array(
        'sanitize_callback' => 'peccular_sanitize_text',
        'default'           => __( 'Installed Capacity' )
    )
);
$wp_customize->add_control(
    'peccular_aboutus_section_secondpara',
    array(
        'settings'      => 'peccular_aboutus_section_secondpara',
        'section'       => 'peccular_aboutus_section', 
        'type'          => 'text',
        'label'         => __( 'About 2 Text', 'peccular-premium' )
    )
);
$wp_customize->add_setting(
    'peccular_about_acbutton_text',
    array(
        'sanitize_callback' => 'peccular_sanitize_text',
        'default'           => __( 'contact us' )
    )
);
$wp_customize->add_control(
    'peccular_about_acbutton_text',
    array(
        'settings'      => 'peccular_about_acbutton_text',
        'section'       => 'peccular_aboutus_section',
        'type'          => 'text',
        'label'         => __( 'Button Text', 'peccular-premium' )
    )
);

$wp_customize->add_setting(
    'peccular_aboutmyaccounturl', 
    array('default'=> 'add link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control(
    'peccular_aboutmyaccounturl',
    array(
        'settings'      => 'peccular_aboutmyaccounturl',
        'section'       => 'peccular_aboutus_section',
        'type'          => 'url',
        'label'         => __( 'Add Button Link Here', 'peccular-premium' )
    )
);   
$wp_customize->add_setting(
    'peccular_aboutus_section_callt',
    array(
        'sanitize_callback' => 'peccular_sanitize_text',
        'default'           => __( 'Call for help' )
    )
);
$wp_customize->add_control(
    'peccular_aboutus_section_callt',
    array(
        'settings'      => 'peccular_aboutus_section_callt',
        'section'       => 'peccular_aboutus_section', 
        'type'          => 'text',
        'label'         => __( 'Contact Box Heading', 'peccular-premium' )
    )
);
$wp_customize->add_setting(
    'peccular_aboutus_section_callnum',
    array(
        'sanitize_callback' => 'peccular_sanitize_text',
        'default'           => __( ' 111-222-333' )
    )
);
$wp_customize->add_control(
    'peccular_aboutus_section_callnum',
    array(
        'settings'      => 'peccular_aboutus_section_callnum',
        'section'       => 'peccular_aboutus_section', 
        'type'          => 'text',
        'label'         => __( 'Contact Box Number', 'peccular-premium' )
    )
);


$wp_customize->add_setting( 'peccular_aboutus_section_bg_color', array(
       'default' => '',
       'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'peccular_aboutus_section_bg_color', array(
        'label' => __('Section Background Color','peccular'),
       'section' => 'peccular_aboutus_section',
    )));

$wp_customize->add_setting( 'peccular_aboutus_section_bg_image', array(
       'default' => '',
       'sanitize_callback' => 'esc_url_raw'
    ));
    $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'peccular_aboutus_section_bg_image', array(
        'label' => __('Section Background Image','peccular'),
       'section' => 'peccular_aboutus_section',
    )));
    


    $wp_customize->add_setting('peccular_aboutus_box_onload_effects',array(
        'default' => 'zoom-in',
        'sanitize_callback' => 'peccular_sanitize_choices',
    ));
    $wp_customize->add_control('peccular_aboutus_box_onload_effects',array(
        'type' => 'select',
        'label' => __('Block Onload Transition Effects','peccular'),
        'choices' => array (
            'wow bounceInLeft' => __('Bounce In Left','peccular'),
            'wow bounceInRight' => __('Bounce In Right','peccular'),
            'wow bounceInUp' => __('Bounce In Up','peccular'),
            'wow bounceInDown' => __('Bounce In Down','peccular'),
            'wow zoomIn' => __('Zoom In','peccular'),
            'wow zoomOut' => __('Zoom Out','peccular'),
            'wow fadeInDown' => __('Fade In Down','peccular'),            
            'wow fadeInUp' => __('Fade In Up','peccular'),
            'wow fadeInLeft' => __('Fade In Left','peccular'),
            'wow fadeInRight' => __('Fade In Right','peccular'),
            'flip-up' => __('Flip Up','peccular')
        ),
        'section' => 'peccular_aboutus_section',
    ));

         $wp_customize->add_setting('peccular_aboutus_head_align',array(
        'default' => 'Left',
        'sanitize_callback' => 'peccular_sanitize_choices',
    ));
    $wp_customize->add_control('peccular_aboutus_head_align',array(
        'type' => 'select',
        'label' => __('Section Heading Alignment','peccular'),
        'choices' => array (
            'Center' => __('Center','peccular'),
            'Left' => __('Left','peccular'),
            'Right' => __('Right','peccular')
        ),
        'section' => 'peccular_aboutus_section',
    ));


    $wp_customize->add_setting('peccular_aboutus_padding',array(
      'sanitize_callback'   => 'esc_html'
   ));
   $wp_customize->add_control('peccular_aboutus_padding',array(
      'label' => __('Section Padding','peccular'),
      'section' => 'peccular_aboutus_section'
   ));

    $wp_customize->add_setting('peccular_aboutus_section_t_padding',array(
        'default' => '0',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('peccular_aboutus_section_t_padding',array(
    'type' => 'number',
    'label' => __('Top','peccular'),
    'section' => 'peccular_aboutus_section',
    ));
     $wp_customize->add_setting('peccular_aboutus_section_b_padding',array(
        'default' => '2',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('peccular_aboutus_section_b_padding',array(
    'type' => 'number',
    'label' => __('Bottom','peccular'),
    'section' => 'peccular_aboutus_section',
    ));

    $wp_customize->add_setting('peccular_aboutus_section_width',array(
        'default' => 'Box Width',
        'sanitize_callback' => 'peccular_sanitize_choices',
    ));
    $wp_customize->add_control('peccular_aboutus_section_width',array(
        'type' => 'select',
        'label' => __('Section Width','peccular'),
        'choices' => array (
            'Box Width' => __('Box Width','peccular'),
            'Full Width' => __('Full Width','peccular')
        ),
        'section' => 'peccular_aboutus_section',
    ));



addColorPalatOption($wp_customize, 'peccular_aboutus_middicon_color', 'peccular_aboutus_section', 'Middle Icon BG Color', '');
addColorPalatOption($wp_customize, 'peccular_aboutus_middiconbor_color', 'peccular_aboutus_section', 'Middle Icon Border Color', '');
addColorPalatOption($wp_customize, 'peccular_aboutus_sheading_color', 'peccular_aboutus_section', 'Section Heading Color', '');
addColorPalatOption($wp_customize, 'peccular_aboutus_sheadingsub_color', 'peccular_aboutus_section', 'Section Sub Heading Color', '');
addColorPalatOption($wp_customize, 'peccular_aboutus_sheadingsubspan_color', 'peccular_aboutus_section', 'Section Sub Heading Span Color', '');
addColorPalatOption($wp_customize, 'peccular_aboutus_sheadingsubhov_color', 'peccular_aboutus_section', 'Section Heading BG Color', '');
addColorPalatOption($wp_customize, 'peccular_aboutus_sdescription_color', 'peccular_aboutus_section', 'Section Description Color', '');
addColorPalatOption($wp_customize, 'peccular_aboutus_sleftbor_color', 'peccular_aboutus_section', '  Left Border Color', '');
addColorPalatOption($wp_customize, 'peccular_aboutus_counticon_color', 'peccular_aboutus_section', ' About Plan Icon Color', '');
addColorPalatOption($wp_customize, 'peccular_aboutus_counttext_color', 'peccular_aboutus_section', ' About Plan Text Color', '');
addColorPalatOption($wp_customize, 'peccular_aboutus_bottomborder_color', 'peccular_aboutus_section', ' About Plan Bottom Border Color', '');

addColorPalatOption($wp_customize, 'peccular_aboutus_btntext_color', 'peccular_aboutus_section', 'Button Text Color', '');
addColorPalatOption($wp_customize, 'peccular_aboutus_btntexthov_color', 'peccular_aboutus_section', 'Button Text Hover Color', '');
addColorPalatOption($wp_customize, 'peccular_aboutus_btnbg_color1', 'peccular_aboutus_section', 'Button BG Color', '');
addColorPalatOption($wp_customize, 'peccular_aboutus_btnbg_color2', 'peccular_aboutus_section', 'Button BG Color', '');
// addColorPalatOption($wp_customize, 'peccular_aboutus_btnhovbg_color', 'peccular_aboutus_section', 'Button Hover BG Color', '');
addColorPalatOption($wp_customize, 'peccular_aboutus_callicon_color', 'peccular_aboutus_section', 'Call Icon Color', '');
addColorPalatOption($wp_customize, 'peccular_aboutus_calliconbor_color', 'peccular_aboutus_section', 'Call Icon Border Color', '');
addColorPalatOption($wp_customize, 'peccular_aboutus_calltit_color', 'peccular_aboutus_section', 'Call Title Color', '');
addColorPalatOption($wp_customize, 'peccular_aboutus_callnumber_color', 'peccular_aboutus_section', 'Call Number Color', '');

?>