<?php
// Adjusted Go Pro button logic
function add_gopro_button_customizer_script() {
    ?>
    <script type="text/javascript">
        jQuery(document).ready(function ($) {
            // Target second-level section titles like "Slider Section", "About Us Section", etc.
            var targetSections = ['Features Section', 'Our Facilities', 'Contact Info', 'Counterbox', 'Team Members', 'Contact', 'Testimonials', 'Gallery','Blog Posts','Newsletter'];
 
            // Loop through each section title and append the "Go Pro" button
            targetSections.forEach(function (title) {
                // Find the section title by its text
                $('h3:contains("' + title + '")').each(function () {
                    var sectionTitle = $(this);

                    // Check if the button already exists
                    if (!sectionTitle.siblings('.go_pro_button').length) {
                        // Create the "Go Pro" button
                        var proButton = $('<a>', {
                            class: 'button button-primary go_pro_button',
                            href: 'https://www.buywpthemes.net/products/solar-energy-wordpress-theme?_pos=1&_psq=solar&_ss=e&_v=1.0',
                            target: '_blank',
                            text: 'Go Pro'
                        });

                        // Insert the button after the title (not inside it)
                        sectionTitle.after(proButton);
                    }
                });
            });
        });
    </script>
    <?php
}
add_action('customize_controls_print_footer_scripts', 'add_gopro_button_customizer_script');
?>