<?php 
$wp_customize->add_section(
    'peccular_service_section',
    array(
        'title'   => __( 'Services', 'peccular' ),
        'panel'   => 'peccular_premium_home_panel1',
        'priority' =>20
    )
);

$wp_customize->add_setting('peccular_Services_nav', array(
       'sanitize_callback' => 'wp_kses_post',
    ));

    $wp_customize->add_control(new peccular_Tab_Control($wp_customize, 'peccular_Services_nav', array(
       'section' => 'peccular_service_section',
       'priority' => 1,
       'buttons' => array(
          array(
             'name' => esc_html__('General', 'peccular-premium'),
            'icon' => 'dashicons dashicons-welcome-write-blog',
            'fields' => array(
                'peccular_service_enable', 
                'peccular_services_maintitle',              
                'peccular_service_area_lbl',
                'peccular_service_section_lbl', 
                'peccular_service_number', 
                'peccular_service_heading1',
                'peccular_service_heading2',
                'peccular_service_heading3',
                'peccular_service_heading4',
                'peccular_service_heading5',
                'peccular_service_heading6',
                'peccular_service_heading7',
                'peccular_service_heading8',
                'peccular_service_heading9',
                'peccular_service_heading10',
                'peccular_service_heading11',
                'peccular_service_heading12',
                'peccular_service_page1',
                'peccular_service_page2',
                'peccular_service_page3',
                'peccular_service_page4',
                'peccular_service_page5',
                'peccular_service_page6',
                'peccular_service_page7',
                'peccular_service_page8',
                'peccular_service_page9',
                'peccular_service_page10',
                'peccular_service_page11',
                'peccular_service_page12',
                'peccular_service_page_icon_left1',                
                'peccular_service_page_icon_left2',                
                'peccular_service_page_icon_left3',                
                'peccular_service_page_icon_left4',                
                'peccular_service_page_icon_left5',                
                'peccular_service_page_icon_left6',                
                'peccular_service_page_icon_left7',                
                'peccular_service_page_icon_left8',                
                'peccular_service_page_icon_left9',                
                'peccular_service_page_icon_left10',                
                'peccular_service_page_icon_left11',                
                'peccular_service_page_icon_left12',                
                'peccular_service_icon_enable',
                'peccular_service_button_enable',
                'peccular_service_button_text'
            ),
            'active' => true,
         ),
          array(
            'name' => esc_html__('Style', 'peccular-premium'),
            'icon' => 'dashicons dashicons-art',
            'fields' => array(
                'peccular_service_section_bg_color',
                'peccular_service_section_bg_image',
                'peccular_service_image_opacity',  
                'peccular_services_imghover_color',      
                'peccular_service_box_onload_effects',
                'peccular_service_title_case',
                'peccular_services_head_align',         
                'peccular_services_heading_color1',
                'peccular_services_btntext_color',
                'peccular_services_title_color1',
                'peccular_services_text_color',
                'peccular_services_contbg_color',
                'peccular_services_btntexthov_color',
                'peccular_services_btnbg_color',
                'peccular_services_btnhovbg_color',
                'peccular_services_imgbrdr_color',
                'peccular_services_subhead_color',
                'peccular_services_contbor_color',
                'peccular_services_contbor_color2',
                'peccular_services_btnborder_color',
                'peccular_services_imgoverlay_color',
                'peccular_services_headingspan_color1',
                'peccular_services_imgbrdrhov_color'               

            ),
         ),
          array(
            'name' => esc_html__('Layout', 'peccular-premium'),
            'icon' => 'dashicons dashicons-layout',
            'fields' => array(
                'peccular_service_padding',                
                'peccular_service_top_padding',
                'peccular_service_bottom_padding',                 
                 'peccular_service_section_width',                
                'peccular_services_post_image_height',                
                'peccular_services_post_excerpt'
            ),
         )
        ),
    )));

$wp_customize->add_setting( 'peccular_service_enable',array(
    'default' => true,
    'sanitize_callback' => 'peccular_switch_sanitization'
) );
$wp_customize->add_control( new peccular_Toggle_Switch_Custom_Control( $wp_customize, 'peccular_service_enable',array(
    'label' => __( 'Disable Section','peccular' ),
    'section' => 'peccular_service_section'
)));

$wp_customize->add_setting(
    'peccular_services_maintitle',
    array(
        'sanitize_callback' => 'peccular_sanitize_text',
        'default'           => __( 'Our <span>SERVICES</span>', 'peccular' )
    )
);
$wp_customize->add_control(
    'peccular_services_maintitle',
    array(
        'settings'      => 'peccular_services_maintitle',
        'section'       => 'peccular_service_section', 
        'type'          => 'text',
        'label'         => __( 'Section Heading', 'peccular' )
    )
);

$wp_customize->add_setting(
    'peccular_servicestitle2',
    array(
        'sanitize_callback' => 'peccular_sanitize_text',
        'default'           => __( 'There are many', 'peccular' )
    )
);
$wp_customize->add_control(
    'peccular_servicestitle2',
    array(
        'settings'      => 'peccular_servicestitle2',
        'section'       => 'peccular_service_section', 
        'type'          => 'text',
        'label'         => __( 'Section Sub Heading', 'peccular' )
    )
);
$ServicesSingleChoice[] = 'select';
if(!is_array($ServicesSingleChoice)){
    $wp_customize->add_setting('peccular_service_area_lbl', array('sanitize_callback'=>'peccular_sanitize_text'));
    $wp_customize->add_control(
        new peccular_Info_Text( 
            $wp_customize,
            'peccular_service_area_lbl',
            array(
                'settings'      => 'peccular_service_area_lbl',
                'section'       => 'peccular_service_section',
                'label'         => __( 'Note:', 'peccular Premium' ), 
                'description'   => __( '<strong>Changes will not reflect unless you select the service.</strong> <br/>Please add the service from "service menu" and then select Testimonial to show information.', 'peccular Premium' ),
            )
        )
    );
}
$wp_customize->add_setting('peccular_service_section_lbl', array('sanitize_callback'=>'peccular_sanitize_text'));
$wp_customize->add_control(
    new peccular_Info_Text( 
        $wp_customize,
        'peccular_service_section_lbl',
        array(
            'settings'      => 'peccular_service_section_lbl',
            'section'       => 'peccular_service_section',
            'label'         => __( 'Note:', 'peccular Premium' ), 
            'description'   => __( 'Just place the shortcode "[SERVICES]" in your page to list the service in a page ', 'peccular Premium' ),
        )
    )
);

$wp_customize->add_setting('peccular_service_number',array('sanitize_callback' => 'peccular_sanitize_text','default' => 3));
$wp_customize->add_control(
    'peccular_service_number',
    array(
        'settings'      => 'peccular_service_number',
        'section'       => 'peccular_service_section',
        'type'          => 'select',
        'label'         => __( 'Number Of Service To Show', 'peccular-premium' ),
        'choices'=>array(1,2,3,4,5,6,7,8,9,10,11,12)
    )
);

//service PAGES
for( $i = 1; $i<= 12; $i++ ){
    $wp_customize->add_setting(
        'peccular_service_heading'.$i,
        array(
            'sanitize_callback' => 'peccular_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new peccular_Customize_Heading(
            $wp_customize,
            'peccular_service_heading'.$i,
            array(
                'settings'      => 'peccular_service_heading'.$i,
                'section'       => 'peccular_service_section',
                'label'         => __( 'Service ', 'peccular Premium' ).$i,
            )
        )
    );
    $wp_customize->add_setting(
        'peccular_service_page'.$i,
        array(
            'sanitize_callback' => 'absint'
        )
    );
    $wp_customize->add_control(
        'peccular_service_page'.$i,
        array(
            'settings'      => 'peccular_service_page'.$i,
            'section'       => 'peccular_service_section',
            'type'=> 'select',
            'label'         => __( 'Select A Services', 'peccular Premium' ),
            'choices' => $ServicesSingleChoice,
        )
    );

    $wp_customize->add_setting(
        'peccular_service_page_icon_left'.$i,
        array(
            'default'           => 'fa fa-cogs',
            'sanitize_callback' => 'peccular_sanitize_text'
        )
    );        
    $wp_customize->add_control(
        new peccular_Fontawesome_Icon_Chooser(
            $wp_customize,
            'peccular_service_page_icon_left'.$i,
            array(
                'settings'      => 'peccular_service_page_icon_left'.$i,
                'section'       => 'peccular_service_section',
                'type'          => 'icon',
                'label'         => __( 'FontAwesome Icon', 'peccular-premium' ),
            )
        )
    );

}

  $wp_customize->add_setting( 'peccular_service_section_bg_color', array(
       'default' => '',
       'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'peccular_service_section_bg_color', array(
        'label' => __('Section Background Color','peccular'),
       'section' => 'peccular_service_section',
    )));

    $wp_customize->add_setting( 'peccular_service_section_bg_image', array(
       'default' => '',
       'sanitize_callback' => 'esc_url_raw'
    ));
    $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'peccular_service_section_bg_image', array(
        'label' => __('Section Background Image','peccular'),
       'section' => 'peccular_service_section',
    )));


 $wp_customize->add_setting('peccular_service_image_opacity',array(
        'default' => 0.7,
        'sanitize_callback' => 'peccular_sanitize_float'
    ));
    $wp_customize->add_control(new peccular_Custom_Control( $wp_customize, 'peccular_service_image_opacity',array(
    'label' => __('Background Opacity','peccular'),
    'section' => 'peccular_service_section',
    'input_attrs' => array(
            'min' => 0,
            'max' => 1,
            'step' => 0.1,
        ),
    )));

 $wp_customize->add_setting('peccular_service_box_onload_effects',array(
        'default' => 'wow zoomIn',
        'sanitize_callback' => 'peccular_sanitize_choices',
    ));
    $wp_customize->add_control('peccular_service_box_onload_effects',array(
        'type' => 'select',
        'label' => __('Box Onload Transition Effects','peccular'),
        'choices' => array (
            'wow bounceInLeft' => __('Bounce In Left','peccular'),
            'wow bounceInRight' => __('Bounce In Right','peccular'),
            'wow bounceInUp' => __('Bounce In Up','peccular'),
            'wow bounceInDown' => __('Bounce In Down','peccular'),
            'wow zoomIn' => __('Zoom In','peccular'),
            'wow zoomOut' => __('Zoom Out','peccular'),
            'wow fadeInDown' => __('Fade In Down','peccular'),            
            'wow fadeInUp' => __('Fade In Up','peccular'),
            'wow fadeInLeft' => __('Fade In Left','peccular'),
            'wow fadeInRight' => __('Fade In Right','peccular'),
            'flip-up' => __('Flip Up','peccular')
        ),
        'section' => 'peccular_service_section',
    ));

    

 
     $wp_customize->add_setting('peccular_service_title_case',array(
        'default' => 'Capitalize',
        'sanitize_callback' => 'peccular_sanitize_choices',
    ));
    $wp_customize->add_control('peccular_service_title_case',array(
        'type' => 'select',
        'label' => __('Services Title Case','peccular'),
        'choices' => array (
            'Uppercase' => __('Uppercase','peccular'),
            'Lowercase' => __('Lowercase','peccular'),
            'Capitalize' => __('Capitalize','peccular'),
            'None' => __('None','peccular')
        ),
        'section' => 'peccular_service_section',
    ));


addColorPalatOption($wp_customize, 'peccular_services_heading_color1', 'peccular_service_section', 'Heading Color', '');
addColorPalatOption($wp_customize, 'peccular_services_headingspan_color1', 'peccular_service_section', 'Heading Span Color', '');
addColorPalatOption($wp_customize, 'peccular_services_imgbrdr_color', 'peccular_service_section', 'Heading Border Color', '');
addColorPalatOption($wp_customize, 'peccular_services_subhead_color', 'peccular_service_section', 'Subheading Color', '');
addColorPalatOption($wp_customize, 'peccular_services_imgbrdrhov_color', 'peccular_service_section', 'Subheading BG Color', '');
addColorPalatOption($wp_customize, 'peccular_services_imgoverlay_color', 'peccular_service_section', 'Image Overlay Color', '');
addColorPalatOption($wp_customize, 'peccular_services_title_color1', 'peccular_service_section', 'Title color', '');
addColorPalatOption($wp_customize, 'peccular_services_text_color', 'peccular_service_section', 'Text color ', '');
addColorPalatOption($wp_customize, 'peccular_services_contbg_color', 'peccular_service_section', 'Content Box color ', '');
addColorPalatOption($wp_customize, 'peccular_services_contbor_color', 'peccular_service_section', 'Content Border color ', '');
addColorPalatOption($wp_customize, 'peccular_services_contbor_color2', 'peccular_service_section', 'Content Border color ', '');
addColorPalatOption($wp_customize, 'peccular_services_btntext_color', 'peccular_service_section', 'Button Text Color', '');
addColorPalatOption($wp_customize, 'peccular_services_btntexthov_color', 'peccular_service_section', 'Button Text Hover Color', '');
addColorPalatOption($wp_customize, 'peccular_services_btnborder_color', 'peccular_service_section', 'Button Border Color', '');
addColorPalatOption($wp_customize, 'peccular_services_btnbg_color', 'peccular_service_section', 'Button BG Color', '');
addColorPalatOption($wp_customize, 'peccular_services_btnhovbg_color', 'peccular_service_section', 'Button Hover BG Color', '');




 $wp_customize->add_setting('peccular_service_padding',array(
      'sanitize_callback'   => 'esc_html'
   ));
   $wp_customize->add_control('peccular_service_padding',array(
      'label' => __('Section Padding','peccular'),
      'section' => 'peccular_service_section'
   ));

    $wp_customize->add_setting('peccular_service_top_padding',array(
        'default' => '5',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('peccular_service_top_padding',array(
    'type' => 'number',
    'label' => __('Top','peccular'),
    'section' => 'peccular_service_section',
    ));
     $wp_customize->add_setting('peccular_service_bottom_padding',array(
        'default' => '4',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('peccular_service_bottom_padding',array(
    'type' => 'number',
    'label' => __('Bottom','peccular'),
    'section' => 'peccular_service_section',
    ));


  $wp_customize->add_setting('peccular_service_section_width',array(
        'default' => 'Box width',
        'sanitize_callback' => 'peccular_sanitize_choices',
    ));
    $wp_customize->add_control('peccular_service_section_width',array(
        'type' => 'select',
        'label' => __('Section Width','peccular'),
        'choices' => array (
            'Box Width' => __('Box Width','peccular'),
            'Full Width' => __('Full Width','peccular')
        ),
        'section' => 'peccular_service_section',
    ));


// backgroundManager($wp_customize, 'services', 'peccular_service_section', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');

$wp_customize->add_setting('peccular_services_post_image_height',array(
        'default' => 'auto',
        'sanitize_callback' => 'peccular_sanitize_integer'
    ));
    $wp_customize->add_control(new peccular_Custom_Control( $wp_customize, 'peccular_services_post_image_height',array(
    'label' => __('Image Height','peccular'),
    'section' => 'peccular_service_section',
    'input_attrs' => array(
            'min' => 0,
            'max' => 500,
            'step' => 1,
        ),
    )));

    $wp_customize->add_setting('peccular_services_post_excerpt',array(
        'default' => 8,
        'sanitize_callback' => 'peccular_sanitize_integer'
    ));
    $wp_customize->add_control(new peccular_Custom_Control( $wp_customize, 'peccular_services_post_excerpt',array(
    'label' => __('Excerpt Length','peccular'),
    'section' => 'peccular_service_section',
    'input_attrs' => array(
            'min' => 0,
            'max' => 100,
            'step' => 1,
        ),
    )));
?>