<?php
/**
 * peccular.
 *
 * @package peccular Premium
 */
require "class/customizer-classes.php";
/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function peccular_lite_customize_register( $wp_customize ) {
 
    load_template( trailingslashit( get_template_directory() ) . '/inc/tab-control.php' );

    global $wp_registered_sidebars;

    $peccular_categories = get_categories(array('hide_empty' => 0));
    foreach ($peccular_categories as $peccular_category) {
        $peccular_cat[$peccular_category->term_id] = $peccular_category->cat_name;
    }
    
    $peccular_pages = get_pages(array('hide_empty' => 0));
    foreach ($peccular_pages as $peccular_pages_single) {
        $peccular_page_choice[$peccular_pages_single->ID] = $peccular_pages_single->post_title; 
    }

    for ( $i = 1; $i <= 100 ; $i++) { 
        $peccular_percentage[$i] = $i; 
    }

    // $peccularTeams = get_posts(array('hide_empty' => 0, 'post_type'=>'peccular_teams'));
    // foreach ($peccularTeams as $peccularTeamsSingle) {
    //     $peccularTeamsSingleChoice[$peccularTeamsSingle->ID] = $peccularTeamsSingle->post_title; 
    // }
    $TeamSingleChoice = getpeccularPostsType('our-team'); 
    $TesimonialsSingleChoice = getpeccularPostsType('our-testimonial');    
    $ServicesSingleChoice = getpeccularPostsType('our-services');
    $peccularfaqSingleChoice = getpeccularPostsType('our-faq');
    $GallerySingleChoice = getpeccularPostsType('our-gallery');
    
    $peccular_post_count_choice = array( 3 => 3, 6 => 6, 9 => 9, 12 => 12, 15 => 15, 18 => 18, 21 => 21 ); 


    /*---------------------
    * Theme Options
    ----------------------*/
    $wp_customize->add_panel( 'panel_id', array(
        'priority'       => 121,
        'capability'     => 'edit_theme_options',
        'title'          => __('Theme Design Options', 'peccular Premium'),
        'description'    => __('Theme Design Options', 'peccular Premium'),
    ) ); 

    /********************* HOME PAGE SETTINGS *************************/
    /*---------------------------- START -----------------------------*/
    $wp_customize->add_panel(
        'peccular_premium_home_panel1',
        array(
            'title' => __( 'Home Sections', 'peccular Premium' ),
            'priority' => 19
        )
    );
    
    // echo 'header color'. 
    $headingColor = get_theme_mod('peccular_title_color', '#fe5722');
    // START SLIDER SECTION 
    include "homeSettings/goprobutton.php";
    include "homeSettings/slider-customizer.php";    
    include "homeSettings/aboutus-customizer.php";
    include "homeSettings/services-customizer.php"; 
    include "homeSettings/features-customizer.php";
    include "homeSettings/facility-customizer.php"; 
    include "homeSettings/contactinfo-customizer.php"; 
    include "homeSettings/counter-customizer.php";   
    include "homeSettings/team-customizer.php";     
    include "homeSettings/testimonial-costomizer.php";
    include "homeSettings/contact-customizer.php";
    include "homeSettings/gallery-customizer.php";   
    include "homeSettings/blog-customizer.php";   
    include "homeSettings/newsletter-customizer.php";   
 
    /*---------------------------- END -------------------------------*/
    /******  GENERAL SETTINGS PANEL START *******/
    include "generalSttings/general-section.php";    
    include "generalSttings/font-customizer.php";   
    /******  GENERAL SETTINGS PANEL END *******/
    //header
    include "headerSettings/header-allsetting.php";
    include "headerSettings/header-logosetting.php"; 
    include "headerSettings/header-menusetting.php"; 

    // inner page
    include "pageSettings/innerpages.php";
    include "pageSettings/singlepost.php";
    include "pageSettings/contactpage.php";
    include "pageSettings/serviceinnerpage.php";  
    

    include "otherSettings/allsetting.php";
    include "otherSettings/fontsetting.php";
    include "otherSettings/breadcrumb.php";

    include "footerSettings/footerset.php";

    // CONTACT US PAGE
    include "homesection-sequence.php";
    
    wp_enqueue_style( 'home1css', get_template_directory_uri() . '/css/home1.css', array(), '4.1.1' );

    /**************************************************/
    /*****                 Info                   *****/
    /**************************************************/
    $wp_customize->add_section(
        'peccular_new',
        array(
            'title' => __('Help & Contact', 'peccular Premium'),
            'priority' => 0,
            'description' => __('
             <p><strong>Instruction - Setting up Home Page</strong>
             <br/>
                1. Create a new page (any title, like Home )<br/>
                2. In right column: Page Attributes -> Template: Home Page<br/>
                3. Click on Publish<br/>
                4. Go to Appearance-> Customize -> General settings -> Static Front Page<br/>
                5. Select - A static page<br/>
                6. In Front Page, select the page that you created in the step 1<br/>
                7. Save changes
             
             <p>
             <strong>Theme issues?</strong><br>
             If you are having theme related problems then please contact us through our <a href="https://www.buywpthemes.net/pages/support" target="_blank">contact form</a>
             </p>
             <p>
             <br>
             <a href="https://www.wpthemesdemo.com/docs/solar-system/" target="_blank" style="display:block;">
             <img src="'.get_bloginfo('template_url').'/images/luzuk-premium.png">
             </a>
             </p>
             ', 'peccular Premium') 
        )
    );  

    $wp_customize->add_setting('peccular_options[info]', array(
        'sanitize_callback' => 'peccular_no_sanitize',
        'type' => 'info_control',
        'capability' => 'edit_theme_options',
     )
    );
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'pro_section', array(
        'section' => 'peccular_new',
        'settings' => 'peccular_options[info]',
        'type' => 'hidden',
        'priority' => 109
        ) )
    );

    $wp_customize->add_section(
        'peccular_prem',
        array(
            'title' => __('Theme Document', 'peccular Premium'),
            'priority' => 9999,
            'description' => __('
             <a href="https://www.wpthemesdemo.com/docs/solar-system/" target="_blank" style="display:block;">
             <img src="'.get_bloginfo('template_url').'/images/luzuk-premium.png">
             </a>
             ', 'peccular Premium') 
        )
    ); 

    $wp_customize->add_setting('peccular_prem[info]', array(
        'sanitize_callback' => 'peccular_no_sanitize',
        'type' => 'info_control',
        'capability' => 'edit_theme_options',
    )
    );
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'premium_section', array(
        'section' => 'peccular_prem',
        'settings' => 'peccular_prem[info]',
        'type' => 'hidden',
        'priority' => 109
        ))
    );   
    
    function peccular_customizer_stylesheet() {
        wp_enqueue_style( 'peccular-customizer-css', get_template_directory_uri().'/css/css-customizer.css', NULL, NULL, 'all' );
        wp_enqueue_style( 'peccular-customizer2-css', get_template_directory_uri().'/css/customizer-style.css', NULL, NULL, 'all' );
        wp_enqueue_style( 'total-customizer-chosen-style', get_template_directory_uri() .'/css/chosen.css');

    }

// customizer button tab
   $wp_customize->register_control_type('peccular_Tab_Control');

    $wp_customize->register_panel_type( 'peccular_WP_Customize_Panel' );
  $wp_customize->register_section_type( 'peccular_WP_Customize_Section' );

}
add_action( 'customize_register', 'peccular_lite_customize_register' );


function peccular_customizer_script() {
    // Endqueue the js of files
    wp_enqueue_script( 'peccular_lite_customizer', get_template_directory_uri(). '/js/customizer.js', array( 'customize-preview' ), '20151215', true );
    wp_enqueue_script( 'peccular_lite_customizer-script', get_template_directory_uri(). '/js/customizer-scripts.js', array( 'customize-preview' ), '201512153', true );
    wp_enqueue_script( 'total-customizer-chosen-script', get_template_directory_uri().' /js/chosen.jquery.js', array("jquery"),'1.4.1', true  );
    // wp_enqueue_style( 'font-awesome', get_template_directory_uri() .'/css/font-awesome.css');   
    wp_enqueue_style( 'font-awesome', get_template_directory_uri() . '/css/font-awesome.css', array(), '4.4.0' );
    wp_enqueue_style( 'google-fonts', 'https://fonts.googleapis.com/css?family=Archivo+Narrow|Arimo|Berkshire+Swash|Bitter|Comfortaa|Dancing+Script|Dosis|Droid+Serif|Francois+One|Germania+One|Hammersmith+One|Indie+Flower|Lobster|Muli|Nosifer|PT+Sans|PT+Sans+Caption|PT+Sans+Narrow|Pacifico|Questrial|Roboto+Mono|Roboto+Slab|Source+Serif+Pro|Titillium+Web|Work+Sans|Poppins|Roboto' );
}
add_action( 'customize_controls_enqueue_scripts', 'peccular_customizer_script' );

function peccular_no_sanitize(){}


//SANITIZATION FUNCTIONS
function peccular_sanitize_text( $input ) {
    return wp_kses_post( force_balance_tags( $input ) );
}

function peccular_sanitize_integer( $input ) {
    if( is_numeric( $input ) ) {
        return intval( $input );
    }
}

function peccular_sanitize_choices_array( $input, $setting ) {
    global $wp_customize;
    
    if(!empty($input)){
        $input = array_map('absint', $input);
    }

    return $input;
} 

function getpeccularPostsType($type){
    $peccularPostData = null;
    if(!empty($type)){
        $peccularPosts = get_posts(array('hide_empty' => 0, 'post_type'=> $type, 'numberposts' => -1 ));
        foreach ($peccularPosts as $peccularPostsSingle) {
            $peccularPostData[$peccularPostsSingle->ID] = $peccularPostsSingle->post_title; 
        }
    }
    return $peccularPostData;
}
/*
if(! function_exists('peccular_color_output' ) ):
/**
* Set the header background color 
*
function peccular_color_output(){
    ?>
    <style type="text/css">
    #site-header { background-color: <?php echo esc_attr(get_theme_mod( 'top_header_background_color')); ?>; }
</style>
<?php }
add_action( 'wp_head', 'peccular_color_output' );
endif;*/

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function peccular_lite_customize_preview_js() {
	wp_enqueue_script( 'peccular_lite_customizer', get_template_directory_uri() . '/js/customizer.js', array( 'customize-preview' ), '20151215', true );
    wp_enqueue_script( 'peccular_lite_customizer-script', get_template_directory_uri() . '/js/customizer-scripts.js', array( 'customize-preview' ), '20151215', true );
    wp_enqueue_script( 'total-customizer-chosen-script', get_template_directory_uri() .'/js/chosen.jquery.js', array("jquery"),'1.4.1', true  );
    // wp_enqueue_style( 'font-awesome', get_template_directory_uri() .'/css/font-awesome.css');   
    wp_enqueue_style( 'total-customizer-chosen-style', get_template_directory_uri() .'/css/chosen.css');
    wp_enqueue_style( 'font-awesome', get_template_directory_uri() . '/css/font-awesome.css', array(), '4.4.0' );


}
add_action( 'customize_preview_init', 'peccular_lite_customize_preview_js' );



/**
 * Enqueue script for custom customize control.
 */
function custom_customize_enqueue() {
    wp_enqueue_script( 'custom-customize', get_template_directory_uri() . '/js/customize-controls.js', array( 'jquery', 'customize-controls' ), false, true );

    wp_localize_script(
        'custom-customize',
        'peccular_customizer_params',
        array(
            'ajaxurl' =>    admin_url( 'admin-ajax.php' )
        )
    );

}
add_action( 'customize_controls_enqueue_scripts', 'custom_customize_enqueue' );

/**
 * Enqueue the stylesheet.
 */
function my_enqueue_customizer_stylesheet() {

    wp_register_style( 'my-customizer-css', get_template_directory_uri() . '/css/customize-controls.css', NULL, NULL, 'all' );
    wp_enqueue_style( 'my-customizer-css' );
}
add_action( 'customize_controls_print_styles', 'my_enqueue_customizer_stylesheet' );

// Enqueue our scripts and styles
function peccular_customize_controls_scripts() {

  wp_enqueue_script( 'peccular-customize-controls', get_theme_file_uri( '/js/panel-customize-controls.js' ), array(), '1.0', true );

}

add_action( 'customize_controls_enqueue_scripts', 'peccular_customize_controls_scripts' );

function peccular_customize_controls_styles() {

  wp_enqueue_style( 'peccular-customize-controls', get_theme_file_uri( '/css/panel-customize-controls.css' ), array(), '1.0' );

}

add_action( 'customize_controls_print_styles', 'peccular_customize_controls_styles' );
