<?php 
  $lvl2ParentPanel3 = new peccular_WP_Customize_Panel( $wp_customize, 'peccular_header_panel3', array(
    'title' => 'Pages',
    'panel' => 'peccular_header_panel1',
    'priority' => 2,
  ));

  $wp_customize->add_panel( $lvl2ParentPanel3 );


  // Add example section and controls to the final (third) panel
  $wp_customize->add_section( 'peccular_section', array(
    'title' => 'Section Test single',
    'panel' => 'peccular_header_panel3',
  ));

//Bottom Header
    $wp_customize->add_section( 'peccular_single_post' , array(
        'title'    => __( 'Single Post', 'peccular-premium' ),
        'priority' => null,
        'panel' => 'peccular_header_panel3'
    ) );

    $wp_customize->add_setting('peccular_singleeblog_nav', array(
       'sanitize_callback' => 'wp_kses_post',
    ));

    $wp_customize->add_control(new peccular_Tab_Control($wp_customize, 'peccular_singleeblog_nav', array(
       'section' => 'peccular_single_post',
       'priority' => 1,
       'buttons' => array(
          array(
             'name' => esc_html__('General', 'peccular-premium'),
            'icon' => 'dashicons dashicons-welcome-write-blog',
            'fields' => array(
                'featured_img_on_off',
                'peccular__blogspost_layout',
                // 'peccular_single_post_image_height',
                'peccular_single_show_author',
                'peccular_single_show_date',
                'peccular_single_show_time',
                'peccular_single_show_category',
                'peccular_single_show_comments',
                'peccular_single_show_tags',
                'single_blog_socials_on_off'
            ),
            'active' => true,
         ),
          array(
            'name' => esc_html__('Style', 'peccular-premium'),
            'icon' => 'dashicons dashicons-art',
            'fields' => array(                
                'peccular_singleblogpage_title_color',
                'peccular_singleblogpage_metatext_color',
                'peccular_singleblogpage_contenttext_color',
                'peccular_singleblogpage_button_color',
                'peccular_singleblogpage_buttonhover_color',
                'peccular_singleblogpage_buttonborder_color',
                'peccular_singleblogpage_socialicon_color',
                'peccular_singleblogpage_socialiconhover_color',
                'peccular_singleblogpage_metaicon_color',
                'peccular_singleblogpage_buttonbg_color',
                'peccular_singleblogpage_socialiconarr_color'
            ),
         )
        ),
    )));


$wp_customize->add_setting(
    'featured_img_on_off',
    array(
        'sanitize_callback' => 'peccular_sanitize_text',
    )
);
$wp_customize->add_control(
    new peccular_Switch_Control(
        $wp_customize,
        'featured_img_on_off',
        array(
            'settings'      => 'featured_img_on_off',
            'section'       => 'peccular_single_post',
            'label'         => __( 'Show Featured Image', 'peccular-premium' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'peccular-premium' ),
                'off' => __( 'No', 'peccular-premium' )
            ),
        )
    )
);

    

//Blog Single Post Layout
$lzBlogSPostLayout = getBlogSPostLayout(true);

$wp_customize->add_setting(
   'peccular__blogspost_layout',
   array(
      'sanitize_callback'=> 'absint',
      'default' => '0'
   )
);
$wp_customize->add_control(
   new peccular_Font_Chooser(
      $wp_customize,
      'peccular__blogspost_layout',
      array(
         'settings'=> 'peccular__blogspost_layout',
         'section' => 'peccular_single_post',
         'label'=>__('Post Sidebar', 'peccular Premium'),
         'choices'=>$lzBlogSPostLayout
      )
   )
);

$wp_customize->add_setting('peccular_single_show_author',array(
  'default' => true,
  'sanitize_callback'   => 'peccular_sanitize_checkbox'
));
$wp_customize->add_control('peccular_single_show_author',array(
  'type' => 'checkbox',
  'label' => __('Show / Hide Author','peccular'),
  'section' => 'peccular_single_post'
));


$wp_customize->add_setting('peccular_single_show_date',array(
      'default' => true,
      'sanitize_callback'   => 'peccular_sanitize_checkbox'
   ));
   $wp_customize->add_control('peccular_single_show_date',array(
      'type' => 'checkbox',
      'label' => __('Show / Hide Date','peccular'),
      'section' => 'peccular_single_post'
   ));

$wp_customize->add_setting('peccular_single_show_time',array(
      'default' => true,
      'sanitize_callback'   => 'peccular_sanitize_checkbox'
   ));
   $wp_customize->add_control('peccular_single_show_time',array(
      'type' => 'checkbox',
      'label' => __('Show / Hide Time','peccular'),
      'section' => 'peccular_single_post'
   ));

$wp_customize->add_setting('peccular_single_show_category',array(
      'default' => true,
      'sanitize_callback'   => 'peccular_sanitize_checkbox'
   ));
   $wp_customize->add_control('peccular_single_show_category',array(
      'type' => 'checkbox',
      'label' => __('Show / Hide Category','peccular'),
      'section' => 'peccular_single_post'
   ));

    $wp_customize->add_setting('peccular_single_show_comments',array(
      'default' => true,
      'sanitize_callback'   => 'peccular_sanitize_checkbox'
   ));
   $wp_customize->add_control('peccular_single_show_comments',array(
      'type' => 'checkbox',
      'label' => __('Show / Hide Comments','peccular'),
      'section' => 'peccular_single_post'
   ));

      $wp_customize->add_setting('peccular_single_show_tags',array(
      'default' => true,
      'sanitize_callback'   => 'peccular_sanitize_checkbox'
   ));
   $wp_customize->add_control('peccular_single_show_tags',array(
      'type' => 'checkbox',
      'label' => __('Show / Hide Tags','peccular'),
      'section' => 'peccular_single_post'
   ));

$wp_customize->add_setting(
    'single_blog_socials_on_off',
    array(
        'sanitize_callback' => 'peccular_sanitize_text',
    )
);
$wp_customize->add_control(
    new peccular_Switch_Control(
        $wp_customize,
        'single_blog_socials_on_off',
        array(
            'settings'      => 'single_blog_socials_on_off',
            'section'       => 'peccular_single_post',
            'label'         => __( 'Social Icon', 'peccular-premium' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'peccular-premium' ),
                'off' => __( 'No', 'peccular-premium' )
            ),
        )
    )
);

addColorPalatOption($wp_customize, 'peccular_singleblogpage_title_color', 'peccular_single_post', 'Title Color', '');
addColorPalatOption($wp_customize, 'peccular_singleblogpage_metatext_color', 'peccular_single_post', 'Meta Text Color', '');
addColorPalatOption($wp_customize, 'peccular_singleblogpage_metaicon_color', 'peccular_single_post', 'Meta Text Icon Color', '');

addColorPalatOption($wp_customize, 'peccular_singleblogpage_contenttext_color', 'peccular_single_post', 'Content Text Color', '');

addColorPalatOption($wp_customize, 'peccular_singleblogpage_button_color', 'peccular_single_post', 'Button Color', '');
addColorPalatOption($wp_customize, 'peccular_singleblogpage_buttonbg_color', 'peccular_single_post', 'Button BG Color', '');
addColorPalatOption($wp_customize, 'peccular_singleblogpage_buttonhover_color', 'peccular_single_post', 'Button Hover Color', '');
addColorPalatOption($wp_customize, 'peccular_singleblogpage_buttonborder_color', 'peccular_single_post', ' Border Color', '');

addColorPalatOption($wp_customize, 'peccular_singleblogpage_socialicon_color', 'peccular_single_post', 'Social Icon Color', '');
addColorPalatOption($wp_customize, 'peccular_singleblogpage_socialiconhover_color', 'peccular_single_post', 'Social Icon Hover Color', '');

addColorPalatOption($wp_customize, 'peccular_singleblogpage_socialiconarr_color', 'peccular_single_post', 'Social Icon Border Color', '');
?>