/*
 * Theme Name: Private Tutor Pro
*/



/*----------------------------------------------------
/* Responsive Navigation
/*--------------------------------------------------*/
jQuery(document).ready(function($){
    $('.primary-navigation').append('<div id="mobile-menu-overlay" />');

    $('.toggle-mobile-menu').click(function(e) {
        e.preventDefault();
        e.stopPropagation();
        $('body').toggleClass('mobile-menu-active');

        if ( $('body').hasClass('mobile-menu-active') ) {
            if ( $(document).height() > $(window).height() ) {
                var scrollTop = ( $('html').scrollTop() ) ? $('html').scrollTop() : $('body').scrollTop();
                $('html').addClass('noscroll').css( 'top', -scrollTop );
            }
            $('#mobile-menu-overlay').fadeIn();
        } else {
            var scrollTop = parseInt( $('html').css('top') );
            $('html').removeClass('noscroll');
            $('html,body').scrollTop( -scrollTop );
            $('#mobile-menu-overlay').fadeOut();
        }
    });
}).on('click', function(event) {

    var $target = jQuery(event.target);
    if ( ( $target.hasClass("publishable-icon") && $target.parent().hasClass("toggle-caret") ) ||  $target.hasClass("toggle-caret") ) {// allow clicking on menu toggles
        return;
    }
    jQuery('body').removeClass('mobile-menu-active');
    jQuery('html').removeClass('noscroll');
    jQuery('#mobile-menu-overlay').fadeOut();
});

/*----------------------------------------------------
/*  Dropdown menu
/* ------------------------------------------------- */
jQuery(document).ready(function($) {
    
    function mtsDropdownMenu() {
        var wWidth = $(window).width();
        if(wWidth > 865) {
            $('#navigation ul.sub-menu, #navigation ul.children').hide();
            var timer;
            var delay = 100;
            $('#navigation li').hover( 
              function() {
                var $this = $(this);
                timer = setTimeout(function() {
                    $this.children('ul.sub-menu, ul.children').slideDown('fast');
                }, delay);
                
              },
              function() {
                $(this).children('ul.sub-menu, ul.children').hide();
                clearTimeout(timer);
              }
            );
        } else {
            $('#navigation li').unbind('hover');
            $('#navigation li.active > ul.sub-menu, #navigation li.active > ul.children').show();
        }
    }

    mtsDropdownMenu();

    $(window).resize(function() {
        mtsDropdownMenu();
    });
});

/*---------------------------------------------------
/*  Vertical menus toggles
/* -------------------------------------------------*/
jQuery(document).ready(function($) {

    $('.widget_nav_menu, #navigation .menu').addClass('toggle-menu');
    $('.toggle-menu ul.sub-menu, .toggle-menu ul.children').addClass('toggle-submenu');
    $('.toggle-menu ul.sub-menu').parent().addClass('toggle-menu-item-parent');

    $('.toggle-menu .toggle-menu-item-parent').append('<span class="toggle-caret"><i class="publishable-icon icon-plus"></i></span>');

    $('.toggle-caret').click(function(e) {
        e.preventDefault();
        $(this).parent().toggleClass('active').children('.toggle-submenu').slideToggle('fast');
    });
});

/*----------------------------------------------------
/* Back to top smooth scrolling
/*--------------------------------------------------*/
jQuery(document).ready(function($) {
    jQuery('a[href=#top]').click(function(){
        jQuery('html, body').animate({scrollTop:0}, 'slow');
        return false;
    });
});




/*----------------------------------------------------
/* Video pop up
/*--------------------------------------------------*/

var links = $('.boxes a');
links.colorbox({
  inline: true,
  rel: 'gallery'
});

/* Colorbox resize function */
var resizeTimer;
function resizeColorBox()
{
    if (resizeTimer) clearTimeout(resizeTimer);
    resizeTimer = setTimeout(function() {
            if ($('#cboxOverlay').is(':visible')) {
                    $.colorbox.load(true);
            }
    }, 300)
}




// Resize Colorbox when resizing window or changing mobile device orientation
$(window).resize(resizeColorBox);
window.addEventListener("orientationchange", resizeColorBox, false);


$('.boxes a').colorbox({maxWidth:'95%', maxHeight:'95%'});

$('#features .owl-carousel').owlCarousel({
                loop: true,
                margin: 0,
                autoplay: true,
                responsiveClass: true,
                responsive: {
                  0: {
                    items: 1,
                    nav: true
                  },
                  600: {
                    items:2,
                    nav: true
                  },
                  1000: {
                    items:3,
                    nav: true,
                    loop: true,
                    margin: 0
                  }
                }
              })






if ($(window).width() > 1200) {
  function itemSize() {
    var OwlSlideItem = $(".carousel-accordion .accordion_li"),
      // OwlSlideItemmargin = 10,
      itemsLength = 5,
      owlFullScrnWidth = $(".carousel-accordion").width(),
      normItemWidth = owlFullScrnWidth / itemsLength - 9;

    OwlSlideItem.stop().animate({ width: normItemWidth + "px" }, 500);
  }
  itemSize();
}

function itemExpanded() {
  var OwlSlidemactive = $(".carousel-accordion .owl-item.active"),
    // OwlSlideItemmargin = $('.carousel-accordion .owl-item').css('marginRight').replace(/[A-Za-z]/g, ""),
    itemsLength = 5,
    owlFullScrnWidth = $(".carousel-accordion").width() - itemsLength,
    normItemWidth = owlFullScrnWidth / itemsLength - 10,
    lgItemWidth = normItemWidth * 2 + 20,
    smItemWidth = (normItemWidth * 3) / 4 - 3;

  OwlSlidemactive.hover(
    function () {
      var $this = $(this);
      $this
        .addClass("expanded")
        .removeClass("active")
        .find(".accordion_li")
        .stop()
        .animate({ width: lgItemWidth + "px" }, 500);
      $(".carousel-accordion .active")
        .find(".accordion_li")
        .stop()
        .animate({ width: smItemWidth + "px" }, 500);
    },
    function () {
      var $this = $(this);
      $this.removeClass("expanded").addClass("active");
      $(".carousel-accordion .active")
        .find(".accordion_li")
        .stop()
        .animate({ width: normItemWidth + "px" }, 800);
    }
  );
}
initialize_owl($(".carousel-accordion"));

function initialize_owl(el) {
  el.owlCarousel({
    loop: false,
    margin: 10,
    navText: ["<i class='angle-left'></i>", "<i class='angle-right'></i>"],
    dots: false,
    autoPlay: true,
    autoplayTimeout: 1000,
    autoplayHoverPause: false,
    nav: true,
    responsiveClass: true,
    responsive: {
      0: {
        items: 2
      },
      460: {
        items: 4
      },
      768: {
        items: 4
      },
      900: {
        items: 4
      },
      1200: {
        
        onInitialized: itemExpanded,
        onRefresh: itemExpanded,
        autoWidth: false,
        mouseDrag: false,
        items: 5
      }
    }
  });
}

